/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cogchar.bind.rk.robot.model.ModelBoneRotation;
import org.cogchar.bind.rk.robot.model.ModelJoint;
import org.cogchar.bind.rk.robot.model.ModelRobot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRobotUtils {
    static Logger theLogger = LoggerFactory.getLogger(ModelRobotUtils.class);

    private static void appendBoneRotation(Map<String, List<ModelBoneRotation>> rotListMap, ModelBoneRotation rot) {
        String bone = rot.getBoneName();
        List<ModelBoneRotation> rotList = rotListMap.get(bone);
        if (rotList == null) {
            rotList = new ArrayList<ModelBoneRotation>();
            rotListMap.put(bone, rotList);
        }
        rotList.add(rot);
    }

    public static Map<String, List<ModelBoneRotation>> getGoalAnglesAsRotations(ModelRobot robot) {
        HashMap<String, List<ModelBoneRotation>> rotListMap = new HashMap<String, List<ModelBoneRotation>>();
        ArrayList joints = new ArrayList(robot.getJointList());
        for (ModelJoint j : joints) {
            for (ModelBoneRotation rot : j.getRotationListForCurrentGoal()) {
                ModelRobotUtils.appendBoneRotation(rotListMap, rot);
            }
        }
        return rotListMap;
    }

    public static Map<String, List<ModelBoneRotation>> getInitialRotationMap(ModelRobot robot) {
        HashMap<String, List<ModelBoneRotation>> rotListMap = new HashMap<String, List<ModelBoneRotation>>();
        List<ModelBoneRotation> initRots = robot.getInitialBoneRotations();
        if (initRots == null) {
            return rotListMap;
        }
        for (ModelBoneRotation rot : initRots) {
            ModelRobotUtils.appendBoneRotation(rotListMap, rot);
        }
        return rotListMap;
    }
}

