/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cogchar.bind.rk.robot.model.ModelBoneRotation;
import org.cogchar.bind.rk.robot.model.ModelJoint;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.AbstractRobot;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRobot
extends AbstractRobot<ModelJoint> {
    static Logger theLogger = LoggerFactory.getLogger(ModelRobot.class);
    private List<ModelBoneRotation> myInitialBoneRotations;
    private boolean myConnectionFlag;
    private long myLastMoveStampMillis = System.currentTimeMillis();
    private List<MoveListener> myListeners = new ArrayList<MoveListener>();

    public void registerMoveListener(MoveListener ml) {
        this.myListeners.add(ml);
    }

    public void notifyMoveListeners() {
        for (MoveListener ml : this.myListeners) {
            ml.notifyBonyRobotMoved(this);
        }
    }

    public ModelRobot(Robot.Id robotId) {
        super(robotId);
    }

    protected void setInitialBoneRotations(List<ModelBoneRotation> rotations) {
        this.myInitialBoneRotations = rotations;
    }

    public List<ModelBoneRotation> getInitialBoneRotations() {
        return this.myInitialBoneRotations;
    }

    protected String getDescription() {
        return "ROBOT[" + this.getRobotId() + "]";
    }

    public boolean connect() {
        this.myConnectionFlag = true;
        theLogger.info(this.getDescription() + " connecting");
        return true;
    }

    public void disconnect() {
        this.myConnectionFlag = false;
        theLogger.info(this.getDescription() + " disconnecting");
    }

    public void move(Robot.RobotPositionMap positions, long lenMillisec) {
        long now = System.currentTimeMillis();
        long elapsed = now - this.myLastMoveStampMillis;
        this.myLastMoveStampMillis = now;
        if (this.myJointMap == null) {
            throw new NullPointerException();
        }
        for (Map.Entry e : positions.entrySet()) {
            Robot.JointId id = (Robot.JointId)e.getKey();
            ModelJoint bj = (ModelJoint)((Object)this.myJointMap.get(id));
            if (bj == null) {
                theLogger.warn("ignoring unknown joint id: " + id);
                continue;
            }
            NormalizedDouble pos = (NormalizedDouble)e.getValue();
            bj.setGoalPosition(pos);
        }
        this.notifyMoveListeners();
    }

    public void registerBonyJoint(ModelJoint bj) {
        theLogger.info(this.getDescription() + " registering " + bj.getDescription());
        this.addJoint((Joint)bj);
    }

    public boolean isConnected() {
        return this.myConnectionFlag;
    }

    public static interface MoveListener {
        public void notifyBonyRobotMoved(ModelRobot var1);
    }
}

