/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.speech.client;

import org.cogchar.bind.rk.robot.client.RobotAnimClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.robokind.api.speech.SpeechService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechOutputClient {
    static Logger theLogger = LoggerFactory.getLogger(RobotAnimClient.class);
    BundleContext myBundleCtx;

    public SpeechOutputClient(BundleContext bundleCtx) {
        this.myBundleCtx = bundleCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speakText(String txt) throws Throwable {
        theLogger.info("Trying to speakText: " + txt);
        if (txt == null) {
            throw new Exception("Speech text is null");
        }
        ServiceReference ref = this.myBundleCtx.getServiceReference(SpeechService.class.getName());
        try {
            if (ref == null) {
                throw new Exception("Cannot find Speech Service");
            }
            Object serviceObj = this.myBundleCtx.getService(ref);
            if (serviceObj == null) {
                throw new Exception("SpeechService object is null");
            }
            SpeechService ss = (SpeechService)serviceObj;
            ss.speak(txt);
        }
        finally {
            if (ref != null) {
                this.myBundleCtx.ungetService(ref);
            }
        }
    }
}

