/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.cogchar.avrogen.bind.robokind.BoneRotationConfig;
import org.cogchar.avrogen.bind.robokind.BoneRotationRangeConfig;
import org.cogchar.avrogen.bind.robokind.BonyJointConfig;
import org.cogchar.avrogen.bind.robokind.BonyRobotConfig;
import org.cogchar.bind.rk.robot.model.ModelBoneRotRange;
import org.cogchar.bind.rk.robot.model.ModelBoneRotation;
import org.cogchar.bind.rk.robot.model.ModelJoint;
import org.cogchar.bind.rk.robot.model.ModelRobot;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.bind.apache_avro.AvroUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRobotFactory {
    static Logger theLogger = LoggerFactory.getLogger(ModelRobotFactory.class);

    public static ModelRobot buildFromFile(File configFile) {
        try {
            BonyRobotConfig config = (BonyRobotConfig)AvroUtils.readFromFile(BonyRobotConfig.class, null, (Schema)BonyRobotConfig.SCHEMA$, (File)configFile, (boolean)true);
            return ModelRobotFactory.buildRobot(config);
        }
        catch (IOException ex) {
            theLogger.warn("Error loading file: " + configFile.getAbsolutePath(), (Throwable)ex);
            return null;
        }
    }

    public static ModelRobot buildRobot(BonyRobotConfig config) {
        ModelRobot robot = new ModelRobot(new Robot.Id(config.robotId.toString()));
        for (BonyJointConfig jc : config.jointConfigs) {
            robot.registerBonyJoint(ModelRobotFactory.buildJoint(jc));
        }
        GenericArray rotConfigs = config.initialBonePositions;
        ArrayList<ModelBoneRotation> rotations = new ArrayList<ModelBoneRotation>(rotConfigs.size());
        for (BoneRotationConfig conf : rotConfigs) {
            rotations.add(new ModelBoneRotation(conf.boneName.toString(), conf.rotationAxis, conf.rotationRadians));
        }
        robot.setInitialBoneRotations(rotations);
        return robot;
    }

    private static ModelJoint buildJoint(BonyJointConfig config) {
        Joint.Id jointId = new Joint.Id(config.jointId);
        double defVal = Utils.bound((double)config.normalizedDefaultPosition, (double)0.0, (double)1.0);
        NormalizedDouble def = new NormalizedDouble(defVal);
        GenericArray rotConfigs = config.boneRotations;
        ArrayList<ModelBoneRotRange> ranges = new ArrayList<ModelBoneRotRange>(rotConfigs.size());
        for (BoneRotationRangeConfig c : rotConfigs) {
            ranges.add(new ModelBoneRotRange(c.boneName.toString(), c.rotationAxis, c.minPosition, c.maxPosition));
        }
        return new ModelJoint(jointId, config.name.toString(), ranges, def);
    }
}

