/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.model;

import java.util.ArrayList;
import java.util.List;
import org.cogchar.bind.rk.robot.model.ModelBoneRotRange;
import org.cogchar.bind.rk.robot.model.ModelBoneRotation;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.AbstractJoint;
import org.robokind.api.motion.Joint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelJoint
extends AbstractJoint {
    static Logger theLogger = LoggerFactory.getLogger(ModelJoint.class);
    private boolean myEnabledFlag = false;
    private NormalizedDouble myDefaultPosNorm;
    private NormalizedDouble myGoalPosNorm;
    private String myName;
    private List<ModelBoneRotRange> myBoneRotRangeList;

    protected ModelJoint(Joint.Id jointId, String name, List<ModelBoneRotRange> rotations, NormalizedDouble defPos) {
        super(jointId);
        this.myName = name;
        this.myBoneRotRangeList = rotations;
        this.myGoalPosNorm = this.myDefaultPosNorm = defPos;
    }

    protected String getDescription() {
        return "JOINT[" + this.getId() + "," + this.myName + "]";
    }

    public String toString() {
        return this.getDescription() + "-[enabled=" + this.myEnabledFlag + " goalPos=" + this.myGoalPosNorm + "]";
    }

    public void setEnabled(Boolean enabled) {
        theLogger.info(this.getDescription() + ".setEnabled(" + enabled + ")");
        this.myEnabledFlag = enabled;
    }

    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public String getName() {
        return this.myName;
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myDefaultPosNorm;
    }

    public NormalizedDouble getGoalPosition() {
        return this.myGoalPosNorm;
    }

    public List<ModelBoneRotRange> getBoneRotationRanges() {
        return this.myBoneRotRangeList;
    }

    void setGoalPosition(NormalizedDouble pos) {
        theLogger.trace(this.getDescription() + ".setGoalPosition(" + pos + ")");
        NormalizedDouble old = this.getGoalPosition();
        this.firePropertyChange("goalPosition", old, pos);
        this.myGoalPosNorm = pos;
    }

    public List<ModelBoneRotation> getRotationListForNormPos(NormalizedDouble normPos) {
        ArrayList<ModelBoneRotation> rotations = new ArrayList<ModelBoneRotation>(this.myBoneRotRangeList.size());
        for (ModelBoneRotRange range : this.myBoneRotRangeList) {
            rotations.add(range.makeRotationForNormalizedFraction(normPos));
        }
        return rotations;
    }

    public List<ModelBoneRotation> getRotationListForCurrentGoal() {
        NormalizedDouble normGoalPos = this.getGoalPosition();
        return this.getRotationListForNormPos(normGoalPos);
    }
}

