/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.model;

import org.cogchar.avrogen.bind.robokind.RotationAxis;
import org.cogchar.bind.rk.robot.model.ModelBoneRotation;
import org.robokind.api.common.position.NormalizedDouble;

public class ModelBoneRotRange {
    private String myBoneName;
    private RotationAxis myRotationAxis;
    private double myMinRotation;
    private double myMaxRotation;

    public ModelBoneRotRange(String boneName, RotationAxis axis, double min, double max) {
        if (boneName == null || axis == null) {
            throw new NullPointerException();
        }
        this.myBoneName = boneName;
        this.myRotationAxis = axis;
        this.myMinRotation = min;
        this.myMaxRotation = max;
    }

    public String getBoneName() {
        return this.myBoneName;
    }

    public RotationAxis getRotationAxis() {
        return this.myRotationAxis;
    }

    public ModelBoneRotation makeRotationForNormalizedFraction(NormalizedDouble normVal) {
        double range = this.myMaxRotation - this.myMinRotation;
        double boneAngle = range * normVal.getValue() + this.myMinRotation;
        return new ModelBoneRotation(this.myBoneName, this.myRotationAxis, boneAngle);
    }
}

