/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.saml2.core.http.HttpRequest;
import org.codelibs.saml2.core.util.Util;

public class ServletUtils {
    private ServletUtils() {
    }

    public static HttpRequest makeHttpRequest(HttpServletRequest req) {
        Map paramsAsArray = req.getParameterMap();
        HashMap<String, List<String>> paramsAsList = new HashMap<String, List<String>>();
        for (Map.Entry param : paramsAsArray.entrySet()) {
            paramsAsList.put((String)param.getKey(), Arrays.asList((String[])param.getValue()));
        }
        return new HttpRequest(req.getRequestURL().toString(), paramsAsList, req.getQueryString());
    }

    public static String getSelfURLhost(HttpServletRequest request) {
        int serverPort = request.getServerPort();
        String hostUrl = serverPort == 80 || serverPort == 443 || serverPort == 0 ? String.format("%s://%s", request.getScheme(), request.getServerName()) : String.format("%s://%s:%s", request.getScheme(), request.getServerName(), serverPort);
        return hostUrl;
    }

    public static String getSelfHost(HttpServletRequest request) {
        return request.getServerName();
    }

    public static boolean isHTTPS(HttpServletRequest request) {
        return request.isSecure();
    }

    public static String getSelfURL(HttpServletRequest request) {
        Object url = ServletUtils.getSelfURLhost(request);
        String requestUri = request.getRequestURI();
        String queryString = request.getQueryString();
        if (null != requestUri && !requestUri.isEmpty()) {
            url = (String)url + requestUri;
        }
        if (null != queryString && !queryString.isEmpty()) {
            url = (String)url + "?" + queryString;
        }
        return url;
    }

    public static String getSelfURLNoQuery(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    public static String getSelfRoutedURLNoQuery(HttpServletRequest request) {
        Object url = ServletUtils.getSelfURLhost(request);
        String requestUri = request.getRequestURI();
        if (null != requestUri && !requestUri.isEmpty()) {
            url = (String)url + requestUri;
        }
        return url;
    }

    public static String sendRedirect(HttpServletResponse response, String location, Map<String, String> parameters, Boolean stay) {
        Object target = location;
        if (!parameters.isEmpty()) {
            boolean first = !location.contains("?");
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                if (first) {
                    target = (String)target + "?";
                    first = false;
                } else {
                    target = (String)target + "&";
                }
                target = (String)target + parameter.getKey();
                if (parameter.getValue().isEmpty()) continue;
                target = (String)target + "=" + Util.urlEncoder((String)parameter.getValue());
            }
        }
        if (!stay.booleanValue()) {
            try {
                response.sendRedirect((String)target);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return target;
    }

    public static void sendRedirect(HttpServletResponse response, String location, Map<String, String> parameters) {
        ServletUtils.sendRedirect(response, location, parameters, false);
    }

    public static void sendRedirect(HttpServletResponse response, String location) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ServletUtils.sendRedirect(response, location, parameters);
    }
}

