/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.factory;

import org.codelibs.saml2.core.authn.AuthnRequest;
import org.codelibs.saml2.core.authn.AuthnRequestParams;
import org.codelibs.saml2.core.authn.SamlResponse;
import org.codelibs.saml2.core.http.HttpRequest;
import org.codelibs.saml2.core.logout.LogoutRequest;
import org.codelibs.saml2.core.logout.LogoutRequestParams;
import org.codelibs.saml2.core.logout.LogoutResponse;
import org.codelibs.saml2.core.logout.LogoutResponseParams;
import org.codelibs.saml2.core.settings.Saml2Settings;

public interface SamlMessageFactory {
    default public AuthnRequest createAuthnRequest(Saml2Settings settings, AuthnRequestParams params) {
        return new AuthnRequest(settings, params);
    }

    default public SamlResponse createSamlResponse(Saml2Settings settings, HttpRequest request) {
        return new SamlResponse(settings, request);
    }

    default public LogoutRequest createOutgoingLogoutRequest(Saml2Settings settings, LogoutRequestParams params) {
        return new LogoutRequest(settings, params);
    }

    default public LogoutRequest createIncomingLogoutRequest(Saml2Settings settings, HttpRequest request) {
        return new LogoutRequest(settings, request);
    }

    default public LogoutResponse createOutgoingLogoutResponse(Saml2Settings settings, LogoutResponseParams params) {
        return new LogoutResponse(settings, params);
    }

    default public LogoutResponse createIncomingLogoutResponse(Saml2Settings settings, HttpRequest request) {
        return new LogoutResponse(settings, request);
    }
}

