/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.PrivateKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codelibs.core.exception.InvalidKeyRuntimeException;
import org.codelibs.core.exception.NoSuchAlgorithmRuntimeException;
import org.codelibs.saml2.core.authn.AuthnRequest;
import org.codelibs.saml2.core.authn.AuthnRequestParams;
import org.codelibs.saml2.core.authn.SamlResponse;
import org.codelibs.saml2.core.exception.SAMLSevereException;
import org.codelibs.saml2.core.exception.SAMLSignatureException;
import org.codelibs.saml2.core.exception.SettingsException;
import org.codelibs.saml2.core.http.HttpRequest;
import org.codelibs.saml2.core.logout.LogoutRequest;
import org.codelibs.saml2.core.logout.LogoutRequestParams;
import org.codelibs.saml2.core.logout.LogoutResponse;
import org.codelibs.saml2.core.logout.LogoutResponseParams;
import org.codelibs.saml2.core.model.KeyStoreSettings;
import org.codelibs.saml2.core.model.SamlResponseStatus;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.settings.SettingsBuilder;
import org.codelibs.saml2.core.util.Util;
import org.codelibs.saml2.factory.SamlMessageFactory;
import org.codelibs.saml2.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth {
    private static final Logger LOGGER = LoggerFactory.getLogger(Auth.class);
    private final Saml2Settings settings;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private String nameid;
    private String nameidFormat;
    private String nameidNameQualifier;
    private String nameidSPNameQualifier;
    private String sessionIndex;
    private Instant sessionExpiration;
    private String lastMessageId;
    private Calendar lastMessageIssueInstant;
    private String lastAssertionId;
    private List<Instant> lastAssertionNotOnOrAfter;
    private Map<String, List<String>> attributes = new LinkedHashMap<String, List<String>>();
    private boolean authenticated = false;
    private final List<String> errors = new ArrayList<String>();
    private String errorReason;
    private Exception validationException;
    private String lastRequestId;
    private Calendar lastRequestIssueInstant;
    private String lastRequest;
    private String lastResponse;
    private static final SamlMessageFactory DEFAULT_SAML_MESSAGE_FACTORY = new SamlMessageFactory(){};
    private SamlMessageFactory samlMessageFactory = DEFAULT_SAML_MESSAGE_FACTORY;

    public Auth() {
        this(new SettingsBuilder().fromFile("onelogin.saml.properties").build(), null, null);
    }

    public Auth(KeyStoreSettings keyStoreSetting) {
        this("onelogin.saml.properties", keyStoreSetting);
    }

    public Auth(String filename) {
        this(filename, null, null, null);
    }

    public Auth(String filename, KeyStoreSettings keyStoreSetting) {
        this(new SettingsBuilder().fromFile(filename, keyStoreSetting).build(), null, null);
    }

    public Auth(HttpServletRequest request, HttpServletResponse response) {
        this(new SettingsBuilder().fromFile("onelogin.saml.properties").build(), request, response);
    }

    public Auth(KeyStoreSettings keyStoreSetting, HttpServletRequest request, HttpServletResponse response) {
        this(new SettingsBuilder().fromFile("onelogin.saml.properties", keyStoreSetting).build(), request, response);
    }

    public Auth(String filename, HttpServletRequest request, HttpServletResponse response) {
        this(filename, null, request, response);
    }

    public Auth(String filename, KeyStoreSettings keyStoreSetting, HttpServletRequest request, HttpServletResponse response) {
        this(new SettingsBuilder().fromFile(filename, keyStoreSetting).build(), request, response);
    }

    public Auth(Saml2Settings settings, HttpServletRequest request, HttpServletResponse response) {
        this.settings = settings;
        this.request = request;
        this.response = response;
        List settingsErrors = settings.checkSettings();
        if (!settingsErrors.isEmpty()) {
            Object errorMsg = "Invalid settings: ";
            errorMsg = (String)errorMsg + StringUtils.join((Iterable)settingsErrors, (String)", ");
            LOGGER.warn((String)errorMsg);
            throw new SettingsException((String)errorMsg, 2);
        }
        LOGGER.debug("Settings validated");
    }

    public void setStrict(Boolean value) {
        this.settings.setStrict(value.booleanValue());
    }

    @Deprecated
    public String login(String relayState, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy, Boolean stay, String nameIdValueReq) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        return this.login(relayState, new AuthnRequestParams(forceAuthn.booleanValue(), isPassive.booleanValue(), setNameIdPolicy.booleanValue(), nameIdValueReq), stay, parameters);
    }

    @Deprecated
    public String login(String relayState, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy, Boolean stay, String nameIdValueReq, Map<String, String> parameters) {
        return this.login(relayState, new AuthnRequestParams(forceAuthn.booleanValue(), isPassive.booleanValue(), setNameIdPolicy.booleanValue(), nameIdValueReq), stay, parameters);
    }

    @Deprecated
    public String login(String relayState, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy, Boolean stay) {
        return this.login(relayState, new AuthnRequestParams(forceAuthn.booleanValue(), isPassive.booleanValue(), setNameIdPolicy.booleanValue()), stay, null);
    }

    @Deprecated
    public void login(String relayState, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy) {
        this.login(relayState, new AuthnRequestParams(forceAuthn.booleanValue(), isPassive.booleanValue(), setNameIdPolicy.booleanValue()), false);
    }

    public void login() {
        this.login(null, new AuthnRequestParams(false, false, true));
    }

    public void login(AuthnRequestParams authnRequestParams) {
        this.login(null, authnRequestParams);
    }

    public void login(String relayState) {
        this.login(relayState, new AuthnRequestParams(false, false, true));
    }

    public void login(String relayState, AuthnRequestParams authnRequestParams) {
        this.login(relayState, authnRequestParams, false);
    }

    public String login(String relayState, AuthnRequestParams authnRequestParams, Boolean stay) {
        return this.login(relayState, authnRequestParams, stay, new HashMap<String, String>());
    }

    public String login(String relayState, AuthnRequestParams authnRequestParams, Boolean stay, Map<String, String> parameters) {
        AuthnRequest authnRequest = this.samlMessageFactory.createAuthnRequest(this.settings, authnRequestParams);
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        String samlRequest = authnRequest.getEncodedAuthnRequest();
        parameters.put("SAMLRequest", samlRequest);
        if (relayState == null) {
            relayState = ServletUtils.getSelfRoutedURLNoQuery(this.request);
        }
        if (!relayState.isEmpty()) {
            parameters.put("RelayState", relayState);
        }
        if (this.settings.getAuthnRequestsSigned()) {
            String sigAlg = this.settings.getSignatureAlgorithm();
            String signature = this.buildRequestSignature(samlRequest, relayState, sigAlg);
            parameters.put("SigAlg", sigAlg);
            parameters.put("Signature", signature);
        }
        String ssoUrl = this.getSSOurl();
        this.lastRequestId = authnRequest.getId();
        this.lastRequestIssueInstant = authnRequest.getIssueInstant();
        this.lastRequest = authnRequest.getAuthnRequestXml();
        if (!stay.booleanValue()) {
            LOGGER.debug("AuthNRequest sent to {} --> {}", (Object)ssoUrl, (Object)samlRequest);
        }
        return ServletUtils.sendRedirect(this.response, ssoUrl, parameters, stay);
    }

    public String logout(String relayState, LogoutRequestParams logoutRequestParams, Boolean stay) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        return this.logout(relayState, logoutRequestParams, stay, parameters);
    }

    public void logout(String relayState, LogoutRequestParams logoutRequestParams) {
        this.logout(relayState, logoutRequestParams, false);
    }

    @Deprecated
    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay, String nameidFormat, String nameIdNameQualifier, String nameIdSPNameQualifier) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier, nameIdSPNameQualifier), stay, parameters);
    }

    public String logout(String relayState, LogoutRequestParams logoutRequestParams, Boolean stay, Map<String, String> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        LogoutRequest logoutRequest = this.samlMessageFactory.createOutgoingLogoutRequest(this.settings, logoutRequestParams);
        String samlLogoutRequest = logoutRequest.getEncodedLogoutRequest();
        parameters.put("SAMLRequest", samlLogoutRequest);
        if (relayState == null) {
            relayState = ServletUtils.getSelfRoutedURLNoQuery(this.request);
        }
        if (!relayState.isEmpty()) {
            parameters.put("RelayState", relayState);
        }
        if (this.settings.getLogoutRequestSigned()) {
            String sigAlg = this.settings.getSignatureAlgorithm();
            String signature = this.buildRequestSignature(samlLogoutRequest, relayState, sigAlg);
            parameters.put("SigAlg", sigAlg);
            parameters.put("Signature", signature);
        }
        String sloUrl = this.getSLOurl();
        this.lastRequestId = logoutRequest.getId();
        this.lastRequestIssueInstant = logoutRequest.getIssueInstant();
        this.lastRequest = logoutRequest.getLogoutRequestXml();
        if (!stay.booleanValue()) {
            LOGGER.debug("Logout request sent to {} --> {}", (Object)sloUrl, (Object)samlLogoutRequest);
        }
        return ServletUtils.sendRedirect(this.response, sloUrl, parameters, stay);
    }

    @Deprecated
    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay, String nameidFormat, String nameIdNameQualifier, String nameIdSPNameQualifier, Map<String, String> parameters) {
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier, nameIdSPNameQualifier), stay, parameters);
    }

    @Deprecated
    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay, String nameidFormat, String nameIdNameQualifier) {
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier), stay, null);
    }

    @Deprecated
    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay, String nameidFormat) {
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat), stay, null);
    }

    @Deprecated
    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay) {
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId), stay, null);
    }

    @Deprecated
    public void logout(String relayState, String nameId, String sessionIndex, String nameidFormat, String nameIdNameQualifier, String nameIdSPNameQualifier) {
        this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier, nameIdSPNameQualifier), false);
    }

    @Deprecated
    public void logout(String relayState, String nameId, String sessionIndex, String nameidFormat, String nameIdNameQualifier) {
        this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier), false);
    }

    @Deprecated
    public void logout(String relayState, String nameId, String sessionIndex, String nameidFormat) {
        this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat), false);
    }

    @Deprecated
    public void logout(String relayState, String nameId, String sessionIndex) {
        this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId), false, null);
    }

    public void logout() {
        this.logout(null, new LogoutRequestParams(), false);
    }

    public void logout(String relayState) {
        this.logout(relayState, new LogoutRequestParams(), false);
    }

    public String getSSOurl() {
        return this.settings.getIdpSingleSignOnServiceUrl().toString();
    }

    public String getSLOurl() {
        return this.settings.getIdpSingleLogoutServiceUrl().toString();
    }

    public String getSLOResponseUrl() {
        return this.settings.getIdpSingleLogoutServiceResponseUrl().toString();
    }

    public void processResponse(String requestId) {
        this.authenticated = false;
        HttpRequest httpRequest = ServletUtils.makeHttpRequest(this.request);
        String samlResponseParameter = httpRequest.getParameter("SAMLResponse");
        if (samlResponseParameter == null) {
            this.errors.add("invalid_binding");
            String errorMsg = "SAML Response not found, Only supported HTTP_POST Binding";
            throw new SAMLSevereException("SAML Response not found, Only supported HTTP_POST Binding", 3);
        }
        SamlResponse samlResponse = this.samlMessageFactory.createSamlResponse(this.settings, httpRequest);
        this.lastResponse = samlResponse.getSAMLResponseXml();
        if (samlResponse.isValid(requestId)) {
            this.nameid = samlResponse.getNameId();
            this.nameidFormat = samlResponse.getNameIdFormat();
            this.nameidNameQualifier = samlResponse.getNameIdNameQualifier();
            this.nameidSPNameQualifier = samlResponse.getNameIdSPNameQualifier();
            this.authenticated = true;
            this.attributes = samlResponse.getAttributes();
            this.sessionIndex = samlResponse.getSessionIndex();
            this.sessionExpiration = samlResponse.getSessionNotOnOrAfter();
            this.lastMessageId = samlResponse.getId();
            this.lastMessageIssueInstant = samlResponse.getResponseIssueInstant();
            this.lastAssertionId = samlResponse.getAssertionId();
            this.lastAssertionNotOnOrAfter = samlResponse.getAssertionNotOnOrAfter();
            LOGGER.debug("processResponse success --> " + samlResponseParameter);
        } else {
            this.errorReason = samlResponse.getError();
            this.validationException = samlResponse.getValidationException();
            SamlResponseStatus samlResponseStatus = samlResponse.getResponseStatus();
            if (samlResponseStatus.getStatusCode() == null || !"urn:oasis:names:tc:SAML:2.0:status:Success".equals(samlResponseStatus.getStatusCode())) {
                this.errors.add("response_not_success");
                LOGGER.warn("processResponse error. sso_not_success");
                LOGGER.debug(" --> {}", (Object)samlResponseParameter);
                this.errors.add(samlResponseStatus.getStatusCode());
                if (samlResponseStatus.getSubStatusCode() != null) {
                    this.errors.add(samlResponseStatus.getSubStatusCode());
                }
            } else {
                this.errors.add("invalid_response");
                LOGGER.warn("processResponse error. invalid_response");
                LOGGER.debug(" --> {}", (Object)samlResponseParameter);
            }
        }
    }

    public void processResponse() {
        this.processResponse(null);
    }

    public String processSLO(Boolean keepLocalSession, String requestId, Boolean stay) {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest(this.request);
        String samlRequestParameter = httpRequest.getParameter("SAMLRequest");
        String samlResponseParameter = httpRequest.getParameter("SAMLResponse");
        if (samlResponseParameter != null) {
            LogoutResponse logoutResponse = this.samlMessageFactory.createIncomingLogoutResponse(this.settings, httpRequest);
            this.lastResponse = logoutResponse.getLogoutResponseXml();
            if (!logoutResponse.isValid(requestId)) {
                this.errors.add("invalid_logout_response");
                LOGGER.warn("processSLO error. invalid_logout_response");
                LOGGER.debug(" --> {}", (Object)samlResponseParameter);
                this.errorReason = logoutResponse.getError();
                this.validationException = logoutResponse.getValidationException();
            } else {
                SamlResponseStatus samlResponseStatus = logoutResponse.getSamlResponseStatus();
                String status = samlResponseStatus.getStatusCode();
                if (status == null || !"urn:oasis:names:tc:SAML:2.0:status:Success".equals(status)) {
                    this.errors.add("logout_not_success");
                    LOGGER.warn("processSLO error. logout_not_success");
                    LOGGER.debug(" --> {}", (Object)samlResponseParameter);
                    this.errors.add(samlResponseStatus.getStatusCode());
                    if (samlResponseStatus.getSubStatusCode() != null) {
                        this.errors.add(samlResponseStatus.getSubStatusCode());
                    }
                } else {
                    this.lastMessageId = logoutResponse.getId();
                    this.lastMessageIssueInstant = logoutResponse.getIssueInstant();
                    LOGGER.debug("processSLO success --> " + samlResponseParameter);
                    if (!keepLocalSession.booleanValue()) {
                        this.request.getSession().invalidate();
                    }
                }
            }
            return null;
        }
        if (samlRequestParameter != null) {
            LogoutRequest logoutRequest = this.samlMessageFactory.createIncomingLogoutRequest(this.settings, httpRequest);
            this.lastRequest = logoutRequest.getLogoutRequestXml();
            if (!logoutRequest.isValid()) {
                this.errors.add("invalid_logout_request");
                LOGGER.warn("processSLO error. invalid_logout_request");
                LOGGER.debug(" --> {}", (Object)samlRequestParameter);
                this.errorReason = logoutRequest.getError();
                this.validationException = logoutRequest.getValidationException();
                return null;
            }
            this.lastMessageId = logoutRequest.getId();
            this.lastMessageIssueInstant = logoutRequest.getIssueInstant();
            LOGGER.debug("processSLO success --> " + samlRequestParameter);
            if (!keepLocalSession.booleanValue()) {
                this.request.getSession().invalidate();
            }
            String inResponseTo = logoutRequest.id;
            LogoutResponse logoutResponseBuilder = this.samlMessageFactory.createOutgoingLogoutResponse(this.settings, new LogoutResponseParams(inResponseTo, "urn:oasis:names:tc:SAML:2.0:status:Success"));
            this.lastResponse = logoutResponseBuilder.getLogoutResponseXml();
            String samlLogoutResponse = logoutResponseBuilder.getEncodedLogoutResponse();
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("SAMLResponse", samlLogoutResponse);
            String relayState = this.request.getParameter("RelayState");
            if (relayState != null) {
                parameters.put("RelayState", relayState);
            }
            if (this.settings.getLogoutResponseSigned()) {
                String sigAlg = this.settings.getSignatureAlgorithm();
                String signature = this.buildResponseSignature(samlLogoutResponse, relayState, sigAlg);
                parameters.put("SigAlg", sigAlg);
                parameters.put("Signature", signature);
            }
            String sloUrl = this.getSLOResponseUrl();
            if (!stay.booleanValue()) {
                LOGGER.debug("Logout response sent to {} --> {}", (Object)sloUrl, (Object)samlLogoutResponse);
            }
            return ServletUtils.sendRedirect(this.response, sloUrl, parameters, stay);
        }
        this.errors.add("invalid_binding");
        String errorMsg = "SAML LogoutRequest/LogoutResponse not found. Only supported HTTP_REDIRECT Binding";
        throw new SAMLSevereException("SAML LogoutRequest/LogoutResponse not found. Only supported HTTP_REDIRECT Binding", 4);
    }

    public void processSLO(Boolean keepLocalSession, String requestId) {
        this.processSLO(keepLocalSession, requestId, false);
    }

    public void processSLO() {
        this.processSLO(false, null);
    }

    public final boolean isAuthenticated() {
        return this.authenticated;
    }

    public final List<String> getAttributesName() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    public final Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public final Collection<String> getAttribute(String name) {
        return this.attributes.get(name);
    }

    public final String getNameId() {
        return this.nameid;
    }

    public final String getNameIdFormat() {
        return this.nameidFormat;
    }

    public final String getNameIdNameQualifier() {
        return this.nameidNameQualifier;
    }

    public final String getNameIdSPNameQualifier() {
        return this.nameidSPNameQualifier;
    }

    public final String getSessionIndex() {
        return this.sessionIndex;
    }

    public final Instant getSessionExpiration() {
        return this.sessionExpiration;
    }

    public String getLastMessageId() {
        return this.lastMessageId;
    }

    public Calendar getLastMessageIssueInstant() {
        return this.lastMessageIssueInstant;
    }

    public String getLastAssertionId() {
        return this.lastAssertionId;
    }

    public List<Instant> getLastAssertionNotOnOrAfter() {
        return this.lastAssertionNotOnOrAfter;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public String getLastErrorReason() {
        return this.errorReason;
    }

    public Exception getLastValidationException() {
        return this.validationException;
    }

    public String getLastRequestId() {
        return this.lastRequestId;
    }

    public Calendar getLastRequestIssueInstant() {
        return this.lastRequestIssueInstant;
    }

    public Saml2Settings getSettings() {
        return this.settings;
    }

    public Boolean isDebugActive() {
        return this.settings.isDebugActive();
    }

    public String buildRequestSignature(String samlRequest, String relayState, String signAlgorithm) {
        return this.buildSignature(samlRequest, relayState, signAlgorithm, "SAMLRequest");
    }

    public String buildResponseSignature(String samlResponse, String relayState, String signAlgorithm) {
        return this.buildSignature(samlResponse, relayState, signAlgorithm, "SAMLResponse");
    }

    private String buildSignature(String samlMessage, String relayState, String signAlgorithm, String type) {
        String signature = "";
        if (!this.settings.checkSPCerts()) {
            String errorMsg = "Trying to sign the " + type + " but can't load the SP private key";
            LOGGER.warn("buildSignature error. {}", (Object)errorMsg);
            throw new SettingsException(errorMsg, 4);
        }
        PrivateKey key = this.settings.getSPkey();
        StringBuilder msg = new StringBuilder().append(type).append("=").append(Util.urlEncoder((String)samlMessage));
        if (StringUtils.isNotEmpty((CharSequence)relayState)) {
            msg.append("&RelayState=").append(Util.urlEncoder((String)relayState));
        }
        if (StringUtils.isEmpty((CharSequence)signAlgorithm)) {
            signAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        msg.append("&SigAlg=").append(Util.urlEncoder((String)signAlgorithm));
        try {
            signature = Util.base64encoder((byte[])Util.sign((String)msg.toString(), (PrivateKey)key, (String)signAlgorithm));
        }
        catch (InvalidKeyRuntimeException | NoSuchAlgorithmRuntimeException | SAMLSignatureException e) {
            String errorMsg = "buildSignature error." + e.getMessage();
            LOGGER.warn(errorMsg, e);
        }
        if (signature.isEmpty()) {
            String errorMsg = "There was a problem when calculating the Signature of the " + type;
            LOGGER.warn("buildSignature error. {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        LOGGER.debug("buildResponseSignature success. --> {}", (Object)signature);
        return signature;
    }

    public String getLastRequestXML() {
        return this.lastRequest;
    }

    public String getLastResponseXML() {
        return this.lastResponse;
    }

    public void setSamlMessageFactory(SamlMessageFactory samlMessageFactory) {
        this.samlMessageFactory = samlMessageFactory != null ? samlMessageFactory : DEFAULT_SAML_MESSAGE_FACTORY;
    }
}

