/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLErrorAccumulatorHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLErrorAccumulatorHandler.class);
    private final List<SAXParseException> errors = new ArrayList<SAXParseException>();

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errors.add(e);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ErrorHandler#error: parsing xml: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.errors.add(e);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ErrorHandler#fatalError: parsing xml: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.errors.add(e);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ErrorHandler#warning: parsing xml: {}", (Object)e.getMessage());
        }
    }

    public List<SAXParseException> getErrorXML() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }
}

