/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.model.hsm;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import java.util.HashMap;
import org.codelibs.saml2.core.model.hsm.HSM;

public class AzureKeyVault
extends HSM {
    private final String clientId;
    private final String clientCredentials;
    private final String tenantId;
    private final String keyVaultId;
    private CryptographyClient akvClient;
    private final HashMap<String, KeyWrapAlgorithm> algorithmMapping;

    public AzureKeyVault(String clientId, String clientCredentials, String tenantId, String keyVaultId) {
        this.clientId = clientId;
        this.clientCredentials = clientCredentials;
        this.tenantId = tenantId;
        this.keyVaultId = keyVaultId;
        this.algorithmMapping = this.createAlgorithmMapping();
    }

    private HashMap<String, KeyWrapAlgorithm> createAlgorithmMapping() {
        HashMap<String, KeyWrapAlgorithm> mapping = new HashMap<String, KeyWrapAlgorithm>();
        mapping.put("http://www.w3.org/2001/04/xmlenc#rsa-1_5", KeyWrapAlgorithm.RSA1_5);
        mapping.put("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", KeyWrapAlgorithm.RSA_OAEP);
        mapping.put("http://www.w3.org/2001/04/xmlenc#kw-aes128", KeyWrapAlgorithm.A128KW);
        mapping.put("http://www.w3.org/2001/04/xmlenc#kw-aes192", KeyWrapAlgorithm.A192KW);
        mapping.put("http://www.w3.org/2001/04/xmlenc#kw-aes256", KeyWrapAlgorithm.A256KW);
        return mapping;
    }

    private KeyWrapAlgorithm getAlgorithm(String algorithmUrl) {
        return this.algorithmMapping.get(algorithmUrl);
    }

    @Override
    public void setClient() {
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.clientId)).clientSecret(this.clientCredentials).tenantId(this.tenantId)).build();
        HttpClient httpClient = new NettyAsyncHttpClientBuilder().build();
        this.akvClient = new CryptographyClientBuilder().httpClient(httpClient).credential((TokenCredential)clientSecretCredential).keyIdentifier(this.keyVaultId).buildClient();
    }

    @Override
    public byte[] wrapKey(String algorithm, byte[] key) {
        return this.akvClient.wrapKey(KeyWrapAlgorithm.fromString((String)algorithm), key).getEncryptedKey();
    }

    @Override
    public byte[] unwrapKey(String algorithmUrl, byte[] wrappedKey) {
        return this.akvClient.unwrapKey(this.getAlgorithm(algorithmUrl), wrappedKey).getKey();
    }

    @Override
    public byte[] encrypt(String algorithm, byte[] plainText) {
        return this.akvClient.encrypt(EncryptionAlgorithm.fromString((String)algorithm), plainText).getCipherText();
    }

    @Override
    public byte[] decrypt(String algorithm, byte[] cipherText) {
        return this.akvClient.decrypt(EncryptionAlgorithm.fromString((String)algorithm), cipherText).getPlainText();
    }
}

