/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.logout;

import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.codelibs.saml2.core.exception.SAMLException;
import org.codelibs.saml2.core.exception.SettingsException;
import org.codelibs.saml2.core.exception.ValidationException;
import org.codelibs.saml2.core.exception.XMLParsingException;
import org.codelibs.saml2.core.http.HttpRequest;
import org.codelibs.saml2.core.logout.LogoutRequestParams;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.util.SchemaFactory;
import org.codelibs.saml2.core.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LogoutRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutRequest.class);
    private final String logoutRequestString;
    public String id;
    private final Saml2Settings settings;
    private final HttpRequest request;
    private String currentUrl;
    private Calendar issueInstant;
    private Exception validationException;

    @Deprecated
    public LogoutRequest(Saml2Settings settings, HttpRequest request, String nameId, String sessionIndex, String nameIdFormat, String nameIdNameQualifier, String nameIdSPNameQualifier) {
        this.settings = settings;
        this.request = request;
        String samlLogoutRequest = null;
        if (request != null) {
            samlLogoutRequest = request.getParameter("SAMLRequest");
            this.currentUrl = request.getRequestURL();
        }
        if (samlLogoutRequest == null) {
            LogoutRequestParams params = new LogoutRequestParams(sessionIndex, nameId, nameIdFormat, nameIdNameQualifier, nameIdSPNameQualifier);
            this.id = Util.generateUniqueID(settings.getUniqueIDPrefix());
            this.issueInstant = Calendar.getInstance();
            StringSubstitutor substitutor = this.generateSubstitutor(params, settings);
            this.logoutRequestString = this.postProcessXml(substitutor.replace((CharSequence)LogoutRequest.getLogoutRequestTemplate()), params, settings);
        } else {
            this.logoutRequestString = Util.base64decodedInflated(samlLogoutRequest);
            Document doc = Util.loadXML(this.logoutRequestString);
            this.id = LogoutRequest.getId(doc);
            this.issueInstant = LogoutRequest.getIssueInstant(doc);
        }
    }

    @Deprecated
    public LogoutRequest(Saml2Settings settings, HttpRequest request, String nameId, String sessionIndex, String nameIdFormat, String nameIdNameQualifier) {
        this(settings, request, nameId, sessionIndex, nameIdFormat, nameIdNameQualifier, null);
    }

    @Deprecated
    public LogoutRequest(Saml2Settings settings, HttpRequest request, String nameId, String sessionIndex, String nameIdFormat) {
        this(settings, request, nameId, sessionIndex, nameIdFormat, null);
    }

    @Deprecated
    public LogoutRequest(Saml2Settings settings, HttpRequest request, String nameId, String sessionIndex) {
        this(settings, request, nameId, sessionIndex, null);
    }

    public LogoutRequest(Saml2Settings settings) {
        this(settings, new LogoutRequestParams());
    }

    public LogoutRequest(Saml2Settings settings, HttpRequest request) {
        this(settings, request, null, null);
    }

    public LogoutRequest(Saml2Settings settings, LogoutRequestParams params) {
        this.settings = settings;
        this.request = null;
        this.id = Util.generateUniqueID(settings.getUniqueIDPrefix());
        this.issueInstant = Calendar.getInstance();
        StringSubstitutor substitutor = this.generateSubstitutor(params, settings);
        this.logoutRequestString = this.postProcessXml(substitutor.replace((CharSequence)LogoutRequest.getLogoutRequestTemplate()), params, settings);
    }

    protected String postProcessXml(String logoutRequestXml, LogoutRequestParams params, Saml2Settings settings) {
        return logoutRequestXml;
    }

    public String getEncodedLogoutRequest(Boolean deflated) {
        if (deflated == null) {
            deflated = this.settings.isCompressRequestEnabled();
        }
        String encodedLogoutRequest = deflated != false ? Util.deflatedBase64encoded(this.getLogoutRequestXml()) : Util.base64encoder(this.getLogoutRequestXml());
        return encodedLogoutRequest;
    }

    public String getEncodedLogoutRequest() {
        return this.getEncodedLogoutRequest(null);
    }

    public String getLogoutRequestXml() {
        return this.logoutRequestString;
    }

    private StringSubstitutor generateSubstitutor(LogoutRequestParams params, Saml2Settings settings) {
        List<X509Certificate> multipleCertList;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("id", Util.toXml(this.id));
        String issueInstantString = Util.formatDateTime(this.issueInstant.getTimeInMillis());
        valueMap.put("issueInstant", issueInstantString);
        Object destinationStr = "";
        URL slo = settings.getIdpSingleLogoutServiceUrl();
        if (slo != null) {
            destinationStr = " Destination=\"" + Util.toXml(slo.toString()) + "\"";
        }
        valueMap.put("destinationStr", (String)destinationStr);
        valueMap.put("issuer", Util.toXml(settings.getSpEntityId()));
        String nameId = params.getNameId();
        String requestedNameIdFormat = params.getNameIdFormat();
        String nameIdFormat = null;
        String spNameQualifier = params.getNameIdSPNameQualifier();
        String nameQualifier = params.getNameIdNameQualifier();
        if (nameId != null) {
            nameIdFormat = requestedNameIdFormat == null && !"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equals(settings.getSpNameIDFormat()) ? settings.getSpNameIDFormat() : requestedNameIdFormat;
        } else {
            nameId = settings.getIdpEntityId();
            nameIdFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
        }
        if (nameIdFormat != null && "urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(nameIdFormat)) {
            nameQualifier = null;
            spNameQualifier = null;
        }
        if (nameIdFormat != null && "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equals(nameIdFormat)) {
            nameIdFormat = null;
        }
        X509Certificate cert = null;
        if (settings.getNameIdEncrypted() && (cert = settings.getIdpx509cert()) == null && (multipleCertList = settings.getIdpx509certMulti()) != null && !multipleCertList.isEmpty()) {
            cert = multipleCertList.get(0);
        }
        String nameIdStr = Util.generateNameId(nameId, spNameQualifier, nameIdFormat, nameQualifier, cert);
        valueMap.put("nameIdStr", nameIdStr);
        Object sessionIndexStr = "";
        String sessionIndex = params.getSessionIndex();
        if (sessionIndex != null) {
            sessionIndexStr = " <samlp:SessionIndex>" + Util.toXml(sessionIndex) + "</samlp:SessionIndex>";
        }
        valueMap.put("sessionIndexStr", (String)sessionIndexStr);
        return new StringSubstitutor(valueMap);
    }

    private static StringBuilder getLogoutRequestTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<samlp:LogoutRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ");
        template.append("ID=\"${id}\" ");
        template.append("Version=\"2.0\" ");
        template.append("IssueInstant=\"${issueInstant}\"${destinationStr} >");
        template.append("<saml:Issuer>${issuer}</saml:Issuer>");
        template.append("${nameIdStr}${sessionIndexStr}</samlp:LogoutRequest>");
        return template;
    }

    public boolean isValid() {
        this.validationException = null;
        try {
            if (this.logoutRequestString == null || this.logoutRequestString.isEmpty()) {
                throw new ValidationException("SAML Logout Request is not loaded", 14);
            }
            if (this.request == null) {
                throw new IllegalArgumentException("The HttpRequest of the current host was not established");
            }
            if (this.currentUrl == null || this.currentUrl.isEmpty()) {
                throw new IllegalArgumentException("The URL of the current host was not established");
            }
            String signature = this.request.getParameter("Signature");
            Document logoutRequestDocument = Util.loadXML(this.logoutRequestString);
            if (this.settings.isStrict()) {
                String destinationUrl;
                String notOnOrAfter;
                Instant notOnOrAfterDate;
                Element rootElement = logoutRequestDocument.getDocumentElement();
                rootElement.normalize();
                if (this.settings.getWantXMLValidation() && !Util.validateXML(logoutRequestDocument, SchemaFactory.SAML_SCHEMA_PROTOCOL_2_0)) {
                    throw new ValidationException("Invalid SAML Logout Request. Not match the saml-schema-protocol-2.0.xsd", 14);
                }
                if (rootElement.hasAttribute("NotOnOrAfter") && (Util.isEqualNow(notOnOrAfterDate = Util.parseDateTime(notOnOrAfter = rootElement.getAttribute("NotOnOrAfter"))) || Util.isBeforeNow(notOnOrAfterDate))) {
                    throw new ValidationException("Could not validate timestamp: expired. Check system clock.", 44);
                }
                if (rootElement.hasAttribute("Destination") && (destinationUrl = rootElement.getAttribute("Destination")) != null && !destinationUrl.isEmpty() && !destinationUrl.equals(this.currentUrl)) {
                    throw new ValidationException("The LogoutRequest was received at " + this.currentUrl + " instead of " + destinationUrl, 24);
                }
                LogoutRequest.getNameId(logoutRequestDocument, this.settings.getSPkey(), this.settings.isTrimNameIds());
                String issuer = LogoutRequest.getIssuer(logoutRequestDocument, this.settings.isTrimNameIds());
                if (issuer != null && (issuer.isEmpty() || !issuer.equals(this.settings.getIdpEntityId()))) {
                    throw new ValidationException(String.format("Invalid issuer in the Logout Request. Was '%s', but expected '%s'", issuer, this.settings.getIdpEntityId()), 29);
                }
                if (this.settings.getWantMessagesSigned() && (signature == null || signature.isEmpty())) {
                    throw new ValidationException("The Message of the Logout Request is not signed and the SP requires it", 32);
                }
            }
            if (signature != null && !signature.isEmpty()) {
                Boolean rejectDeprecatedAlg;
                X509Certificate cert = this.settings.getIdpx509cert();
                ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
                List<X509Certificate> multipleCertList = this.settings.getIdpx509certMulti();
                if (multipleCertList != null && multipleCertList.size() != 0) {
                    certList.addAll(multipleCertList);
                }
                if (cert != null && (certList.isEmpty() || !certList.contains(cert))) {
                    certList.add(0, cert);
                }
                if (certList.isEmpty()) {
                    throw new SettingsException("In order to validate the sign on the Logout Request, the x509cert of the IdP is required", 3);
                }
                String signAlg = this.request.getParameter("SigAlg");
                if (signAlg == null || signAlg.isEmpty()) {
                    signAlg = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                }
                if (Util.mustRejectDeprecatedSignatureAlgo(signAlg, rejectDeprecatedAlg = Boolean.valueOf(this.settings.getRejectDeprecatedAlg()))) {
                    return false;
                }
                String relayState = this.request.getEncodedParameter("RelayState");
                StringBuilder signedQuery = new StringBuilder("SAMLRequest=").append(this.request.getEncodedParameter("SAMLRequest"));
                if (relayState != null && !relayState.isEmpty()) {
                    signedQuery.append("&RelayState=").append(relayState);
                }
                signedQuery.append("&SigAlg=").append(this.request.getEncodedParameter("SigAlg", signAlg));
                if (!Util.validateBinarySignature(signedQuery.toString(), Util.base64decoder(signature), certList, signAlg)) {
                    throw new ValidationException("Signature validation failed. Logout Request rejected", 42);
                }
            }
            LOGGER.debug("LogoutRequest validated --> {}", (Object)this.logoutRequestString);
            return true;
        }
        catch (Exception e) {
            this.validationException = e;
            LOGGER.debug("LogoutRequest invalid --> {}", (Object)this.logoutRequestString, (Object)e);
            LOGGER.warn(this.validationException.getMessage());
            return false;
        }
    }

    public static String getId(Document samlLogoutRequestDocument) {
        String id = null;
        try {
            Element rootElement = samlLogoutRequestDocument.getDocumentElement();
            rootElement.normalize();
            id = rootElement.getAttribute("ID");
        }
        catch (Exception e) {
            LOGGER.debug("Failed to get ID.", (Throwable)e);
        }
        return id;
    }

    public static Calendar getIssueInstant(Document samlLogoutRequestDocument) {
        Calendar issueInstant = null;
        try {
            String issueInstantString;
            Element rootElement = samlLogoutRequestDocument.getDocumentElement();
            rootElement.normalize();
            String string = issueInstantString = rootElement.hasAttribute("IssueInstant") ? rootElement.getAttribute("IssueInstant") : null;
            if (issueInstantString == null) {
                return null;
            }
            issueInstant = Calendar.getInstance();
            issueInstant.setTimeInMillis(Util.parseDateTime(issueInstantString).toEpochMilli());
        }
        catch (Exception e) {
            LOGGER.debug("Failed to get an issue instant.", (Throwable)e);
        }
        return issueInstant;
    }

    public static String getId(String samlLogoutRequestString) {
        Document doc = Util.loadXML(samlLogoutRequestString);
        return LogoutRequest.getId(doc);
    }

    public static Calendar getIssueInstant(String samlLogoutRequestString) {
        Document doc = Util.loadXML(samlLogoutRequestString);
        return LogoutRequest.getIssueInstant(doc);
    }

    public static Map<String, String> getNameIdData(Document samlLogoutRequestDocument, PrivateKey key) {
        return LogoutRequest.getNameIdData(samlLogoutRequestDocument, key, false);
    }

    public static Map<String, String> getNameIdData(Document samlLogoutRequestDocument, PrivateKey key, boolean trimValue) {
        try {
            NodeList nameIdNodes;
            NodeList encryptedIDNodes = Util.query(samlLogoutRequestDocument, "/samlp:LogoutRequest/saml:EncryptedID");
            if (encryptedIDNodes.getLength() == 1) {
                if (key == null) {
                    throw new SettingsException("Key is required in order to decrypt the NameID", 4);
                }
                Element encryptedData = (Element)encryptedIDNodes.item(0);
                Util.decryptElement(encryptedData, key);
                nameIdNodes = Util.query(samlLogoutRequestDocument, "/samlp:LogoutRequest/saml:NameID");
                if (nameIdNodes == null || nameIdNodes.getLength() != 1) {
                    throw new SAMLException("Not able to decrypt the EncryptedID and get a NameID");
                }
            } else {
                nameIdNodes = Util.query(samlLogoutRequestDocument, "/samlp:LogoutRequest/saml:NameID");
            }
            if (nameIdNodes == null || nameIdNodes.getLength() != 1) {
                throw new ValidationException("No name id found in Logout Request.", 38);
            }
            Element nameIdElem = (Element)nameIdNodes.item(0);
            HashMap<String, String> nameIdData = new HashMap<String, String>();
            if (nameIdElem != null) {
                String value = nameIdElem.getTextContent();
                if (value != null && trimValue) {
                    value = value.trim();
                }
                nameIdData.put("Value", value);
                if (nameIdElem.hasAttribute("Format")) {
                    nameIdData.put("Format", nameIdElem.getAttribute("Format"));
                }
                if (nameIdElem.hasAttribute("SPNameQualifier")) {
                    nameIdData.put("SPNameQualifier", nameIdElem.getAttribute("SPNameQualifier"));
                }
                if (nameIdElem.hasAttribute("NameQualifier")) {
                    nameIdData.put("NameQualifier", nameIdElem.getAttribute("NameQualifier"));
                }
            }
            return nameIdData;
        }
        catch (SAMLException e) {
            throw e;
        }
        catch (DOMException e) {
            throw new XMLParsingException("Failed to get NameID Data.", e);
        }
    }

    public static Map<String, String> getNameIdData(String samlLogoutRequestString, PrivateKey key) {
        return LogoutRequest.getNameIdData(samlLogoutRequestString, key, false);
    }

    public static Map<String, String> getNameIdData(String samlLogoutRequestString, PrivateKey key, boolean trimValue) {
        Document doc = Util.loadXML(samlLogoutRequestString);
        return LogoutRequest.getNameIdData(doc, key, trimValue);
    }

    public static String getNameId(Document samlLogoutRequestDocument, PrivateKey key) {
        return LogoutRequest.getNameId(samlLogoutRequestDocument, key, false);
    }

    public static String getNameId(Document samlLogoutRequestDocument, PrivateKey key, boolean trimValue) {
        Map<String, String> nameIdData = LogoutRequest.getNameIdData(samlLogoutRequestDocument, key, trimValue);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("LogoutRequest has NameID --> {}", (Object)nameIdData.get("Value"));
        }
        return nameIdData.get("Value");
    }

    public static String getNameId(Document samlLogoutRequestDocument) {
        return LogoutRequest.getNameId(samlLogoutRequestDocument, null);
    }

    public static String getNameId(String samlLogoutRequestString, PrivateKey key) {
        return LogoutRequest.getNameId(samlLogoutRequestString, key, false);
    }

    public static String getNameId(String samlLogoutRequestString, PrivateKey key, boolean trimValue) {
        Map<String, String> nameId = LogoutRequest.getNameIdData(samlLogoutRequestString, key, trimValue);
        return nameId.get("Value");
    }

    public static String getNameId(String samlLogoutRequestString) {
        return LogoutRequest.getNameId(samlLogoutRequestString, null);
    }

    public static String getIssuer(Document samlLogoutRequestDocument) {
        return LogoutRequest.getIssuer(samlLogoutRequestDocument, false);
    }

    public static String getIssuer(Document samlLogoutRequestDocument, boolean trim) {
        String issuer = null;
        NodeList nodes = Util.query(samlLogoutRequestDocument, "/samlp:LogoutRequest/saml:Issuer");
        if (nodes.getLength() == 1) {
            issuer = nodes.item(0).getTextContent();
        }
        if (issuer != null && trim) {
            issuer = issuer.trim();
        }
        return issuer;
    }

    public static String getIssuer(String samlLogoutRequestString) {
        return LogoutRequest.getIssuer(samlLogoutRequestString, false);
    }

    public static String getIssuer(String samlLogoutRequestString, boolean trim) {
        Document doc = Util.loadXML(samlLogoutRequestString);
        return LogoutRequest.getIssuer(doc, trim);
    }

    public static List<String> getSessionIndexes(Document samlLogoutRequestDocument) {
        return LogoutRequest.getSessionIndexes(samlLogoutRequestDocument, false);
    }

    public static List<String> getSessionIndexes(Document samlLogoutRequestDocument, boolean trim) {
        ArrayList<String> sessionIndexes = new ArrayList<String>();
        NodeList nodes = Util.query(samlLogoutRequestDocument, "/samlp:LogoutRequest/samlp:SessionIndex");
        for (int i = 0; i < nodes.getLength(); ++i) {
            String sessionIndex = nodes.item(i).getTextContent();
            if (sessionIndex == null) continue;
            if (trim) {
                sessionIndex = sessionIndex.trim();
            }
            sessionIndexes.add(sessionIndex);
        }
        return sessionIndexes;
    }

    public static List<String> getSessionIndexes(String samlLogoutRequestString) {
        return LogoutRequest.getSessionIndexes(samlLogoutRequestString, false);
    }

    public static List<String> getSessionIndexes(String samlLogoutRequestString, boolean trim) {
        Document doc = Util.loadXML(samlLogoutRequestString);
        return LogoutRequest.getSessionIndexes(doc, trim);
    }

    public String getError() {
        if (this.validationException != null) {
            return this.validationException.getMessage();
        }
        return null;
    }

    public Exception getValidationException() {
        return this.validationException;
    }

    protected void setValidationException(Exception validationException) {
        this.validationException = validationException;
    }

    public String getId() {
        return this.id;
    }

    public Calendar getIssueInstant() {
        return this.issueInstant == null ? null : (Calendar)this.issueInstant.clone();
    }
}

