/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.authn;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.codelibs.saml2.core.exception.SAMLException;
import org.codelibs.saml2.core.exception.SettingsException;
import org.codelibs.saml2.core.exception.ValidationException;
import org.codelibs.saml2.core.exception.XMLParsingException;
import org.codelibs.saml2.core.http.HttpRequest;
import org.codelibs.saml2.core.model.SamlResponseStatus;
import org.codelibs.saml2.core.model.SubjectConfirmationIssue;
import org.codelibs.saml2.core.model.hsm.HSM;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.util.SchemaFactory;
import org.codelibs.saml2.core.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SamlResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlResponse.class);
    private final Saml2Settings settings;
    private String samlResponseString;
    private Document samlResponseDocument;
    private Document decryptedDocument;
    private Map<String, String> nameIdData = null;
    private String currentUrl;
    private Boolean encrypted = false;
    private Exception validationException;
    private SamlResponseStatus responseStatus;

    public SamlResponse(Saml2Settings settings, String currentUrl, String samlResponse) {
        this.settings = settings;
        this.currentUrl = currentUrl;
        this.loadXmlFromBase64(samlResponse);
    }

    public SamlResponse(Saml2Settings settings, HttpRequest request) {
        this(settings, request.getRequestURL(), request.getParameter("SAMLResponse"));
    }

    public void loadXmlFromBase64(String responseStr) {
        try {
            this.samlResponseString = new String(Util.base64decoder(responseStr), "UTF-8");
            this.samlResponseDocument = Util.loadXML(this.samlResponseString);
            if (this.samlResponseDocument == null) {
                throw new ValidationException("SAML Response could not be processed", 14);
            }
            NodeList encryptedAssertionNodes = this.samlResponseDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
            if (encryptedAssertionNodes.getLength() != 0) {
                this.decryptedDocument = Util.copyDocument(this.samlResponseDocument);
                this.encrypted = true;
                this.decryptedDocument = this.decryptAssertion(this.decryptedDocument);
            }
        }
        catch (SAMLException e) {
            throw e;
        }
        catch (IOException e) {
            throw new XMLParsingException("Failed to load XML data.", e);
        }
    }

    public boolean isValid(String requestId) {
        this.validationException = null;
        try {
            Document documentToCheckAssertion;
            if (this.samlResponseDocument == null) {
                throw new Exception("SAML Response is not loaded");
            }
            if (this.currentUrl == null || this.currentUrl.isEmpty()) {
                throw new Exception("The URL of the current host was not established");
            }
            Element rootElement = this.samlResponseDocument.getDocumentElement();
            rootElement.normalize();
            if (!"2.0".equals(rootElement.getAttribute("Version"))) {
                throw new ValidationException("Unsupported SAML Version on Response.", 0);
            }
            if (!rootElement.hasAttribute("ID")) {
                throw new ValidationException("Missing ID attribute on SAML Response.", 1);
            }
            this.checkStatus();
            if (!this.validateNumAssertions()) {
                throw new ValidationException("SAML Response must contain 1 Assertion.", 2);
            }
            ArrayList<String> signedElements = this.processSignedElements();
            String responseTag = "{urn:oasis:names:tc:SAML:2.0:protocol}Response";
            String assertionTag = "{urn:oasis:names:tc:SAML:2.0:assertion}Assertion";
            boolean hasSignedResponse = signedElements.contains("{urn:oasis:names:tc:SAML:2.0:protocol}Response");
            boolean hasSignedAssertion = signedElements.contains("{urn:oasis:names:tc:SAML:2.0:assertion}Assertion");
            if (this.settings.isStrict()) {
                NodeList encryptedNameIdNodes;
                String responseInResponseTo;
                if (this.settings.getWantXMLValidation()) {
                    if (!Util.validateXML(this.samlResponseDocument, SchemaFactory.SAML_SCHEMA_PROTOCOL_2_0)) {
                        throw new ValidationException("Invalid SAML Response. Not match the saml-schema-protocol-2.0.xsd", 14);
                    }
                    if (this.encrypted.booleanValue() && !Util.validateXML(this.decryptedDocument, SchemaFactory.SAML_SCHEMA_PROTOCOL_2_0)) {
                        throw new ValidationException("Invalid decrypted SAML Response. Not match the saml-schema-protocol-2.0.xsd", 14);
                    }
                }
                String string = responseInResponseTo = rootElement.hasAttribute("InResponseTo") ? rootElement.getAttribute("InResponseTo") : null;
                if (requestId == null && responseInResponseTo != null && this.settings.isRejectUnsolicitedResponsesWithInResponseTo()) {
                    throw new ValidationException("The Response has an InResponseTo attribute: " + responseInResponseTo + " while no InResponseTo was expected", 15);
                }
                if (requestId != null && !Objects.equals(responseInResponseTo, requestId)) {
                    throw new ValidationException("The InResponseTo of the Response: " + responseInResponseTo + ", does not match the ID of the AuthNRequest sent by the SP: " + requestId, 15);
                }
                NodeList assertions = this.queryAssertion("");
                Node versionAttribute = assertions.item(0).getAttributes().getNamedItem("Version");
                if (versionAttribute == null || !"2.0".equals(versionAttribute.getNodeValue())) {
                    throw new ValidationException("Unsupported SAML Version on Assertion.", 0);
                }
                if (!this.encrypted.booleanValue() && this.settings.getWantAssertionsEncrypted()) {
                    throw new ValidationException("The assertion of the Response is not encrypted and the SP requires it", 16);
                }
                if (this.settings.getWantNameIdEncrypted() && (encryptedNameIdNodes = this.queryAssertion("/saml:Subject/saml:EncryptedID/xenc:EncryptedData")).getLength() == 0) {
                    throw new ValidationException("The NameID of the Response is not encrypted and the SP requires it", 17);
                }
                if (!this.checkOneCondition().booleanValue()) {
                    throw new ValidationException("The Assertion must include a Conditions element", 18);
                }
                if (!this.validateTimestamps()) {
                    throw new Exception("Timing issues (please check your clock settings)");
                }
                if (!this.checkOneAuthnStatement().booleanValue()) {
                    throw new ValidationException("The Assertion must include an AuthnStatement element", 21);
                }
                NodeList encryptedAttributeNodes = this.queryAssertion("/saml:AttributeStatement/saml:EncryptedAttribute");
                if (encryptedAttributeNodes.getLength() > 0) {
                    throw new ValidationException("There is an EncryptedAttribute in the Response and this SP does not support them", 23);
                }
                this.validateDestination(rootElement);
                this.validateAudiences();
                List<String> issuers = this.getIssuers();
                for (String issuer : issuers) {
                    if (!issuer.isEmpty() && issuer.equals(this.settings.getIdpEntityId())) continue;
                    throw new ValidationException(String.format("Invalid issuer in the Assertion/Response. Was '%s', but expected '%s'", issuer, this.settings.getIdpEntityId()), 29);
                }
                Instant sessionExpiration = this.getSessionNotOnOrAfter();
                if (sessionExpiration != null && (Util.isEqualNow(sessionExpiration = ChronoUnit.SECONDS.addTo(sessionExpiration, 180L)) || Util.isBeforeNow(sessionExpiration))) {
                    throw new ValidationException("The attributes have expired, based on the SessionNotOnOrAfter of the AttributeStatement of this Response", 30);
                }
                this.validateSubjectConfirmation(responseInResponseTo);
                if (this.settings.getWantAssertionsSigned() && !hasSignedAssertion) {
                    throw new ValidationException("The Assertion of the Response is not signed and the SP requires it", 33);
                }
                if (this.settings.getWantMessagesSigned() && !hasSignedResponse) {
                    throw new ValidationException("The Message of the Response is not signed and the SP requires it", 32);
                }
            }
            if (signedElements.isEmpty() || !hasSignedAssertion && !hasSignedResponse) {
                throw new ValidationException("No Signature found. SAML Response rejected", 34);
            }
            X509Certificate cert = this.settings.getIdpx509cert();
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            List<X509Certificate> multipleCertList = this.settings.getIdpx509certMulti();
            if (multipleCertList != null && !multipleCertList.isEmpty()) {
                certList.addAll(multipleCertList);
            }
            if (cert != null && !certList.contains(cert)) {
                certList.add(0, cert);
            }
            String fingerprint = this.settings.getIdpCertFingerprint();
            String alg = this.settings.getIdpCertFingerprintAlgorithm();
            Boolean rejectDeprecatedAlg = this.settings.getRejectDeprecatedAlg();
            if (hasSignedResponse && !Util.validateSign(this.samlResponseDocument, certList, fingerprint, alg, "/samlp:Response/ds:Signature", rejectDeprecatedAlg)) {
                throw new ValidationException("Signature validation failed. SAML Response rejected", 42);
            }
            Document document = documentToCheckAssertion = this.encrypted != false ? this.decryptedDocument : this.samlResponseDocument;
            if (hasSignedAssertion && !Util.validateSign(documentToCheckAssertion, certList, fingerprint, alg, "/samlp:Response/saml:Assertion/ds:Signature", rejectDeprecatedAlg)) {
                throw new ValidationException("Signature validation failed. SAML Response rejected", 42);
            }
            LOGGER.debug("SAMLResponse validated --> {}", (Object)this.samlResponseString);
            return true;
        }
        catch (Exception e) {
            this.validationException = e;
            LOGGER.debug("SAMLResponse invalid --> {}", (Object)this.samlResponseString);
            LOGGER.warn(this.validationException.getMessage());
            return false;
        }
    }

    private void validateSubjectConfirmation(String responseInResponseTo) {
        ArrayList<SubjectConfirmationIssue> validationIssues = new ArrayList<SubjectConfirmationIssue>();
        boolean validSubjectConfirmation = false;
        NodeList subjectConfirmationNodes = this.queryAssertion("/saml:Subject/saml:SubjectConfirmation");
        for (int i = 0; i < subjectConfirmationNodes.getLength(); ++i) {
            Node scn = subjectConfirmationNodes.item(i);
            Node method = scn.getAttributes().getNamedItem("Method");
            if (method != null && !"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(method.getNodeValue())) continue;
            NodeList subjectConfirmationDataNodes = scn.getChildNodes();
            for (int c = 0; c < subjectConfirmationDataNodes.getLength(); ++c) {
                if (subjectConfirmationDataNodes.item(c).getLocalName() == null || !"SubjectConfirmationData".equals(subjectConfirmationDataNodes.item(c).getLocalName())) continue;
                Node recipient = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("Recipient");
                SubjectConfirmationIssue issue = this.validateRecipient(recipient, i);
                if (issue != null) {
                    validationIssues.add(issue);
                    continue;
                }
                Node inResponseTo = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("InResponseTo");
                if (inResponseTo == null && responseInResponseTo != null || inResponseTo != null && !inResponseTo.getNodeValue().equals(responseInResponseTo)) {
                    validationIssues.add(new SubjectConfirmationIssue(i, "SubjectConfirmationData has an invalid InResponseTo value"));
                    continue;
                }
                Node notOnOrAfter = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("NotOnOrAfter");
                if (notOnOrAfter == null) {
                    validationIssues.add(new SubjectConfirmationIssue(i, "SubjectConfirmationData doesn't contain a NotOnOrAfter attribute"));
                    continue;
                }
                Instant noa = Util.parseDateTime(notOnOrAfter.getNodeValue());
                if (Util.isEqualNow(noa = ChronoUnit.SECONDS.addTo(noa, 180L)) || Util.isBeforeNow(noa)) {
                    validationIssues.add(new SubjectConfirmationIssue(i, "SubjectConfirmationData is no longer valid"));
                    continue;
                }
                Node notBefore = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("NotBefore");
                if (notBefore != null) {
                    Instant nb = Util.parseDateTime(notBefore.getNodeValue());
                    if (Util.isAfterNow(nb = ChronoUnit.SECONDS.addTo(nb, -180L))) {
                        validationIssues.add(new SubjectConfirmationIssue(i, "SubjectConfirmationData is not yet valid"));
                        continue;
                    }
                }
                validSubjectConfirmation = true;
            }
        }
        if (!validSubjectConfirmation) {
            throw new ValidationException(SubjectConfirmationIssue.prettyPrintIssues(validationIssues), 31);
        }
    }

    public boolean isValid() {
        return this.isValid(null);
    }

    public Map<String, String> getNameIdData() {
        if (this.nameIdData != null) {
            return this.nameIdData;
        }
        try {
            NodeList nameIdNodes;
            HashMap<String, String> nameIdData = new HashMap<String, String>();
            NodeList encryptedIDNodes = this.queryAssertion("/saml:Subject/saml:EncryptedID");
            if (encryptedIDNodes.getLength() == 1) {
                NodeList encryptedDataNodes = this.queryAssertion("/saml:Subject/saml:EncryptedID/xenc:EncryptedData");
                if (encryptedDataNodes.getLength() == 1) {
                    Element encryptedData = (Element)encryptedDataNodes.item(0);
                    PrivateKey key = this.settings.getSPkey();
                    if (key == null) {
                        throw new SettingsException("Key is required in order to decrypt the NameID", 4);
                    }
                    Util.decryptElement(encryptedData, key);
                }
                if ((nameIdNodes = this.queryAssertion("/saml:Subject/saml:EncryptedID/saml:NameID|/saml:Subject/saml:NameID")) == null || nameIdNodes.getLength() == 0) {
                    throw new SAMLException("Not able to decrypt the EncryptedID and get a NameID");
                }
            } else {
                nameIdNodes = this.queryAssertion("/saml:Subject/saml:NameID");
            }
            if (nameIdNodes != null && nameIdNodes.getLength() == 1) {
                Element nameIdElem = (Element)nameIdNodes.item(0);
                if (nameIdElem != null) {
                    String value = nameIdElem.getTextContent();
                    if (value != null && this.settings.isTrimNameIds()) {
                        value = value.trim();
                    }
                    if (this.settings.isStrict() && StringUtils.isEmpty((CharSequence)value)) {
                        throw new ValidationException("An empty NameID value found", 39);
                    }
                    nameIdData.put("Value", value);
                    if (nameIdElem.hasAttribute("Format")) {
                        nameIdData.put("Format", nameIdElem.getAttribute("Format"));
                    }
                    if (nameIdElem.hasAttribute("SPNameQualifier")) {
                        String spNameQualifier = nameIdElem.getAttribute("SPNameQualifier");
                        this.validateSpNameQualifier(spNameQualifier);
                        nameIdData.put("SPNameQualifier", spNameQualifier);
                    }
                    if (nameIdElem.hasAttribute("NameQualifier")) {
                        nameIdData.put("NameQualifier", nameIdElem.getAttribute("NameQualifier"));
                    }
                }
            } else if (this.settings.getWantNameId()) {
                throw new ValidationException("No name id found in Document.", 38);
            }
            this.nameIdData = nameIdData;
            return nameIdData;
        }
        catch (SAMLException e) {
            throw e;
        }
        catch (DOMException e) {
            throw new XMLParsingException("Failed to get NameID.", e);
        }
    }

    public String getNameId() {
        Map<String, String> nameIdData = this.getNameIdData();
        String nameID = null;
        if (!nameIdData.isEmpty()) {
            LOGGER.debug("SAMLResponse has NameID --> {}", (Object)nameIdData.get("Value"));
            nameID = nameIdData.get("Value");
        }
        return nameID;
    }

    public String getNameIdFormat() {
        Map<String, String> nameIdData = this.getNameIdData();
        String nameidFormat = null;
        if (!nameIdData.isEmpty() && nameIdData.containsKey("Format")) {
            LOGGER.debug("SAMLResponse has NameID Format --> {}", (Object)nameIdData.get("Format"));
            nameidFormat = nameIdData.get("Format");
        }
        return nameidFormat;
    }

    public String getNameIdNameQualifier() {
        Map<String, String> nameIdData = this.getNameIdData();
        String nameQualifier = null;
        if (!nameIdData.isEmpty() && nameIdData.containsKey("NameQualifier")) {
            LOGGER.debug("SAMLResponse has NameID NameQualifier --> " + nameIdData.get("NameQualifier"));
            nameQualifier = nameIdData.get("NameQualifier");
        }
        return nameQualifier;
    }

    public String getNameIdSPNameQualifier() {
        Map<String, String> nameIdData = this.getNameIdData();
        String spNameQualifier = null;
        if (!nameIdData.isEmpty() && nameIdData.containsKey("SPNameQualifier")) {
            LOGGER.debug("SAMLResponse has NameID NameQualifier --> " + nameIdData.get("SPNameQualifier"));
            spNameQualifier = nameIdData.get("SPNameQualifier");
        }
        return spNameQualifier;
    }

    public Map<String, List<String>> getAttributes() {
        LinkedHashMap<String, List<String>> attributes = new LinkedHashMap<String, List<String>>();
        NodeList nodes = this.queryAssertion("/saml:AttributeStatement/saml:Attribute");
        if (nodes.getLength() != 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                NamedNodeMap attrName = nodes.item(i).getAttributes();
                String attName = attrName.getNamedItem("Name").getNodeValue();
                if (attributes.containsKey(attName) && !this.settings.isAllowRepeatAttributeName()) {
                    throw new ValidationException("Found an Attribute element with duplicated Name", 41);
                }
                NodeList childrens = nodes.item(i).getChildNodes();
                List attrValues = null;
                attrValues = attributes.containsKey(attName) && this.settings.isAllowRepeatAttributeName() ? (List)attributes.get(attName) : new ArrayList();
                for (int j = 0; j < childrens.getLength(); ++j) {
                    if (!"AttributeValue".equals(childrens.item(j).getLocalName())) continue;
                    String attrValue = childrens.item(j).getTextContent();
                    if (attrValue != null && this.settings.isTrimAttributeValues()) {
                        attrValue = attrValue.trim();
                    }
                    attrValues.add(attrValue);
                }
                attributes.put(attName, attrValues);
            }
            LOGGER.debug("SAMLResponse has attributes: {}", (Object)((Object)attributes).toString());
        } else {
            LOGGER.debug("SAMLResponse has no attributes");
        }
        return attributes;
    }

    public SamlResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    public void checkStatus() {
        this.responseStatus = SamlResponse.getStatus(this.samlResponseDocument);
        if (!this.responseStatus.is("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            StringBuilder statusExceptionMsg = new StringBuilder("The status code of the Response was not Success, was ").append(this.responseStatus.getStatusCode());
            if (this.responseStatus.getStatusMessage() != null) {
                statusExceptionMsg.append(" -> ").append(this.responseStatus.getStatusMessage());
            }
            throw new ValidationException(statusExceptionMsg.toString(), 5);
        }
    }

    public static SamlResponseStatus getStatus(Document dom) {
        String statusXpath = "/samlp:Response/samlp:Status";
        return Util.getStatus("/samlp:Response/samlp:Status", dom);
    }

    public Boolean checkOneCondition() {
        NodeList entries = this.queryAssertion("/saml:Conditions");
        if (entries.getLength() == 1) {
            return true;
        }
        return false;
    }

    public Boolean checkOneAuthnStatement() {
        NodeList entries = this.queryAssertion("/saml:AuthnStatement");
        if (entries.getLength() == 1) {
            return true;
        }
        return false;
    }

    public List<String> getAudiences() {
        ArrayList<String> audiences = new ArrayList<String>();
        NodeList entries = this.queryAssertion("/saml:Conditions/saml:AudienceRestriction/saml:Audience");
        for (int i = 0; i < entries.getLength(); ++i) {
            if (entries.item(i) == null) continue;
            String value = entries.item(i).getTextContent();
            if (value != null) {
                value = value.trim();
            }
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            audiences.add(value);
        }
        return audiences;
    }

    public String getResponseIssuer() {
        NodeList responseIssuer = Util.query(this.samlResponseDocument, "/samlp:Response/saml:Issuer");
        if (responseIssuer.getLength() > 0) {
            if (responseIssuer.getLength() != 1) {
                throw new ValidationException("Issuer of the Response is multiple.", 27);
            }
            String value = responseIssuer.item(0).getTextContent();
            if (value != null && this.settings.isTrimNameIds()) {
                value = value.trim();
            }
            return value;
        }
        return null;
    }

    public String getAssertionIssuer() {
        NodeList assertionIssuer = this.queryAssertion("/saml:Issuer");
        if (assertionIssuer.getLength() != 1) {
            throw new ValidationException("Issuer of the Assertion not found or multiple.", 28);
        }
        String value = assertionIssuer.item(0).getTextContent();
        if (value != null && this.settings.isTrimNameIds()) {
            value = value.trim();
        }
        return value;
    }

    @Deprecated
    public List<String> getIssuers() {
        String assertionIssuer;
        ArrayList<String> issuers = new ArrayList<String>();
        String responseIssuer = this.getResponseIssuer();
        if (responseIssuer != null) {
            issuers.add(responseIssuer);
        }
        if (!issuers.contains(assertionIssuer = this.getAssertionIssuer())) {
            issuers.add(assertionIssuer);
        }
        return issuers;
    }

    public Instant getSessionNotOnOrAfter() {
        String notOnOrAfter = null;
        NodeList entries = this.queryAssertion("/saml:AuthnStatement[@SessionNotOnOrAfter]");
        if (entries.getLength() > 0) {
            notOnOrAfter = entries.item(0).getAttributes().getNamedItem("SessionNotOnOrAfter").getNodeValue();
            return Util.parseDateTime(notOnOrAfter);
        }
        return null;
    }

    public String getSessionIndex() {
        String sessionIndex = null;
        NodeList entries = this.queryAssertion("/saml:AuthnStatement[@SessionIndex]");
        if (entries.getLength() > 0) {
            sessionIndex = entries.item(0).getAttributes().getNamedItem("SessionIndex").getNodeValue();
        }
        return sessionIndex;
    }

    public String getId() {
        return this.samlResponseDocument.getDocumentElement().getAttributes().getNamedItem("ID").getNodeValue();
    }

    public String getAssertionId() {
        if (!this.validateNumAssertions()) {
            throw new IllegalArgumentException("SAML Response must contain 1 Assertion.");
        }
        NodeList assertionNode = this.queryAssertion("");
        return assertionNode.item(0).getAttributes().getNamedItem("ID").getNodeValue();
    }

    public List<Instant> getAssertionNotOnOrAfter() {
        NodeList notOnOrAfterNodes = this.queryAssertion("/saml:Subject/saml:SubjectConfirmation/saml:SubjectConfirmationData");
        ArrayList<Instant> notOnOrAfters = new ArrayList<Instant>();
        for (int i = 0; i < notOnOrAfterNodes.getLength(); ++i) {
            Node notOnOrAfterAttribute = notOnOrAfterNodes.item(i).getAttributes().getNamedItem("NotOnOrAfter");
            if (notOnOrAfterAttribute == null) continue;
            notOnOrAfters.add(Instant.parse(notOnOrAfterAttribute.getNodeValue()));
        }
        return notOnOrAfters;
    }

    public boolean validateNumAssertions() {
        boolean valid;
        NodeList encryptedAssertionNodes = this.samlResponseDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
        NodeList assertionNodes = this.samlResponseDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        boolean bl = valid = assertionNodes.getLength() + encryptedAssertionNodes.getLength() == 1;
        if (this.encrypted.booleanValue()) {
            valid = valid && this.decryptedDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").getLength() == 1;
        }
        return valid;
    }

    public ArrayList<String> processSignedElements() {
        ArrayList<String> signedElements = new ArrayList<String>();
        ArrayList<String> verifiedSeis = new ArrayList<String>();
        ArrayList<String> verifiedIds = new ArrayList<String>();
        NodeList signNodes = this.query("//ds:Signature", null);
        for (int i = 0; i < signNodes.getLength(); ++i) {
            Node signNode = signNodes.item(i);
            String signedElement = "{" + signNode.getParentNode().getNamespaceURI() + "}" + signNode.getParentNode().getLocalName();
            String responseTag = "{urn:oasis:names:tc:SAML:2.0:protocol}Response";
            String assertionTag = "{urn:oasis:names:tc:SAML:2.0:assertion}Assertion";
            if (!"{urn:oasis:names:tc:SAML:2.0:protocol}Response".equals(signedElement) && !"{urn:oasis:names:tc:SAML:2.0:assertion}Assertion".equals(signedElement)) {
                throw new ValidationException("Invalid Signature Element " + signedElement + " SAML Response rejected", 6);
            }
            Node idNode = signNode.getParentNode().getAttributes().getNamedItem("ID");
            if (idNode == null || idNode.getNodeValue() == null || idNode.getNodeValue().isEmpty()) {
                throw new ValidationException("Signed Element must contain an ID. SAML Response rejected", 7);
            }
            String idValue = idNode.getNodeValue();
            if (verifiedIds.contains(idValue)) {
                throw new ValidationException("Duplicated ID. SAML Response rejected", 8);
            }
            verifiedIds.add(idValue);
            NodeList refNodes = Util.query(null, "ds:SignedInfo/ds:Reference", signNode);
            if (refNodes.getLength() != 1) {
                throw new ValidationException("Unexpected number of Reference nodes found for signature. SAML Response rejected.", 45);
            }
            Node refNode = refNodes.item(0);
            Node seiNode = refNode.getAttributes().getNamedItem("URI");
            if (seiNode != null && seiNode.getNodeValue() != null && !seiNode.getNodeValue().isEmpty()) {
                String sei = seiNode.getNodeValue().substring(1);
                if (!sei.equals(idValue)) {
                    throw new ValidationException("Found an invalid Signed Element. SAML Response rejected", 9);
                }
                if (verifiedSeis.contains(sei)) {
                    throw new ValidationException("Duplicated Reference URI. SAML Response rejected", 10);
                }
                verifiedSeis.add(sei);
            }
            signedElements.add(signedElement);
        }
        if (!signedElements.isEmpty() && !this.validateSignedElements(signedElements)) {
            throw new ValidationException("Found an unexpected Signature Element. SAML Response rejected", 11);
        }
        return signedElements;
    }

    public boolean validateSignedElements(ArrayList<String> signedElements) {
        NodeList expectedSignatureNode;
        if (signedElements.size() > 2) {
            return false;
        }
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        for (String e : signedElements) {
            if (occurrences.containsKey(e)) {
                occurrences.put(e, (Integer)occurrences.get(e) + 1);
                continue;
            }
            occurrences.put(e, 1);
        }
        String responseTag = "{urn:oasis:names:tc:SAML:2.0:protocol}Response";
        String assertionTag = "{urn:oasis:names:tc:SAML:2.0:assertion}Assertion";
        if (occurrences.containsKey("{urn:oasis:names:tc:SAML:2.0:protocol}Response") && (Integer)occurrences.get("{urn:oasis:names:tc:SAML:2.0:protocol}Response") > 1 || occurrences.containsKey("{urn:oasis:names:tc:SAML:2.0:assertion}Assertion") && (Integer)occurrences.get("{urn:oasis:names:tc:SAML:2.0:assertion}Assertion") > 1 || !occurrences.containsKey("{urn:oasis:names:tc:SAML:2.0:protocol}Response") && !occurrences.containsKey("{urn:oasis:names:tc:SAML:2.0:assertion}Assertion")) {
            return false;
        }
        if (occurrences.containsKey("{urn:oasis:names:tc:SAML:2.0:protocol}Response") && (expectedSignatureNode = this.query("/samlp:Response/ds:Signature", null)).getLength() != 1) {
            throw new ValidationException("Unexpected number of Response signatures found. SAML Response rejected.", 12);
        }
        if (occurrences.containsKey("{urn:oasis:names:tc:SAML:2.0:assertion}Assertion") && (expectedSignatureNode = this.query("/samlp:Response/saml:Assertion/ds:Signature", null)).getLength() != 1) {
            throw new ValidationException("Unexpected number of Assertion signatures found. SAML Response rejected.", 13);
        }
        return true;
    }

    public boolean validateTimestamps() {
        NodeList timestampNodes = this.samlResponseDocument.getElementsByTagNameNS("*", "Conditions");
        if (timestampNodes.getLength() != 0) {
            for (int i = 0; i < timestampNodes.getLength(); ++i) {
                NamedNodeMap attrName = timestampNodes.item(i).getAttributes();
                Node nbAttribute = attrName.getNamedItem("NotBefore");
                Node naAttribute = attrName.getNamedItem("NotOnOrAfter");
                if (naAttribute != null) {
                    Instant notOnOrAfterDate = Util.parseDateTime(naAttribute.getNodeValue());
                    if (Util.isEqualNow(notOnOrAfterDate = ChronoUnit.SECONDS.addTo(notOnOrAfterDate, 180L)) || Util.isBeforeNow(notOnOrAfterDate)) {
                        throw new ValidationException("Could not validate timestamp: expired. Check system clock.", 20);
                    }
                }
                if (nbAttribute == null) continue;
                Instant notBeforeDate = Util.parseDateTime(nbAttribute.getNodeValue());
                if (!Util.isAfterNow(notBeforeDate = ChronoUnit.SECONDS.addTo(notBeforeDate, -180L))) continue;
                throw new ValidationException("Could not validate timestamp: not yet valid. Check system clock.", 19);
            }
        }
        return true;
    }

    public void setDestinationUrl(String url) {
        this.currentUrl = url;
    }

    public String getError() {
        if (this.validationException != null) {
            return this.validationException.getMessage();
        }
        return null;
    }

    public Exception getValidationException() {
        return this.validationException;
    }

    protected void setValidationException(Exception validationException) {
        this.validationException = validationException;
    }

    protected NodeList queryAssertion(String assertionXpath) {
        Object nameQuery;
        String assertionExpr = "/saml:Assertion";
        String signatureExpr = "ds:Signature/ds:SignedInfo/ds:Reference";
        String signedAssertionQuery = "/samlp:Response/saml:Assertion/ds:Signature/ds:SignedInfo/ds:Reference";
        NodeList nodeList = this.query("/samlp:Response/saml:Assertion/ds:Signature/ds:SignedInfo/ds:Reference", null);
        if (nodeList.getLength() == 0) {
            String signedMessageQuery = "/samlp:Response/ds:Signature/ds:SignedInfo/ds:Reference";
            nodeList = this.query("/samlp:Response/ds:Signature/ds:SignedInfo/ds:Reference", null);
            if (nodeList.getLength() == 1) {
                Node responseReferenceNode = nodeList.item(0);
                String responseId = responseReferenceNode.getAttributes().getNamedItem("URI").getNodeValue();
                responseId = responseId != null && !responseId.isEmpty() ? responseId.substring(1) : responseReferenceNode.getParentNode().getParentNode().getParentNode().getAttributes().getNamedItem("ID").getNodeValue();
                nameQuery = "/samlp:Response[@ID='" + responseId + "']";
            } else {
                nameQuery = "/samlp:Response";
            }
            nameQuery = (String)nameQuery + "/saml:Assertion";
        } else {
            Node assertionReferenceNode = nodeList.item(0);
            String assertionId = assertionReferenceNode.getAttributes().getNamedItem("URI").getNodeValue();
            assertionId = assertionId != null && !assertionId.isEmpty() ? assertionId.substring(1) : assertionReferenceNode.getParentNode().getParentNode().getParentNode().getAttributes().getNamedItem("ID").getNodeValue();
            nameQuery = "/samlp:Response//saml:Assertion[@ID='" + assertionId + "']";
        }
        nameQuery = (String)nameQuery + assertionXpath;
        return this.query((String)nameQuery, null);
    }

    protected NodeList query(String nameQuery, Node context) {
        return Util.query(this.getSAMLResponseDocument(), nameQuery, context);
    }

    private Document decryptAssertion(Document dom) {
        PrivateKey key = this.settings.getSPkey();
        HSM hsm = this.settings.getHsm();
        if (hsm == null && key == null) {
            throw new SettingsException("No private key available for decrypt, check settings", 4);
        }
        NodeList encryptedDataNodes = Util.query(dom, "/samlp:Response/saml:EncryptedAssertion/xenc:EncryptedData");
        if (encryptedDataNodes.getLength() == 0) {
            throw new ValidationException("No /samlp:Response/saml:EncryptedAssertion/xenc:EncryptedData element found", 48);
        }
        Element encryptedData = (Element)encryptedDataNodes.item(0);
        if (hsm != null) {
            Util.decryptUsingHsm(encryptedData, hsm);
        } else {
            Util.decryptElement(encryptedData, key);
        }
        NodeList AssertionDataNodes = Util.query(dom, "/samlp:Response/saml:EncryptedAssertion/saml:Assertion");
        if (encryptedDataNodes.getLength() == 0) {
            throw new ValidationException("No /samlp:Response/saml:EncryptedAssertion/saml:Assertion element found", 48);
        }
        Node assertionNode = AssertionDataNodes.item(0);
        assertionNode.getParentNode().getParentNode().replaceChild(assertionNode, assertionNode.getParentNode());
        String xmlStr = Util.convertDocumentToString(dom);
        return Util.convertStringToDocument(xmlStr);
    }

    public String getSAMLResponseXml() {
        String xml = this.encrypted != false ? Util.convertDocumentToString(this.decryptedDocument) : this.samlResponseString;
        return xml;
    }

    protected Document getSAMLResponseDocument() {
        Document doc = this.encrypted != false ? this.decryptedDocument : this.samlResponseDocument;
        return doc;
    }

    protected void validateAudiences() {
        List<String> validAudiences = this.getAudiences();
        if (!validAudiences.isEmpty() && !validAudiences.contains(this.settings.getSpEntityId())) {
            throw new ValidationException(this.settings.getSpEntityId() + " is not a valid audience for this Response", 26);
        }
    }

    protected void validateDestination(Element element) {
        String destinationUrl;
        if (element.hasAttribute("Destination") && (destinationUrl = element.getAttribute("Destination")) != null) {
            if (destinationUrl.isEmpty()) {
                throw new ValidationException("The response has an empty Destination value", 25);
            }
            if (!destinationUrl.equals(this.currentUrl)) {
                throw new ValidationException("The response was received at " + this.currentUrl + " instead of " + destinationUrl, 24);
            }
        }
    }

    protected SubjectConfirmationIssue validateRecipient(Node recipient, int index) {
        if (recipient == null) {
            return new SubjectConfirmationIssue(index, "SubjectConfirmationData doesn't contain a Recipient");
        }
        if (!recipient.getNodeValue().equals(this.currentUrl)) {
            return new SubjectConfirmationIssue(index, "SubjectConfirmationData doesn't match a valid Recipient");
        }
        return null;
    }

    protected void validateSpNameQualifier(String spNameQualifier) {
        if (this.settings.isStrict() && !spNameQualifier.equals(this.settings.getSpEntityId())) {
            throw new ValidationException("The SPNameQualifier value mismatch the SP entityID value.", 40);
        }
    }

    public Calendar getResponseIssueInstant() {
        String issueInstantString;
        Element rootElement = this.getSAMLResponseDocument().getDocumentElement();
        String string = issueInstantString = rootElement.hasAttribute("IssueInstant") ? rootElement.getAttribute("IssueInstant") : null;
        if (issueInstantString == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        try {
            result.setTimeInMillis(Util.parseDateTime(issueInstantString).toEpochMilli());
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("The Response IssueInstant attribute is not in the expected UTC form of ISO-8601 format", 49);
        }
        return result;
    }
}

