/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.test.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.saml2.core.exception.InvalidKeySpecRuntimeException;
import org.codelibs.saml2.core.exception.SAMLSignatureException;
import org.codelibs.saml2.core.exception.XMLParsingException;
import org.codelibs.saml2.core.util.SchemaFactory;
import org.codelibs.saml2.core.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UtilsTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testLoadXMLForAttacks1() {
        String attackVector = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE foo [<!ELEMENT foo ANY ><!ENTITY xxe SYSTEM \"file:///etc/passwd\" >]><foo>&xxe;</foo>";
        Document res = Util.loadXML((String)attackVector);
        Assert.assertNull((Object)res);
    }

    @Test
    public void testLoadXMLForAttacks2() {
        String attackVector = "<?xml version=\"1.0\"?><!DOCTYPE results [<!ENTITY harmless \"completely harmless\">]><results><result>This result is &harmless;</result></results>";
        Document res = Util.loadXML((String)attackVector);
        Assert.assertNull((Object)res);
    }

    @Test
    public void testLoadXMLForAttacks3() {
        String attackVector = "<?xml version=\"1.0\"?><!DOCTYPE results [<!ELEMENT results (result+)><!ELEMENT result (#PCDATA)>]><results><result>test</result></results>";
        Document res = Util.loadXML((String)attackVector);
        Assert.assertNull((Object)res);
    }

    @Test
    public void testLoadXMLBadXML() {
        String metadataUnloaded = "<xml><EntityDescriptor>";
        Document result = Util.loadXML((String)metadataUnloaded);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLoadXML() throws URISyntaxException, IOException {
        String metadataInvalid = Util.getFileAsString((String)"data/metadata/noentity_metadata_settings1.xml");
        Document result = Util.loadXML((String)metadataInvalid);
        Assert.assertTrue((boolean)(result instanceof Document));
        String metadataOk = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        result = Util.loadXML((String)metadataOk);
        Assert.assertTrue((boolean)(result instanceof Document));
    }

    @Test
    public void testValidateXMLBadFormat() throws Exception {
        String metadataUnloaded = "<xml><EntityDescriptor>";
        Document docMetadataUnloaded = Util.loadXML((String)metadataUnloaded);
        boolean isValid = Util.validateXML((Document)docMetadataUnloaded, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testValidateXMLNoentity() throws Exception {
        String metadataInvalid = Util.getFileAsString((String)"data/metadata/noentity_metadata_settings1.xml");
        Document docMetadataInvalid = Util.loadXML((String)metadataInvalid);
        boolean isValid = Util.validateXML((Document)docMetadataInvalid, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testValidateXMLInvalid() throws Exception {
        String metadataValid = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        String metadataInvalid = metadataValid.replace("/md:EntityDescriptor", "/md:EntityDescriptor2");
        Document docMetadataInvalid = Util.loadXML((String)metadataInvalid);
        boolean isValid = Util.validateXML((Document)docMetadataInvalid, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testValidateXMLMetadataBadOrder() throws Exception {
        String metadataBadOrder = Util.getFileAsString((String)"data/metadata/metadata_bad_order_settings1.xml");
        Document docMetadataBadOrder = Util.loadXML((String)metadataBadOrder);
        boolean isValid = Util.validateXML((Document)docMetadataBadOrder, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testValidateXMLMetadataWrongSchema() throws Exception {
        String metadataOk = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        Document docMetadataOk = Util.loadXML((String)metadataOk);
        boolean isValid = Util.validateXML((Document)docMetadataOk, (URL)SchemaFactory.SAML_SCHEMA_PROTOCOL_2_0);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testValidateXMLExpiredMetadata() throws Exception {
        String metadataExpired = Util.getFileAsString((String)"data/metadata/expired_metadata_settings1.xml");
        Document docExpiredMetadata = Util.loadXML((String)metadataExpired);
        boolean isValid = Util.validateXML((Document)docExpiredMetadata, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0);
        Assert.assertTrue((boolean)isValid);
    }

    @Test
    public void testValidateXMLMetadataOk() throws Exception {
        String metadataOk = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        Document docMetadataOk = Util.loadXML((String)metadataOk);
        boolean isValid = Util.validateXML((Document)docMetadataOk, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0);
        Assert.assertTrue((boolean)isValid);
    }

    @Test
    public void testValidateXMLSAMLResponse() throws Exception {
        String responseOk = new String(Base64.decodeBase64((String)Util.getFileAsString((String)"data/responses/valid_response.xml.base64")));
        Document docResponseOk = Util.loadXML((String)responseOk);
        boolean isValid = Util.validateXML((Document)docResponseOk, (URL)SchemaFactory.SAML_SCHEMA_PROTOCOL_2_0);
        Assert.assertTrue((boolean)isValid);
    }

    @Test
    public void testValidateXMLSignedMetadataSettings1() throws Exception {
        String signedmetadata = Util.getFileAsString((String)"data/metadata/signed_metadata_settings1.xml");
        Document docSignedmetadata = Util.loadXML((String)signedmetadata);
        boolean isValid = Util.validateXML((Document)docSignedmetadata, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0);
        Assert.assertTrue((boolean)isValid);
    }

    @Test
    public void testConvertDocumentToStringWithc14n() throws URISyntaxException, IOException {
        String responseOk = new String(Base64.decodeBase64((String)Util.getFileAsString((String)"data/responses/valid_response.xml.base64")));
        Document docResponseOk = Util.loadXML((String)responseOk);
        String responseString = Util.convertDocumentToString((Document)docResponseOk, (boolean)true);
        Assert.assertNotNull((Object)responseString);
        Assert.assertTrue((responseString.length() == 6855 ? 1 : 0) != 0);
    }

    @Test
    public void testConvertDocumentToStringWithoutc14n() throws URISyntaxException, IOException {
        String responseOk = new String(Base64.decodeBase64((String)Util.getFileAsString((String)"data/responses/valid_response.xml.base64")));
        Document docResponseOk = Util.loadXML((String)responseOk);
        String responseString = Util.convertDocumentToString((Document)docResponseOk, (boolean)false);
        String responseString2 = Util.convertDocumentToString((Document)docResponseOk);
        Assert.assertNotNull((Object)responseString);
        Assert.assertTrue((responseString.length() == 6855 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)responseString.contentEquals(responseString2));
    }

    @Test
    public void testConvertStringToDocumentOk() throws ParserConfigurationException, SAXException, IOException, URISyntaxException {
        String responseOk = new String(Base64.decodeBase64((String)Util.getFileAsString((String)"data/responses/valid_response.xml.base64")));
        Document responseDom = Util.convertStringToDocument((String)responseOk);
        Assert.assertNotNull((Object)responseDom);
        Assert.assertEquals((Object)"samlp:Response", (Object)responseDom.getDocumentElement().getNodeName());
        String metadataOk = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        Document metadataDom = Util.convertStringToDocument((String)metadataOk);
        Assert.assertEquals((Object)"md:EntityDescriptor", (Object)metadataDom.getDocumentElement().getNodeName());
    }

    @Test(expected=XMLParsingException.class)
    public void testConvertStringToDocumentBad() throws URISyntaxException, IOException, ParserConfigurationException, SAXException {
        String metadataValid = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        String metadataInvalid = metadataValid.replace("/md:EntityDescriptor", "/md:EntityDescriptor2");
        Document metadataDom = Util.convertStringToDocument((String)metadataInvalid);
        Assert.assertNull((Object)metadataDom);
    }

    @Test
    public void testFormatCert() throws IOException, URISyntaxException {
        String certWithHeads = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        String certWithoutHeads = certWithHeads.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
        Assert.assertThat((Object)certWithHeads, (Matcher)CoreMatchers.containsString((String)"-----BEGIN CERTIFICATE-----"));
        Assert.assertThat((Object)certWithHeads, (Matcher)CoreMatchers.containsString((String)"-----END CERTIFICATE-----"));
        Assert.assertThat((Object)certWithoutHeads, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----BEGIN CERTIFICATE-----"))));
        Assert.assertThat((Object)certWithoutHeads, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----END CERTIFICATE-----"))));
        String formatCert1 = Util.formatCert((String)certWithHeads, (boolean)true);
        Assert.assertThat((Object)formatCert1, (Matcher)CoreMatchers.containsString((String)"-----BEGIN CERTIFICATE-----"));
        Assert.assertThat((Object)formatCert1, (Matcher)CoreMatchers.containsString((String)"-----END CERTIFICATE-----"));
        Assert.assertEquals((long)927L, (long)formatCert1.length());
        String formatCert2 = Util.formatCert((String)certWithHeads, (boolean)false);
        Assert.assertThat((Object)formatCert2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----BEGIN CERTIFICATE-----"))));
        Assert.assertThat((Object)formatCert2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----END CERTIFICATE-----"))));
        Assert.assertEquals((long)860L, (long)formatCert2.length());
        String formatCert3 = Util.formatCert((String)certWithoutHeads, (boolean)true);
        Assert.assertThat((Object)formatCert3, (Matcher)CoreMatchers.containsString((String)"-----BEGIN CERTIFICATE-----"));
        Assert.assertThat((Object)formatCert3, (Matcher)CoreMatchers.containsString((String)"-----END CERTIFICATE-----"));
        Assert.assertEquals((long)927L, (long)formatCert3.length());
        String formatCert4 = Util.formatCert((String)certWithoutHeads, (boolean)false);
        Assert.assertThat((Object)formatCert4, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----BEGIN CERTIFICATE-----"))));
        Assert.assertThat((Object)formatCert4, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----END CERTIFICATE-----"))));
        Assert.assertEquals((long)860L, (long)formatCert4.length());
        String empty1 = Util.formatCert((String)"", (boolean)false);
        String empty2 = Util.formatCert((String)"", (boolean)true);
        Assert.assertEquals((Object)"", (Object)empty1);
        Assert.assertEquals((Object)empty1, (Object)empty2);
        String null1 = Util.formatCert(null, (boolean)false);
        String null2 = Util.formatCert(null, (boolean)true);
        Assert.assertEquals((Object)"", (Object)null1);
        Assert.assertEquals((Object)null1, (Object)null2);
    }

    @Test
    public void formatPrivateKey() throws IOException, URISyntaxException {
        String keyWithHeads = Util.getFileAsString((String)"data/customPath/certs/sp.key");
        String keyWithoutHeads = keyWithHeads.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "");
        Assert.assertThat((Object)keyWithHeads, (Matcher)CoreMatchers.containsString((String)"-----BEGIN RSA PRIVATE KEY-----"));
        Assert.assertThat((Object)keyWithHeads, (Matcher)CoreMatchers.containsString((String)"-----END RSA PRIVATE KEY-----"));
        Assert.assertThat((Object)keyWithoutHeads, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----BEGIN RSA PRIVATE KEY-----"))));
        Assert.assertThat((Object)keyWithoutHeads, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----END RSA PRIVATE KEY-----"))));
        String formatKey1 = Util.formatPrivateKey((String)keyWithHeads, (boolean)true);
        Assert.assertThat((Object)formatKey1, (Matcher)CoreMatchers.containsString((String)"-----BEGIN RSA PRIVATE KEY-----"));
        Assert.assertThat((Object)formatKey1, (Matcher)CoreMatchers.containsString((String)"-----END RSA PRIVATE KEY-----"));
        Assert.assertEquals((long)890L, (long)formatKey1.length());
        String formatKey2 = Util.formatPrivateKey((String)keyWithHeads, (boolean)false);
        Assert.assertThat((Object)formatKey2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----BEGIN RSA PRIVATE KEY-----"))));
        Assert.assertThat((Object)formatKey2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----END RSA PRIVATE KEY-----"))));
        Assert.assertEquals((long)816L, (long)formatKey2.length());
        String formatKey3 = Util.formatPrivateKey((String)keyWithoutHeads, (boolean)true);
        Assert.assertThat((Object)formatKey3, (Matcher)CoreMatchers.containsString((String)"-----BEGIN RSA PRIVATE KEY-----"));
        Assert.assertThat((Object)formatKey3, (Matcher)CoreMatchers.containsString((String)"-----END RSA PRIVATE KEY-----"));
        Assert.assertEquals((long)890L, (long)formatKey3.length());
        String formatKey4 = Util.formatPrivateKey((String)keyWithoutHeads, (boolean)false);
        Assert.assertThat((Object)formatKey4, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----BEGIN RSA PRIVATE KEY-----"))));
        Assert.assertThat((Object)formatKey4, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----END RSA PRIVATE KEY-----"))));
        Assert.assertEquals((long)816L, (long)formatKey4.length());
        String noRsaKey = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        String noRsaKeyWithHeads = keyWithHeads.replace("-----BEGIN RSA PRIVATE KEY-----", "-----BEGIN PRIVATE KEY-----").replace("-----END RSA PRIVATE KEY-----", "-----END PRIVATE KEY-----");
        String formatKey5 = Util.formatPrivateKey((String)noRsaKeyWithHeads, (boolean)false);
        Assert.assertThat((Object)formatKey5, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----BEGIN PRIVATE KEY-----"))));
        Assert.assertThat((Object)formatKey5, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"-----END PRIVATE KEY-----"))));
        Assert.assertEquals((long)816L, (long)formatKey5.length());
        String formatKey6 = Util.formatPrivateKey((String)noRsaKeyWithHeads, (boolean)true);
        Assert.assertThat((Object)formatKey6, (Matcher)CoreMatchers.containsString((String)"-----BEGIN PRIVATE KEY-----"));
        Assert.assertThat((Object)formatKey6, (Matcher)CoreMatchers.containsString((String)"-----END PRIVATE KEY-----"));
        Assert.assertEquals((long)882L, (long)formatKey6.length());
        String empty1 = Util.formatPrivateKey((String)"", (boolean)false);
        String empty2 = Util.formatPrivateKey((String)"", (boolean)true);
        Assert.assertEquals((Object)"", (Object)empty1);
        Assert.assertEquals((Object)empty1, (Object)empty2);
        String null1 = Util.formatPrivateKey(null, (boolean)false);
        String null2 = Util.formatPrivateKey(null, (boolean)true);
        Assert.assertEquals((Object)"", (Object)null1);
        Assert.assertEquals((Object)null1, (Object)null2);
    }

    @Test
    public void testLoadCertCert() throws URISyntaxException, IOException, CertificateException {
        String cert = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        String certWithHeads = Util.formatCert((String)cert, (boolean)true);
        String certWithoutHeads = Util.formatCert((String)cert, (boolean)false);
        X509Certificate certObject1 = Util.loadCert((String)certWithHeads);
        X509Certificate certObject2 = Util.loadCert((String)certWithoutHeads);
        Assert.assertNotNull((Object)certObject1);
        Assert.assertNotNull((Object)certObject2);
        Assert.assertEquals((Object)certObject1.getSigAlgName(), (Object)certObject2.getSigAlgName());
        Assert.assertEquals((Object)"X.509", (Object)certObject1.getType());
        Assert.assertEquals((Object)"X.509", (Object)certObject2.getType());
    }

    @Test
    public void testLoadCertWithHeads() throws CertificateException, UnsupportedEncodingException {
        String certWithHeads = "-----BEGIN CERTIFICATE-----\nMIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czET\nMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYD\nVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wHhcNMTUxMDE4MjAxMjM1WhcNMTgw\nNzE0MjAxMjM1WjBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEV\nMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBs\nZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALvwEktX1+4y2AhEqxVw\nOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFU\nm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/\nSDW7cDgIC8vb0ygOsiXdreANAgMBAAGjUDBOMB0GA1UdDgQWBBTifMwN3CQ5ZOPk\nV5tDJsutU8teFDAfBgNVHSMEGDAWgBTifMwN3CQ5ZOPkV5tDJsutU8teFDAMBgNV\nHRMEBTADAQH/MA0GCSqGSIb3DQEBDQUAA4GBAG3nAEUjJaA75SkzID5FKLolsxG5\nTE/0HU0+yEUAVkXiqvqN4mPWq/JjoK5+uP4LEZIb4pRrCqI3iHp+vazLLYSeyV3k\naGN7q35Afw8nk8WM0f7vImbQ69j1S8GQ+6E0PEI26qBLykGkMn3GUVtBBWSdpP09\n3NuNLJiOomnHqhqj\n-----END CERTIFICATE-----";
        X509Certificate loadedCert = Util.loadCert((String)certWithHeads);
        Assert.assertNotNull((Object)loadedCert);
        Assert.assertEquals((Object)"X.509", (Object)loadedCert.getType());
    }

    @Test
    public void testLoadCertWithoutHeads() throws CertificateException, UnsupportedEncodingException {
        String certWithoutHeads = "MIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wHhcNMTUxMDE4MjAxMjM1WhcNMTgwNzE0MjAxMjM1WjBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALvwEktX1+4y2AhEqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAGjUDBOMB0GA1UdDgQWBBTifMwN3CQ5ZOPkV5tDJsutU8teFDAfBgNVHSMEGDAWgBTifMwN3CQ5ZOPkV5tDJsutU8teFDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBDQUAA4GBAG3nAEUjJaA75SkzID5FKLolsxG5TE/0HU0+yEUAVkXiqvqN4mPWq/JjoK5+uP4LEZIb4pRrCqI3iHp+vazLLYSeyV3kaGN7q35Afw8nk8WM0f7vImbQ69j1S8GQ+6E0PEI26qBLykGkMn3GUVtBBWSdpP093NuNLJiOomnHqhqj";
        X509Certificate loadedCert = Util.loadCert((String)certWithoutHeads);
        Assert.assertNotNull((Object)loadedCert);
        Assert.assertEquals((Object)"X.509", (Object)loadedCert.getType());
    }

    @Test
    public void testLoadPrivateKeyPKCS8() throws URISyntaxException, IOException, GeneralSecurityException {
        String key = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        String keyWithHeads = Util.formatPrivateKey((String)key, (boolean)true);
        String keyWithoutHeads = Util.formatPrivateKey((String)key, (boolean)false);
        PrivateKey keyObject1 = Util.loadPrivateKey((String)keyWithHeads);
        PrivateKey keyObject2 = Util.loadPrivateKey((String)keyWithoutHeads);
        Assert.assertNotNull((Object)keyObject1);
        Assert.assertNotNull((Object)keyObject2);
        Assert.assertEquals(keyObject1.getClass(), keyObject2.getClass());
        Assert.assertEquals((Object)keyObject1.getAlgorithm(), (Object)keyObject2.getAlgorithm());
    }

    @Test(expected=InvalidKeySpecRuntimeException.class)
    public void testLoadPrivateKeyPKCS1() throws URISyntaxException, GeneralSecurityException, IOException {
        String key = Util.getFileAsString((String)"data/customPath/certs/sp.key");
        PrivateKey keyObject1 = Util.loadPrivateKey((String)key);
        Assert.assertNull((Object)keyObject1);
    }

    @Test
    public void testGetNameIdDataWrongKey() throws Exception {
        String keyString = Util.getFileAsString((String)"data/misc/sp3.key");
        this.expectedEx.expect(InvalidKeySpecRuntimeException.class);
        Util.loadPrivateKey((String)keyString);
    }

    @Test
    public void testLoadPrivateKeyWithHeads() throws GeneralSecurityException, IOException {
        String keyWithHeads = "-----BEGIN PRIVATE KEY-----\nMIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALvwEktX1+4y2AhE\nqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4\nakFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCq\nFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAECgYA7VPVRl+/xoVeWdKdWY1F17Her\nSa23ynI2vQ8TkUY6kR3ucz6ElRxHJesY8fNCPoX+XuMfUly7IKyPZMkWyvEgDPo7\nJ5mYqP5VsTK0Li4AwR/BA93Aw6gaX7/EYi3HjBh8QdNSt4fi9yOea/hv04yfR9Lx\n/a5fvQIyhqaDtT2QeQJBAOnCgnxnj70/sv9UsFPa8t1OGdAfXtOgEoklh1F2NR9j\nid6FPw5E98eCpdZ00MfRrmUavgqg6Y4swZISyzJIjGMCQQDN0YNsC4S+eJJM6aOC\npupKluWE/cCWB01UQYekyXH7OdUtl49NlKEUPBSAvtaLMuMKlTNOjlPrx4Q+/c5i\n0vTPAkEA5H7CR9J/OZETaewhc8ZYkaRvLPYNHjWhCLhLXoB6itUkhgOfUFZwEXAO\npOOI1VmL675JN2B1DAmJqTx/rQYnWwJBAMx3ztsAmnBq8dTM6y65ydouDHhRawjg\n2jbRHwNbSQvuyVSQ08Gb3WZvxWKdtB/3fsydqqnpBYAf5sZ5eJZ+wssCQAOiIKnh\ndYe+RBbBwykzjUqtzEmt4fwCFE8tD4feEx77D05j5f7u7KYh1mL0G2zIbnUryi7j\nwc4ye98VirRpZ1w=\n-----END PRIVATE KEY-----";
        PrivateKey loadedKey = Util.loadPrivateKey((String)keyWithHeads);
        Assert.assertNotNull((Object)loadedKey);
    }

    @Test
    public void testLoadPrivateKeyWithoutHeads() throws GeneralSecurityException, IOException {
        String keyWithoutHeads = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALvwEktX1+4y2AhEqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAECgYA7VPVRl+/xoVeWdKdWY1F17HerSa23ynI2vQ8TkUY6kR3ucz6ElRxHJesY8fNCPoX+XuMfUly7IKyPZMkWyvEgDPo7J5mYqP5VsTK0Li4AwR/BA93Aw6gaX7/EYi3HjBh8QdNSt4fi9yOea/hv04yfR9Lx/a5fvQIyhqaDtT2QeQJBAOnCgnxnj70/sv9UsFPa8t1OGdAfXtOgEoklh1F2NR9jid6FPw5E98eCpdZ00MfRrmUavgqg6Y4swZISyzJIjGMCQQDN0YNsC4S+eJJM6aOCpupKluWE/cCWB01UQYekyXH7OdUtl49NlKEUPBSAvtaLMuMKlTNOjlPrx4Q+/c5i0vTPAkEA5H7CR9J/OZETaewhc8ZYkaRvLPYNHjWhCLhLXoB6itUkhgOfUFZwEXAOpOOI1VmL675JN2B1DAmJqTx/rQYnWwJBAMx3ztsAmnBq8dTM6y65ydouDHhRawjg2jbRHwNbSQvuyVSQ08Gb3WZvxWKdtB/3fsydqqnpBYAf5sZ5eJZ+wssCQAOiIKnhdYe+RBbBwykzjUqtzEmt4fwCFE8tD4feEx77D05j5f7u7KYh1mL0G2zIbnUryi7jwc4ye98VirRpZ1w=";
        PrivateKey loadedKey = Util.loadPrivateKey((String)keyWithoutHeads);
        Assert.assertNotNull((Object)loadedKey);
    }

    @Test
    public void testCalculateX509Fingerprint() throws URISyntaxException, IOException, CertificateException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String fingerprint = Util.calculateX509Fingerprint((X509Certificate)cert);
        String fingerprint2 = Util.calculateX509Fingerprint((X509Certificate)cert, null);
        String fingerprint3 = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"");
        String fingerprintSha1 = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"SHA-1");
        String fingerprintSha1_2 = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"sha1");
        String fingerprintSha256 = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"SHA-256");
        String fingerprintSha256_2 = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"sha256");
        String fingerprintSha384 = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"SHA-384");
        String fingerprintSha384_2 = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"sha384");
        String fingerprintSha512 = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"SHA-512");
        String fingerprintSha512_2 = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"sha512");
        String fingerprintInvalid = Util.calculateX509Fingerprint((X509Certificate)cert, (String)"SHA-XXX");
        Assert.assertEquals((Object)"afe71c28ef740bc87425be13a2263d37971da1f9", (Object)fingerprint);
        Assert.assertEquals((Object)fingerprint, (Object)fingerprintSha1);
        Assert.assertEquals((Object)fingerprint, (Object)fingerprintSha1_2);
        Assert.assertEquals((Object)fingerprint2, (Object)fingerprintSha1);
        Assert.assertEquals((Object)fingerprint3, (Object)fingerprintSha1);
        Assert.assertEquals((Object)"c51cfa06c7a49767f6eab18238eae1c56708e29264da3d11f538a12cd2c357ba", (Object)fingerprintSha256);
        Assert.assertEquals((Object)"c51cfa06c7a49767f6eab18238eae1c56708e29264da3d11f538a12cd2c357ba", (Object)fingerprintSha256_2);
        Assert.assertEquals((Object)"bc5826e6f9429247254bae5e3c650e6968a36a62d23075eb168134978d88600559c10830c28711b2c29c7947c0c2eb1d", (Object)fingerprintSha384);
        Assert.assertEquals((Object)"bc5826e6f9429247254bae5e3c650e6968a36a62d23075eb168134978d88600559c10830c28711b2c29c7947c0c2eb1d", (Object)fingerprintSha384_2);
        Assert.assertEquals((Object)"3db29251b97559c67988ea0754cb0573fc409b6f75d89282d57cfb75089539b0bbdb2dcd9ec6e032549ecbc466439d5992e18db2cf5494ca2fe1b2e16f348dff", (Object)fingerprintSha512);
        Assert.assertEquals((Object)"3db29251b97559c67988ea0754cb0573fc409b6f75d89282d57cfb75089539b0bbdb2dcd9ec6e032549ecbc466439d5992e18db2cf5494ca2fe1b2e16f348dff", (Object)fingerprintSha512_2);
        Assert.assertTrue((boolean)fingerprintInvalid.isEmpty());
    }

    @Test
    public void testConvertToPem() throws URISyntaxException, IOException, CertificateException {
        String cert = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        String certWithHeads = Util.formatCert((String)cert, (boolean)true);
        String certWithoutHeads = Util.formatCert((String)cert, (boolean)false);
        X509Certificate certObject1 = Util.loadCert((String)certWithHeads);
        X509Certificate certObject2 = Util.loadCert((String)certWithoutHeads);
        Assert.assertNotNull((Object)certObject1);
        Assert.assertNotNull((Object)certObject2);
        Assert.assertEquals((Object)Util.convertToPem((X509Certificate)certObject1), (Object)Util.convertToPem((X509Certificate)certObject2));
    }

    @Test
    public void testgetFileAsStringSuccess() throws IOException {
        String string = Util.getFileAsString((String)"config/config.certfile.properties");
        Assert.assertNotNull((Object)string);
    }

    @Test(expected=IORuntimeException.class)
    public void testLoadResourceFail() throws IOException {
        String string = Util.getFileAsString((String)"invalid_path");
        Assert.assertNull((Object)string);
    }

    @Test
    public void testBase64decodedInflated() throws URISyntaxException, IOException {
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        String encodedAuthNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml.base64");
        String deflatedEncodedAuthNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml.deflated.base64");
        Assert.assertThat((Object)authNRequest.toString(), (Matcher)CoreMatchers.equalTo((Object)Util.base64decodedInflated((String)encodedAuthNRequest).toString()));
        Assert.assertThat((Object)authNRequest.toString(), (Matcher)CoreMatchers.equalTo((Object)Util.base64decodedInflated((String)deflatedEncodedAuthNRequest).toString()));
    }

    @Test
    public void testBase64decodedInflated2() throws URISyntaxException, IOException {
        String samlResponse = Util.getFileAsString((String)"data/responses/response_long_cert.xml");
        String deflatedEncodedsamlResponse = Util.getFileAsString((String)"data/responses/response_long_cert.xml.deflated.base64");
        Assert.assertThat((Object)samlResponse.toString(), (Matcher)CoreMatchers.equalTo((Object)Util.base64decodedInflated((String)deflatedEncodedsamlResponse).toString()));
    }

    @Test
    public void testDeflatedBase64encoded() throws URISyntaxException, IOException {
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        String deflatedEncodedAuthNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml.deflated.base64");
        Assert.assertThat((Object)Util.deflatedBase64encoded((String)authNRequest).toString(), (Matcher)CoreMatchers.equalTo((Object)deflatedEncodedAuthNRequest.toString()));
    }

    @Test
    public void testBase64encoder() throws URISyntaxException, IOException {
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        String encodedAuthNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml.base64");
        Assert.assertThat((Object)Util.base64encoder((String)authNRequest).toString(), (Matcher)CoreMatchers.equalTo((Object)encodedAuthNRequest.toString()));
    }

    @Test
    public void testBase64decoder() throws URISyntaxException, IOException {
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        String encodedAuthNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml.base64");
        Assert.assertThat((Object)authNRequest.toString(), (Matcher)CoreMatchers.equalTo((Object)new String(Util.base64decoder((String)encodedAuthNRequest))));
    }

    @Test
    public void testUrlEncoder() throws URISyntaxException, IOException {
        String deflatedEncodedAuthNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml.deflated.base64");
        Assert.assertEquals((Object)"pVNNj9owEL3vr4h8hxCSCmJtkCjbDyQKKdAeeqm8zqRryR%2Bpx9ml%2F752YFv3sBy2cxzPzHvz3vgWmZIdXfbuQe%2FhZw%2FokpOSGunwUJHeamoYCqSaKUDqOD0sP23odDyhnTXOcCNJsr6ryPfd9t1m92G9zSZ5MZ2Xk5LdAy%2BmRcvezPPprJ2Vxawo5wVJvoJFYXRF%2FBTfjNjDWqNj2vnUJCtGWTbK8mOW0bykefGNJO%2BN5TCwrEjLJEJoqxmieIQ%2FmfrC563QjdA%2FrpO%2FPxch%2FXg81qN6dziSZIkI1nlmK6OxV2APYB8Fhy%2F7TUUenOtomsKJqU7CmBuVMo5kcZP4uA1y0WETGwl4nQJ7hrsMCXFBEU03jpEUONYwx85gaYQW4Xd06zHWd7WRgv96jY9eZsXc9eqQEc2oHUppF6xEB9qR5FAH%2FM89k6IVYCsSbeDFldI8rSww5x1ztveGpf%2BQv9wfNIPP3gIHp1dd48qojlmB4cI8Be4ifc9GxQgr6X3YQ%2FtftoW42sMpDzg%2BHa72ydjmL6X0RU6LyO8XBFrcPD%2FHn3jxGw%3D%3D", (Object)Util.urlEncoder((String)deflatedEncodedAuthNRequest));
        Assert.assertEquals(null, (Object)Util.urlEncoder(null));
    }

    @Test
    public void testUrlDecoder() throws URISyntaxException, IOException {
        String deflatedEncodedAuthNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml.deflated.base64");
        Assert.assertEquals((Object)deflatedEncodedAuthNRequest, (Object)Util.urlDecoder((String)"pVNNj9owEL3vr4h8hxCSCmJtkCjbDyQKKdAeeqm8zqRryR%2Bpx9ml%2F752YFv3sBy2cxzPzHvz3vgWmZIdXfbuQe%2FhZw%2FokpOSGunwUJHeamoYCqSaKUDqOD0sP23odDyhnTXOcCNJsr6ryPfd9t1m92G9zSZ5MZ2Xk5LdAy%2BmRcvezPPprJ2Vxawo5wVJvoJFYXRF%2FBTfjNjDWqNj2vnUJCtGWTbK8mOW0bykefGNJO%2BN5TCwrEjLJEJoqxmieIQ%2FmfrC563QjdA%2FrpO%2FPxch%2FXg81qN6dziSZIkI1nlmK6OxV2APYB8Fhy%2F7TUUenOtomsKJqU7CmBuVMo5kcZP4uA1y0WETGwl4nQJ7hrsMCXFBEU03jpEUONYwx85gaYQW4Xd06zHWd7WRgv96jY9eZsXc9eqQEc2oHUppF6xEB9qR5FAH%2FM89k6IVYCsSbeDFldI8rSww5x1ztveGpf%2BQv9wfNIPP3gIHp1dd48qojlmB4cI8Be4ifc9GxQgr6X3YQ%2FtftoW42sMpDzg%2BHa72ydjmL6X0RU6LyO8XBFrcPD%2FHn3jxGw%3D%3D"));
        Assert.assertEquals(null, (Object)Util.urlDecoder(null));
    }

    @Test
    public void testSign() throws URISyntaxException, IOException, GeneralSecurityException {
        String deflatedEncodedAuthNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml.deflated.base64");
        String signAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String spPrivateKey = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)spPrivateKey);
        String expectedSign = "lRsULuIIPLmpfvlJ7VQq6Vg5HWMKxLbCeVdQ3GvBRXsT+MIrYUwAY13oH9kx6hvEGCOyte8xAsVea8/WSFhZ84Oawm+2DRXz52Gs+N+RWDZ9uoT4yTXimZk71rpXc1Bqy7o/ZOJh51S3wqph2KEgBTqf2cBFjYiLz2/OSl2w4qE=";
        Assert.assertEquals((Object)expectedSign, (Object)Util.base64encoder((byte[])Util.sign((String)deflatedEncodedAuthNRequest, (PrivateKey)key, (String)signAlgorithm)));
        Assert.assertEquals((Object)expectedSign, (Object)Util.base64encoder((byte[])Util.sign((String)deflatedEncodedAuthNRequest, (PrivateKey)key, null)));
        String expectedSign_2 = "DPnI7fef7Mm2Y3hriCWKlwvt0TOEdPaQR5yG/JXvtka/55ihHi0j8IjtiwvYNwO6AuIiru6LYKLnVv8x2Kf9Fb/myNx6I/+SwpKZkAQ10Ukpb0/oE4Cage6WDM3gtKukJmHPzJlUgWjB+no+9g4A4kt3Mq3n1UDWhfqDk508+fE=";
        String signAlgorithm_2 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        Assert.assertEquals((Object)expectedSign_2, (Object)Util.base64encoder((byte[])Util.sign((String)deflatedEncodedAuthNRequest, (PrivateKey)key, (String)signAlgorithm_2)));
    }

    @Test
    public void testSignatureAlgConversion() {
        Assert.assertEquals((Object)"SHA1withDSA", (Object)Util.signatureAlgConversion((String)"http://www.w3.org/2000/09/xmldsig#dsa-sha1"));
        Assert.assertEquals((Object)"SHA1withRSA", (Object)Util.signatureAlgConversion((String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        Assert.assertEquals((Object)"SHA1withRSA", (Object)Util.signatureAlgConversion(null));
        Assert.assertEquals((Object)"SHA256withRSA", (Object)Util.signatureAlgConversion((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertEquals((Object)"SHA384withRSA", (Object)Util.signatureAlgConversion((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"));
        Assert.assertEquals((Object)"SHA512withRSA", (Object)Util.signatureAlgConversion((String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"));
    }

    @Test
    public void testValidateSignInvalidsInputs() throws URISyntaxException, IOException, CertificateException, ParserConfigurationException, SAXException {
        String responseStr = Util.getFileAsString((String)"data/responses/signed_message_response.xml.base64");
        String samlResponseStr = new String(Util.base64decoder((String)responseStr));
        Document samlResponseDocument = Util.loadXML((String)samlResponseStr);
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String fingerprint_c1_sha1 = "afe71c28ef740bc87425be13a2263d37971da1f9";
        String fingerprint_c1_sha256 = "c51cfa06c7a49767f6eab18238eae1c56708e29264da3d11f538a12cd2c357ba";
        String certString_2 = Util.getFileAsString((String)"certs/certificate1");
        X509Certificate cert_2 = Util.loadCert((String)certString_2);
        String fingerprint_c2_sha1 = "c51985d947f1be57082025050846eb27f6cab783";
        Assert.assertFalse((boolean)Util.validateSign(null, (X509Certificate)cert, null, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign(null, (X509Certificate)cert, null, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign(null, (X509Certificate)cert, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign(null, (X509Certificate)cert, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, null, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, null, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)cert_2, null, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)cert_2, null, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)cert_2, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)cert_2, null, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c1_sha1, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c1_sha1, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        NamedNodeMap attrs = samlResponseDocument.getFirstChild().getAttributes();
        Node nodeAttr = attrs.getNamedItem("ID");
        nodeAttr.setTextContent("pfxc3d2b542-0f7e-8767-8e87-5b0dc6913375-alter");
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlResponseDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        String signedAssertionStr = Util.getFileAsString((String)"data/responses/signed_assertion_response.xml.base64");
        String samlSignedAssertionStr = new String(Util.base64decoder((String)signedAssertionStr));
        Document samlSignedAssertionDocument = Util.loadXML((String)samlSignedAssertionStr);
        Node audience = samlSignedAssertionDocument.getElementsByTagName("saml:Audience").item(0);
        audience.setTextContent("http://sp.example.com/metadata.php");
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        String doubleSignedResponseStr = Util.getFileAsString((String)"data/responses/signed_assertion_response.xml.base64");
        String samlDoubleSignedResponseStr = new String(Util.base64decoder((String)doubleSignedResponseStr));
        Document samlDoubleSignedResponseDocument = Util.loadXML((String)samlDoubleSignedResponseStr);
        Node assertionElement = samlDoubleSignedResponseDocument.getFirstChild().getFirstChild().getNextSibling().getNextSibling();
        Assert.assertFalse((boolean)Util.validateSignNode((Node)assertionElement, (X509Certificate)cert, null, null));
        String noSignatureStr = Util.getFileAsString((String)"data/responses/invalids/no_signature.xml.base64");
        String samlNoSignatureStr = new String(Util.base64decoder((String)noSignatureStr));
        Document samlNoSignatureDocument = Util.loadXML((String)samlNoSignatureStr);
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoSignatureDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoSignatureDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoSignatureDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoSignatureDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoSignatureDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoSignatureDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoSignatureDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoSignatureDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        String noKeyStr = Util.getFileAsString((String)"data/responses/invalids/no_key.xml.base64");
        String samlNoKeyStr = new String(Util.base64decoder((String)noKeyStr));
        Document samlNoKeyDocument = Util.loadXML((String)samlNoKeyStr);
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoKeyDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoKeyDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoKeyDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoKeyDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoKeyDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoKeyDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoKeyDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlNoKeyDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        String sigAttackStr = Util.getFileAsString((String)"data/responses/invalids/signature_wrapping_attack.xml.base64");
        String samlSigAttackStr = new String(Util.base64decoder((String)sigAttackStr));
        Document samlSigAttackDocument = Util.loadXML((String)samlSigAttackStr);
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSigAttackDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSigAttackDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSigAttackDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSigAttackDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSigAttackDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSigAttackDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSigAttackDocument, (X509Certificate)null, (String)fingerprint_c2_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSigAttackDocument, (X509Certificate)null, (String)fingerprint_c1_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
    }

    @Test
    public void testValidateSign() throws URISyntaxException, IOException, CertificateException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String fingerprint_sha1 = "afe71c28ef740bc87425be13a2263d37971da1f9";
        String fingerprint_sha256 = "c51cfa06c7a49767f6eab18238eae1c56708e29264da3d11f538a12cd2c357ba";
        String fingerprint_sha1_uppercase = "AFE71C28EF740BC87425BE13A2263D37971DA1F9";
        String fingerprint_sha256_uppercase = "C51CFA06C7A49767F6EAB18238EAE1C56708E29264DA3D11F538A12CD2C357BA";
        String signedResponseStr = Util.getFileAsString((String)"data/responses/signed_message_response.xml.base64");
        String samlSignedResponseStr = new String(Util.base64decoder((String)signedResponseStr));
        Document samlSignedResponseDocument = Util.loadXML((String)samlSignedResponseStr);
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha1, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha256, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha1_uppercase, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha256_uppercase, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedResponseDocument, (X509Certificate)cert, null, null, (String)""));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedResponseDocument, (X509Certificate)null, null, null, (String)""));
        String signedAssertionStr = Util.getFileAsString((String)"data/responses/signed_assertion_response.xml.base64");
        String samlSignedAssertionStr = new String(Util.base64decoder((String)signedAssertionStr));
        Document samlSignedAssertionDocument = Util.loadXML((String)samlSignedAssertionStr);
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_sha1_uppercase, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (X509Certificate)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        String doubleSignedResponseStr = Util.getFileAsString((String)"data/responses/double_signed_response.xml.base64");
        String samlDoubleSignedResponseStr = new String(Util.base64decoder((String)doubleSignedResponseStr));
        Document samlDoubleSignedResponseDocument = Util.loadXML((String)samlDoubleSignedResponseStr);
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)cert, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha1, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha1_uppercase, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha1_uppercase, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha256, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha256_uppercase, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (X509Certificate)null, (String)fingerprint_sha256_uppercase, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
    }

    @Test
    public void testValidateSignWilthMultiCert() throws URISyntaxException, IOException, CertificateException {
        String[] certListString = new String[]{Util.getFileAsString((String)"data/customPath/certs/sp.crt"), Util.getFileAsString((String)"certs/certificate1"), Util.getFileAsString((String)"certs/certificate2"), Util.getFileAsString((String)"certs/certificate3")};
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (String certString : certListString) {
            certList.add(Util.loadCert((String)certString));
        }
        String fingerprint_sha1 = "afe71c28ef740bc87425be13a2263d37971da1f9";
        String fingerprint_sha256 = "c51cfa06c7a49767f6eab18238eae1c56708e29264da3d11f538a12cd2c357ba";
        String signedResponseStr = Util.getFileAsString((String)"data/responses/signed_message_response.xml.base64");
        String samlSignedResponseStr = new String(Util.base64decoder((String)signedResponseStr));
        Document samlSignedResponseDocument = Util.loadXML((String)samlSignedResponseStr);
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, certList, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, (List)null, (String)fingerprint_sha1, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, (List)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedResponseDocument, (List)null, (String)fingerprint_sha256, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedResponseDocument, (List)null, (String)fingerprint_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedResponseDocument, certList, null, null, (String)""));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedResponseDocument, (List)null, null, null, (String)""));
        String signedAssertionStr = Util.getFileAsString((String)"data/responses/signed_assertion_response.xml.base64");
        String samlSignedAssertionStr = new String(Util.base64decoder((String)signedAssertionStr));
        Document samlSignedAssertionDocument = Util.loadXML((String)samlSignedAssertionStr);
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedAssertionDocument, certList, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (List)null, (String)fingerprint_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (List)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertFalse((boolean)Util.validateSign((Document)samlSignedAssertionDocument, (List)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        String doubleSignedResponseStr = Util.getFileAsString((String)"data/responses/double_signed_response.xml.base64");
        String samlDoubleSignedResponseStr = new String(Util.base64decoder((String)doubleSignedResponseStr));
        Document samlDoubleSignedResponseDocument = Util.loadXML((String)samlDoubleSignedResponseStr);
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, certList, null, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, certList, null, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (List)null, (String)fingerprint_sha1, null, (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (List)null, (String)fingerprint_sha1, null, (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (List)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (List)null, (String)fingerprint_sha1, (String)"SHA-1", (String)"/samlp:Response/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (List)null, (String)fingerprint_sha256, (String)"SHA-256", (String)"/samlp:Response/saml:Assertion/ds:Signature"));
        Assert.assertTrue((boolean)Util.validateSign((Document)samlDoubleSignedResponseDocument, (List)null, (String)fingerprint_sha256, (String)"SHA-256", (String)"/samlp:Response/ds:Signature"));
    }

    @Test
    public void testValidateMetadataSign() throws URISyntaxException, IOException, CertificateException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String fingerprint_sha1 = "afe71c28ef740bc87425be13a2263d37971da1f9";
        String fingerprint_sha256 = "c51cfa06c7a49767f6eab18238eae1c56708e29264da3d11f538a12cd2c357ba";
        String unsignedMetadataStr = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        Document unsignedMetadataDocument = Util.loadXML((String)unsignedMetadataStr);
        Assert.assertFalse((boolean)Util.validateMetadataSign((Document)unsignedMetadataDocument, (X509Certificate)cert, null, null));
        Assert.assertFalse((boolean)Util.validateMetadataSign((Document)unsignedMetadataDocument, null, (String)fingerprint_sha1, null));
        Assert.assertFalse((boolean)Util.validateMetadataSign((Document)unsignedMetadataDocument, null, (String)fingerprint_sha1, (String)"SHA-1"));
        Assert.assertFalse((boolean)Util.validateMetadataSign((Document)unsignedMetadataDocument, null, (String)fingerprint_sha256, (String)"SHA-256"));
        String signedMetadataStr = Util.getFileAsString((String)"data/metadata/signed_metadata_settings1.xml");
        Document signedMetadataDocument = Util.loadXML((String)signedMetadataStr);
        Assert.assertTrue((boolean)Util.validateMetadataSign((Document)signedMetadataDocument, (X509Certificate)cert, null, null));
        Assert.assertTrue((boolean)Util.validateMetadataSign((Document)signedMetadataDocument, null, (String)fingerprint_sha1, null));
        Assert.assertTrue((boolean)Util.validateMetadataSign((Document)signedMetadataDocument, null, (String)fingerprint_sha1, (String)"SHA-1"));
        Assert.assertTrue((boolean)Util.validateMetadataSign((Document)signedMetadataDocument, null, (String)fingerprint_sha256, (String)"SHA-256"));
        String signed256MetadataStr = Util.getFileAsString((String)"data/metadata/signed_metadata_settings256.xml");
        Document signed256MetadataDocument = Util.loadXML((String)signed256MetadataStr);
        Assert.assertFalse((boolean)Util.validateMetadataSign((Document)signedMetadataDocument, null, (String)fingerprint_sha1, (String)"SHA-1", (boolean)true));
        Assert.assertTrue((boolean)Util.validateMetadataSign((Document)signed256MetadataDocument, null, (String)fingerprint_sha1, (String)"SHA-1", (boolean)true));
    }

    @Test
    public void testDecryptElementNameId() throws URISyntaxException, IOException, GeneralSecurityException, XPathExpressionException {
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String responseNameIdEnc = Util.base64decodedInflated((String)Util.getFileAsString((String)"data/responses/response_encrypted_nameid.xml.base64"));
        Document responseNameIdEncDoc = Util.loadXML((String)responseNameIdEnc);
        NodeList EncryptedNameIdNodes = Util.query((Document)responseNameIdEncDoc, (String)".//saml:EncryptedID");
        NodeList EncryptedDataNodes = Util.query((Document)responseNameIdEncDoc, (String)"./xenc:EncryptedData", (Node)EncryptedNameIdNodes.item(0));
        Element encryptedData = (Element)EncryptedDataNodes.item(0);
        Assert.assertEquals((Object)"xenc:EncryptedData", (Object)encryptedData.getNodeName());
        Util.decryptElement((Element)encryptedData, (PrivateKey)key);
        Assert.assertEquals((Object)"saml:NameID", (Object)EncryptedNameIdNodes.item(0).getFirstChild().getNodeName());
    }

    @Test
    public void testDecryptElementNameIdWrongKey() throws URISyntaxException, IOException, GeneralSecurityException, XPathExpressionException {
        String keyString = "-----BEGIN PRIVATE KEY-----\nMIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALvwEktX1+4y2AhE\nqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4\nakFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCq\nFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAECgYA7VPVRl+/xoVeWdKdWY1F17Her\nSa23ynI2vQ8TkUY6kR3ucz6ElRxHJesY8fNCPoX+XuMfUly7IKyPZMkWyvEgDPo7\nJ5mYqP5VsTK0Li4AwR/BA93Aw6gaX7/EYi3HjBh8QdNSt4fi9yOea/hv04yfR9Lx\n/a5fvQIyhqaDtT2QeQJBAOnCgnxnj70/sv9UsFPa8t1OGdAfXtOgEoklh1F2NR9j\nid6FPw5E98eCpdZ00MfRrmUavgqg6Y4swZISyzJIjGMCQQDN0YNsC4S+eJJM6aOC\npupKluWE/cCWB01UQYekyXH7OdUtl49NlKEUPBSAvtaLMuMKlTNOjlPrx4Q+/c5i\n0vTPAkEA5H7CR9J/OZETaewhc8ZYkaRvLPYNHjWhCLhLXoB6itUkhgOfUFZwEXAO\npOOI1VmL675JN2B1DAmJqTx/rQYnWwJBAMx3ztsAmnBq8dTM6y65ydouDHhRawjg\n2jbRHwNbSQvuyVSQ08Gb3WZvxWKdtB/3fsydqqnpBYAf5sZ5eJZ+wssCQAOiIKnh\ndYe+RBbBwykzjUqtzEmt4fwCFE8tD4feEx77D05j5f7u7KYh1mL0G2zIbnUryi7j\nwc4ye98VirRpZ1w=\n-----END PRIVATE KEY-----";
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String responseNameIdEnc = Util.base64decodedInflated((String)Util.getFileAsString((String)"data/responses/response_encrypted_nameid.xml.base64"));
        Document responseNameIdEncDoc = Util.loadXML((String)responseNameIdEnc);
        NodeList EncryptedNameIdNodes = Util.query((Document)responseNameIdEncDoc, (String)".//saml:EncryptedID");
        NodeList EncryptedDataNodes = Util.query((Document)responseNameIdEncDoc, (String)"./xenc:EncryptedData", (Node)EncryptedNameIdNodes.item(0));
        Element encryptedData = (Element)EncryptedDataNodes.item(0);
        Assert.assertEquals((Object)"xenc:EncryptedData", (Object)encryptedData.getNodeName());
        Util.decryptElement((Element)encryptedData, (PrivateKey)key);
        Assert.assertNotEquals((Object)"saml:NameID", (Object)EncryptedNameIdNodes.item(0).getFirstChild().getNodeName());
        Assert.assertEquals((Object)"xenc:EncryptedData", (Object)EncryptedNameIdNodes.item(0).getFirstChild().getNodeName());
    }

    @Test
    public void testDecryptElementAssertion() throws URISyntaxException, IOException, GeneralSecurityException, XPathExpressionException {
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String responseAssertionEnc = Util.base64decodedInflated((String)Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64"));
        Document responseAssertionEncDoc = Util.loadXML((String)responseAssertionEnc);
        NodeList EncryptedAssertionNodes = Util.query((Document)responseAssertionEncDoc, (String)".//saml:EncryptedAssertion");
        NodeList EncryptedDataNodes = Util.query((Document)responseAssertionEncDoc, (String)"./xenc:EncryptedData", (Node)EncryptedAssertionNodes.item(0));
        Element encryptedData = (Element)EncryptedDataNodes.item(0);
        Assert.assertEquals((Object)"xenc:EncryptedData", (Object)encryptedData.getNodeName());
        Util.decryptElement((Element)encryptedData, (PrivateKey)key);
        Assert.assertEquals((Object)"saml:Assertion", (Object)EncryptedAssertionNodes.item(0).getFirstChild().getNodeName());
    }

    @Test
    public void testDecryptElementAssertionWrongKey() throws URISyntaxException, IOException, GeneralSecurityException, XPathExpressionException {
        String keyString = "-----BEGIN PRIVATE KEY-----\nMIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALvwEktX1+4y2AhE\nqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4\nakFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCq\nFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAECgYA7VPVRl+/xoVeWdKdWY1F17Her\nSa23ynI2vQ8TkUY6kR3ucz6ElRxHJesY8fNCPoX+XuMfUly7IKyPZMkWyvEgDPo7\nJ5mYqP5VsTK0Li4AwR/BA93Aw6gaX7/EYi3HjBh8QdNSt4fi9yOea/hv04yfR9Lx\n/a5fvQIyhqaDtT2QeQJBAOnCgnxnj70/sv9UsFPa8t1OGdAfXtOgEoklh1F2NR9j\nid6FPw5E98eCpdZ00MfRrmUavgqg6Y4swZISyzJIjGMCQQDN0YNsC4S+eJJM6aOC\npupKluWE/cCWB01UQYekyXH7OdUtl49NlKEUPBSAvtaLMuMKlTNOjlPrx4Q+/c5i\n0vTPAkEA5H7CR9J/OZETaewhc8ZYkaRvLPYNHjWhCLhLXoB6itUkhgOfUFZwEXAO\npOOI1VmL675JN2B1DAmJqTx/rQYnWwJBAMx3ztsAmnBq8dTM6y65ydouDHhRawjg\n2jbRHwNbSQvuyVSQ08Gb3WZvxWKdtB/3fsydqqnpBYAf5sZ5eJZ+wssCQAOiIKnh\ndYe+RBbBwykzjUqtzEmt4fwCFE8tD4feEx77D05j5f7u7KYh1mL0G2zIbnUryi7j\nwc4ye98VirRpZ1w=\n-----END PRIVATE KEY-----";
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String responseAssertionEnc = Util.base64decodedInflated((String)Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64"));
        Document responseAssertionEncDoc = Util.loadXML((String)responseAssertionEnc);
        NodeList EncryptedAssertionNodes = Util.query((Document)responseAssertionEncDoc, (String)".//saml:EncryptedAssertion");
        NodeList EncryptedDataNodes = Util.query((Document)responseAssertionEncDoc, (String)"./xenc:EncryptedData", (Node)EncryptedAssertionNodes.item(0));
        Element encryptedData = (Element)EncryptedDataNodes.item(0);
        Assert.assertEquals((Object)"xenc:EncryptedData", (Object)encryptedData.getNodeName());
        Util.decryptElement((Element)encryptedData, (PrivateKey)key);
        Assert.assertEquals((Object)"xenc:EncryptedData", (Object)EncryptedAssertionNodes.item(0).getFirstChild().getNodeName());
        Assert.assertNotEquals((Object)"saml:Assertion", (Object)EncryptedAssertionNodes.item(0).getFirstChild().getNodeName());
    }

    @Test
    public void testDecryptElementNoMethod() throws URISyntaxException, IOException, GeneralSecurityException, XPathExpressionException {
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String encResponseNoMethod = Util.base64decodedInflated((String)Util.getFileAsString((String)"data/responses/invalids/encrypted_nameID_without_EncMethod.xml.base64"));
        Document encResponseNoMethodDoc = Util.loadXML((String)encResponseNoMethod);
        NodeList EncryptedIdNodes = Util.query((Document)encResponseNoMethodDoc, (String)".//saml:EncryptedID");
        NodeList EncryptedDataNodes = Util.query((Document)encResponseNoMethodDoc, (String)"./xenc:EncryptedData", (Node)EncryptedIdNodes.item(0));
        Element encryptedData = (Element)EncryptedDataNodes.item(0);
        Assert.assertEquals((Object)"xenc:EncryptedData", (Object)encryptedData.getNodeName());
        Util.decryptElement((Element)encryptedData, (PrivateKey)key);
        Assert.assertNotEquals((Object)"saml:NameID", (Object)EncryptedIdNodes.item(0).getFirstChild().getNodeName());
    }

    @Test
    public void testDecryptElementNoKeyinfo() throws URISyntaxException, IOException, GeneralSecurityException, XPathExpressionException {
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String encResponseNoMethod = Util.base64decodedInflated((String)Util.getFileAsString((String)"data/responses/invalids/encrypted_nameID_without_keyinfo.xml.base64"));
        Document encResponseNoMethodDoc = Util.loadXML((String)encResponseNoMethod);
        NodeList EncryptedIdNodes = Util.query((Document)encResponseNoMethodDoc, (String)".//saml:EncryptedID");
        NodeList EncryptedDataNodes = Util.query((Document)encResponseNoMethodDoc, (String)"./xenc:EncryptedData", (Node)EncryptedIdNodes.item(0));
        Element encryptedData = (Element)EncryptedDataNodes.item(0);
        Assert.assertEquals((Object)"xenc:EncryptedData", (Object)encryptedData.getNodeName());
        Util.decryptElement((Element)encryptedData, (PrivateKey)key);
        Assert.assertNotEquals((Object)"saml:NameID", (Object)EncryptedIdNodes.item(0).getFirstChild().getNodeName());
    }

    @Test
    public void testCopyDocument() throws URISyntaxException, IOException, ParserConfigurationException {
        String signedResponseStr = Util.getFileAsString((String)"data/responses/signed_message_response.xml.base64");
        String samlSignedResponseStr = new String(Util.base64decoder((String)signedResponseStr));
        Document samlSignedResponseDocument = Util.loadXML((String)samlSignedResponseStr);
        Document copiedSamlSignedResponseDocument = Util.copyDocument((Document)samlSignedResponseDocument);
        Assert.assertThat((Object)Util.convertDocumentToString((Document)samlSignedResponseDocument), (Matcher)CoreMatchers.equalTo((Object)Util.convertDocumentToString((Document)copiedSamlSignedResponseDocument)));
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        Document authNRequestDoc = Util.loadXML((String)authNRequest);
        Document copiedAuthNRequestDoc = Util.copyDocument((Document)authNRequestDoc);
        Assert.assertThat((Object)Util.convertDocumentToString((Document)authNRequestDoc), (Matcher)CoreMatchers.equalTo((Object)Util.convertDocumentToString((Document)copiedAuthNRequestDoc)));
        String logoutRequest = Util.getFileAsString((String)"data/logout_requests/logout_request.xml");
        Document logoutRequestDoc = Util.loadXML((String)logoutRequest);
        Document copiedLogoutRequestDoc = Util.copyDocument((Document)logoutRequestDoc);
        Assert.assertThat((Object)Util.convertDocumentToString((Document)logoutRequestDoc), (Matcher)CoreMatchers.equalTo((Object)Util.convertDocumentToString((Document)copiedLogoutRequestDoc)));
        String logoutResponse = Util.getFileAsString((String)"data/logout_responses/logout_response.xml");
        Document logoutResponseDoc = Util.loadXML((String)logoutResponse);
        Document copiedLogoutResponseDoc = Util.copyDocument((Document)logoutResponseDoc);
        Assert.assertThat((Object)Util.convertDocumentToString((Document)logoutResponseDoc), (Matcher)CoreMatchers.equalTo((Object)Util.convertDocumentToString((Document)copiedLogoutResponseDoc)));
        String metadata = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        Document metadataDoc = Util.loadXML((String)metadata);
        Document copiedMetadataDoc = Util.copyDocument((Document)metadataDoc);
        Assert.assertThat((Object)Util.convertDocumentToString((Document)metadataDoc), (Matcher)CoreMatchers.equalTo((Object)Util.convertDocumentToString((Document)copiedMetadataDoc)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSignDocNull() throws URISyntaxException, IOException, GeneralSecurityException, ParserConfigurationException, XPathExpressionException, XMLSecurityException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String signAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String docSigned = Util.addSign(null, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSignDocEmpty() throws URISyntaxException, IOException, GeneralSecurityException, ParserConfigurationException, XPathExpressionException, XMLSecurityException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String signAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document emptyDoc = builder.newDocument();
        Assert.assertNull((Object)emptyDoc.getDocumentElement());
        String docSigned = Util.addSign((Document)emptyDoc, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSignNodeNull() throws URISyntaxException, IOException, GeneralSecurityException, ParserConfigurationException, XPathExpressionException, XMLSecurityException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String signAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        Node node = null;
        String docSigned = Util.addSign(node, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSignKeyNull() throws URISyntaxException, IOException, GeneralSecurityException, ParserConfigurationException, XPathExpressionException, XMLSecurityException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String signAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        Document authNRequestDoc = Util.loadXML((String)authNRequest);
        String authNRequestSigned = Util.addSign((Document)authNRequestDoc, null, (X509Certificate)cert, (String)signAlgorithmSha1);
    }

    @Test(expected=SAMLSignatureException.class)
    public void testAddSignInvalidSigAlg() throws URISyntaxException, IOException, GeneralSecurityException, ParserConfigurationException, XPathExpressionException, XMLSecurityException {
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        Document authNRequestDoc = Util.loadXML((String)authNRequest);
        String authNRequestSigned = Util.addSign((Document)authNRequestDoc, (PrivateKey)key, (X509Certificate)cert, (String)"invalid_signAlgorithm");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSignCertNull() throws URISyntaxException, IOException, GeneralSecurityException, ParserConfigurationException, XPathExpressionException, XMLSecurityException {
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String signAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        Document authNRequestDoc = Util.loadXML((String)authNRequest);
        String authNRequestSigned = Util.addSign((Document)authNRequestDoc, (PrivateKey)key, null, (String)signAlgorithmSha1);
    }

    @Test
    public void testAddSignDoc() throws URISyntaxException, IOException, GeneralSecurityException, ParserConfigurationException, XPathExpressionException, XMLSecurityException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String signAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String signAlgorithmSha256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        String digestAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#sha1";
        String digestAlgorithmSha512 = "http://www.w3.org/2001/04/xmlenc#sha512";
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        Document authNRequestDoc = Util.loadXML((String)authNRequest);
        String authNRequestSigned = Util.addSign((Document)authNRequestDoc, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha1);
        Assert.assertThat((Object)authNRequestSigned, (Matcher)CoreMatchers.containsString((String)"<ds:SignatureValue>"));
        Document authNRequestSignedDoc = Util.loadXML((String)authNRequestSigned);
        Node ds_signature_authn = authNRequestSignedDoc.getFirstChild().getFirstChild().getNextSibling().getNextSibling();
        Assert.assertEquals((Object)"ds:Signature", (Object)ds_signature_authn.getNodeName());
        Document authNRequestDoc_2 = Util.loadXML((String)authNRequest);
        String authNRequestSigned_2 = Util.addSign((Document)authNRequestDoc_2, (PrivateKey)key, (X509Certificate)cert, null);
        Document authNRequestDoc_3 = Util.loadXML((String)authNRequest);
        String authNRequestSigned_3 = Util.addSign((Document)authNRequestDoc_3, (PrivateKey)key, (X509Certificate)cert, (String)"");
        Assert.assertThat((Object)authNRequestSigned.toString(), (Matcher)CoreMatchers.equalTo((Object)authNRequestSigned_2.toString()));
        Assert.assertThat((Object)authNRequestSigned.toString(), (Matcher)CoreMatchers.equalTo((Object)authNRequestSigned_3.toString()));
        String authNRequestNoID = authNRequest.replace("_ONELOGIN103428909abec424fa58327f79474984", "");
        Document authNRequesNoIDtDoc = Util.loadXML((String)authNRequestNoID);
        String authNRequestNoIDSigned = Util.addSign((Document)authNRequesNoIDtDoc, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha1);
        Assert.assertThat((Object)authNRequestNoIDSigned, (Matcher)CoreMatchers.containsString((String)"<ds:SignatureValue>"));
        String logoutRequest = Util.getFileAsString((String)"data/logout_requests/logout_request.xml");
        Document logoutRequestDoc = Util.loadXML((String)logoutRequest);
        String logoutRequestSigned = Util.addSign((Document)logoutRequestDoc, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha256, (String)digestAlgorithmSha512);
        Assert.assertThat((Object)logoutRequestSigned, (Matcher)CoreMatchers.containsString((String)"<ds:SignatureValue>"));
        Document logoutRequestSignedDoc = Util.loadXML((String)logoutRequestSigned);
        Assert.assertEquals((Object)"samlp:LogoutRequest", (Object)logoutRequestSignedDoc.getFirstChild().getNodeName());
        Node ds_signature_logout_request = logoutRequestSignedDoc.getFirstChild().getFirstChild().getNextSibling().getNextSibling();
        Assert.assertEquals((Object)"ds:Signature", (Object)ds_signature_logout_request.getNodeName());
        Node canonization_logout_request_signed = ds_signature_logout_request.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:CanonicalizationMethod", (Object)canonization_logout_request_signed.getNodeName());
        Assert.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)canonization_logout_request_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node signature_method_logout_request_signed = ds_signature_logout_request.getFirstChild().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:SignatureMethod", (Object)signature_method_logout_request_signed.getNodeName());
        Assert.assertEquals((Object)signAlgorithmSha256, (Object)signature_method_logout_request_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node digest_method_logout_request_signed = ds_signature_logout_request.getFirstChild().getFirstChild().getNextSibling().getNextSibling().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:DigestMethod", (Object)digest_method_logout_request_signed.getNodeName());
        Assert.assertEquals((Object)digestAlgorithmSha512, (Object)digest_method_logout_request_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        String logoutResponse = Util.getFileAsString((String)"data/logout_responses/logout_response.xml");
        Document logoutResponseDoc = Util.loadXML((String)logoutResponse);
        String logoutResponseSigned = Util.addSign((Document)logoutResponseDoc, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha1);
        Assert.assertThat((Object)logoutResponseSigned, (Matcher)CoreMatchers.containsString((String)"<ds:SignatureValue>"));
        Document logoutResponseSignedDoc = Util.loadXML((String)logoutResponseSigned);
        Assert.assertEquals((Object)"samlp:LogoutResponse", (Object)logoutResponseSignedDoc.getFirstChild().getNodeName());
        Node ds_signature_logout_response = logoutResponseSignedDoc.getFirstChild().getFirstChild().getNextSibling().getNextSibling();
        Assert.assertEquals((Object)"ds:Signature", (Object)ds_signature_logout_response.getNodeName());
        Node canonization_logout_response_signed = ds_signature_logout_response.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:CanonicalizationMethod", (Object)canonization_logout_response_signed.getNodeName());
        Assert.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)canonization_logout_response_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node signature_method_logout_response_signed = ds_signature_logout_response.getFirstChild().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:SignatureMethod", (Object)signature_method_logout_response_signed.getNodeName());
        Assert.assertEquals((Object)signAlgorithmSha1, (Object)signature_method_logout_response_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node digest_method_logout_response_signed = ds_signature_logout_response.getFirstChild().getFirstChild().getNextSibling().getNextSibling().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:DigestMethod", (Object)digest_method_logout_response_signed.getNodeName());
        Assert.assertEquals((Object)digestAlgorithmSha1, (Object)digest_method_logout_response_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        String metadata = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        Document metadataDoc = Util.loadXML((String)metadata);
        String metadataSigned = Util.addSign((Document)metadataDoc, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha1);
        Assert.assertThat((Object)metadataSigned, (Matcher)CoreMatchers.containsString((String)"<ds:SignatureValue>"));
        Document metadataSignedDoc = Util.loadXML((String)metadataSigned);
        Assert.assertEquals((Object)"md:EntityDescriptor", (Object)metadataSignedDoc.getFirstChild().getNodeName());
        Node ds_signature_metadata = metadataSignedDoc.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:Signature", (Object)ds_signature_metadata.getNodeName());
        Node canonization_metadata_signed = ds_signature_metadata.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:CanonicalizationMethod", (Object)canonization_metadata_signed.getNodeName());
        Assert.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)canonization_metadata_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node signature_method_metadata_signed = ds_signature_metadata.getFirstChild().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:SignatureMethod", (Object)signature_method_metadata_signed.getNodeName());
        Assert.assertEquals((Object)signAlgorithmSha1, (Object)signature_method_metadata_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node digest_method_metadata_signed = ds_signature_metadata.getFirstChild().getFirstChild().getNextSibling().getNextSibling().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:DigestMethod", (Object)digest_method_metadata_signed.getNodeName());
        Assert.assertEquals((Object)digestAlgorithmSha1, (Object)digest_method_metadata_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        String metadata_entities = Util.getFileAsString((String)"data/metadata/metadata_entities.xml");
        Document metadataEntitiesDoc = Util.loadXML((String)metadata_entities);
        String metadataEntitiesSigned = Util.addSign((Document)metadataEntitiesDoc, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha256, (String)digestAlgorithmSha512);
        Assert.assertThat((Object)metadataEntitiesSigned, (Matcher)CoreMatchers.containsString((String)"<ds:SignatureValue>"));
        Document metadataEntitiesSignedDoc = Util.loadXML((String)metadataEntitiesSigned);
        Assert.assertEquals((Object)"EntitiesDescriptor", (Object)metadataEntitiesSignedDoc.getFirstChild().getNodeName());
        Node ds_signature_metadata_entities = metadataEntitiesSignedDoc.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:Signature", (Object)ds_signature_metadata_entities.getNodeName());
        Node canonization_metadata_entities_signed = ds_signature_metadata_entities.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:CanonicalizationMethod", (Object)canonization_metadata_entities_signed.getNodeName());
        Assert.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)canonization_metadata_entities_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node signature_method_metadata_entities_signed = ds_signature_metadata_entities.getFirstChild().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:SignatureMethod", (Object)signature_method_metadata_entities_signed.getNodeName());
        Assert.assertEquals((Object)signAlgorithmSha256, (Object)signature_method_metadata_entities_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node digest_method_metadata_entities_signed = ds_signature_metadata_entities.getFirstChild().getFirstChild().getNextSibling().getNextSibling().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:DigestMethod", (Object)digest_method_metadata_entities_signed.getNodeName());
        Assert.assertEquals((Object)digestAlgorithmSha512, (Object)digest_method_metadata_entities_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
    }

    @Test
    public void testAddSignNode() throws URISyntaxException, IOException, GeneralSecurityException, ParserConfigurationException, XPathExpressionException, XMLSecurityException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String signAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String authNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml");
        Document authNRequestDoc = Util.loadXML((String)authNRequest);
        Node node = authNRequestDoc.getFirstChild();
        String authNRequestSigned = Util.addSign((Node)node, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha1);
        Assert.assertThat((Object)authNRequestSigned, (Matcher)CoreMatchers.containsString((String)"<ds:SignatureValue>"));
        Document authNRequestSignedDoc = Util.loadXML((String)authNRequestSigned);
        Node ds_signature = authNRequestSignedDoc.getFirstChild().getFirstChild().getNextSibling().getNextSibling();
        Assert.assertEquals((Object)"ds:Signature", (Object)ds_signature.getNodeName());
    }

    @Test
    public void testValidateBinarySignature() throws URISyntaxException, IOException, CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        String certString = "-----BEGIN CERTIFICATE-----MIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wHhcNMTUxMDE4MjAxMjM1WhcNMTgwNzE0MjAxMjM1WjBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALvwEktX1+4y2AhEqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAGjUDBOMB0GA1UdDgQWBBTifMwN3CQ5ZOPkV5tDJsutU8teFDAfBgNVHSMEGDAWgBTifMwN3CQ5ZOPkV5tDJsutU8teFDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBDQUAA4GBAG3nAEUjJaA75SkzID5FKLolsxG5TE/0HU0+yEUAVkXiqvqN4mPWq/JjoK5+uP4LEZIb4pRrCqI3iHp+vazLLYSeyV3kaGN7q35Afw8nk8WM0f7vImbQ69j1S8GQ+6E0PEI26qBLykGkMn3GUVtBBWSdpP093NuNLJiOomnHqhqj-----END CERTIFICATE-----";
        X509Certificate cert = Util.loadCert((String)certString);
        String deflatedEncodedAuthNRequest = Util.getFileAsString((String)"data/requests/authn_request.xml.deflated.base64");
        String relayState = "http://example.com";
        String signAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String signAlgorithmSha256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        String SignatureSha1 = "FqFJi9aIut9Gp/SUyLcj4ewwnU4ajjhfWpdr8pc4w//9m0QB1hzDUHR7YmKxXB6rrRuX7iy9CJy+o7zzhz2pTr0PHHE9mvFPsyk/mas9e2ZGUeLS2OzMPHYwJCdOg4uLrbqybWGKy0AgoDqTpAfpkQVxuunVKTj4pOPXGx156Oo=";
        String SignatureSha256 = "PJoiwvBgKnRefzaYMaPqOTvlia7EhFoRrc+tFlJCi557VEpG0oY1x8YTmkOxC+oI0zWyQ0RiXA65q7hv1xyYgGnSFdMKr5s+qeD4+1BjPxEGwXVU6+gTX0gg2+UL+1o4YpoVTQ1aKSO85uyBEGO20WnK2zETuGA/Wgl1VBSxNSw=";
        String signedQuerySha1 = "SAMLRequest=" + Util.urlEncoder((String)deflatedEncodedAuthNRequest) + "&RelayState=" + Util.urlEncoder((String)relayState) + "&SigAlg=" + Util.urlEncoder((String)signAlgorithmSha1);
        String signedQuerySha256 = "SAMLRequest=" + Util.urlEncoder((String)deflatedEncodedAuthNRequest) + "&RelayState=" + Util.urlEncoder((String)relayState) + "&SigAlg=" + Util.urlEncoder((String)signAlgorithmSha256);
        Assert.assertTrue((boolean)Util.validateBinarySignature((String)signedQuerySha1, (byte[])Util.base64decoder((String)SignatureSha1), (X509Certificate)cert, (String)signAlgorithmSha1));
        Assert.assertFalse((boolean)Util.validateBinarySignature((String)signedQuerySha256, (byte[])Util.base64decoder((String)SignatureSha1), (X509Certificate)cert, (String)signAlgorithmSha1));
        Assert.assertFalse((boolean)Util.validateBinarySignature((String)signedQuerySha1, (byte[])Util.base64decoder((String)SignatureSha256), (X509Certificate)cert, (String)signAlgorithmSha1));
        Assert.assertTrue((boolean)Util.validateBinarySignature((String)signedQuerySha256, (byte[])Util.base64decoder((String)SignatureSha256), (X509Certificate)cert, (String)signAlgorithmSha256));
        Assert.assertFalse((boolean)Util.validateBinarySignature((String)signedQuerySha1, (byte[])Util.base64decoder((String)SignatureSha256), (X509Certificate)cert, (String)signAlgorithmSha256));
        Assert.assertFalse((boolean)Util.validateBinarySignature((String)signedQuerySha256, (byte[])Util.base64decoder((String)SignatureSha256), (X509Certificate)cert, (String)signAlgorithmSha1));
    }

    @Test
    public void testGenerateNameIdException() throws URISyntaxException, IOException, CertificateException {
        String nameId = Util.generateNameId(null, null, null);
        Assert.assertNull((Object)nameId);
    }

    @Test
    public void testGenerateNameId() throws URISyntaxException, IOException, CertificateException {
        String nameIdValue = "ONELOGIN_ce998811003f4e60f8b07a311dc641621379cfde";
        String entityId = "http://stuff.com/endpoints/metadata.php";
        String nameIDFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        String nameId = Util.generateNameId((String)nameIdValue, (String)entityId, (String)nameIDFormat);
        String expectedNameId = "<saml:NameID Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified\" SPNameQualifier=\"http://stuff.com/endpoints/metadata.php\">ONELOGIN_ce998811003f4e60f8b07a311dc641621379cfde</saml:NameID>";
        Assert.assertEquals((Object)expectedNameId, (Object)nameId);
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String nameIdEnc = Util.generateNameId((String)nameIdValue, (String)entityId, (String)nameIDFormat, (X509Certificate)cert);
        Assert.assertThat((Object)nameIdEnc, (Matcher)CoreMatchers.containsString((String)"<saml:EncryptedID><xenc:EncryptedData"));
        Assert.assertThat((Object)nameIdEnc, (Matcher)CoreMatchers.containsString((String)"<xenc:EncryptedKey"));
        Assert.assertThat((Object)nameIdEnc, (Matcher)CoreMatchers.containsString((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        Assert.assertThat((Object)nameIdEnc, (Matcher)CoreMatchers.containsString((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
    }

    @Test
    public void testGenerateNameIdWithoutFormat() throws URISyntaxException, IOException, CertificateException {
        String nameIdValue = "ONELOGIN_ce998811003f4e60f8b07a311dc641621379cfde";
        String nameId = Util.generateNameId((String)nameIdValue);
        String expectedNameId = "<saml:NameID>ONELOGIN_ce998811003f4e60f8b07a311dc641621379cfde</saml:NameID>";
        Assert.assertEquals((Object)expectedNameId, (Object)nameId);
    }

    @Test
    public void testGenerateUniqueID() {
        String s1 = Util.generateUniqueID();
        Assert.assertThat((Object)s1, (Matcher)CoreMatchers.startsWith((String)"ONELOGIN_"));
    }

    @Test
    public void testGenerateUniqueID_withCustomPrefix() {
        String s1 = Util.generateUniqueID((String)"ONELOGIN_");
        Assert.assertThat((Object)s1, (Matcher)CoreMatchers.startsWith((String)"ONELOGIN_"));
        Assert.assertTrue((s1.length() > 40 ? 1 : 0) != 0);
        String s2 = Util.generateUniqueID((String)"ONELOGIN_");
        String s3 = Util.generateUniqueID((String)"_");
        Assert.assertThat((Object)s3, (Matcher)CoreMatchers.startsWith((String)"_"));
        Assert.assertNotEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s1, (Object)s3);
        Assert.assertNotEquals((Object)s2, (Object)s3);
    }

    @Test
    public void testGenerateUniqueID_usesDefaultOnNull() {
        String s1 = Util.generateUniqueID(null);
        Assert.assertThat((Object)s1, (Matcher)CoreMatchers.startsWith((String)"ONELOGIN_"));
    }

    @Test
    public void testGenerateUniqueID_usesDefaultOnEmpty() {
        String s1 = Util.generateUniqueID((String)"");
        Assert.assertThat((Object)s1, (Matcher)CoreMatchers.startsWith((String)"ONELOGIN_"));
    }

    @Test(expected=DateTimeParseException.class)
    public void testParseDurationException() throws Exception {
        long timestamp = 1393876825L;
        long parsedDuration = Util.parseDuration((String)"aaa", (long)timestamp);
    }

    @Test
    public void testParseDuration() throws Exception {
        String duration = "PT1393462294S";
        long timestamp = 1393876825L;
        long parsedDuration = Util.parseDuration((String)duration, (long)timestamp);
        Assert.assertEquals((long)2787339119L, (long)parsedDuration);
        long parsedDuration2 = Util.parseDuration((String)duration);
        Assert.assertTrue((parsedDuration2 > parsedDuration ? 1 : 0) != 0);
        String newDuration = "P1Y1M";
        long parsedDuration4 = Util.parseDuration((String)newDuration, (long)timestamp);
        Assert.assertEquals((long)1428091225L, (long)parsedDuration4);
        String negDuration = "-P14M";
        long parsedDuration5 = Util.parseDuration((String)negDuration, (long)timestamp);
        Assert.assertEquals((long)1357243225L, (long)parsedDuration5);
        try {
            String invalidDuration = "PT1Y";
            Util.parseDuration((String)invalidDuration);
        }
        catch (DateTimeParseException anDateTimeParseException) {
            Assert.assertThat((Object)anDateTimeParseException.getMessage(), (Matcher)CoreMatchers.is((Object)"Text cannot be parsed to a Duration"));
        }
    }

    @Test
    public void testGetCurrentTimeStamp() {
        Date currentDate = new Date();
        Long dt = currentDate.getTime() / 1000L;
        Long dt2 = Util.getCurrentTimeStamp();
        Assert.assertTrue((dt2 - dt <= 3L ? 1 : 0) != 0);
    }

    @Test
    public void testGetExpireTime() {
        long num = 1291955971L;
        long num2 = 3311642371L;
        Assert.assertEquals((long)0L, (long)Util.getExpireTime(null, null));
        Assert.assertEquals((long)0L, (long)Util.getExpireTime((String)"", (String)""));
        Assert.assertEquals((long)num, (long)Util.getExpireTime(null, (long)num));
        Assert.assertEquals((long)num, (long)Util.getExpireTime((String)"", (long)num));
        Assert.assertEquals((long)num2, (long)Util.getExpireTime(null, (long)num2));
        Assert.assertEquals((long)num2, (long)Util.getExpireTime((String)"", (long)num2));
        Assert.assertEquals((long)num, (long)Util.getExpireTime(null, (String)"2010-12-10T04:39:31Z"));
        Assert.assertEquals((long)num, (long)Util.getExpireTime((String)"", (String)"2010-12-10T04:39:31Z"));
        Assert.assertEquals((long)num2, (long)Util.getExpireTime(null, (String)"2074-12-10T04:39:31Z"));
        Assert.assertEquals((long)num2, (long)Util.getExpireTime((String)"", (String)"2074-12-10T04:39:31Z"));
        Assert.assertEquals((long)num, (long)Util.getExpireTime((String)"PT360000S", (String)"2010-12-10T04:39:31Z"));
        Assert.assertNotEquals((long)num2, (long)Util.getExpireTime((String)"PT360000S", (String)"2074-12-10T04:39:31Z"));
        long x = Util.getExpireTime((String)"PT360000S", (long)num);
        Assert.assertEquals((long)num, (long)Util.getExpireTime((String)"PT360000S", (long)num));
        Assert.assertNotEquals((long)num2, (long)Util.getExpireTime((String)"PT360000S", (long)num2));
        Assert.assertNotEquals((long)0L, (long)Util.getExpireTime((String)"PT360000S", null));
    }

    @Test
    public void testFormatDateTime() {
        long time = 1386650371L;
        String datetime = "2013-12-10T04:39:31Z";
        String parsedTime = Util.formatDateTime((long)(time * 1000L));
        Assert.assertEquals((Object)datetime, (Object)parsedTime);
    }

    @Test
    public void testParseDateTime() {
        long time = 1386650371L;
        String datetime = "2013-12-10T04:39:31Z";
        Instant parsedTime = Util.parseDateTime((String)datetime);
        Assert.assertEquals((long)time, (long)(parsedTime.toEpochMilli() / 1000L));
        String datetime2 = "2013-12-10T04:39:31.120Z";
        Instant parsedTime2 = Util.parseDateTime((String)datetime2);
        Assert.assertEquals((long)time, (long)(parsedTime2.toEpochMilli() / 1000L));
    }

    @Test
    public void testQuery() throws XPathExpressionException, URISyntaxException, IOException {
        String responseCoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        String response = Util.base64decodedInflated((String)responseCoded);
        Document dom = Util.loadXML((String)response);
        NodeList assertionNodes = Util.query((Document)dom, (String)"/samlp:Response/saml:Assertion", null);
        Assert.assertEquals((long)1L, (long)assertionNodes.getLength());
        Node assertion = assertionNodes.item(0);
        Assert.assertEquals((Object)"saml:Assertion", (Object)assertion.getNodeName());
        NodeList attributeStatementNodes = Util.query((Document)dom, (String)"/samlp:Response/saml:Assertion/saml:AttributeStatement", null);
        Assert.assertEquals((long)1L, (long)attributeStatementNodes.getLength());
        Node attributeStatement = attributeStatementNodes.item(0);
        Assert.assertEquals((Object)"saml:AttributeStatement", (Object)attributeStatement.getNodeName());
        NodeList attributeStatementNodes2 = Util.query((Document)dom, (String)"./saml:AttributeStatement", (Node)assertion);
        Assert.assertEquals((long)1L, (long)attributeStatementNodes2.getLength());
        Node attributeStatement2 = attributeStatementNodes2.item(0);
        Assert.assertEquals((Object)attributeStatement, (Object)attributeStatement2);
        NodeList signatureResNodes = Util.query((Document)dom, (String)"/samlp:Response/ds:Signature", null);
        Assert.assertEquals((long)1L, (long)signatureResNodes.getLength());
        Node signatureRes = signatureResNodes.item(0);
        Assert.assertEquals((Object)"ds:Signature", (Object)signatureRes.getNodeName());
        NodeList signatureNodes = Util.query((Document)dom, (String)"/samlp:Response/saml:Assertion/ds:Signature", null);
        Assert.assertEquals((long)1L, (long)signatureNodes.getLength());
        Node signature = signatureNodes.item(0);
        Assert.assertEquals((Object)"ds:Signature", (Object)signature.getNodeName());
        NodeList signatureNodes2 = Util.query((Document)dom, (String)"./ds:Signature", (Node)assertion);
        Assert.assertEquals((long)1L, (long)signatureNodes2.getLength());
        Node signature2 = signatureNodes2.item(0);
        Assert.assertEquals((Object)signature.getTextContent(), (Object)signature2.getTextContent());
        Assert.assertNotEquals((Object)signatureRes.getTextContent(), (Object)signature2.getTextContent());
        NodeList signatureNodes3 = Util.query((Document)dom, (String)"./ds:SignatureValue", (Node)assertion);
        Assert.assertEquals((long)0L, (long)signatureNodes3.getLength());
        NodeList signatureNodes4 = Util.query((Document)dom, (String)"./ds:Signature/ds:SignatureValue", (Node)assertion);
        Assert.assertEquals((long)1L, (long)signatureNodes4.getLength());
        NodeList signatureNodes5 = Util.query((Document)dom, (String)".//ds:SignatureValue", (Node)assertion);
        Assert.assertEquals((long)1L, (long)signatureNodes5.getLength());
        String encryptedAssertionResponseCoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        String encryptedAssertionResponse = Util.base64decodedInflated((String)encryptedAssertionResponseCoded);
        Document dom2 = Util.loadXML((String)encryptedAssertionResponse);
        NodeList encryptAssertionNode = Util.query((Document)dom2, (String)"/samlp:Response/saml:EncryptedAssertion");
        Assert.assertEquals((long)1L, (long)encryptAssertionNode.getLength());
        NodeList encryptedDataNode = Util.query((Document)dom2, (String)".//xenc:EncryptedData");
        Assert.assertEquals((long)1L, (long)encryptedDataNode.getLength());
        NodeList encryptedDataNode_2 = Util.query((Document)dom2, (String)"./xenc:EncryptedData", (Node)encryptAssertionNode.item(0));
        Assert.assertEquals((long)1L, (long)encryptedDataNode_2.getLength());
        String response_2 = response.replace("<saml:", "<saml2:").replace("</saml:", "</saml2:").replace("xmlns:saml=", "xmlns:saml2=");
        response_2 = response_2.replace("<samlp:", "<samlp2:").replace("</samlp:", "</samlp2:").replace("xmlns:samlp=", "xmlns:samlp2=");
        Document dom_2 = Util.loadXML((String)response_2);
        NodeList assertionNodes_2 = Util.query((Document)dom_2, (String)"/samlp:Response/saml:Assertion", null);
        Assert.assertEquals((long)1L, (long)assertionNodes_2.getLength());
        Node assertion_2 = assertionNodes_2.item(0);
        Assert.assertEquals((Object)"saml2:Assertion", (Object)assertion_2.getNodeName());
    }

    @Test
    public void testToXml() {
        Assert.assertEquals((Object)"", (Object)Util.toXml((String)""));
        Assert.assertEquals((Object)"No escape", (Object)Util.toXml((String)"No escape"));
        Assert.assertEquals((Object)"&amp;&quot;&lt;&gt;&apos;", (Object)Util.toXml((String)"&\"<>'"));
    }

    @Test
    public void testToXmlNull() {
        Assert.assertNull((Object)Util.toXml(null));
    }
}

