/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.test.settings;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.codelibs.saml2.core.exception.SAMLSevereException;
import org.codelibs.saml2.core.exception.SettingsException;
import org.codelibs.saml2.core.model.Contact;
import org.codelibs.saml2.core.model.KeyStoreSettings;
import org.codelibs.saml2.core.model.Organization;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.settings.SettingsBuilder;
import org.codelibs.saml2.core.util.Util;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SettingBuilderTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testLoadFromFileNotExist() throws IOException, SAMLSevereException {
        this.expectedEx.expect(SAMLSevereException.class);
        this.expectedEx.expectMessage("properties file 'config/config.notfound.properties' not found in the classpath");
        new SettingsBuilder().fromFile("config/config.notfound.properties").build();
    }

    private KeyStoreSettings getKeyStoreSettings() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        String storePassword = "changeit";
        String keyStoreFile = "src/test/resources/keystore/oneloginTestKeystore.jks";
        String alias = "keywithpassword";
        String keyPassword = "keypassword";
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(keyStoreFile), storePassword.toCharArray());
        return new KeyStoreSettings(ks, alias, keyPassword);
    }

    @Test
    public void testLoadFromFileAndKeyStore() throws IOException, CertificateException, URISyntaxException, SettingsException, SAMLSevereException, KeyStoreException, NoSuchAlgorithmException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.empty.properties", this.getKeyStoreSettings()).build();
        Assert.assertTrue((boolean)(setting.getSPcert() instanceof X509Certificate));
        Assert.assertTrue((boolean)(setting.getSPkey() instanceof Key));
    }

    @Test
    public void testLoadFromFileEmpty() throws IOException, CertificateException, URISyntaxException, SettingsException, SAMLSevereException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.empty.properties").build();
        Assert.assertFalse((boolean)setting.isDebugActive());
        Assert.assertTrue((boolean)setting.isStrict());
        Assert.assertTrue((boolean)setting.getSpEntityId().isEmpty());
        Assert.assertNull((Object)setting.getSpAssertionConsumerServiceUrl());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (Object)setting.getSpAssertionConsumerServiceBinding());
        Assert.assertNull((Object)setting.getSpSingleLogoutServiceUrl());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (Object)setting.getSpSingleLogoutServiceBinding());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", (Object)setting.getSpNameIDFormat());
        Assert.assertTrue((boolean)setting.getIdpEntityId().isEmpty());
        Assert.assertNull((Object)setting.getIdpSingleSignOnServiceUrl());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (Object)setting.getIdpSingleSignOnServiceBinding());
        Assert.assertNull((Object)setting.getIdpSingleLogoutServiceUrl());
        Assert.assertNull((Object)setting.getIdpSingleLogoutServiceResponseUrl());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (Object)setting.getIdpSingleLogoutServiceBinding());
        Assert.assertNull((Object)setting.getIdpx509cert());
        Assert.assertNull((Object)setting.getIdpCertFingerprint());
        Assert.assertEquals((Object)"sha1", (Object)setting.getIdpCertFingerprintAlgorithm());
        Assert.assertFalse((boolean)setting.getNameIdEncrypted());
        Assert.assertFalse((boolean)setting.getAuthnRequestsSigned());
        Assert.assertFalse((boolean)setting.getLogoutRequestSigned());
        Assert.assertFalse((boolean)setting.getLogoutResponseSigned());
        Assert.assertFalse((boolean)setting.getWantMessagesSigned());
        Assert.assertFalse((boolean)setting.getWantAssertionsSigned());
        Assert.assertFalse((boolean)setting.getWantAssertionsEncrypted());
        Assert.assertFalse((boolean)setting.getWantNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getRequestedAuthnContext().isEmpty());
        Assert.assertEquals((Object)"exact", (Object)setting.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)setting.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#sha1", (Object)setting.getDigestAlgorithm());
        Assert.assertFalse((boolean)setting.getSignMetadata());
        Assert.assertFalse((boolean)setting.isTrimNameIds());
        Assert.assertFalse((boolean)setting.isTrimAttributeValues());
        Assert.assertNull((Object)setting.getOrganization());
        Assert.assertTrue((boolean)setting.getContacts().isEmpty());
    }

    @Test
    public void testLoadFromFileMinProp() throws IOException, CertificateException, URISyntaxException, SettingsException, SAMLSevereException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Assert.assertFalse((boolean)setting.isDebugActive());
        Assert.assertTrue((boolean)setting.isStrict());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp", (Object)setting.getSpEntityId());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/acs.jsp", (Object)setting.getSpAssertionConsumerServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpAssertionConsumerServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/sls.jsp", (Object)setting.getSpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)setting.getSpNameIDFormat(), (Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)setting.getIdpEntityId());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SSOService.php", (Object)setting.getIdpSingleSignOnServiceUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleSignOnServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceResponseUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertNotNull((Object)setting.getIdpx509cert());
        Assert.assertEquals((Object)Util.loadCert((String)Util.getFileAsString((String)"certs/certificate1")), (Object)setting.getIdpx509cert());
        Assert.assertNull((Object)setting.getIdpCertFingerprint());
        Assert.assertEquals((Object)"sha1", (Object)setting.getIdpCertFingerprintAlgorithm());
        Assert.assertFalse((boolean)setting.getNameIdEncrypted());
        Assert.assertFalse((boolean)setting.getAuthnRequestsSigned());
        Assert.assertFalse((boolean)setting.getLogoutRequestSigned());
        Assert.assertFalse((boolean)setting.getLogoutResponseSigned());
        Assert.assertFalse((boolean)setting.getWantMessagesSigned());
        Assert.assertFalse((boolean)setting.getWantAssertionsSigned());
        Assert.assertFalse((boolean)setting.getWantAssertionsEncrypted());
        Assert.assertFalse((boolean)setting.getWantNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getRequestedAuthnContext().isEmpty());
        Assert.assertEquals((Object)"exact", (Object)setting.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)setting.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#sha1", (Object)setting.getDigestAlgorithm());
        Assert.assertFalse((boolean)setting.getSignMetadata());
        Assert.assertFalse((boolean)setting.isTrimNameIds());
        Assert.assertFalse((boolean)setting.isTrimAttributeValues());
        Assert.assertNull((Object)setting.getOrganization());
        Assert.assertTrue((boolean)setting.getContacts().isEmpty());
        Assert.assertEquals((Object)"ONELOGIN_", (Object)setting.getUniqueIDPrefix());
    }

    @Test
    public void testLoadFromFileAllProp() throws IOException, CertificateException, URISyntaxException, SettingsException, SAMLSevereException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.all.properties").build();
        Assert.assertTrue((boolean)setting.isDebugActive());
        Assert.assertTrue((boolean)setting.isStrict());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp", (Object)setting.getSpEntityId());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/acs.jsp", (Object)setting.getSpAssertionConsumerServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpAssertionConsumerServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/sls.jsp", (Object)setting.getSpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)setting.getSpNameIDFormat(), (Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)setting.getIdpEntityId());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SSOService.php", (Object)setting.getIdpSingleSignOnServiceUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleSignOnServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutServiceResponse.php", (Object)setting.getIdpSingleLogoutServiceResponseUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertNotNull((Object)setting.getIdpx509cert());
        Assert.assertEquals((Object)Util.loadCert((String)Util.getFileAsString((String)"certs/certificate1")), (Object)setting.getIdpx509cert());
        Assert.assertEquals((Object)"4b6f70bb2cab82c86a8270f71a880b62e25bc2b3", (Object)setting.getIdpCertFingerprint());
        Assert.assertEquals((Object)"sha1", (Object)setting.getIdpCertFingerprintAlgorithm());
        Assert.assertTrue((boolean)setting.getNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getAuthnRequestsSigned());
        Assert.assertTrue((boolean)setting.getLogoutRequestSigned());
        Assert.assertTrue((boolean)setting.getLogoutResponseSigned());
        Assert.assertTrue((boolean)setting.getWantMessagesSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsEncrypted());
        Assert.assertTrue((boolean)setting.getWantNameIdEncrypted());
        ArrayList<String> reqAuthContext = new ArrayList<String>();
        reqAuthContext.add("urn:oasis:names:tc:SAML:2.0:ac:classes:urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        Assert.assertEquals(reqAuthContext, (Object)setting.getRequestedAuthnContext());
        Assert.assertEquals((Object)"exact", (Object)setting.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", (Object)setting.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#sha512", (Object)setting.getDigestAlgorithm());
        Assert.assertTrue((boolean)setting.getSignMetadata());
        Assert.assertFalse((boolean)setting.isTrimNameIds());
        Assert.assertFalse((boolean)setting.isTrimAttributeValues());
        Organization org = new Organization("SP Java", "SP Java Example", "http://sp.example.com");
        Assert.assertTrue((boolean)org.equalsTo(setting.getOrganization()));
        List contacts = setting.getContacts();
        Assert.assertEquals((long)4L, (long)contacts.size());
        Contact c1 = (Contact)contacts.get(0);
        Assert.assertEquals((Object)"administrative", (Object)c1.getContactType());
        Assert.assertEquals((Object)"ACME", (Object)c1.getCompany());
        Assert.assertEquals((Object)"Guy", (Object)c1.getGivenName());
        Assert.assertEquals((Object)"Administrative", (Object)c1.getSurName());
        Assert.assertEquals((long)2L, (long)c1.getEmailAddresses().size());
        Assert.assertEquals((Object)"administrative@example.com", c1.getEmailAddresses().get(0));
        Assert.assertEquals((Object)"administrative2@example.com", c1.getEmailAddresses().get(1));
        List c1Phones = c1.getTelephoneNumbers();
        Assert.assertEquals((long)2L, (long)c1Phones.size());
        Assert.assertEquals((Object)"+1-123456789", c1Phones.get(0));
        Assert.assertEquals((Object)"+1-987654321", c1Phones.get(1));
        Contact c2 = (Contact)contacts.get(1);
        Assert.assertEquals((Object)"other", (Object)c2.getContactType());
        Assert.assertEquals((Object)"Big Corp", (Object)c2.getCompany());
        Assert.assertNull((Object)c2.getGivenName());
        Assert.assertNull((Object)c2.getSurName());
        Assert.assertEquals((long)1L, (long)c2.getEmailAddresses().size());
        Assert.assertEquals((Object)"info@example.com", c2.getEmailAddresses().get(0));
        Assert.assertEquals((long)0L, (long)c2.getTelephoneNumbers().size());
        Contact c3 = (Contact)contacts.get(2);
        Assert.assertEquals((Object)"technical", (Object)c3.getContactType());
        Assert.assertNull((Object)c3.getCompany());
        Assert.assertEquals((Object)"Technical Guy", (Object)c3.getGivenName());
        Assert.assertNull((Object)c3.getSurName());
        List c3Emails = c3.getEmailAddresses();
        Assert.assertEquals((long)1L, (long)c3Emails.size());
        Assert.assertEquals((Object)"technical@example.com", c3Emails.get(0));
        Assert.assertEquals((Object)"technical@example.com", (Object)c3.getEmailAddress());
        Assert.assertEquals((long)0L, (long)c3.getTelephoneNumbers().size());
        Contact c4 = (Contact)contacts.get(3);
        Assert.assertEquals((Object)"support", (Object)c4.getContactType());
        Assert.assertNull((Object)c4.getCompany());
        Assert.assertEquals((Object)"Support Guy", (Object)c4.getGivenName());
        Assert.assertNull((Object)c4.getSurName());
        List c4Emails = c4.getEmailAddresses();
        Assert.assertEquals((long)1L, (long)c4Emails.size());
        Assert.assertEquals((Object)"support@example.com", c4Emails.get(0));
        Assert.assertEquals((Object)"support@example.com", (Object)c4.getEmailAddress());
        Assert.assertEquals((long)0L, (long)c4.getTelephoneNumbers().size());
        Assert.assertEquals((Object)"EXAMPLE", (Object)setting.getUniqueIDPrefix());
    }

    @Test
    public void testLoadFromFileCertString() throws IOException, CertificateException, URISyntaxException, SettingsException, SAMLSevereException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.certstring.properties").build();
        Assert.assertFalse((boolean)setting.isDebugActive());
        Assert.assertFalse((boolean)setting.isStrict());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp", (Object)setting.getSpEntityId());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/acs.jsp", (Object)setting.getSpAssertionConsumerServiceUrl().toString());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (Object)setting.getSpAssertionConsumerServiceBinding());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/sls.jsp", (Object)setting.getSpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (Object)setting.getSpSingleLogoutServiceBinding());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", (Object)setting.getSpNameIDFormat());
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)setting.getIdpEntityId());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SSOService.php", (Object)setting.getIdpSingleSignOnServiceUrl().toString());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (Object)setting.getIdpSingleSignOnServiceBinding());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceResponseUrl().toString());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (Object)setting.getIdpSingleLogoutServiceBinding());
        Assert.assertEquals((Object)Util.loadCert((String)Util.getFileAsString((String)"certs/certificate1")), (Object)setting.getIdpx509cert());
        Assert.assertFalse((boolean)setting.getNameIdEncrypted());
        Assert.assertFalse((boolean)setting.getAuthnRequestsSigned());
        Assert.assertFalse((boolean)setting.getLogoutRequestSigned());
        Assert.assertFalse((boolean)setting.getLogoutResponseSigned());
        Assert.assertFalse((boolean)setting.getWantMessagesSigned());
        Assert.assertFalse((boolean)setting.getWantAssertionsSigned());
        Assert.assertFalse((boolean)setting.getWantAssertionsEncrypted());
        Assert.assertFalse((boolean)setting.getWantNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getRequestedAuthnContext().isEmpty());
        Assert.assertEquals((Object)"exact", (Object)setting.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)setting.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#sha1", (Object)setting.getDigestAlgorithm());
        Assert.assertFalse((boolean)setting.getSignMetadata());
        Organization org = new Organization("SP Java", "SP Java Example", "http://sp.example.com");
        Assert.assertTrue((boolean)org.equalsTo(setting.getOrganization()));
        Assert.assertTrue((boolean)setting.getContacts().isEmpty());
    }

    @Test
    public void testLoadFromFileContactString() throws IOException, CertificateException, URISyntaxException, SettingsException, SAMLSevereException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.invalidcontacts.properties").build();
        Assert.assertFalse((boolean)setting.isDebugActive());
        Assert.assertFalse((boolean)setting.isStrict());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp", (Object)setting.getSpEntityId());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/acs.jsp", (Object)setting.getSpAssertionConsumerServiceUrl().toString());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (Object)setting.getSpAssertionConsumerServiceBinding());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/sls.jsp", (Object)setting.getSpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (Object)setting.getSpSingleLogoutServiceBinding());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", (Object)setting.getSpNameIDFormat());
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)setting.getIdpEntityId());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SSOService.php", (Object)setting.getIdpSingleSignOnServiceUrl().toString());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (Object)setting.getIdpSingleSignOnServiceBinding());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceResponseUrl().toString());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", (Object)setting.getIdpSingleLogoutServiceBinding());
        Assert.assertEquals((Object)Util.loadCert((String)Util.getFileAsString((String)"certs/certificate1")), (Object)setting.getIdpx509cert());
        Assert.assertFalse((boolean)setting.getNameIdEncrypted());
        Assert.assertFalse((boolean)setting.getAuthnRequestsSigned());
        Assert.assertFalse((boolean)setting.getLogoutRequestSigned());
        Assert.assertFalse((boolean)setting.getLogoutResponseSigned());
        Assert.assertFalse((boolean)setting.getWantMessagesSigned());
        Assert.assertFalse((boolean)setting.getWantAssertionsSigned());
        Assert.assertFalse((boolean)setting.getWantAssertionsEncrypted());
        Assert.assertFalse((boolean)setting.getWantNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getRequestedAuthnContext().isEmpty());
        Assert.assertEquals((Object)"exact", (Object)setting.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)setting.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#sha1", (Object)setting.getDigestAlgorithm());
        Assert.assertFalse((boolean)setting.getSignMetadata());
        Organization org = new Organization("SP Java", "SP Java Example", "http://sp.example.com");
        Assert.assertTrue((boolean)org.equalsTo(setting.getOrganization()));
        List contacts = setting.getContacts();
        Assert.assertEquals((long)2L, (long)contacts.size());
        Contact c1 = (Contact)contacts.get(0);
        Assert.assertEquals((Object)"technical", (Object)c1.getContactType());
        Assert.assertTrue((boolean)c1.getGivenName().isEmpty());
        Assert.assertEquals((Object)"technical@example.com", (Object)c1.getEmailAddress());
        Contact c2 = (Contact)contacts.get(1);
        Assert.assertEquals((Object)"support", (Object)c2.getContactType());
        Assert.assertEquals((Object)"Support Guy", (Object)c2.getGivenName());
        Assert.assertTrue((boolean)c2.getEmailAddress().isEmpty());
    }

    @Test
    public void testLoadFromFileInvalidSPCerts() throws IOException, CertificateException, URISyntaxException, SettingsException, SAMLSevereException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.invalidspcertstring.properties").build();
        Assert.assertNull((Object)setting.getSPkey());
        Assert.assertNull((Object)setting.getSPcert());
    }

    @Test
    public void testCompression() throws IOException, CertificateException, URISyntaxException, SettingsException, SAMLSevereException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Assert.assertTrue((boolean)setting.isCompressRequestEnabled());
        Assert.assertTrue((boolean)setting.isCompressResponseEnabled());
        setting = new SettingsBuilder().fromFile("config/config.compress.properties").build();
        Assert.assertTrue((boolean)setting.isCompressRequestEnabled());
        Assert.assertTrue((boolean)setting.isCompressResponseEnabled());
        setting = new SettingsBuilder().fromFile("config/config.nocompress.properties").build();
        Assert.assertFalse((boolean)setting.isCompressRequestEnabled());
        Assert.assertFalse((boolean)setting.isCompressResponseEnabled());
    }

    @Test
    public void testLoadFromFileSomeEmptyProp() throws IOException, CertificateException, URISyntaxException, SAMLSevereException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.somevaluesempty.properties").build();
        Assert.assertTrue((boolean)setting.isDebugActive());
        Assert.assertTrue((boolean)setting.isStrict());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp", (Object)setting.getSpEntityId());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/acs.jsp", (Object)setting.getSpAssertionConsumerServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpAssertionConsumerServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/sls.jsp", (Object)setting.getSpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)setting.getSpNameIDFormat(), (Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)setting.getIdpEntityId());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SSOService.php", (Object)setting.getIdpSingleSignOnServiceUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleSignOnServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceResponseUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertNull((Object)setting.getIdpx509cert());
        Assert.assertEquals((Object)"4b6f70bb2cab82c86a8270f71a880b62e25bc2b3", (Object)setting.getIdpCertFingerprint());
        Assert.assertEquals((Object)"sha1", (Object)setting.getIdpCertFingerprintAlgorithm());
        Assert.assertTrue((boolean)setting.getNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getAuthnRequestsSigned());
        Assert.assertTrue((boolean)setting.getLogoutRequestSigned());
        Assert.assertTrue((boolean)setting.getLogoutResponseSigned());
        Assert.assertTrue((boolean)setting.getWantMessagesSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsEncrypted());
        Assert.assertTrue((boolean)setting.getWantNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getRequestedAuthnContext().isEmpty());
        Assert.assertEquals((Object)"exact", (Object)setting.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)setting.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#sha1", (Object)setting.getDigestAlgorithm());
        Assert.assertTrue((boolean)setting.getSignMetadata());
        Assert.assertNull((Object)setting.getOrganization());
        Assert.assertTrue((boolean)setting.getContacts().isEmpty());
    }

    @Test
    public void testLoadFromFileDifferentProp() throws IOException, CertificateException, URISyntaxException, SAMLSevereException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.different.properties").build();
        Assert.assertTrue((boolean)setting.isDebugActive());
        Assert.assertTrue((boolean)setting.isStrict());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp", (Object)setting.getSpEntityId());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/acs.jsp", (Object)setting.getSpAssertionConsumerServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpAssertionConsumerServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/sls.jsp", (Object)setting.getSpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)setting.getSpNameIDFormat(), (Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)setting.getIdpEntityId());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SSOService.php", (Object)setting.getIdpSingleSignOnServiceUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleSignOnServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertNull((Object)setting.getIdpSingleLogoutServiceUrl());
        Assert.assertNull((Object)setting.getIdpSingleLogoutServiceResponseUrl());
        Assert.assertEquals((Object)setting.getIdpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertNull((Object)setting.getIdpx509cert());
        Assert.assertEquals((Object)"00d84fd17802a1f1edd9a03447ca1d3a6c2101a610a164ab898b880d01c44190", (Object)setting.getIdpCertFingerprint());
        Assert.assertEquals((Object)"sha256", (Object)setting.getIdpCertFingerprintAlgorithm());
        Assert.assertTrue((boolean)setting.getNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getAuthnRequestsSigned());
        Assert.assertTrue((boolean)setting.getLogoutRequestSigned());
        Assert.assertTrue((boolean)setting.getLogoutResponseSigned());
        Assert.assertTrue((boolean)setting.getWantMessagesSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsEncrypted());
        Assert.assertTrue((boolean)setting.getWantNameIdEncrypted());
        ArrayList<String> reqAuthContext = new ArrayList<String>();
        reqAuthContext.add("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        reqAuthContext.add("urn:oasis:names:tc:SAML:2.0:ac:classes:urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        Assert.assertEquals(reqAuthContext, (Object)setting.getRequestedAuthnContext());
        Assert.assertEquals((Object)"minimum", (Object)setting.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", (Object)setting.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#sha512", (Object)setting.getDigestAlgorithm());
        Assert.assertTrue((boolean)setting.getSignMetadata());
        Assert.assertTrue((boolean)setting.isTrimNameIds());
        Assert.assertTrue((boolean)setting.isTrimAttributeValues());
        Organization org = new Organization("SP Java", "", "");
        Assert.assertTrue((boolean)org.equalsTo(setting.getOrganization()));
        List contacts = setting.getContacts();
        Assert.assertEquals((long)2L, (long)contacts.size());
        Contact c1 = (Contact)contacts.get(0);
        Assert.assertEquals((Object)"technical", (Object)c1.getContactType());
        Assert.assertTrue((boolean)c1.getEmailAddress().isEmpty());
        Assert.assertEquals((Object)"Technical Guy", (Object)c1.getGivenName());
        Contact c2 = (Contact)contacts.get(1);
        Assert.assertEquals((Object)"support", (Object)c2.getContactType());
        Assert.assertEquals((Object)"support@example.com", (Object)c2.getEmailAddress());
        Assert.assertTrue((boolean)c2.getGivenName().isEmpty());
    }

    @Test
    public void testLoadFromFileMinUniqueIDProp() throws Exception {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.min_uniqueid.properties").build();
        Assert.assertEquals((Object)"_", (Object)setting.getUniqueIDPrefix());
    }

    @Test
    public void testFromProperties() throws IOException, SAMLSevereException, CertificateException {
        Saml2Settings setting = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Base64 encoder = new Base64(64);
        String x509cert = new String(encoder.encode(setting.getIdpx509cert().getEncoded()));
        Properties prop = new Properties();
        prop.setProperty("onelogin.saml2.idp.entityid", setting.getIdpEntityId());
        prop.setProperty("onelogin.saml2.idp.single_sign_on_service.url", setting.getIdpSingleSignOnServiceUrl().toString());
        prop.setProperty("onelogin.saml2.idp.single_logout_service.url", setting.getIdpSingleLogoutServiceUrl().toString());
        prop.setProperty("onelogin.saml2.idp.x509cert", x509cert);
        prop.setProperty("onelogin.saml2.sp.entityid", setting.getSpEntityId());
        prop.setProperty("onelogin.saml2.sp.assertion_consumer_service.url", setting.getSpAssertionConsumerServiceUrl().toString());
        prop.setProperty("onelogin.saml2.sp.single_logout_service.url", setting.getSpSingleLogoutServiceUrl().toString());
        Saml2Settings setting2 = new SettingsBuilder().fromProperties(prop).build();
        Assert.assertFalse((boolean)setting2.isDebugActive());
        Assert.assertTrue((boolean)setting2.isStrict());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp", (Object)setting2.getSpEntityId());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/acs.jsp", (Object)setting2.getSpAssertionConsumerServiceUrl().toString());
        Assert.assertEquals((Object)setting2.getSpAssertionConsumerServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/sls.jsp", (Object)setting2.getSpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)setting2.getSpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)setting2.getSpNameIDFormat(), (Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)setting2.getIdpEntityId());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SSOService.php", (Object)setting2.getIdpSingleSignOnServiceUrl().toString());
        Assert.assertEquals((Object)setting2.getIdpSingleSignOnServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting2.getIdpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting2.getIdpSingleLogoutServiceResponseUrl().toString());
        Assert.assertEquals((Object)setting2.getIdpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertNotNull((Object)setting2.getIdpx509cert());
        Assert.assertEquals((Object)Util.loadCert((String)Util.getFileAsString((String)"certs/certificate1")), (Object)setting2.getIdpx509cert());
        Assert.assertNull((Object)setting2.getIdpCertFingerprint());
        Assert.assertEquals((Object)"sha1", (Object)setting2.getIdpCertFingerprintAlgorithm());
        Assert.assertFalse((boolean)setting2.getNameIdEncrypted());
        Assert.assertFalse((boolean)setting2.getAuthnRequestsSigned());
        Assert.assertFalse((boolean)setting2.getLogoutRequestSigned());
        Assert.assertFalse((boolean)setting2.getLogoutResponseSigned());
        Assert.assertFalse((boolean)setting2.getWantMessagesSigned());
        Assert.assertFalse((boolean)setting2.getWantAssertionsSigned());
        Assert.assertFalse((boolean)setting2.getWantAssertionsEncrypted());
        Assert.assertFalse((boolean)setting2.getWantNameIdEncrypted());
        Assert.assertTrue((boolean)setting2.getRequestedAuthnContext().isEmpty());
        Assert.assertEquals((Object)"exact", (Object)setting2.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting2.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)setting2.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#sha1", (Object)setting2.getDigestAlgorithm());
        Assert.assertFalse((boolean)setting2.getSignMetadata());
        Assert.assertFalse((boolean)setting.isTrimNameIds());
        Assert.assertFalse((boolean)setting.isTrimAttributeValues());
        Assert.assertNull((Object)setting2.getOrganization());
        Assert.assertTrue((boolean)setting2.getContacts().isEmpty());
        Assert.assertEquals((Object)"ONELOGIN_", (Object)setting2.getUniqueIDPrefix());
    }

    @Test
    public void testLoadFromValues() throws Exception {
        LinkedHashMap<String, Object> samlData = new LinkedHashMap<String, Object>();
        samlData.put("onelogin.saml2.strict", "true");
        samlData.put("onelogin.saml2.sp.entityid", "http://localhost:8080/java-saml-jspsample/metadata.jsp");
        samlData.put("onelogin.saml2.sp.assertion_consumer_service.url", "http://localhost:8080/java-saml-jspsample/acs.jsp");
        samlData.put("onelogin.saml2.sp.assertion_consumer_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        samlData.put("onelogin.saml2.sp.single_logout_service.url", "http://localhost:8080/java-saml-jspsample/sls.jsp");
        samlData.put("onelogin.saml2.sp.single_logout_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        samlData.put("onelogin.saml2.sp.nameidformat", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        samlData.put("onelogin.saml2.sp.x509cert", "-----BEGIN CERTIFICATE-----MIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wHhcNMTUxMDE4MjAxMjM1WhcNMTgwNzE0MjAxMjM1WjBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALvwEktX1+4y2AhEqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAGjUDBOMB0GA1UdDgQWBBTifMwN3CQ5ZOPkV5tDJsutU8teFDAfBgNVHSMEGDAWgBTifMwN3CQ5ZOPkV5tDJsutU8teFDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBDQUAA4GBAG3nAEUjJaA75SkzID5FKLolsxG5TE/0HU0+yEUAVkXiqvqN4mPWq/JjoK5+uP4LEZIb4pRrCqI3iHp+vazLLYSeyV3kaGN7q35Afw8nk8WM0f7vImbQ69j1S8GQ+6E0PEI26qBLykGkMn3GUVtBBWSdpP093NuNLJiOomnHqhqj-----END CERTIFICATE-----");
        samlData.put("onelogin.saml2.sp.x509certNew", "-----BEGIN CERTIFICATE-----MIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wHhcNMTUxMDE4MjAxMjM1WhcNMTgwNzE0MjAxMjM1WjBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALvwEktX1+4y2AhEqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAGjUDBOMB0GA1UdDgQWBBTifMwN3CQ5ZOPkV5tDJsutU8teFDAfBgNVHSMEGDAWgBTifMwN3CQ5ZOPkV5tDJsutU8teFDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBDQUAA4GBAG3nAEUjJaA75SkzID5FKLolsxG5TE/0HU0+yEUAVkXiqvqN4mPWq/JjoK5+uP4LEZIb4pRrCqI3iHp+vazLLYSeyV3kaGN7q35Afw8nk8WM0f7vImbQ69j1S8GQ+6E0PEI26qBLykGkMn3GUVtBBWSdpP093NuNLJiOomnHqhqj-----END CERTIFICATE-----");
        samlData.put("onelogin.saml2.sp.privatekey", "-----BEGIN PRIVATE KEY-----MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALvwEktX1+4y2AhEqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAECgYA7VPVRl+/xoVeWdKdWY1F17HerSa23ynI2vQ8TkUY6kR3ucz6ElRxHJesY8fNCPoX+XuMfUly7IKyPZMkWyvEgDPo7J5mYqP5VsTK0Li4AwR/BA93Aw6gaX7/EYi3HjBh8QdNSt4fi9yOea/hv04yfR9Lx/a5fvQIyhqaDtT2QeQJBAOnCgnxnj70/sv9UsFPa8t1OGdAfXtOgEoklh1F2NR9jid6FPw5E98eCpdZ00MfRrmUavgqg6Y4swZISyzJIjGMCQQDN0YNsC4S+eJJM6aOCpupKluWE/cCWB01UQYekyXH7OdUtl49NlKEUPBSAvtaLMuMKlTNOjlPrx4Q+/c5i0vTPAkEA5H7CR9J/OZETaewhc8ZYkaRvLPYNHjWhCLhLXoB6itUkhgOfUFZwEXAOpOOI1VmL675JN2B1DAmJqTx/rQYnWwJBAMx3ztsAmnBq8dTM6y65ydouDHhRawjg2jbRHwNbSQvuyVSQ08Gb3WZvxWKdtB/3fsydqqnpBYAf5sZ5eJZ+wssCQAOiIKnhdYe+RBbBwykzjUqtzEmt4fwCFE8tD4feEx77D05j5f7u7KYh1mL0G2zIbnUryi7jwc4ye98VirRpZ1w=-----END PRIVATE KEY-----");
        samlData.put("onelogin.saml2.idp.entityid", "http://idp.example.com/");
        samlData.put("onelogin.saml2.idp.single_sign_on_service.url", "http://idp.example.com/simplesaml/saml2/idp/SSOService.php");
        samlData.put("onelogin.saml2.idp.single_sign_on_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        samlData.put("onelogin.saml2.idp.single_logout_service.url", "http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php");
        samlData.put("onelogin.saml2.idp.single_logout_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        samlData.put("onelogin.saml2.idp.single_logout_service.response.url", "http://idp.example.com/simplesaml/saml2/idp/SingleLogoutServiceResponse.php");
        samlData.put("onelogin.saml2.idp.x509cert", "-----BEGIN CERTIFICATE-----\nMIIBrTCCAaGgAwIBAgIBATADBgEAMGcxCzAJBgNVBAYTAlVTMRMwEQYDVQQIDApDYWxpZm9ybmlhMRUwEwYDVQQHDAxTYW50YSBNb25pY2ExETAPBgNVBAoMCE9uZUxvZ2luMRkwFwYDVQQDDBBhcHAub25lbG9naW4uY29tMB4XDTEwMTAxMTIxMTUxMloXDTE1MTAxMTIxMTUxMlowZzELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFTATBgNVBAcMDFNhbnRhIE1vbmljYTERMA8GA1UECgwIT25lTG9naW4xGTAXBgNVBAMMEGFwcC5vbmVsb2dpbi5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMPmjfjy7L35oDpeBXBoRVCgktPkLno9DOEWB7MgYMMVKs2B6ymWQLEWrDugMK1hkzWFhIb5fqWLGbWy0J0veGR9/gHOQG+rD/I36xAXnkdiXXhzoiAG/zQxM0edMOUf40n314FC8moErcUg6QabttzesO59HFz6shPuxcWaVAgxAgMBAAEwAwYBAAMBAA==\n-----END CERTIFICATE-----");
        samlData.put("onelogin.saml2.idp.x509certMulti.0", "-----BEGIN CERTIFICATE-----\nMIICgTCCAeoCCQCbOlrWDdX7FTANBgkqhkiG9w0BAQUFADCBhDELMAkGA1UEBhMCTk8xGDAWBgNVBAgTD0FuZHJlYXMgU29sYmVyZzEMMAoGA1UEBxMDRm9vMRAwDgYDVQQKEwdVTklORVRUMRgwFgYDVQQDEw9mZWlkZS5lcmxhbmcubm8xITAfBgkqhkiG9w0BCQEWEmFuZHJlYXNAdW5pbmV0dC5ubzAeFw0wNzA2MTUxMjAxMzVaFw0wNzA4MTQxMjAxMzVaMIGEMQswCQYDVQQGEwJOTzEYMBYGA1UECBMPQW5kcmVhcyBTb2xiZXJnMQwwCgYDVQQHEwNGb28xEDAOBgNVBAoTB1VOSU5FVFQxGDAWBgNVBAMTD2ZlaWRlLmVybGFuZy5ubzEhMB8GCSqGSIb3DQEJARYSYW5kcmVhc0B1bmluZXR0Lm5vMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDivbhR7P516x/S3BqKxupQe0LONoliupiBOesCO3SHbDrl3+q9IbfnfmE04rNuMcPsIxB161TdDpIesLCn7c8aPHISKOtPlAeTZSnb8QAu7aRjZq3+PbrP5uW3TcfCGPtKTytHOge/OlJbo078dVhXQ14d1EDwXJW1rRXuUt4C8QIDAQABMA0GCSqGSIb3DQEBBQUAA4GBACDVfp86HObqY+e8BUoWQ9+VMQx1ASDohBjwOsg2WykUqRXF+dLfcUH9dWR63CtZIKFDbStNomPnQz7nbK+onygwBspVEbnHuUihZq3ZUdmumQqCw4Uvs/1Uvq3orOo/WJVhTyvLgFVK2QarQ4/67OZfHd7R+POBXhophSMv1ZOo\n-----END CERTIFICATE-----");
        samlData.put("onelogin.saml2.idp.x509certMulti.1", "-----BEGIN CERTIFICATE-----\nMIICbDCCAdWgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBTMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lbG9naW4gSW5jMRgwFgYDVQQDDA9pZHAuZXhhbXBsZS5jb20wHhcNMTQwOTIzMTIyNDA4WhcNNDIwMjA4MTIyNDA4WjBTMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lbG9naW4gSW5jMRgwFgYDVQQDDA9pZHAuZXhhbXBsZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAOWA+YHU7cvPOrBOfxCscsYTJB+kH3MaA9BFrSHFS+KcR6cw7oPSktIJxUgvDpQbtfNcOkE/tuOPBDoech7AXfvH6d7Bw7xtW8PPJ2mB5Hn/HGW2roYhxmfh3tR5SdwN6i4ERVF8eLkvwCHsNQyK2Ref0DAJvpBNZMHCpS24916/AgMBAAGjUDBOMB0GA1UdDgQWBBQ77/qVeiigfhYDITplCNtJKZTM8DAfBgNVHSMEGDAWgBQ77/qVeiigfhYDITplCNtJKZTM8DAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBDQUAA4GBAJO2j/1uO80E5C2PM6Fk9mzerrbkxl7AZ/mvlbOn+sNZE+VZ1AntYuG8ekbJpJtG1YfRfc7EA9mEtqvv4dhv7zBy4nK49OR+KpIBjItWB5kYvrqMLKBa32sMbgqqUqeF1ENXKjpvLSuPdfGJZA3dNa/+Dyb8GGqWe707zLyc5F8m\n-----END CERTIFICATE-----");
        samlData.put("onelogin.saml2.idp.certfingerprint", "4b6f70bb2cab82c86a8270f71a880b62e25bc2b3");
        samlData.put("onelogin.saml2.idp.certfingerprint_algorithm", "sha1");
        samlData.put("onelogin.saml2.security.nameid_encrypted", "true");
        samlData.put("onelogin.saml2.security.authnrequest_signed", "true");
        samlData.put("onelogin.saml2.security.logoutrequest_signed", "true");
        samlData.put("onelogin.saml2.security.logoutresponse_signed", "true");
        samlData.put("onelogin.saml2.security.want_messages_signed", "true");
        samlData.put("onelogin.saml2.security.want_assertions_signed", "true");
        samlData.put("onelogin.saml2.security.sign_metadata", "true");
        samlData.put("onelogin.saml2.security.want_assertions_encrypted", "true");
        samlData.put("onelogin.saml2.security.want_nameid", "false");
        samlData.put("onelogin.saml2.security.want_nameid_encrypted", "true");
        samlData.put("onelogin.saml2.security.requested_authncontext", Arrays.asList("urn:oasis:names:tc:SAML:2.0:ac:classes:urn:oasis:names:tc:SAML:2.0:ac:classes:Password"));
        samlData.put("onelogin.saml2.security.requested_authncontextcomparison", "exact");
        samlData.put("onelogin.saml2.security.want_xml_validation", "true");
        samlData.put("onelogin.saml2.security.signature_algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        samlData.put("onelogin.saml2.security.digest_algorithm", "http://www.w3.org/2001/04/xmlenc#sha512");
        samlData.put("onelogin.saml2.compress.request", "false");
        samlData.put("onelogin.saml2.compress.response", "false");
        samlData.put("onelogin.saml2.parsing.trim_name_ids", "true");
        samlData.put("onelogin.saml2.parsing.trim_attribute_values", "true");
        samlData.put("onelogin.saml2.organization.name", "SP Java");
        samlData.put("onelogin.saml2.organization.displayname", "SP Java Example");
        samlData.put("onelogin.saml2.organization.url", "http://sp.example.com");
        samlData.put("onelogin.saml2.organization.lang", "en");
        samlData.put("onelogin.saml2.sp.contact[0].contactType", "administrative");
        samlData.put("onelogin.saml2.sp.contact[0].company", "ACME");
        samlData.put("onelogin.saml2.sp.contact[0].given_name", "Guy");
        samlData.put("onelogin.saml2.sp.contact[0].sur_name", "Administrative");
        samlData.put("onelogin.saml2.sp.contact[0].email_address[0]", "administrative@example.com");
        samlData.put("onelogin.saml2.sp.contact[0].email_address[1]", "administrative2@example.com");
        samlData.put("onelogin.saml2.sp.contact[0].telephone_number[0]", "+1-123456789");
        samlData.put("onelogin.saml2.sp.contact[0].telephone_number[1]", "+1-987654321");
        samlData.put("onelogin.saml2.sp.contact[1].contactType", "other");
        samlData.put("onelogin.saml2.sp.contact[1].company", "Big Corp");
        samlData.put("onelogin.saml2.sp.contact[1].email_address", "info@example.com");
        samlData.put("onelogin.saml2.contacts.technical.given_name", "Technical Guy");
        samlData.put("onelogin.saml2.contacts.technical.email_address", "technical@example.org");
        samlData.put("onelogin.saml2.contacts.support.given_name", "Support Guy");
        samlData.put("onelogin.saml2.contacts.support.email_address", "support@example.org");
        samlData.put("onelogin.saml2.unique_id_prefix", "_");
        Saml2Settings setting = new SettingsBuilder().fromValues(samlData).build();
        Assert.assertTrue((boolean)setting.isStrict());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp", (Object)setting.getSpEntityId());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/acs.jsp", (Object)setting.getSpAssertionConsumerServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpAssertionConsumerServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/sls.jsp", (Object)setting.getSpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)setting.getSpNameIDFormat(), (Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        Assert.assertNotNull((Object)setting.getSPcert());
        Assert.assertNotNull((Object)setting.getSPcertNew());
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)setting.getIdpEntityId());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SSOService.php", (Object)setting.getIdpSingleSignOnServiceUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleSignOnServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutServiceResponse.php", (Object)setting.getIdpSingleLogoutServiceResponseUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertNotNull((Object)setting.getIdpx509cert());
        Assert.assertEquals((Object)Util.loadCert((String)Util.getFileAsString((String)"certs/certificate1")), (Object)setting.getIdpx509cert());
        Assert.assertNotNull((Object)setting.getIdpx509certMulti());
        Assert.assertEquals((long)setting.getIdpx509certMulti().size(), (long)2L);
        Assert.assertNotNull(setting.getIdpx509certMulti().get(0));
        Assert.assertEquals((Object)Util.loadCert((String)Util.getFileAsString((String)"certs/certificate2")), setting.getIdpx509certMulti().get(0));
        Assert.assertNotNull(setting.getIdpx509certMulti().get(1));
        Assert.assertEquals((Object)Util.loadCert((String)Util.getFileAsString((String)"certs/certificate3")), setting.getIdpx509certMulti().get(1));
        Assert.assertEquals((Object)"4b6f70bb2cab82c86a8270f71a880b62e25bc2b3", (Object)setting.getIdpCertFingerprint());
        Assert.assertEquals((Object)"sha1", (Object)setting.getIdpCertFingerprintAlgorithm());
        Assert.assertTrue((boolean)setting.getNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getAuthnRequestsSigned());
        Assert.assertTrue((boolean)setting.getLogoutRequestSigned());
        Assert.assertTrue((boolean)setting.getLogoutResponseSigned());
        Assert.assertTrue((boolean)setting.getWantMessagesSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsEncrypted());
        Assert.assertTrue((boolean)setting.getWantNameIdEncrypted());
        ArrayList<String> reqAuthContext = new ArrayList<String>();
        reqAuthContext.add("urn:oasis:names:tc:SAML:2.0:ac:classes:urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        Assert.assertEquals(reqAuthContext, (Object)setting.getRequestedAuthnContext());
        Assert.assertEquals((Object)"exact", (Object)setting.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", (Object)setting.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#sha512", (Object)setting.getDigestAlgorithm());
        Assert.assertTrue((boolean)setting.getSignMetadata());
        Assert.assertFalse((boolean)setting.getWantNameId());
        Assert.assertFalse((boolean)setting.isCompressRequestEnabled());
        Assert.assertFalse((boolean)setting.isCompressResponseEnabled());
        Assert.assertTrue((boolean)setting.isTrimNameIds());
        Assert.assertTrue((boolean)setting.isTrimAttributeValues());
        Organization org = new Organization("SP Java", "SP Java Example", "http://sp.example.com");
        Assert.assertTrue((boolean)org.equalsTo(setting.getOrganization()));
        List contacts = setting.getContacts();
        Assert.assertEquals((long)4L, (long)contacts.size());
        Contact c1 = (Contact)contacts.get(0);
        Assert.assertEquals((Object)"administrative", (Object)c1.getContactType());
        Assert.assertEquals((Object)"ACME", (Object)c1.getCompany());
        Assert.assertEquals((Object)"Guy", (Object)c1.getGivenName());
        Assert.assertEquals((Object)"Administrative", (Object)c1.getSurName());
        List c1Emails = c1.getEmailAddresses();
        Assert.assertEquals((long)2L, (long)c1Emails.size());
        Assert.assertEquals((Object)"administrative@example.com", c1Emails.get(0));
        Assert.assertEquals((Object)"administrative2@example.com", c1Emails.get(1));
        List c1Phones = c1.getTelephoneNumbers();
        Assert.assertEquals((long)2L, (long)c1Phones.size());
        Assert.assertEquals((Object)"+1-123456789", c1Phones.get(0));
        Assert.assertEquals((Object)"+1-987654321", c1Phones.get(1));
        Contact c2 = (Contact)contacts.get(1);
        Assert.assertEquals((Object)"other", (Object)c2.getContactType());
        Assert.assertEquals((Object)"Big Corp", (Object)c2.getCompany());
        Assert.assertNull((Object)c2.getGivenName());
        Assert.assertNull((Object)c2.getSurName());
        List c2Emails = c2.getEmailAddresses();
        Assert.assertEquals((long)1L, (long)c2Emails.size());
        Assert.assertTrue((boolean)c2.getTelephoneNumbers().isEmpty());
        Contact c3 = (Contact)contacts.get(2);
        Assert.assertEquals((Object)"technical", (Object)c3.getContactType());
        Assert.assertNull((Object)c3.getCompany());
        Assert.assertEquals((Object)"Technical Guy", (Object)c3.getGivenName());
        Assert.assertNull((Object)c3.getSurName());
        List c3Emails = c3.getEmailAddresses();
        Assert.assertEquals((long)1L, (long)c3Emails.size());
        Assert.assertEquals((Object)"technical@example.org", c3Emails.get(0));
        Assert.assertEquals((Object)"technical@example.org", (Object)c3.getEmailAddress());
        Assert.assertTrue((boolean)c3.getTelephoneNumbers().isEmpty());
        Contact c4 = (Contact)contacts.get(3);
        Assert.assertEquals((Object)"support", (Object)c4.getContactType());
        Assert.assertNull((Object)c4.getCompany());
        Assert.assertEquals((Object)"Support Guy", (Object)c4.getGivenName());
        Assert.assertNull((Object)c4.getSurName());
        List c4Emails = c4.getEmailAddresses();
        Assert.assertEquals((long)1L, (long)c4Emails.size());
        Assert.assertEquals((Object)"support@example.org", c4Emails.get(0));
        Assert.assertEquals((Object)"support@example.org", (Object)c4.getEmailAddress());
        Assert.assertTrue((boolean)c4.getTelephoneNumbers().isEmpty());
        Assert.assertEquals((Object)"_", (Object)setting.getUniqueIDPrefix());
        X509Certificate previousCert = setting.getSPcert();
        PrivateKey previousKey = setting.getSPkey();
        samlData.remove("onelogin.saml2.sp.x509cert");
        samlData.remove("onelogin.saml2.sp.privatekey");
        setting = new SettingsBuilder().fromValues(samlData, this.getKeyStoreSettings()).build();
        X509Certificate newCert = setting.getSPcert();
        PrivateKey newKey = setting.getSPkey();
        Assert.assertNotNull((Object)newCert);
        Assert.assertNotNull((Object)newKey);
        Assert.assertFalse((boolean)previousCert.equals(newCert));
        Assert.assertFalse((boolean)previousKey.equals(newKey));
    }

    @Test
    public void testLoadFromValuesWithObjects() throws Exception {
        LinkedHashMap<String, Object> samlData = new LinkedHashMap<String, Object>();
        samlData.put("onelogin.saml2.strict", true);
        samlData.put("onelogin.saml2.sp.entityid", "http://localhost:8080/java-saml-jspsample/metadata.jsp");
        samlData.put("onelogin.saml2.sp.assertion_consumer_service.url", new URL("http://localhost:8080/java-saml-jspsample/acs.jsp"));
        samlData.put("onelogin.saml2.sp.assertion_consumer_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        samlData.put("onelogin.saml2.sp.single_logout_service.url", new URL("http://localhost:8080/java-saml-jspsample/sls.jsp"));
        samlData.put("onelogin.saml2.sp.single_logout_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        samlData.put("onelogin.saml2.sp.nameidformat", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        samlData.put("onelogin.saml2.sp.x509cert", "-----BEGIN CERTIFICATE-----MIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wHhcNMTUxMDE4MjAxMjM1WhcNMTgwNzE0MjAxMjM1WjBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALvwEktX1+4y2AhEqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAGjUDBOMB0GA1UdDgQWBBTifMwN3CQ5ZOPkV5tDJsutU8teFDAfBgNVHSMEGDAWgBTifMwN3CQ5ZOPkV5tDJsutU8teFDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBDQUAA4GBAG3nAEUjJaA75SkzID5FKLolsxG5TE/0HU0+yEUAVkXiqvqN4mPWq/JjoK5+uP4LEZIb4pRrCqI3iHp+vazLLYSeyV3kaGN7q35Afw8nk8WM0f7vImbQ69j1S8GQ+6E0PEI26qBLykGkMn3GUVtBBWSdpP093NuNLJiOomnHqhqj-----END CERTIFICATE-----");
        samlData.put("onelogin.saml2.sp.x509certNew", "-----BEGIN CERTIFICATE-----MIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wHhcNMTUxMDE4MjAxMjM1WhcNMTgwNzE0MjAxMjM1WjBZMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lTG9naW4gSW5jMR4wHAYDVQQDDBVqYXZhLXNhbWwuZXhhbXBsZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALvwEktX1+4y2AhEqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAGjUDBOMB0GA1UdDgQWBBTifMwN3CQ5ZOPkV5tDJsutU8teFDAfBgNVHSMEGDAWgBTifMwN3CQ5ZOPkV5tDJsutU8teFDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBDQUAA4GBAG3nAEUjJaA75SkzID5FKLolsxG5TE/0HU0+yEUAVkXiqvqN4mPWq/JjoK5+uP4LEZIb4pRrCqI3iHp+vazLLYSeyV3kaGN7q35Afw8nk8WM0f7vImbQ69j1S8GQ+6E0PEI26qBLykGkMn3GUVtBBWSdpP093NuNLJiOomnHqhqj-----END CERTIFICATE-----");
        samlData.put("onelogin.saml2.sp.privatekey", "-----BEGIN PRIVATE KEY-----MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALvwEktX1+4y2AhEqxVwOO6HO7Wtzi3hr5becRkfLYGjNSyhzZCjI1DsNL61JSWDO3nviZd9fSkFnRC4akFUm0CS6GJ7TZe4T5o+9aowQ6N8e8cts9XPXyP6Inz7q4sD8pO2EInlfwHYPQCqFmz/SDW7cDgIC8vb0ygOsiXdreANAgMBAAECgYA7VPVRl+/xoVeWdKdWY1F17HerSa23ynI2vQ8TkUY6kR3ucz6ElRxHJesY8fNCPoX+XuMfUly7IKyPZMkWyvEgDPo7J5mYqP5VsTK0Li4AwR/BA93Aw6gaX7/EYi3HjBh8QdNSt4fi9yOea/hv04yfR9Lx/a5fvQIyhqaDtT2QeQJBAOnCgnxnj70/sv9UsFPa8t1OGdAfXtOgEoklh1F2NR9jid6FPw5E98eCpdZ00MfRrmUavgqg6Y4swZISyzJIjGMCQQDN0YNsC4S+eJJM6aOCpupKluWE/cCWB01UQYekyXH7OdUtl49NlKEUPBSAvtaLMuMKlTNOjlPrx4Q+/c5i0vTPAkEA5H7CR9J/OZETaewhc8ZYkaRvLPYNHjWhCLhLXoB6itUkhgOfUFZwEXAOpOOI1VmL675JN2B1DAmJqTx/rQYnWwJBAMx3ztsAmnBq8dTM6y65ydouDHhRawjg2jbRHwNbSQvuyVSQ08Gb3WZvxWKdtB/3fsydqqnpBYAf5sZ5eJZ+wssCQAOiIKnhdYe+RBbBwykzjUqtzEmt4fwCFE8tD4feEx77D05j5f7u7KYh1mL0G2zIbnUryi7jwc4ye98VirRpZ1w=-----END PRIVATE KEY-----");
        samlData.put("onelogin.saml2.idp.entityid", "http://idp.example.com/");
        samlData.put("onelogin.saml2.idp.single_sign_on_service.url", new URL("http://idp.example.com/simplesaml/saml2/idp/SSOService.php"));
        samlData.put("onelogin.saml2.idp.single_sign_on_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        samlData.put("onelogin.saml2.idp.single_logout_service.url", "http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php");
        samlData.put("onelogin.saml2.idp.single_logout_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        samlData.put("onelogin.saml2.idp.single_logout_service.response.url", "http://idp.example.com/simplesaml/saml2/idp/SingleLogoutServiceResponse.php");
        samlData.put("onelogin.saml2.idp.x509cert", Util.loadCert((String)Util.getFileAsString((String)"certs/certificate1")));
        samlData.put("onelogin.saml2.idp.certfingerprint", "4b6f70bb2cab82c86a8270f71a880b62e25bc2b3");
        samlData.put("onelogin.saml2.idp.certfingerprint_algorithm", "sha1");
        samlData.put("onelogin.saml2.security.nameid_encrypted", true);
        samlData.put("onelogin.saml2.security.authnrequest_signed", true);
        samlData.put("onelogin.saml2.security.logoutrequest_signed", true);
        samlData.put("onelogin.saml2.security.logoutresponse_signed", true);
        samlData.put("onelogin.saml2.security.want_messages_signed", true);
        samlData.put("onelogin.saml2.security.want_assertions_signed", true);
        samlData.put("onelogin.saml2.security.sign_metadata", true);
        samlData.put("onelogin.saml2.security.want_assertions_encrypted", true);
        samlData.put("onelogin.saml2.security.want_nameid", "false");
        samlData.put("onelogin.saml2.security.want_nameid_encrypted", true);
        samlData.put("onelogin.saml2.security.requested_authncontext", "urn:oasis:names:tc:SAML:2.0:ac:classes:urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        samlData.put("onelogin.saml2.security.requested_authncontextcomparison", "exact");
        samlData.put("onelogin.saml2.security.want_xml_validation", true);
        samlData.put("onelogin.saml2.security.signature_algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        samlData.put("onelogin.saml2.security.digest_algorithm", "http://www.w3.org/2001/04/xmlenc#sha512");
        samlData.put("onelogin.saml2.compress.request", "false");
        samlData.put("onelogin.saml2.compress.response", "false");
        samlData.put("onelogin.saml2.parsing.trim_name_ids", "true");
        samlData.put("onelogin.saml2.parsing.trim_attribute_values", "true");
        samlData.put("onelogin.saml2.organization.name", "SP Java");
        samlData.put("onelogin.saml2.organization.displayname", "SP Java Example");
        samlData.put("onelogin.saml2.organization.url", "http://sp.example.com");
        samlData.put("onelogin.saml2.organization.lang", "en");
        samlData.put("onelogin.saml2.sp.contact[0].contactType", "administrative");
        samlData.put("onelogin.saml2.sp.contact[0].company", "ACME");
        samlData.put("onelogin.saml2.sp.contact[0].given_name", "Guy");
        samlData.put("onelogin.saml2.sp.contact[0].sur_name", "Administrative");
        samlData.put("onelogin.saml2.sp.contact[0].email_address[0]", "administrative@example.com");
        samlData.put("onelogin.saml2.sp.contact[0].email_address[1]", "administrative2@example.com");
        samlData.put("onelogin.saml2.sp.contact[0].telephone_number[0]", "+1-123456789");
        samlData.put("onelogin.saml2.sp.contact[0].telephone_number[1]", "+1-987654321");
        samlData.put("onelogin.saml2.sp.contact[1].contactType", "other");
        samlData.put("onelogin.saml2.sp.contact[1].company", "Big Corp");
        samlData.put("onelogin.saml2.sp.contact[1].email_address", "info@example.com");
        samlData.put("onelogin.saml2.contacts.technical.given_name", "Technical Guy");
        samlData.put("onelogin.saml2.contacts.technical.email_address", "technical@example.org");
        samlData.put("onelogin.saml2.contacts.support.given_name", "Support Guy");
        samlData.put("onelogin.saml2.contacts.support.email_address", "support@example.org");
        Saml2Settings setting = new SettingsBuilder().fromValues(samlData).build();
        Assert.assertTrue((boolean)setting.isStrict());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp", (Object)setting.getSpEntityId());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/acs.jsp", (Object)setting.getSpAssertionConsumerServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpAssertionConsumerServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/sls.jsp", (Object)setting.getSpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)setting.getSpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)setting.getSpNameIDFormat(), (Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        Assert.assertNotNull((Object)setting.getSPcert());
        Assert.assertNotNull((Object)setting.getSPcertNew());
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)setting.getIdpEntityId());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SSOService.php", (Object)setting.getIdpSingleSignOnServiceUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleSignOnServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php", (Object)setting.getIdpSingleLogoutServiceUrl().toString());
        Assert.assertEquals((Object)"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutServiceResponse.php", (Object)setting.getIdpSingleLogoutServiceResponseUrl().toString());
        Assert.assertEquals((Object)setting.getIdpSingleLogoutServiceBinding(), (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        Assert.assertNotNull((Object)setting.getIdpx509cert());
        Assert.assertEquals((Object)Util.loadCert((String)Util.getFileAsString((String)"certs/certificate1")), (Object)setting.getIdpx509cert());
        Assert.assertEquals((Object)"4b6f70bb2cab82c86a8270f71a880b62e25bc2b3", (Object)setting.getIdpCertFingerprint());
        Assert.assertEquals((Object)"sha1", (Object)setting.getIdpCertFingerprintAlgorithm());
        Assert.assertTrue((boolean)setting.getNameIdEncrypted());
        Assert.assertTrue((boolean)setting.getAuthnRequestsSigned());
        Assert.assertTrue((boolean)setting.getLogoutRequestSigned());
        Assert.assertTrue((boolean)setting.getLogoutResponseSigned());
        Assert.assertTrue((boolean)setting.getWantMessagesSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsSigned());
        Assert.assertTrue((boolean)setting.getWantAssertionsEncrypted());
        Assert.assertTrue((boolean)setting.getWantNameIdEncrypted());
        ArrayList<String> reqAuthContext = new ArrayList<String>();
        reqAuthContext.add("urn:oasis:names:tc:SAML:2.0:ac:classes:urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        Assert.assertEquals(reqAuthContext, (Object)setting.getRequestedAuthnContext());
        Assert.assertEquals((Object)"exact", (Object)setting.getRequestedAuthnContextComparison());
        Assert.assertTrue((boolean)setting.getWantXMLValidation());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", (Object)setting.getSignatureAlgorithm());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#sha512", (Object)setting.getDigestAlgorithm());
        Assert.assertTrue((boolean)setting.getSignMetadata());
        Assert.assertFalse((boolean)setting.getWantNameId());
        Assert.assertFalse((boolean)setting.isCompressRequestEnabled());
        Assert.assertFalse((boolean)setting.isCompressResponseEnabled());
        Assert.assertTrue((boolean)setting.isTrimNameIds());
        Assert.assertTrue((boolean)setting.isTrimAttributeValues());
        Organization org = new Organization("SP Java", "SP Java Example", "http://sp.example.com");
        Assert.assertTrue((boolean)org.equalsTo(setting.getOrganization()));
        List contacts = setting.getContacts();
        Assert.assertEquals((long)4L, (long)contacts.size());
        Contact c1 = (Contact)contacts.get(0);
        Assert.assertEquals((Object)"administrative", (Object)c1.getContactType());
        Assert.assertEquals((Object)"ACME", (Object)c1.getCompany());
        Assert.assertEquals((Object)"Guy", (Object)c1.getGivenName());
        Assert.assertEquals((Object)"Administrative", (Object)c1.getSurName());
        List c1Emails = c1.getEmailAddresses();
        Assert.assertEquals((long)2L, (long)c1Emails.size());
        Assert.assertEquals((Object)"administrative@example.com", c1Emails.get(0));
        Assert.assertEquals((Object)"administrative2@example.com", c1Emails.get(1));
        List c1Phones = c1.getTelephoneNumbers();
        Assert.assertEquals((long)2L, (long)c1Phones.size());
        Assert.assertEquals((Object)"+1-123456789", c1Phones.get(0));
        Assert.assertEquals((Object)"+1-987654321", c1Phones.get(1));
        Contact c2 = (Contact)contacts.get(1);
        Assert.assertEquals((Object)"other", (Object)c2.getContactType());
        Assert.assertEquals((Object)"Big Corp", (Object)c2.getCompany());
        Assert.assertNull((Object)c2.getGivenName());
        Assert.assertNull((Object)c2.getSurName());
        List c2Emails = c2.getEmailAddresses();
        Assert.assertEquals((long)1L, (long)c2Emails.size());
        Assert.assertTrue((boolean)c2.getTelephoneNumbers().isEmpty());
        Contact c3 = (Contact)contacts.get(2);
        Assert.assertEquals((Object)"technical", (Object)c3.getContactType());
        Assert.assertNull((Object)c3.getCompany());
        Assert.assertEquals((Object)"Technical Guy", (Object)c3.getGivenName());
        Assert.assertNull((Object)c3.getSurName());
        List c3Emails = c3.getEmailAddresses();
        Assert.assertEquals((long)1L, (long)c3Emails.size());
        Assert.assertEquals((Object)"technical@example.org", c3Emails.get(0));
        Assert.assertEquals((Object)"technical@example.org", (Object)c3.getEmailAddress());
        Assert.assertTrue((boolean)c3.getTelephoneNumbers().isEmpty());
        Contact c4 = (Contact)contacts.get(3);
        Assert.assertEquals((Object)"support", (Object)c4.getContactType());
        Assert.assertNull((Object)c4.getCompany());
        Assert.assertEquals((Object)"Support Guy", (Object)c4.getGivenName());
        Assert.assertNull((Object)c4.getSurName());
        List c4Emails = c4.getEmailAddresses();
        Assert.assertEquals((long)1L, (long)c4Emails.size());
        Assert.assertEquals((Object)"support@example.org", c4Emails.get(0));
        Assert.assertEquals((Object)"support@example.org", (Object)c4.getEmailAddress());
        Assert.assertTrue((boolean)c4.getTelephoneNumbers().isEmpty());
        Assert.assertEquals((Object)"ONELOGIN_", (Object)setting.getUniqueIDPrefix());
    }
}

