/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.test.settings;

import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import org.codelibs.saml2.core.exception.SAMLSevereException;
import org.codelibs.saml2.core.model.hsm.AzureKeyVault;
import org.codelibs.saml2.core.model.hsm.HSM;
import org.codelibs.saml2.core.settings.Metadata;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.settings.SettingsBuilder;
import org.codelibs.saml2.core.util.SchemaFactory;
import org.codelibs.saml2.core.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Saml2SettingsTest {
    @Test
    public void testIsStrict() {
        Saml2Settings settings = new Saml2Settings();
        Assert.assertTrue((boolean)settings.isStrict());
        settings.setStrict(false);
        Assert.assertFalse((boolean)settings.isStrict());
        settings.setStrict(true);
        Assert.assertTrue((boolean)settings.isStrict());
    }

    @Test
    public void testIsDebugActive() {
        Saml2Settings settings = new Saml2Settings();
        Assert.assertFalse((boolean)settings.isDebugActive());
        settings.setDebug(true);
        Assert.assertTrue((boolean)settings.isDebugActive());
        settings.setDebug(false);
        Assert.assertFalse((boolean)settings.isDebugActive());
    }

    @Test
    public void testCheckIdPSettingsAllErrors() throws IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.idperrors.properties").build();
        List settingsErrors = settings.checkIdPSettings();
        Assert.assertFalse((boolean)settingsErrors.isEmpty());
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_entityId_not_found"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_sso_url_invalid"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_cert_or_fingerprint_not_found_and_required"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_cert_not_found_and_required"));
    }

    @Test
    public void testCheckIdPSettingsOk() throws IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        List settingsErrors = settings.checkIdPSettings();
        Assert.assertTrue((boolean)settingsErrors.isEmpty());
    }

    @Test
    public void testCheckSPSettingsAllErrors() throws IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.sperrors.properties").build();
        List settingsErrors = settings.checkSPSettings();
        Assert.assertFalse((boolean)settingsErrors.isEmpty());
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"sp_entityId_not_found"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"sp_acs_not_found"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"sp_cert_not_found_and_required"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"contact_type_invalid"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"contact_not_enough_data"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"organization_not_enough_data"));
    }

    @Test
    public void testCheckSPSettingsOk() throws IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        List settingsErrors = settings.checkSPSettings();
        Assert.assertTrue((boolean)settingsErrors.isEmpty());
    }

    @Test
    public void testCheckSettingsAllErrors() throws IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.allerrors.properties").build();
        List settingsErrors = settings.checkSettings();
        Assert.assertFalse((boolean)settingsErrors.isEmpty());
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"sp_entityId_not_found"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"sp_acs_not_found"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"sp_cert_not_found_and_required"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"contact_type_invalid"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"contact_not_enough_data"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"organization_not_enough_data"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_entityId_not_found"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_sso_url_invalid"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_cert_or_fingerprint_not_found_and_required"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_cert_not_found_and_required"));
    }

    @Test
    public void testCheckSettingsIdPErrors() throws IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.idperrors.properties").build();
        List settingsErrors = settings.checkSettings();
        Assert.assertFalse((boolean)settingsErrors.isEmpty());
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_entityId_not_found"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_sso_url_invalid"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_cert_or_fingerprint_not_found_and_required"));
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"idp_cert_not_found_and_required"));
        settings.setSPValidationOnly(true);
        settingsErrors = settings.checkSettings();
        Assert.assertTrue((boolean)settingsErrors.isEmpty());
    }

    @Test
    public void testCheckIdpMultipleCertSettings() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_idp_multicert.properties").build();
        List settingsErrors = settings.checkSettings();
        Assert.assertTrue((boolean)settingsErrors.isEmpty());
    }

    @Test
    public void testCheckSettingsOk() throws IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        List settingsErrors = settings.checkSettings();
        Assert.assertTrue((boolean)settingsErrors.isEmpty());
    }

    @Test
    public void testCheckSpSettingsWhenSettingHsm() throws IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.hsm.properties").build();
        settings.setHsm((HSM)new AzureKeyVault("", "", "", ""));
        List settingsErrors = settings.checkSettings();
        Assert.assertTrue((boolean)settingsErrors.isEmpty());
    }

    @Test
    public void testCheckSpSettingsWhenSettingBothHsmAndPrivateKey() throws IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        settings.setHsm((HSM)new AzureKeyVault("", "", "", ""));
        List settingsErrors = settings.checkSettings();
        Assert.assertThat((Object)settingsErrors, (Matcher)CoreMatchers.hasItem((Object)"use_either_hsm_or_private_key"));
    }

    @Test
    public void testGetSPMetadataUnsigned() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String metadataStr = settings.getSPMetadata();
        Document metadataDoc = Util.loadXML((String)metadataStr);
        Assert.assertTrue((boolean)(metadataDoc instanceof Document));
        Assert.assertEquals((Object)"md:EntityDescriptor", (Object)metadataDoc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"md:SPSSODescriptor", (Object)metadataDoc.getDocumentElement().getFirstChild().getNodeName());
        Assert.assertTrue((boolean)Util.validateXML((Document)metadataDoc, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:SPSSODescriptor"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"entityID=\"http://localhost:8080/java-saml-jspsample/metadata.jsp\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"AuthnRequestsSigned=\"false\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"WantAssertionsSigned=\"false\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<md:KeyDescriptor use=\"signing\">")));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:AssertionConsumerService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\" Location=\"http://localhost:8080/java-saml-jspsample/acs.jsp\" index=\"1\"/>"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:SingleLogoutService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\" Location=\"http://localhost:8080/java-saml-jspsample/sls.jsp\"/>"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified</md:NameIDFormat>"));
    }

    @Test
    public void testGetSPMetadataUnsignedNoSLS() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.minnosls.properties").build();
        String metadataStr = settings.getSPMetadata();
        Document metadataDoc = Util.loadXML((String)metadataStr);
        Assert.assertTrue((boolean)(metadataDoc instanceof Document));
        Assert.assertEquals((Object)"md:EntityDescriptor", (Object)metadataDoc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"md:SPSSODescriptor", (Object)metadataDoc.getDocumentElement().getFirstChild().getNodeName());
        Assert.assertTrue((boolean)Util.validateXML((Document)metadataDoc, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:SPSSODescriptor"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"entityID=\"http://localhost:8080/java-saml-jspsample/metadata.jsp\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"AuthnRequestsSigned=\"false\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"WantAssertionsSigned=\"false\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<md:KeyDescriptor use=\"signing\">")));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:AssertionConsumerService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\" Location=\"http://localhost:8080/java-saml-jspsample/acs.jsp\" index=\"1\"/>"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<md:SingleLogoutService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\" Location=\"http://localhost:8080/java-saml-jspsample/sls.jsp\"/>")));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified</md:NameIDFormat>"));
    }

    @Test
    public void testGetSPMetadataSigned() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        String metadataStr = settings.getSPMetadata();
        Document metadataDoc = Util.loadXML((String)metadataStr);
        Assert.assertTrue((boolean)(metadataDoc instanceof Document));
        Assert.assertEquals((Object)"ds:Signature", (Object)metadataDoc.getDocumentElement().getFirstChild().getNodeName());
        Node ds_signature_metadata = metadataDoc.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)ds_signature_metadata.getFirstChild().getFirstChild().getAttributes().getNamedItem("Algorithm").getNodeValue());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", (Object)ds_signature_metadata.getFirstChild().getFirstChild().getNextSibling().getAttributes().getNamedItem("Algorithm").getNodeValue());
        Assert.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#sha512", (Object)ds_signature_metadata.getFirstChild().getFirstChild().getNextSibling().getNextSibling().getFirstChild().getNextSibling().getAttributes().getNamedItem("Algorithm").getNodeValue());
        Assert.assertEquals((Object)"md:SPSSODescriptor", (Object)metadataDoc.getDocumentElement().getFirstChild().getNextSibling().getNodeName());
        Assert.assertTrue((boolean)Util.validateXML((Document)metadataDoc, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:SPSSODescriptor"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"entityID=\"http://localhost:8080/java-saml-jspsample/metadata.jsp\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"AuthnRequestsSigned=\"true\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"WantAssertionsSigned=\"true\""));
        String keyDescriptorSigningText = "<md:KeyDescriptor use=\"signing\">";
        int keyDescriptorSignStrCount = metadataStr.split(keyDescriptorSigningText).length - 1;
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)keyDescriptorSigningText));
        Assert.assertEquals((long)2L, (long)keyDescriptorSignStrCount);
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:AssertionConsumerService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\" Location=\"http://localhost:8080/java-saml-jspsample/acs.jsp\" index=\"1\">"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:SingleLogoutService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\" Location=\"http://localhost:8080/java-saml-jspsample/sls.jsp\">"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified</md:NameIDFormat>"));
    }

    @Test
    public void testValidateMetadataValid() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        String metadataStr = settings.getSPMetadata();
        List errors = Saml2Settings.validateMetadata((String)metadataStr);
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testValidateMetadataInvalidXML() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        String metadataStr = settings.getSPMetadata();
        metadataStr = metadataStr.replace("md:EntityDescriptor", "md:EntityDescriptor2");
        List errors = Saml2Settings.validateMetadata((String)metadataStr);
        Assert.assertFalse((boolean)errors.isEmpty());
        Assert.assertTrue((boolean)errors.contains("Invalid SAML Metadata. Not match the saml-schema-metadata-2.0.xsd"));
    }

    @Test
    public void testValidateMetadataNoDescriptor() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        String metadataStr = "<md:EntitiesDescriptor xmlns:md=\"urn:oasis:names:tc:SAML:2.0:metadata\" Name=\"https://your-federation.org/metadata/federation-name.xml\">" + settings.getSPMetadata() + "</md:EntitiesDescriptor>";
        List errors = Saml2Settings.validateMetadata((String)metadataStr);
        Assert.assertFalse((boolean)errors.isEmpty());
        Assert.assertTrue((boolean)errors.contains("noEntityDescriptor_xml"));
    }

    @Test
    public void testGivenUniqueIDPrefixIsUsed() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        Assert.assertEquals((Object)"EXAMPLE", (Object)settings.getUniqueIDPrefix());
    }

    @Test
    public void testUniqueIDPrefixIsUsed() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_uniqueid.properties").build();
        Assert.assertEquals((Object)"_", (Object)settings.getUniqueIDPrefix());
    }

    @Test
    public void testUniqueIDPrefixUsesDefaultWhenNotSet() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Assert.assertEquals((Object)"ONELOGIN_", (Object)settings.getUniqueIDPrefix());
    }

    @Test
    public void testValidateMetadataNoSP() throws Exception {
        String metadataStr = Util.getFileAsString((String)"data/metadata/idp_metadata.xml");
        List errors = Saml2Settings.validateMetadata((String)metadataStr);
        Assert.assertFalse((boolean)errors.isEmpty());
        Assert.assertTrue((boolean)errors.contains("onlySPSSODescriptor_allowed_xml"));
    }

    @Test
    public void testValidateMetadataExpired() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Calendar validUntilTime = Calendar.getInstance();
        validUntilTime.add(6, -2);
        Metadata metadataObj = new Metadata(settings, validUntilTime, null);
        String metadataStr = metadataObj.getMetadataString();
        metadataStr = metadataStr.replace("cacheDuration=\"PT604800S\"", "");
        List errors = Saml2Settings.validateMetadata((String)metadataStr);
        Assert.assertFalse((boolean)errors.isEmpty());
        Assert.assertTrue((boolean)errors.contains("expired_xml"));
    }
}

