/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.test.settings;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.codelibs.saml2.core.exception.SAMLSevereException;
import org.codelibs.saml2.core.model.AttributeConsumingService;
import org.codelibs.saml2.core.model.RequestedAttribute;
import org.codelibs.saml2.core.settings.Metadata;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.settings.SettingsBuilder;
import org.codelibs.saml2.core.util.SchemaFactory;
import org.codelibs.saml2.core.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MetadataTest {
    @Test
    public void testMetadata() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        Document metadataDoc = Util.loadXML((String)metadataStr);
        Assert.assertTrue((boolean)(metadataDoc instanceof Document));
        Assert.assertEquals((Object)"md:EntityDescriptor", (Object)metadataDoc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"md:SPSSODescriptor", (Object)metadataDoc.getDocumentElement().getFirstChild().getNodeName());
        Assert.assertTrue((boolean)Util.validateXML((Document)metadataDoc, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:SPSSODescriptor"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"entityID=\"http://localhost:8080/java-saml-jspsample/metadata.jsp\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"AuthnRequestsSigned=\"false\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"WantAssertionsSigned=\"false\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<md:KeyDescriptor use=\"signing\">")));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:AssertionConsumerService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\" Location=\"http://localhost:8080/java-saml-jspsample/acs.jsp\" index=\"1\"/>"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:SingleLogoutService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\" Location=\"http://localhost:8080/java-saml-jspsample/sls.jsp\"/>"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified</md:NameIDFormat>"));
    }

    @Test
    public void testMetadataSpecialChars() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_specialchars.properties").build();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        Document metadataDoc = Util.loadXML((String)metadataStr);
        Assert.assertTrue((boolean)(metadataDoc instanceof Document));
        Assert.assertEquals((Object)"md:EntityDescriptor", (Object)metadataDoc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"md:SPSSODescriptor", (Object)metadataDoc.getDocumentElement().getFirstChild().getNodeName());
        Assert.assertTrue((boolean)Util.validateXML((Document)metadataDoc, (URL)SchemaFactory.SAML_SCHEMA_METADATA_2_0));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:SPSSODescriptor"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"entityID=\"http://localhost:8080/java-saml-jspsample/metadata.jsp?a=1&amp;b=2\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"AuthnRequestsSigned=\"false\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"WantAssertionsSigned=\"false\""));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<md:KeyDescriptor use=\"signing\">")));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:AssertionConsumerService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\" Location=\"http://localhost:8080/java-saml-jspsample/acs.jsp?a=1&amp;b=2\" index=\"1\"/>"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:SingleLogoutService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\" Location=\"http://localhost:8080/java-saml-jspsample/sls.jsp?a=1&amp;b=2\"/>"));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)"<md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified</md:NameIDFormat>"));
    }

    @Test
    public void testMetadataExpiration() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Metadata metadataObj = new Metadata(settings, null, null);
        String metadataStr = metadataObj.getMetadataString();
        Calendar validUntilTime = Calendar.getInstance();
        validUntilTime.add(6, 2);
        String validUntilStr = "validUntil=\"" + Util.formatDateTime((long)validUntilTime.getTimeInMillis()) + "\"";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"cacheDuration")));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)validUntilStr)));
        String validUntilStr2 = "validUntil=\"" + Util.formatDateTime((long)validUntilTime.getTimeInMillis()) + "\"";
        Metadata metadataObj2 = new Metadata(settings, validUntilTime, Integer.valueOf(36000));
        String metadataStr2 = metadataObj2.getMetadataString();
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.containsString((String)"cacheDuration=\"PT36000S\""));
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.containsString((String)validUntilStr2));
    }

    @Test
    public void testToContactsXml() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String administrativeContactStr = "<md:ContactPerson contactType=\"administrative\"><md:Company>ACME</md:Company><md:GivenName>Guy</md:GivenName><md:SurName>Administrative</md:SurName><md:EmailAddress>administrative@example.com</md:EmailAddress><md:EmailAddress>administrative2@example.com</md:EmailAddress><md:TelephoneNumber>+1-123456789</md:TelephoneNumber><md:TelephoneNumber>+1-987654321</md:TelephoneNumber></md:ContactPerson>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)administrativeContactStr));
        String otherContactStr = "<md:ContactPerson contactType=\"other\"><md:Company>Big Corp</md:Company><md:EmailAddress>info@example.com</md:EmailAddress></md:ContactPerson>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)otherContactStr));
        Saml2Settings settings2 = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Metadata metadataObj2 = new Metadata(settings2);
        String metadataStr2 = metadataObj2.getMetadataString();
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)administrativeContactStr)));
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)otherContactStr)));
    }

    @Test
    public void testToContactsXmlSpecialChars() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllSpecialCharsProperties();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String administrativeContactStr = "<md:ContactPerson contactType=\"administrative\"><md:Company>ACME &amp; C.</md:Company><md:GivenName>&quot;Guy&quot;</md:GivenName><md:SurName>&lt;Administrative&gt;</md:SurName><md:EmailAddress>administrativ&amp;@example.com</md:EmailAddress><md:EmailAddress>administrativ&amp;2@example.com</md:EmailAddress><md:TelephoneNumber>&lt;+1&gt;-123456789</md:TelephoneNumber><md:TelephoneNumber>&lt;+1&gt;-987654321</md:TelephoneNumber></md:ContactPerson>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)administrativeContactStr));
        String otherContactStr = "<md:ContactPerson contactType=\"other\"><md:Company>Big Corp</md:Company><md:EmailAddress>info@example.com</md:EmailAddress></md:ContactPerson>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)otherContactStr));
        Saml2Settings settings2 = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Metadata metadataObj2 = new Metadata(settings2);
        String metadataStr2 = metadataObj2.getMetadataString();
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)administrativeContactStr)));
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)otherContactStr)));
    }

    @Test
    public void testToContactsXmlLegacy() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String technicalContactStr = "<md:ContactPerson contactType=\"technical\"><md:GivenName>Technical Guy</md:GivenName><md:EmailAddress>technical@example.com</md:EmailAddress></md:ContactPerson>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)technicalContactStr));
        String supportContactStr = "<md:ContactPerson contactType=\"support\"><md:GivenName>Support Guy</md:GivenName><md:EmailAddress>support@example.com</md:EmailAddress></md:ContactPerson>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)supportContactStr));
        Saml2Settings settings2 = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Metadata metadataObj2 = new Metadata(settings2);
        String metadataStr2 = metadataObj2.getMetadataString();
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)technicalContactStr)));
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)supportContactStr)));
    }

    @Test
    public void testToContactsXmlLegacySpecialChars() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllSpecialCharsProperties();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String technicalContactStr = "<md:ContactPerson contactType=\"technical\"><md:GivenName>T&amp;chnical Guy</md:GivenName><md:EmailAddress>t&amp;chnical@example.com</md:EmailAddress></md:ContactPerson>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)technicalContactStr));
        String supportContactStr = "<md:ContactPerson contactType=\"support\"><md:GivenName>&quot;Support Guy&quot;</md:GivenName><md:EmailAddress>supp&amp;rt@example.com</md:EmailAddress></md:ContactPerson>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)supportContactStr));
    }

    @Test
    public void testToOrganizationXml() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String orgStr = "<md:Organization><md:OrganizationName xml:lang=\"en\">SP Java</md:OrganizationName><md:OrganizationDisplayName xml:lang=\"en\">SP Java Example</md:OrganizationDisplayName><md:OrganizationURL xml:lang=\"en\">http://sp.example.com</md:OrganizationURL></md:Organization>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)orgStr));
        Saml2Settings settings2 = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Metadata metadataObj2 = new Metadata(settings2);
        String metadataStr2 = metadataObj2.getMetadataString();
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)orgStr)));
    }

    @Test
    public void testToNonLocalizedOrganizationXml() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.org.properties").build();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String orgStr = "<md:Organization><md:OrganizationName xml:lang=\"en\">SP Java</md:OrganizationName><md:OrganizationDisplayName xml:lang=\"en\">SP Java Example</md:OrganizationDisplayName><md:OrganizationURL xml:lang=\"en\">http://sp.example.com</md:OrganizationURL></md:Organization>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)orgStr));
        Saml2Settings settings2 = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Metadata metadataObj2 = new Metadata(settings2);
        String metadataStr2 = metadataObj2.getMetadataString();
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)orgStr)));
    }

    @Test
    public void testToLocalizedOrganizationXml() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.org.localized.properties").build();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String orgStr = "<md:Organization><md:OrganizationName xml:lang=\"fr\">SP Java</md:OrganizationName><md:OrganizationDisplayName xml:lang=\"fr\">SP Exemple Java</md:OrganizationDisplayName><md:OrganizationURL xml:lang=\"fr\">http://sp.example.com/fr</md:OrganizationURL></md:Organization>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)orgStr));
        Saml2Settings settings2 = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Metadata metadataObj2 = new Metadata(settings2);
        String metadataStr2 = metadataObj2.getMetadataString();
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)orgStr)));
    }

    @Test
    public void testToOrganizationXmlSpecialChars() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllSpecialCharsProperties();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String orgStr = "<md:Organization><md:OrganizationName xml:lang=\"en\">S&amp;P Java</md:OrganizationName><md:OrganizationDisplayName xml:lang=\"en\">S&amp;P Java &quot;Example&quot;</md:OrganizationDisplayName><md:OrganizationURL xml:lang=\"en\">http://sp.example.com?a=1&amp;b=2</md:OrganizationURL></md:Organization>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)orgStr));
    }

    @Test
    public void testToSLSXml() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String slsStr = "<md:SingleLogoutService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\" Location=\"http://localhost:8080/java-saml-jspsample/sls.jsp\"/>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)slsStr));
        Saml2Settings settings2 = new SettingsBuilder().fromFile("config/config.minnosls.properties").build();
        Metadata metadataObj2 = new Metadata(settings2);
        String metadataStr2 = metadataObj2.getMetadataString();
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)slsStr)));
    }

    @Test
    public void testToSLSXmlSpecialChars() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllSpecialCharsProperties();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String slsStr = "<md:SingleLogoutService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\" Location=\"http://localhost:8080/java-saml-jspsample/sls.jsp?a=1&amp;b=2\"/>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)slsStr));
    }

    @Test
    public void testToX509KeyDescriptorsXML() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        String keyDescriptorSignStr = "<md:KeyDescriptor use=\"signing\"><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:X509Data><ds:X509Certificate>MIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czET";
        String keyDescriptorEncStr = "<md:KeyDescriptor use=\"encryption\"><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:X509Data><ds:X509Certificate>MIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czET";
        int keyDescriptorSignStrCount = metadataStr.split(keyDescriptorSignStr).length - 1;
        int keyDescriptorEncStrCount = metadataStr.split(keyDescriptorEncStr).length - 1;
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)keyDescriptorSignStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)keyDescriptorEncStr));
        Assert.assertEquals((long)2L, (long)keyDescriptorEncStrCount);
        Assert.assertEquals((long)2L, (long)keyDescriptorSignStrCount);
        Saml2Settings settings2 = new SettingsBuilder().fromFile("config/config.minnosls.properties").build();
        Metadata metadataObj2 = new Metadata(settings2);
        String metadataStr2 = metadataObj2.getMetadataString();
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)keyDescriptorSignStr)));
        Assert.assertThat((Object)metadataStr2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)keyDescriptorEncStr)));
    }

    @Test
    public void testToX509KeyDescriptorsXMLEncryption() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        String keyDescriptorEncStr = "<md:KeyDescriptor use=\"encryption\"><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:X509Data><ds:X509Certificate>MIICeDCCAeGgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBZMQswCQYDVQQGEwJ1czET";
        settings.setWantAssertionsEncrypted(false);
        settings.setWantNameIdEncrypted(false);
        Metadata metadataObj = new Metadata(settings);
        String metadataStr = metadataObj.getMetadataString();
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)keyDescriptorEncStr)));
        settings.setWantAssertionsEncrypted(true);
        settings.setWantNameIdEncrypted(false);
        metadataObj = new Metadata(settings);
        metadataStr = metadataObj.getMetadataString();
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)keyDescriptorEncStr));
        settings.setWantAssertionsEncrypted(false);
        settings.setWantNameIdEncrypted(true);
        metadataObj = new Metadata(settings);
        metadataStr = metadataObj.getMetadataString();
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)keyDescriptorEncStr));
        settings.setWantAssertionsEncrypted(true);
        settings.setWantNameIdEncrypted(true);
        metadataObj = new Metadata(settings);
        metadataStr = metadataObj.getMetadataString();
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)keyDescriptorEncStr));
    }

    @Test
    public void testGetAttributeConsumingServiceXml() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        AttributeConsumingService attributeConsumingService = new AttributeConsumingService("Test Service", "Test Service Desc");
        RequestedAttribute requestedAttribute = new RequestedAttribute("Email", "Email", Boolean.valueOf(true), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null);
        RequestedAttribute requestedAttribute2 = new RequestedAttribute("FirstName", null, Boolean.valueOf(true), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null);
        RequestedAttribute requestedAttribute3 = new RequestedAttribute("LastName", null, Boolean.valueOf(true), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null);
        attributeConsumingService.addRequestedAttribute(requestedAttribute);
        attributeConsumingService.addRequestedAttribute(requestedAttribute2);
        attributeConsumingService.addRequestedAttribute(requestedAttribute3);
        Metadata metadataObj = new Metadata(settings, null, null, attributeConsumingService);
        String metadataStr = metadataObj.getMetadataString();
        String headerStr = "<md:AttributeConsumingService index=\"1\">";
        String sNameStr = "<md:ServiceName xml:lang=\"en\">Test Service</md:ServiceName>";
        String sDescStr = "<md:ServiceDescription xml:lang=\"en\">Test Service Desc</md:ServiceDescription>";
        String reqAttr1Str = "<md:RequestedAttribute Name=\"Email\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:uri\" FriendlyName=\"Email\" isRequired=\"true\" />";
        String reqAttr2Str = "<md:RequestedAttribute Name=\"FirstName\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:uri\" isRequired=\"true\" />";
        String reqAttr3Str = "<md:RequestedAttribute Name=\"LastName\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:uri\" isRequired=\"true\" />";
        String footerStr = "</md:AttributeConsumingService>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)headerStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)sNameStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)sDescStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr1Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr2Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr3Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)footerStr));
    }

    @Test
    public void testGetAttributeConsumingServiceXmlSpecialChars() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        AttributeConsumingService attributeConsumingService = new AttributeConsumingService("T&st Service", "T&st Service Desc");
        RequestedAttribute requestedAttribute = new RequestedAttribute("Email", "Email \"address\"", Boolean.valueOf(true), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null);
        RequestedAttribute requestedAttribute2 = new RequestedAttribute("FirstName&LastName", null, Boolean.valueOf(true), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null);
        attributeConsumingService.addRequestedAttribute(requestedAttribute);
        attributeConsumingService.addRequestedAttribute(requestedAttribute2);
        Metadata metadataObj = new Metadata(settings, null, null, attributeConsumingService);
        String metadataStr = metadataObj.getMetadataString();
        String headerStr = "<md:AttributeConsumingService index=\"1\">";
        String sNameStr = "<md:ServiceName xml:lang=\"en\">T&amp;st Service</md:ServiceName>";
        String sDescStr = "<md:ServiceDescription xml:lang=\"en\">T&amp;st Service Desc</md:ServiceDescription>";
        String reqAttr1Str = "<md:RequestedAttribute Name=\"Email\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:uri\" FriendlyName=\"Email &quot;address&quot;\" isRequired=\"true\" />";
        String reqAttr2Str = "<md:RequestedAttribute Name=\"FirstName&amp;LastName\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:uri\" isRequired=\"true\" />";
        String footerStr = "</md:AttributeConsumingService>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)headerStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)sNameStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)sDescStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr1Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr2Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)footerStr));
    }

    @Test
    public void testGetAttributeConsumingServiceXmlWithMultipleAttributeValue() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        AttributeConsumingService attributeConsumingService = new AttributeConsumingService("Test Service", "Test Service Desc");
        ArrayList<String> attrValues = new ArrayList<String>();
        attrValues.add("userType");
        attrValues.add("admin");
        RequestedAttribute requestedAttribute = new RequestedAttribute("userType", null, Boolean.valueOf(false), "urn:oasis:names:tc:SAML:2.0:attrname-format:basic", attrValues);
        RequestedAttribute requestedAttribute2 = new RequestedAttribute("urn:oid:0.9.2342.19200300.100.1.1", "uid", Boolean.valueOf(true), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null);
        attributeConsumingService.addRequestedAttribute(requestedAttribute);
        attributeConsumingService.addRequestedAttribute(requestedAttribute2);
        Metadata metadataObj = new Metadata(settings, null, null, attributeConsumingService);
        String metadataStr = metadataObj.getMetadataString();
        String headerStr = "<md:AttributeConsumingService index=\"1\">";
        String sNameStr = "<md:ServiceName xml:lang=\"en\">Test Service</md:ServiceName>";
        String sDescStr = "<md:ServiceDescription xml:lang=\"en\">Test Service Desc</md:ServiceDescription>";
        String reqAttr1Str = "<md:RequestedAttribute Name=\"userType\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\" isRequired=\"false\">";
        String reqAttr1Atr1Str = "<saml:AttributeValue xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\">userType</saml:AttributeValue>";
        String reqAttr1Attr2Str = "<saml:AttributeValue xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\">admin</saml:AttributeValue>";
        String reqAttr2Str = "<md:RequestedAttribute Name=\"urn:oid:0.9.2342.19200300.100.1.1\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:uri\" FriendlyName=\"uid\" isRequired=\"true\" />";
        String footerStr = "</md:AttributeConsumingService>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)headerStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)sNameStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)sDescStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr1Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr1Atr1Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr1Attr2Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr2Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)footerStr));
    }

    @Test
    public void testGetAttributeConsumingServiceXmlWithMultipleAttributeValueSpecialChars() throws IOException, CertificateEncodingException, SAMLSevereException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        AttributeConsumingService attributeConsumingService = new AttributeConsumingService("T&st Service", "T&st Service Desc");
        ArrayList<String> attrValues = new ArrayList<String>();
        attrValues.add("us&rType");
        attrValues.add("admin");
        RequestedAttribute requestedAttribute = new RequestedAttribute("us&rType", null, Boolean.valueOf(false), "urn:oasis:names:tc:SAML:2.0:attrname-format:basic", attrValues);
        RequestedAttribute requestedAttribute2 = new RequestedAttribute("urn:oid:0.9.2342.19200300.100.1.1", "uid", Boolean.valueOf(true), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null);
        attributeConsumingService.addRequestedAttribute(requestedAttribute);
        attributeConsumingService.addRequestedAttribute(requestedAttribute2);
        Metadata metadataObj = new Metadata(settings, null, null, attributeConsumingService);
        String metadataStr = metadataObj.getMetadataString();
        String headerStr = "<md:AttributeConsumingService index=\"1\">";
        String sNameStr = "<md:ServiceName xml:lang=\"en\">T&amp;st Service</md:ServiceName>";
        String sDescStr = "<md:ServiceDescription xml:lang=\"en\">T&amp;st Service Desc</md:ServiceDescription>";
        String reqAttr1Str = "<md:RequestedAttribute Name=\"us&amp;rType\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\" isRequired=\"false\">";
        String reqAttr1Atr1Str = "<saml:AttributeValue xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\">us&amp;rType</saml:AttributeValue>";
        String reqAttr1Attr2Str = "<saml:AttributeValue xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\">admin</saml:AttributeValue>";
        String reqAttr2Str = "<md:RequestedAttribute Name=\"urn:oid:0.9.2342.19200300.100.1.1\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:uri\" FriendlyName=\"uid\" isRequired=\"true\" />";
        String footerStr = "</md:AttributeConsumingService>";
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)headerStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)sNameStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)sDescStr));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr1Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr1Atr1Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr1Attr2Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)reqAttr2Str));
        Assert.assertThat((Object)metadataStr, (Matcher)CoreMatchers.containsString((String)footerStr));
    }

    @Test
    public void testSignImportedMetadata() throws IOException, GeneralSecurityException, XPathExpressionException, XMLSecurityException {
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String signAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String digestAlgorithmSha1 = "http://www.w3.org/2000/09/xmldsig#sha1";
        String metadata = Util.getFileAsString((String)"data/metadata/metadata_settings1.xml");
        String metadataSigned = Metadata.signMetadata((String)metadata, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha1);
        Assert.assertThat((Object)metadataSigned, (Matcher)CoreMatchers.containsString((String)"<ds:SignatureValue>"));
        Document metadataSignedDoc = Util.loadXML((String)metadataSigned);
        Assert.assertEquals((Object)"md:EntityDescriptor", (Object)metadataSignedDoc.getFirstChild().getNodeName());
        Node ds_signature_metadata = metadataSignedDoc.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:Signature", (Object)ds_signature_metadata.getNodeName());
        Node canonization_metadata_signed = ds_signature_metadata.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:CanonicalizationMethod", (Object)canonization_metadata_signed.getNodeName());
        Assert.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)canonization_metadata_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node signature_method_metadata_signed = ds_signature_metadata.getFirstChild().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:SignatureMethod", (Object)signature_method_metadata_signed.getNodeName());
        Assert.assertEquals((Object)signAlgorithmSha1, (Object)signature_method_metadata_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node digest_method_metadata_signed = ds_signature_metadata.getFirstChild().getFirstChild().getNextSibling().getNextSibling().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:DigestMethod", (Object)digest_method_metadata_signed.getNodeName());
        Assert.assertEquals((Object)digestAlgorithmSha1, (Object)digest_method_metadata_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
    }

    @Test
    public void testSigngeneratedMetadata() throws SAMLSevereException, IOException, GeneralSecurityException, XPathExpressionException, XMLSecurityException {
        Saml2Settings settings = this.getSettingFromAllProperties();
        String certString = Util.getFileAsString((String)"data/customPath/certs/sp.crt");
        X509Certificate cert = Util.loadCert((String)certString);
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        String signAlgorithmSha256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        String digestAlgorithmSha512 = "http://www.w3.org/2001/04/xmlenc#sha512";
        Metadata metadataObj = new Metadata(settings);
        String metadata = metadataObj.getMetadataString();
        String metadataSigned = Metadata.signMetadata((String)metadata, (PrivateKey)key, (X509Certificate)cert, (String)signAlgorithmSha256, (String)digestAlgorithmSha512);
        Assert.assertThat((Object)metadataSigned, (Matcher)CoreMatchers.containsString((String)"<ds:SignatureValue>"));
        Document metadataSignedDoc = Util.loadXML((String)metadataSigned);
        Assert.assertEquals((Object)"md:EntityDescriptor", (Object)metadataSignedDoc.getFirstChild().getNodeName());
        Node ds_signature_metadata = metadataSignedDoc.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:Signature", (Object)ds_signature_metadata.getNodeName());
        Node canonization_metadata_signed = ds_signature_metadata.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"ds:CanonicalizationMethod", (Object)canonization_metadata_signed.getNodeName());
        Assert.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)canonization_metadata_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node signature_method_metadata_signed = ds_signature_metadata.getFirstChild().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:SignatureMethod", (Object)signature_method_metadata_signed.getNodeName());
        Assert.assertEquals((Object)signAlgorithmSha256, (Object)signature_method_metadata_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
        Node digest_method_metadata_signed = ds_signature_metadata.getFirstChild().getFirstChild().getNextSibling().getNextSibling().getFirstChild().getNextSibling();
        Assert.assertEquals((Object)"ds:DigestMethod", (Object)digest_method_metadata_signed.getNodeName());
        Assert.assertEquals((Object)digestAlgorithmSha512, (Object)digest_method_metadata_signed.getAttributes().getNamedItem("Algorithm").getNodeValue());
    }

    private Saml2Settings getSettingFromAllProperties() throws SAMLSevereException, IOException {
        return new SettingsBuilder().fromFile("config/config.all.properties").build();
    }

    private Saml2Settings getSettingFromAllSpecialCharsProperties() throws SAMLSevereException, IOException {
        return new SettingsBuilder().fromFile("config/config.all_specialchars.properties").build();
    }

    @Test
    public void shouldIncludeValidUntilAndDuration() throws CertificateEncodingException, SAMLSevereException, IOException {
        Saml2Settings saml2Settings = this.getSettingFromAllProperties();
        Integer cacheDuration = 123;
        Calendar validUntil = Calendar.getInstance();
        Metadata metadata = new Metadata(saml2Settings, validUntil, cacheDuration);
        String metadataString = metadata.getMetadataString();
        Document metadataSignedDoc = Util.loadXML((String)metadataString);
        Node validUntilNode = metadataSignedDoc.getFirstChild().getAttributes().getNamedItem("validUntil");
        Node cacheDurationNode = metadataSignedDoc.getFirstChild().getAttributes().getNamedItem("cacheDuration");
        Assert.assertEquals((String)"should set valid until attribute", (Object)Util.formatDateTime((long)validUntil.getTimeInMillis()), (Object)validUntilNode.getTextContent());
        Assert.assertEquals((String)"should set cache duration attribute", (Object)"PT123S", (Object)cacheDurationNode.getTextContent());
    }

    @Test
    public void shouldIgnoreValidUntil() throws CertificateEncodingException, SAMLSevereException, IOException {
        Saml2Settings saml2Settings = this.getSettingFromAllProperties();
        Integer cacheDuration = 123;
        Calendar validUntil = Calendar.getInstance();
        Metadata metadata = new Metadata(saml2Settings, null, cacheDuration);
        String metadataString = metadata.getMetadataString();
        Document metadataSignedDoc = Util.loadXML((String)metadataString);
        Node validUntilNode = metadataSignedDoc.getFirstChild().getAttributes().getNamedItem("validUntil");
        Node cacheDurationNode = metadataSignedDoc.getFirstChild().getAttributes().getNamedItem("cacheDuration");
        Assert.assertNull((String)"should not set valid until attribute", (Object)validUntilNode);
        Assert.assertEquals((String)"should set cache duration attribute", (Object)"PT123S", (Object)cacheDurationNode.getTextContent());
    }

    @Test
    public void shouldIgnoreCacheDuration() throws CertificateEncodingException, SAMLSevereException, IOException {
        Saml2Settings saml2Settings = this.getSettingFromAllProperties();
        Integer cacheDuration = 123;
        Calendar validUntil = Calendar.getInstance();
        Metadata metadata = new Metadata(saml2Settings, validUntil, null);
        String metadataString = metadata.getMetadataString();
        Document metadataSignedDoc = Util.loadXML((String)metadataString);
        Node validUntilNode = metadataSignedDoc.getFirstChild().getAttributes().getNamedItem("validUntil");
        Node cacheDurationNode = metadataSignedDoc.getFirstChild().getAttributes().getNamedItem("cacheDuration");
        Assert.assertEquals((String)"should set valid until attribute", (Object)Util.formatDateTime((long)validUntil.getTimeInMillis()), (Object)validUntilNode.getTextContent());
        Assert.assertNull((String)"should not set cache duration attribute", (Object)cacheDurationNode);
    }

    @Test
    public void testPostProcessXml() throws Exception {
        final Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        Metadata metadata = new Metadata(settings){

            protected String postProcessXml(String authRequestXml, Saml2Settings sett) {
                Assert.assertEquals((Object)authRequestXml, (Object)super.postProcessXml(authRequestXml, sett));
                Assert.assertSame((Object)settings, (Object)sett);
                return "changed";
            }
        };
        Assert.assertEquals((Object)"changed", (Object)metadata.getMetadataString());
    }
}

