/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.test.logout;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Calendar;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.codelibs.saml2.core.exception.SAMLSevereException;
import org.codelibs.saml2.core.exception.ValidationException;
import org.codelibs.saml2.core.http.HttpRequest;
import org.codelibs.saml2.core.logout.LogoutResponse;
import org.codelibs.saml2.core.logout.LogoutResponseParams;
import org.codelibs.saml2.core.model.SamlResponseStatus;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.settings.SettingsBuilder;
import org.codelibs.saml2.core.test.NaiveUrlEncoder;
import org.codelibs.saml2.core.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LogoutResponseTest {
    @Test
    public void testGetEncodedLogoutResponseSimulated() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        final String logoutResponseString = Util.getFileAsString((String)"data/logout_responses/logout_response.xml");
        String requestURL = "/";
        HttpRequest httpRequest = new HttpRequest("/", (String)null);
        LogoutResponse logoutResponseBuilder = new LogoutResponse(settings, httpRequest){

            public String getLogoutResponseXml() {
                return logoutResponseString;
            }
        };
        logoutResponseBuilder.build();
        String expectedLogoutResponseStringBase64Deflated = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String expectedLogoutResponseStringBase64 = Util.getFileAsString((String)"data/logout_responses/logout_response.xml.base64");
        String logoutResponseStringBase64Deflated = logoutResponseBuilder.getEncodedLogoutResponse();
        Assert.assertEquals((Object)logoutResponseStringBase64Deflated, (Object)expectedLogoutResponseStringBase64Deflated);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest){

            public String getLogoutResponseXml() {
                return logoutResponseString;
            }
        };
        logoutResponseStringBase64Deflated = logoutResponse.getEncodedLogoutResponse();
        Assert.assertEquals((Object)logoutResponseStringBase64Deflated, (Object)expectedLogoutResponseStringBase64Deflated);
        logoutResponseStringBase64Deflated = logoutResponse.getEncodedLogoutResponse(null);
        Assert.assertEquals((Object)logoutResponseStringBase64Deflated, (Object)expectedLogoutResponseStringBase64Deflated);
        logoutResponseStringBase64Deflated = logoutResponse.getEncodedLogoutResponse(Boolean.valueOf(true));
        Assert.assertEquals((Object)logoutResponseStringBase64Deflated, (Object)expectedLogoutResponseStringBase64Deflated);
        logoutResponseStringBase64Deflated = logoutResponse.getEncodedLogoutResponse(Boolean.valueOf(false));
        Assert.assertNotEquals((Object)logoutResponseStringBase64Deflated, (Object)expectedLogoutResponseStringBase64Deflated);
        Assert.assertEquals((Object)logoutResponseStringBase64Deflated, (Object)expectedLogoutResponseStringBase64);
        settings.setCompressResponse(true);
        logoutResponse = new LogoutResponse(settings, httpRequest){

            public String getLogoutResponseXml() {
                return logoutResponseString;
            }
        };
        logoutResponseStringBase64Deflated = logoutResponse.getEncodedLogoutResponse(null);
        Assert.assertEquals((Object)logoutResponseStringBase64Deflated, (Object)expectedLogoutResponseStringBase64Deflated);
        settings.setCompressResponse(false);
        logoutResponse = new LogoutResponse(settings, httpRequest){

            public String getLogoutResponseXml() {
                return logoutResponseString;
            }
        };
        logoutResponseStringBase64Deflated = logoutResponse.getEncodedLogoutResponse(null);
        Assert.assertNotEquals((Object)logoutResponseStringBase64Deflated, (Object)expectedLogoutResponseStringBase64Deflated);
        Assert.assertEquals((Object)logoutResponseStringBase64Deflated, (Object)expectedLogoutResponseStringBase64);
    }

    @Test
    public void testReceivedMessageConstructor() throws IOException, XMLSecurityException, URISyntaxException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("/", samlResponseEncoded);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        String expectedLogoutResponseStringBase64 = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String logoutResponseStringBase64 = logoutResponse.getEncodedLogoutResponse();
        Assert.assertEquals((Object)logoutResponseStringBase64, (Object)expectedLogoutResponseStringBase64);
    }

    @Test
    public void testOutgoingMessageConstructor() throws IOException, XMLSecurityException, URISyntaxException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        LogoutResponse logoutResponse = new LogoutResponse(settings, new LogoutResponseParams());
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"SAML Logout Response is not loaded", (Object)logoutResponse.getError());
        String logoutResponseStringBase64 = logoutResponse.getEncodedLogoutResponse();
        Assert.assertFalse((boolean)logoutResponseStringBase64.isEmpty());
        String logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"InResponseTo=")));
        LogoutResponse logoutResponse2 = new LogoutResponse(settings, new LogoutResponseParams("inResponseValue"));
        logoutResponseStringBase64 = logoutResponse2.getEncodedLogoutResponse();
        logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"InResponseTo=\"inResponseValue\""));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\""));
        LogoutResponse logoutResponse3 = new LogoutResponse(settings, new LogoutResponseParams("inResponseValue", "urn:oasis:names:tc:SAML:2.0:status:VersionMismatch"));
        logoutResponseStringBase64 = logoutResponse3.getEncodedLogoutResponse();
        logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"InResponseTo=\"inResponseValue\""));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:VersionMismatch\" />"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"</samlp:StatusCode>")));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:StatusMessage>")));
        SamlResponseStatus responseStatus = new SamlResponseStatus("urn:oasis:names:tc:SAML:2.0:status:Responder");
        responseStatus.setSubStatusCode("urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
        LogoutResponse logoutResponse4 = new LogoutResponse(settings, new LogoutResponseParams("inResponseValue", responseStatus));
        logoutResponseStringBase64 = logoutResponse4.getEncodedLogoutResponse();
        logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"InResponseTo=\"inResponseValue\""));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Responder\"><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:PartialLogout\" /></samlp:StatusCode>"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:StatusMessage>")));
        responseStatus.setStatusMessage("status message");
        LogoutResponse logoutResponse5 = new LogoutResponse(settings, new LogoutResponseParams("inResponseValue", responseStatus));
        logoutResponseStringBase64 = logoutResponse5.getEncodedLogoutResponse();
        logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"InResponseTo=\"inResponseValue\""));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Responder\"><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:PartialLogout\" /></samlp:StatusCode>"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:StatusMessage>status message</samlp:StatusMessage>"));
    }

    @Test
    public void testBuild() throws IOException, XMLSecurityException, URISyntaxException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String requestURL = "/";
        HttpRequest httpRequest = new HttpRequest("/", (String)null);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"SAML Logout Response is not loaded", (Object)logoutResponse.getError());
        logoutResponse.build();
        String logoutResponseStringBase64 = logoutResponse.getEncodedLogoutResponse();
        Assert.assertFalse((boolean)logoutResponseStringBase64.isEmpty());
        String logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"InResponseTo=")));
        LogoutResponse logoutResponse2 = new LogoutResponse(settings, httpRequest);
        logoutResponse2.build("inResponseValue");
        logoutResponseStringBase64 = logoutResponse2.getEncodedLogoutResponse();
        logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"InResponseTo=\"inResponseValue\""));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\""));
        LogoutResponse logoutResponse3 = new LogoutResponse(settings, httpRequest);
        logoutResponse3.build("inResponseValue", "urn:oasis:names:tc:SAML:2.0:status:VersionMismatch");
        logoutResponseStringBase64 = logoutResponse3.getEncodedLogoutResponse();
        logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"InResponseTo=\"inResponseValue\""));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:VersionMismatch\" />"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"</samlp:StatusCode>")));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:StatusMessage>")));
        LogoutResponse logoutResponse4 = new LogoutResponse(settings, httpRequest);
        SamlResponseStatus responseStatus = new SamlResponseStatus("urn:oasis:names:tc:SAML:2.0:status:Responder");
        responseStatus.setSubStatusCode("urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
        logoutResponse4.build("inResponseValue", responseStatus);
        logoutResponseStringBase64 = logoutResponse4.getEncodedLogoutResponse();
        logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"InResponseTo=\"inResponseValue\""));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Responder\"><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:PartialLogout\" /></samlp:StatusCode>"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:StatusMessage>")));
        responseStatus.setStatusMessage("status message");
        logoutResponse4.build("inResponseValue", responseStatus);
        logoutResponseStringBase64 = logoutResponse4.getEncodedLogoutResponse();
        logoutResponseStr = Util.base64decodedInflated((String)logoutResponseStringBase64);
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"InResponseTo=\"inResponseValue\""));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Responder\"><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:PartialLogout\" /></samlp:StatusCode>"));
        Assert.assertThat((Object)logoutResponseStr, (Matcher)CoreMatchers.containsString((String)"<samlp:StatusMessage>status message</samlp:StatusMessage>"));
    }

    @Test
    public void testGetLogoutResponseXml() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        LogoutResponse logoutResponse = new LogoutResponse(settings, new LogoutResponseParams());
        String logoutResponseXML = logoutResponse.getLogoutResponseXml();
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php\""));
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest(requestURL, samlResponseEncoded);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        logoutResponseXML = logoutResponse.getLogoutResponseXml();
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
    }

    @Test
    public void testGetLogoutResponseXmlLegacy() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        LogoutResponse logoutResponse = new LogoutResponse(settings, (HttpRequest)null);
        logoutResponse.build();
        String logoutResponseXML = logoutResponse.getLogoutResponseXml();
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php\""));
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest(requestURL, samlResponseEncoded);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        logoutResponseXML = logoutResponse.getLogoutResponseXml();
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
    }

    @Test
    public void testGetLogoutResponseXmlSpecialChars() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_specialchars.properties").build();
        LogoutResponse logoutResponse = new LogoutResponse(settings, new LogoutResponseParams());
        String logoutResponseXML = logoutResponse.getLogoutResponseXml();
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php?a=1&amp;b=2\""));
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest(requestURL, samlResponseEncoded);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        logoutResponseXML = logoutResponse.getLogoutResponseXml();
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
    }

    @Test
    public void testGetLogoutResponseXmlSpecialCharsLegacy() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_specialchars.properties").build();
        LogoutResponse logoutResponse = new LogoutResponse(settings, (HttpRequest)null);
        logoutResponse.build();
        String logoutResponseXML = logoutResponse.getLogoutResponseXml();
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php?a=1&amp;b=2\""));
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest(requestURL, samlResponseEncoded);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        logoutResponseXML = logoutResponse.getLogoutResponseXml();
        Assert.assertThat((Object)logoutResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse"));
    }

    @Test
    public void testGetStatus() throws IOException, URISyntaxException, XMLSecurityException, XPathExpressionException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("/", samlResponseEncoded);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:status:Success", (Object)logoutResponse.getStatus());
        samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/invalids/no_status.xml.base64");
        httpRequest = LogoutResponseTest.newHttpRequest("/", samlResponseEncoded);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertNull((Object)logoutResponse.getStatus());
    }

    @Test
    public void testGetIssuer() throws IOException, URISyntaxException, XMLSecurityException, XPathExpressionException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("/", samlResponseEncoded);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        String expectedIssuer = "http://idp.example.com/";
        Assert.assertEquals((Object)expectedIssuer, (Object)logoutResponse.getIssuer());
        String logoutRequestStr = Util.base64decodedInflated((String)samlResponseEncoded);
        logoutRequestStr = logoutRequestStr.replace("<saml:Issuer>http://idp.example.com/</saml:Issuer>", "");
        samlResponseEncoded = Util.deflatedBase64encoded((String)logoutRequestStr);
        httpRequest = LogoutResponseTest.newHttpRequest("/", samlResponseEncoded);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertNull((Object)logoutResponse.getIssuer());
    }

    @Test
    public void testGetIssueInstant() throws IOException, SAMLSevereException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("/", samlResponseEncoded);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertEquals((Object)"2013-12-10T04:39:31Z", (Object)Util.formatDateTime((long)logoutResponse.getIssueInstant().getTimeInMillis()));
    }

    @Test
    public void testGetIssueInstantOutgoingMessage() throws IOException, SAMLSevereException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        long start = System.currentTimeMillis();
        LogoutResponse logoutResponse = new LogoutResponse(settings, new LogoutResponseParams());
        long end = System.currentTimeMillis();
        Calendar issueInstant = logoutResponse.getIssueInstant();
        Assert.assertNotNull((Object)issueInstant);
        long millis = issueInstant.getTimeInMillis();
        Assert.assertTrue((millis >= start && millis <= end ? 1 : 0) != 0);
    }

    @Test
    public void testGetIssueInstantOutgoingMessageLegacy() throws IOException, SAMLSevereException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        LogoutResponse logoutResponse = new LogoutResponse(settings, new LogoutResponseParams());
        long start = System.currentTimeMillis();
        logoutResponse.build();
        long end = System.currentTimeMillis();
        Calendar issueInstant = logoutResponse.getIssueInstant();
        Assert.assertNotNull((Object)issueInstant);
        long millis = issueInstant.getTimeInMillis();
        Assert.assertTrue((millis >= start && millis <= end ? 1 : 0) != 0);
    }

    @Test
    public void testGetIssuerTrimming() throws SAMLSevereException, IOException, XPathExpressionException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response_with_whitespace.xml.base64");
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("/", samlResponseEncoded);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertEquals((Object)"\n    \thttp://idp.example.com/\n    ", (Object)logoutResponse.getIssuer());
        settings.setTrimNameIds(true);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)logoutResponse.getIssuer());
    }

    @Test
    public void testIsValidNoResponse() throws XMLSecurityException, IOException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("/", "");
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"SAML Logout Response is not loaded", (Object)logoutResponse.getError());
        httpRequest = new HttpRequest("/", (String)null);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"SAML Logout Response is not loaded", (Object)logoutResponse.getError());
    }

    @Test
    public void testIsInValidRequestId() throws XMLSecurityException, IOException, URISyntaxException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String requestURL = "http://stuff.com/endpoints/endpoints/sls.php";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("http://stuff.com/endpoints/endpoints/sls.php", samlResponseEncoded);
        settings.setStrict(false);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        Assert.assertTrue((boolean)logoutResponse.isValid("invalid_request_id"));
        settings.setStrict(true);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        Assert.assertFalse((boolean)logoutResponse.isValid("invalid_request_id"));
        Assert.assertThat((Object)logoutResponse.getError(), (Matcher)CoreMatchers.containsString((String)"The InResponseTo of the Logout Response"));
    }

    @Test
    public void testIsInValidIssuer() throws XMLSecurityException, IOException, URISyntaxException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/invalids/invalid_issuer.xml.base64");
        String requestURL = "http://stuff.com/endpoints/endpoints/sls.php";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("http://stuff.com/endpoints/endpoints/sls.php", samlResponseEncoded);
        settings.setStrict(false);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        settings.setStrict(true);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"Invalid issuer in the Logout Response. Was 'http://invalid.example.com/', but expected 'http://idp.example.com/'", (Object)logoutResponse.getError());
    }

    @Test
    public void testIsInValidWrongXML() throws XMLSecurityException, IOException, URISyntaxException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/invalids/invalid_xml.xml.base64");
        String requestURL = "http://stuff.com/endpoints/endpoints/sls.php";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("http://stuff.com/endpoints/endpoints/sls.php", samlResponseEncoded);
        settings.setWantXMLValidation(true);
        settings.setStrict(false);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        settings.setStrict(true);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"Invalid SAML Logout Response. Not match the saml-schema-protocol-2.0.xsd", (Object)logoutResponse.getError());
        settings.setWantXMLValidation(false);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        settings.setStrict(false);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
    }

    @Test
    public void testIsInValidDestination() throws XMLSecurityException, IOException, URISyntaxException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("/", samlResponseEncoded);
        settings.setStrict(false);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        settings.setStrict(true);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertThat((Object)logoutResponse.getError(), (Matcher)CoreMatchers.containsString((String)"The LogoutResponse was received at"));
    }

    @Test
    public void testIsValid() throws URISyntaxException, IOException, XMLSecurityException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest(requestURL, samlResponseEncoded);
        settings.setStrict(true);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        settings.setStrict(false);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        requestURL = "http://stuff.com/endpoints/endpoints/sls.php";
        httpRequest = LogoutResponseTest.newHttpRequest(requestURL, samlResponseEncoded);
        settings.setStrict(true);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        settings.setStrict(false);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
    }

    @Test
    public void testIsInValidSign_defaultUrlEncode() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.knownIdpPrivateKey.properties").build();
        settings.setStrict(true);
        settings.setWantMessagesSigned(true);
        String requestURL = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls";
        String samlResponseEncoded = "fZJva8IwEMa/Ssl7TZrW/gnqGHMMwSlM8cXeyLU9NaxNQi9lfvxVZczB5ptwSe733MPdjQma2qmFPdjOvyE5awiDU1MbUpevCetaoyyQJmWgQVK+VOvH14WSQ6Fca70tbc1ukPsEEGHrtTUsmM8mbDfKUhnFci8gliGINI/yXIAAiYnsw6JIRgWWAKlkwRZb6skJ64V6nKjDuSEPxvdPIowHIhpIsQkTFaYqSt9ZMEPy2oC/UEfvHSnOnfZFV38MjR1oN7TtgRv8tAZre9CGV9jYkGtT4Wnoju6Bauprme/ebOyErZbPi9XLfLnDoohwhHGc5WVSVhjCKM6rBMpYQpWJrIizfZ4IZNPxuTPqYrmd/m+EdONqPOfy8yG5rhxv0EMFHs52xvxWaHyd3tqD7+j37clWGGyh7vD+POiSrdZdWSIR49NrhR9R/teGTL8A";
        String relayState = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php";
        String sigAlg = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        String queryString = "SAMLResponse=" + Util.urlEncoder((String)samlResponseEncoded);
        queryString = queryString + "&RelayState=" + Util.urlEncoder((String)relayState);
        queryString = queryString + "&SigAlg=" + Util.urlEncoder((String)sigAlg);
        String signature = "czxEy2WDRZS1U4b2PQFpE4KRhRs8jt5bBKdTFx5oIXpte6qtm0Lk/5lzw/2S6Y1NJpj5DJvSLJvylgNE+RYfJR1GX0zQplm2dZYtlo7CZUyfS3JCLsWviEtPXaon+8Z0lQQkPt4yxCf9v8Qd0pvxHglTUCK/sU0NXnZQdpSxxfsaNCcjQf5gTg/gj8oI7xdrnamBPFtsaH6tAirkjGMoYS4Otju3mcrdcNBIHG40wrffUDnE83Jw4AOFCp8Vsf0zPTQOQsxS4HF4VS78OvGn7jLi2MdabeAQcK5+tP3mUB4vO8AAt8QbkEEiWQbcvA9i1Ezma92CdNYgaf4B3JYpPA==";
        HttpRequest httpRequest = new HttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls", queryString).addParameter("SAMLResponse", samlResponseEncoded).addParameter("RelayState", relayState).addParameter("SigAlg", sigAlg).addParameter("Signature", signature);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"Signature validation failed. Logout Response rejected", (Object)logoutResponse.getError());
    }

    @Test
    public void testIsInValidSign_naiveUrlEncoding() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.knownIdpPrivateKey.properties").build();
        settings.setStrict(true);
        settings.setWantMessagesSigned(true);
        String requestURL = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls";
        String samlResponseEncoded = "fZJva8IwEMa/Ssl7TZrW/gnqGHMMwSlM8cXeyLU9NaxNQi9lfvxVZczB5ptwSe733MPdjQma2qmFPdjOvyE5awiDU1MbUpevCetaoyyQJmWgQVK+VOvH14WSQ6Fca70tbc1ukPsEEGHrtTUsmM8mbDfKUhnFci8gliGINI/yXIAAiYnsw6JIRgWWAKlkwRZb6skJ64V6nKjDuSEPxvdPIowHIhpIsQkTFaYqSt9ZMEPy2oC/UEfvHSnOnfZFV38MjR1oN7TtgRv8tAZre9CGV9jYkGtT4Wnoju6Bauprme/ebOyErZbPi9XLfLnDoohwhHGc5WVSVhjCKM6rBMpYQpWJrIizfZ4IZNPxuTPqYrmd/m+EdONqPOfy8yG5rhxv0EMFHs52xvxWaHyd3tqD7+j37clWGGyh7vD+POiSrdZdWSIR49NrhR9R/teGTL8A";
        String relayState = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php";
        String sigAlg = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        String queryString = "SAMLResponse=" + NaiveUrlEncoder.encode(samlResponseEncoded);
        queryString = queryString + "&RelayState=" + NaiveUrlEncoder.encode(relayState);
        queryString = queryString + "&SigAlg=" + NaiveUrlEncoder.encode(sigAlg);
        String signature = "eSoTB+0GA/HfncASEFk7ONHbB3+9YrOBgK9xUyRoCDY97oXw49JYoXOL07kHrVvbngKmKFNx5fnYtDaL8WCe5LfRRgjJz1LLacriHn2ggeMmY/fTaXPoy2zQW0Fv1H362QXicTWQXgWFS5cJAIcBa2I7TLgNwXsMgjdBF2hyacW0IwfkAceGiBwDDTy6XIBAZk2Ff7w5lbZh+fa5JLNKrbvoveJk2NS3KK6INYO7UW5hukWz2cpzbHsx9lfxUJi8/ZCwUtFWZ4rdXVN+Qiw5y8S2eE2BIEfFmz7IfvrMRXa2la/rXFQfmteQo+N1sO3K1YZyoT/aA3k36glXvnj3kw==";
        HttpRequest httpRequest = new HttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls", queryString).addParameter("SAMLResponse", samlResponseEncoded).addParameter("RelayState", relayState).addParameter("SigAlg", sigAlg).addParameter("Signature", signature);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"Signature validation failed. Logout Response rejected", (Object)logoutResponse.getError());
    }

    @Test
    public void testIsInValidSign() throws URISyntaxException, IOException, XMLSecurityException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setStrict(false);
        settings.setWantMessagesSigned(true);
        String requestURL = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls";
        String samlResponseEncoded = "fZJva8IwEMa/Ssl7TZrW/gnqGHMMwSlM8cXeyLU9NaxNQi9lfvxVZczB5ptwSe733MPdjQma2qmFPdjOvyE5awiDU1MbUpevCetaoyyQJmWgQVK+VOvH14WSQ6Fca70tbc1ukPsEEGHrtTUsmM8mbDfKUhnFci8gliGINI/yXIAAiYnsw6JIRgWWAKlkwRZb6skJ64V6nKjDuSEPxvdPIowHIhpIsQkTFaYqSt9ZMEPy2oC/UEfvHSnOnfZFV38MjR1oN7TtgRv8tAZre9CGV9jYkGtT4Wnoju6Bauprme/ebOyErZbPi9XLfLnDoohwhHGc5WVSVhjCKM6rBMpYQpWJrIizfZ4IZNPxuTPqYrmd/m+EdONqPOfy8yG5rhxv0EMFHs52xvxWaHyd3tqD7+j37clWGGyh7vD+POiSrdZdWSIR49NrhR9R/teGTL8A";
        String relayState = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php";
        String sigAlg = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String signature = "vfWbbc47PkP3ejx4bjKsRX7lo9Ml1WRoE5J5owF/0mnyKHfSY6XbhO1wwjBV5vWdrUVX+xp6slHyAf4YoAsXFS0qhan6txDiZY4Oec6yE+l10iZbzvie06I4GPak4QrQ4gAyXOSzwCrRmJu4gnpeUxZ6IqKtdrKfAYRAcVfNKGA=";
        HttpRequest httpRequest = new HttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls", (String)null).addParameter("SAMLResponse", samlResponseEncoded).addParameter("RelayState", relayState).addParameter("SigAlg", sigAlg).addParameter("Signature", signature);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        settings.setStrict(true);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        settings.setStrict(false);
        String signature2 = "vfWbbc47PkP3ejx4bjKsRX7lo9Ml1WRoE5J5owF/0mnyKHfSY6XbhO1wwjBV5vWdrUVX+xp6slHyAf4YoAsXFS0qhan6txDiZY4Oec6yE+l10iZbzvie06I4GPak4QrQ4gAyXOSzwCrRmJu4gnpeUxZ6IqKtdrKfAYRAcVf3333=";
        httpRequest = httpRequest.removeParameter("Signature").addParameter("Signature", signature2);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"Signature validation failed. Logout Response rejected", (Object)logoutResponse.getError());
        httpRequest = httpRequest.removeParameter("Signature").addParameter("Signature", signature).removeParameter("SigAlg");
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        httpRequest = httpRequest.removeParameter("Signature");
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        settings.setStrict(true);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"The Message of the Logout Response is not signed and the SP requires it", (Object)logoutResponse.getError());
        httpRequest = httpRequest.addParameter("Signature", signature);
        settings = new SettingsBuilder().fromFile("config/config.mywithnocert.properties").build();
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"In order to validate the sign on the Logout Response, the x509cert of the IdP is required", (Object)logoutResponse.getError());
    }

    @Test
    public void testIsInValidSignWithDeprecatedAlg() throws URISyntaxException, IOException, XMLSecurityException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setStrict(false);
        settings.setWantMessagesSigned(true);
        String requestURL = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls";
        String samlResponseEncoded = "fZJva8IwEMa/Ssl7TZrW/gnqGHMMwSlM8cXeyLU9NaxNQi9lfvxVZczB5ptwSe733MPdjQma2qmFPdjOvyE5awiDU1MbUpevCetaoyyQJmWgQVK+VOvH14WSQ6Fca70tbc1ukPsEEGHrtTUsmM8mbDfKUhnFci8gliGINI/yXIAAiYnsw6JIRgWWAKlkwRZb6skJ64V6nKjDuSEPxvdPIowHIhpIsQkTFaYqSt9ZMEPy2oC/UEfvHSnOnfZFV38MjR1oN7TtgRv8tAZre9CGV9jYkGtT4Wnoju6Bauprme/ebOyErZbPi9XLfLnDoohwhHGc5WVSVhjCKM6rBMpYQpWJrIizfZ4IZNPxuTPqYrmd/m+EdONqPOfy8yG5rhxv0EMFHs52xvxWaHyd3tqD7+j37clWGGyh7vD+POiSrdZdWSIR49NrhR9R/teGTL8A";
        String relayState = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php";
        String sigAlg = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String signature = "vfWbbc47PkP3ejx4bjKsRX7lo9Ml1WRoE5J5owF/0mnyKHfSY6XbhO1wwjBV5vWdrUVX+xp6slHyAf4YoAsXFS0qhan6txDiZY4Oec6yE+l10iZbzvie06I4GPak4QrQ4gAyXOSzwCrRmJu4gnpeUxZ6IqKtdrKfAYRAcVfNKGA=";
        HttpRequest httpRequest = new HttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls", (String)null).addParameter("SAMLResponse", samlResponseEncoded).addParameter("RelayState", relayState).addParameter("SigAlg", sigAlg).addParameter("Signature", signature);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertTrue((boolean)logoutResponse.isValid());
        settings.setRejectDeprecatedAlg(true);
        LogoutResponse logoutResponse2 = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse2.isValid());
    }

    @Test
    public void testIsValidNoLogoutResponse() throws IOException, XMLSecurityException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("/", "");
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertFalse((boolean)logoutResponse.isValid());
        Assert.assertEquals((Object)"SAML Logout Response is not loaded", (Object)logoutResponse.getError());
    }

    @Test
    public void testGetError() throws URISyntaxException, IOException, XMLSecurityException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        settings.setStrict(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/logout_responses/logout_response_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutResponseTest.newHttpRequest("/", samlResponseEncoded);
        LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertNull((Object)logoutResponse.getError());
        Assert.assertNull((Object)logoutResponse.getValidationException());
        logoutResponse.isValid();
        Assert.assertThat((Object)logoutResponse.getError(), (Matcher)CoreMatchers.containsString((String)"The LogoutResponse was received at"));
        Assert.assertTrue((boolean)(logoutResponse.getValidationException() instanceof ValidationException));
        settings.setStrict(false);
        logoutResponse = new LogoutResponse(settings, httpRequest);
        Assert.assertNull((Object)logoutResponse.getError());
        Assert.assertNull((Object)logoutResponse.getValidationException());
        logoutResponse.isValid();
        Assert.assertNull((Object)logoutResponse.getError());
        Assert.assertNull((Object)logoutResponse.getValidationException());
    }

    private static HttpRequest newHttpRequest(String requestURL, String samlResponseEncoded) {
        return new HttpRequest(requestURL, (String)null).addParameter("SAMLResponse", samlResponseEncoded);
    }

    @Test
    public void testPostProcessXml() throws Exception {
        final Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        final LogoutResponseParams params = new LogoutResponseParams();
        LogoutResponse logoutResponse = new LogoutResponse(settings, params){

            protected String postProcessXml(String logoutResponseXml, LogoutResponseParams par, Saml2Settings sett) {
                Assert.assertEquals((Object)logoutResponseXml, (Object)super.postProcessXml(logoutResponseXml, par, sett));
                Assert.assertSame((Object)settings, (Object)sett);
                Assert.assertSame((Object)params, (Object)par);
                return "changed";
            }
        };
        Assert.assertEquals((Object)"changed", (Object)logoutResponse.getLogoutResponseXml());
    }

    @Test
    public void testPostProcessXmlLegacy() throws Exception {
        final Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        LogoutResponse logoutResponse = new LogoutResponse(settings, null){

            protected String postProcessXml(String logoutResponseXml, LogoutResponseParams params, Saml2Settings sett) {
                Assert.assertEquals((Object)logoutResponseXml, (Object)super.postProcessXml(logoutResponseXml, params, sett));
                Assert.assertSame((Object)settings, (Object)sett);
                Assert.assertNull((Object)params.getInResponseTo());
                SamlResponseStatus responseStatus = params.getResponseStatus();
                Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:status:Success", (Object)responseStatus.getStatusCode());
                Assert.assertNull((Object)responseStatus.getSubStatusCode());
                Assert.assertNull((Object)responseStatus.getStatusMessage());
                return "changed";
            }
        };
        logoutResponse.build();
        Assert.assertEquals((Object)"changed", (Object)logoutResponse.getLogoutResponseXml());
    }
}

