/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.test.logout;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.codelibs.saml2.core.exception.SAMLSevereException;
import org.codelibs.saml2.core.exception.SettingsException;
import org.codelibs.saml2.core.exception.ValidationException;
import org.codelibs.saml2.core.http.HttpRequest;
import org.codelibs.saml2.core.logout.LogoutRequest;
import org.codelibs.saml2.core.logout.LogoutRequestParams;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.settings.SettingsBuilder;
import org.codelibs.saml2.core.test.NaiveUrlEncoder;
import org.codelibs.saml2.core.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.w3c.dom.Document;

public class LogoutRequestTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testGetEncodedLogoutRequestSimulated() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        final String logoutRequestString = Util.getFileAsString((String)"data/logout_requests/logout_request.xml");
        LogoutRequest logoutRequest = new LogoutRequest(settings){

            public String getLogoutRequestXml() {
                return logoutRequestString;
            }
        };
        String expectedLogoutRequestStringBase64Deflated = Util.getFileAsString((String)"data/logout_requests/logout_request_deflated.xml.base64");
        String expectedLogoutRequestStringBase64 = Util.getFileAsString((String)"data/logout_requests/logout_request.xml.base64");
        String logoutRequestStringBase64Deflated = logoutRequest.getEncodedLogoutRequest();
        Assert.assertEquals((Object)logoutRequestStringBase64Deflated, (Object)expectedLogoutRequestStringBase64Deflated);
        logoutRequestStringBase64Deflated = logoutRequest.getEncodedLogoutRequest(null);
        Assert.assertEquals((Object)logoutRequestStringBase64Deflated, (Object)expectedLogoutRequestStringBase64Deflated);
        logoutRequestStringBase64Deflated = logoutRequest.getEncodedLogoutRequest(Boolean.valueOf(true));
        Assert.assertEquals((Object)logoutRequestStringBase64Deflated, (Object)expectedLogoutRequestStringBase64Deflated);
        logoutRequestStringBase64Deflated = logoutRequest.getEncodedLogoutRequest(Boolean.valueOf(false));
        Assert.assertNotEquals((Object)logoutRequestStringBase64Deflated, (Object)expectedLogoutRequestStringBase64Deflated);
        Assert.assertEquals((Object)logoutRequestStringBase64Deflated, (Object)expectedLogoutRequestStringBase64);
        settings.setCompressRequest(true);
        logoutRequest = new LogoutRequest(settings){

            public String getLogoutRequestXml() {
                return logoutRequestString;
            }
        };
        logoutRequestStringBase64Deflated = logoutRequest.getEncodedLogoutRequest(null);
        Assert.assertEquals((Object)logoutRequestStringBase64Deflated, (Object)expectedLogoutRequestStringBase64Deflated);
        settings.setCompressRequest(false);
        logoutRequest = new LogoutRequest(settings){

            public String getLogoutRequestXml() {
                return logoutRequestString;
            }
        };
        logoutRequestStringBase64Deflated = logoutRequest.getEncodedLogoutRequest(null);
        Assert.assertNotEquals((Object)logoutRequestStringBase64Deflated, (Object)expectedLogoutRequestStringBase64Deflated);
        Assert.assertEquals((Object)logoutRequestStringBase64Deflated, (Object)expectedLogoutRequestStringBase64);
    }

    @Test
    public void testConstructor() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        LogoutRequest logoutRequest = new LogoutRequest(settings);
        String logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        String logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)("ID=\"" + logoutRequest.getId() + "\"")));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:SessionIndex>")));
    }

    @Test
    public void testConstructorWithRequest() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String requestURL = "/";
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/logout_request_deflated.xml.base64");
        LogoutRequest logoutRequest = new LogoutRequest(settings, LogoutRequestTest.newHttpRequest("/", samlRequestEncoded));
        String logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        String logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
    }

    @Test
    public void testConstructorWithSessionIndex() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String sessionIndex = "_51be37965feb5579d803141076936dc2e9d1d98ebf";
        LogoutRequest logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(sessionIndex, null));
        String logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        String logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        String expectedSessionIndex = "<samlp:SessionIndex>_51be37965feb5579d803141076936dc2e9d1d98ebf</samlp:SessionIndex>";
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)expectedSessionIndex));
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, null));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:SessionIndex>")));
    }

    @Test
    public void testConstructorWithSessionIndexSpecialChars() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String sessionIndex = "_51be37965feb5579d803141076936dc2e9d1d98ebf&";
        LogoutRequest logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(sessionIndex, null));
        String logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        String logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        String expectedSessionIndex = "<samlp:SessionIndex>_51be37965feb5579d803141076936dc2e9d1d98ebf&amp;</samlp:SessionIndex>";
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)expectedSessionIndex));
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, null));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:SessionIndex>")));
    }

    @Test
    public void testConstructorWithEncryptedNameID() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        LogoutRequest logoutRequest = new LogoutRequest(settings);
        String logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        String logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:EncryptedID><xenc:EncryptedData"));
        settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        logoutRequest = new LogoutRequest(settings);
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<saml:EncryptedID><xenc:EncryptedData")));
    }

    @Test
    public void testGetLogoutRequestXml() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        LogoutRequest logoutRequest = new LogoutRequest(settings);
        String logoutRequestXML = logoutRequest.getLogoutRequestXml();
        Assert.assertThat((Object)logoutRequestXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        Assert.assertThat((Object)logoutRequestXML, (Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php\""));
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/logout_request.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest(requestURL, samlRequestEncoded);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        logoutRequestXML = logoutRequest.getLogoutRequestXml();
        Assert.assertThat((Object)logoutRequestXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
    }

    @Test
    public void testGetLogoutRequestXmlSpecialChars() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_specialchars.properties").build();
        LogoutRequest logoutRequest = new LogoutRequest(settings);
        String logoutRequestXML = logoutRequest.getLogoutRequestXml();
        Assert.assertThat((Object)logoutRequestXML, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        Assert.assertThat((Object)logoutRequestXML, (Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SingleLogoutService.php?a=1&amp;b=2\""));
    }

    @Test
    public void testGetNameIdData() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        LogoutRequest logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, "ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        String logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        String logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        String nameIdDataStr = LogoutRequest.getNameIdData((String)logoutRequestStr, null).toString();
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Value=ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SPNameQualifier")));
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, null));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        nameIdDataStr = LogoutRequest.getNameIdData((String)logoutRequestStr, null).toString();
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Format=urn:oasis:names:tc:SAML:2.0:nameid-format:entity"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Value=http://idp.example.com/"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SPNameQualifier=http://localhost:8080/java-saml-jspsample/metadata.jsp")));
        settings = new SettingsBuilder().fromFile("config/config.samecerts.properties").build();
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, "ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        PrivateKey key = settings.getSPkey();
        nameIdDataStr = LogoutRequest.getNameIdData((String)logoutRequestStr, (PrivateKey)key).toString();
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Value=ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SPNameQualifier")));
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, "ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c", "urn:oasis:names:tc:SAML:2.0:nameid-format:emailAddress"));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        nameIdDataStr = LogoutRequest.getNameIdData((String)logoutRequestStr, (PrivateKey)key).toString();
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"urn:oasis:names:tc:SAML:2.0:nameid-format:emailAddress"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Value=ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SPNameQualifier")));
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        key = Util.loadPrivateKey((String)keyString);
        logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_encrypted_nameid.xml");
        nameIdDataStr = LogoutRequest.getNameIdData((String)logoutRequestStr, (PrivateKey)key).toString();
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Format=urn:oasis:names:tc:SAML:2.0:nameid-format:emailAddress"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Value=ONELOGIN_9c86c4542ab9d6fce07f2f7fd335287b9b3cdf69"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"SPNameQualifier=https://pitbulk.no-ip.org/newonelogin/demo1/metadata.php"));
        settings = new SettingsBuilder().fromFile("config/config.emailaddressformat.properties").build();
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, "ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        nameIdDataStr = LogoutRequest.getNameIdData((String)logoutRequestStr, null).toString();
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Value=ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Format=urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SPNameQualifier")));
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, "ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c", "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", settings.getIdpEntityId(), settings.getSpEntityId()));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        nameIdDataStr = LogoutRequest.getNameIdData((String)logoutRequestStr, null).toString();
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Value=ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Format=urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)("NameQualifier=" + settings.getIdpEntityId())));
        Assert.assertThat((Object)nameIdDataStr, (Matcher)CoreMatchers.containsString((String)("SPNameQualifier=" + settings.getSpEntityId())));
    }

    @Test
    public void testGetNameIdDataSpecialChars() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_specialchars.properties").build();
        LogoutRequest logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, "<ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c>"));
        String logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        String logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:NameID>&lt;ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c&gt;</saml:NameID>"));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SPNameQualifier")));
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, null));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:NameID Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:entity\">http://idp.example.com/?a=1&amp;b=2</saml:NameID>"));
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SPNameQualifier")));
    }

    @Test
    public void testGetId() throws Exception {
        String samlRequest = Util.getFileAsString((String)"data/logout_requests/logout_request.xml");
        String id = LogoutRequest.getId((String)samlRequest);
        String expectedId = "ONELOGIN_21584ccdfaca36a145ae990442dcd96bfe60151e";
        Assert.assertEquals((Object)expectedId, (Object)id);
        Document samlRequestDoc = Util.loadXML((String)samlRequest);
        id = LogoutRequest.getId((Document)samlRequestDoc);
        Assert.assertEquals((Object)expectedId, (Object)id);
        Assert.assertNull((Object)LogoutRequest.getId((String)""));
    }

    @Test
    public void testGetIssueInstant() throws Exception {
        String samlRequest = Util.getFileAsString((String)"data/logout_requests/logout_request.xml");
        Calendar issueInstant = LogoutRequest.getIssueInstant((String)samlRequest);
        String expectedIssueInstant = "2013-12-10T04:39:31Z";
        Assert.assertEquals((Object)expectedIssueInstant, (Object)Util.formatDateTime((long)issueInstant.getTimeInMillis()));
        Document samlRequestDoc = Util.loadXML((String)samlRequest);
        issueInstant = LogoutRequest.getIssueInstant((Document)samlRequestDoc);
        Assert.assertEquals((Object)expectedIssueInstant, (Object)Util.formatDateTime((long)issueInstant.getTimeInMillis()));
        Assert.assertNull((Object)LogoutRequest.getIssueInstant((String)""));
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/logout_request.xml.base64");
        String requestURL = "http://stuff.com/endpoints/endpoints/sls.php";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest("http://stuff.com/endpoints/endpoints/sls.php", samlRequestEncoded);
        issueInstant = new LogoutRequest(settings, httpRequest).getIssueInstant();
        Assert.assertEquals((Object)expectedIssueInstant, (Object)Util.formatDateTime((long)issueInstant.getTimeInMillis()));
    }

    @Test
    public void testGetIssueInstantBuiltMessage() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        long start = System.currentTimeMillis();
        LogoutRequest logoutRequest = new LogoutRequest(settings);
        long end = System.currentTimeMillis();
        Calendar issueInstant = logoutRequest.getIssueInstant();
        Assert.assertNotNull((Object)issueInstant);
        long millis = issueInstant.getTimeInMillis();
        Assert.assertTrue((millis >= start && millis <= end ? 1 : 0) != 0);
    }

    @Test
    public void testGetNameIdDataNoKey() throws Exception {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_encrypted_nameid.xml");
        this.expectedEx.expect(SettingsException.class);
        this.expectedEx.expectMessage("Key is required in order to decrypt the NameID");
        LogoutRequest.getNameIdData((String)logoutRequestStr, null).toString();
    }

    @Test
    public void testGetNameIdDataWrongKey() throws Exception {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_encrypted_nameid.xml");
        String keyString = Util.getFileAsString((String)"data/misc/sp4.key");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        this.expectedEx.expect(Exception.class);
        this.expectedEx.expectMessage("Not able to decrypt the EncryptedID and get a NameID");
        LogoutRequest.getNameIdData((String)logoutRequestStr, (PrivateKey)key).toString();
    }

    @Test
    public void testGetNameIdDataNoNameId() throws Exception {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_no_nameid.xml");
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("No name id found in Logout Request.");
        LogoutRequest.getNameIdData((String)logoutRequestStr, null).toString();
    }

    @Test
    public void testGetNameIdDataTrimming() throws Exception {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_with_whitespace.xml");
        Map nameIdData = LogoutRequest.getNameIdData((String)logoutRequestStr, null, (boolean)true);
        Assert.assertEquals((Object)"ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c", nameIdData.get("Value"));
        nameIdData = LogoutRequest.getNameIdData((String)logoutRequestStr, null, (boolean)false);
        Assert.assertEquals((Object)"\n\t\tONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c\n\t", nameIdData.get("Value"));
    }

    @Test
    public void testGetNameId() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        LogoutRequest logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, "ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        String logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        String logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        String expectedNameIdStr = "ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c";
        String nameIdStr = LogoutRequest.getNameId((String)logoutRequestStr, null).toString();
        Assert.assertEquals((Object)expectedNameIdStr, (Object)nameIdStr);
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, null));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        Assert.assertThat((Object)logoutRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:LogoutRequest"));
        expectedNameIdStr = "http://idp.example.com/";
        nameIdStr = LogoutRequest.getNameId((String)logoutRequestStr, null).toString();
        Assert.assertEquals((Object)expectedNameIdStr, (Object)nameIdStr);
        nameIdStr = LogoutRequest.getNameId((String)logoutRequestStr).toString();
        Assert.assertEquals((Object)expectedNameIdStr, (Object)nameIdStr);
        Document logoutRequestDoc = Util.loadXML((String)logoutRequestStr);
        nameIdStr = LogoutRequest.getNameId((Document)logoutRequestDoc).toString();
        Assert.assertEquals((Object)expectedNameIdStr, (Object)nameIdStr);
        settings = new SettingsBuilder().fromFile("config/config.samecerts.properties").build();
        logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(null, "ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c"));
        logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        PrivateKey key = settings.getSPkey();
        nameIdStr = LogoutRequest.getNameId((String)logoutRequestStr, (PrivateKey)key).toString();
        expectedNameIdStr = "ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c";
        Assert.assertEquals((Object)expectedNameIdStr, (Object)nameIdStr);
        String keyString = Util.getFileAsString((String)"data/customPath/certs/sp.pem");
        key = Util.loadPrivateKey((String)keyString);
        logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_encrypted_nameid.xml");
        nameIdStr = LogoutRequest.getNameId((String)logoutRequestStr, (PrivateKey)key).toString();
        expectedNameIdStr = "ONELOGIN_9c86c4542ab9d6fce07f2f7fd335287b9b3cdf69";
        Assert.assertEquals((Object)expectedNameIdStr, (Object)nameIdStr);
        logoutRequestDoc = Util.loadXML((String)logoutRequestStr);
        nameIdStr = LogoutRequest.getNameId((Document)logoutRequestDoc, (PrivateKey)key).toString();
        Assert.assertEquals((Object)expectedNameIdStr, (Object)nameIdStr);
    }

    @Test
    public void testGetNameIdNoKey() throws Exception {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_encrypted_nameid.xml");
        this.expectedEx.expect(SettingsException.class);
        this.expectedEx.expectMessage("Key is required in order to decrypt the NameID");
        LogoutRequest.getNameId((String)logoutRequestStr, null).toString();
    }

    @Test
    public void testGetNameIdWrongKey() throws Exception {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_encrypted_nameid.xml");
        String keyString = Util.getFileAsString((String)"data/misc/sp4.key");
        PrivateKey key = Util.loadPrivateKey((String)keyString);
        this.expectedEx.expect(Exception.class);
        this.expectedEx.expectMessage("Not able to decrypt the EncryptedID and get a NameID");
        LogoutRequest.getNameIdData((String)logoutRequestStr, (PrivateKey)key).toString();
    }

    @Test
    public void testGetNameIdTrimming() throws Exception {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_with_whitespace.xml");
        String nameId = LogoutRequest.getNameId((String)logoutRequestStr, null, (boolean)true);
        Assert.assertEquals((Object)"ONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c", (Object)nameId);
        nameId = LogoutRequest.getNameId((String)logoutRequestStr, null, (boolean)false);
        Assert.assertEquals((Object)"\n\t\tONELOGIN_1e442c129e1f822c8096086a1103c5ee2c7cae1c\n\t", (Object)nameId);
    }

    @Test
    public void testGetIssuer() throws URISyntaxException, IOException, XPathExpressionException {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request.xml");
        String expectedIssuer = "http://idp.example.com/";
        String issuer = LogoutRequest.getIssuer((String)logoutRequestStr);
        Assert.assertEquals((Object)expectedIssuer, (Object)issuer);
        logoutRequestStr = logoutRequestStr.replace("<saml:Issuer>http://idp.example.com/</saml:Issuer>", "");
        issuer = LogoutRequest.getIssuer((String)logoutRequestStr);
        Assert.assertNull((Object)issuer);
    }

    @Test
    public void testGetIssuerTrimming() throws URISyntaxException, IOException, XPathExpressionException {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_with_whitespace.xml");
        String issuer = LogoutRequest.getIssuer((String)logoutRequestStr, (boolean)true);
        Assert.assertEquals((Object)"http://idp.example.com/", (Object)issuer);
        issuer = LogoutRequest.getIssuer((String)logoutRequestStr, (boolean)false);
        Assert.assertEquals((Object)"\n    \thttp://idp.example.com/\n    ", (Object)issuer);
    }

    @Test
    public void testGetSessionIndexes() throws URISyntaxException, IOException, XPathExpressionException, XMLSecurityException, SAMLSevereException {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request.xml");
        ArrayList<String> expectedIndexes = new ArrayList<String>();
        List indexes = LogoutRequest.getSessionIndexes((String)logoutRequestStr);
        Assert.assertEquals(expectedIndexes, (Object)indexes);
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String sessionIndex = "_51be37965feb5579d803141076936dc2e9d1d98ebf";
        expectedIndexes.add(sessionIndex);
        LogoutRequest logoutRequest = new LogoutRequest(settings, new LogoutRequestParams(sessionIndex, null));
        String logoutRequestStringBase64 = logoutRequest.getEncodedLogoutRequest();
        logoutRequestStr = Util.base64decodedInflated((String)logoutRequestStringBase64);
        indexes = LogoutRequest.getSessionIndexes((String)logoutRequestStr);
        Assert.assertEquals(expectedIndexes, (Object)indexes);
    }

    @Test
    public void testGetSessionIndexesTrimming() throws IOException, XPathExpressionException {
        String logoutRequestStr = Util.getFileAsString((String)"data/logout_requests/logout_request_with_whitespace.xml");
        List indexes = LogoutRequest.getSessionIndexes((String)logoutRequestStr, (boolean)true);
        Assert.assertEquals(Arrays.asList("_ac72a76526cb6ca19f8438e73879a0e6c8ae5131"), (Object)indexes);
        indexes = LogoutRequest.getSessionIndexes((String)logoutRequestStr, (boolean)false);
        Assert.assertEquals(Arrays.asList("\n\t\t_ac72a76526cb6ca19f8438e73879a0e6c8ae5131\n\t"), (Object)indexes);
    }

    @Test
    public void testIsInvalidIssuer() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/invalids/invalid_issuer.xml.base64");
        String requestURL = "http://stuff.com/endpoints/endpoints/sls.php";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest("http://stuff.com/endpoints/endpoints/sls.php", samlRequestEncoded);
        settings.setStrict(false);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setStrict(true);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"Invalid issuer in the Logout Request. Was 'https://example.hello.com/access/saml', but expected 'http://idp.example.com/'", (Object)logoutRequest.getError());
    }

    @Test
    public void testIsInValidWrongXML() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/invalids/invalid_xml.xml.base64");
        String requestURL = "http://stuff.com/endpoints/endpoints/sls.php";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest("http://stuff.com/endpoints/endpoints/sls.php", samlRequestEncoded);
        settings.setWantXMLValidation(true);
        settings.setStrict(false);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setStrict(true);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"Invalid SAML Logout Request. Not match the saml-schema-protocol-2.0.xsd", (Object)logoutRequest.getError());
        settings.setWantXMLValidation(false);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setStrict(false);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
    }

    @Test
    public void testIsInvalidDestination() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/logout_request_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest("/", samlRequestEncoded);
        settings.setStrict(false);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setStrict(true);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertThat((Object)logoutRequest.getError(), (Matcher)CoreMatchers.containsString((String)"The LogoutRequest was received at"));
    }

    @Test
    public void testIsInvalidNotOnOrAfter() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/invalids/not_after_failed.xml.base64");
        String requestURL = "http://stuff.com/endpoints/endpoints/sls.php";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest("http://stuff.com/endpoints/endpoints/sls.php", samlRequestEncoded);
        settings.setStrict(false);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setStrict(true);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"Could not validate timestamp: expired. Check system clock.", (Object)logoutRequest.getError());
    }

    @Test
    public void testIsValid() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/logout_request_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest(requestURL, samlRequestEncoded);
        settings.setStrict(true);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        settings.setStrict(false);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        requestURL = "http://stuff.com/endpoints/endpoints/sls.php";
        httpRequest = LogoutRequestTest.newHttpRequest(requestURL, samlRequestEncoded);
        settings.setStrict(true);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setStrict(false);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
    }

    @Test
    public void testIsInValidSign_defaultUrlEncode() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.knownIdpPrivateKey.properties").build();
        settings.setStrict(true);
        settings.setWantMessagesSigned(true);
        String requestURL = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls";
        String samlRequestEncoded = "lVLBitswEP0Vo7tjWbJkSyReFkIhsN1tm6WHvQTZHmdFbUmVZLqfXzlpIS10oZdhGM17b96MtkHNk5MP9myX+AW+LxBi9jZPJsjLyw4t3kirgg7SqBmCjL083n98kGSDpfM22t5O6AbyPkKFAD5qa1B22O/QSWA+EFWPjCtaM6gBugrXHCo6Ut6UgvTV2DSkBoKyr+BDQu5QIkrwEBY4mBCViamEyyrHNCf4ueSScMnIC8r2yY02Kl5QrzG6IIvC6dgt07eNsbl2G+vPhYEf1sBkz9oUA8y2LLQZ4G3jXt1dmALKHm18Mk/+fozgk5YQNMciJ+UzKWV11Wq3q3l5mcq3/9YKenYTrL3FGkihB1fMENWgoloVt8Ut0ZX1Me3xsM+On9bk86ImPep1kv+xdKuBsg/Wzyq+f6u1ood8vLTK6JUJGkxE7WnsSDcQRirOKMc97TtWCgqU1ZyJBvM+RZbSrv/l5mrg6sbJI4T1kId1ye0JhoaQgYg+XT1dnilMSZO4uko1jPSYVF0luqQjrmR/4X8X//jC7U8=";
        String relayState = "_1037fbc88ec82ce8e770b2bed1119747bb812a07e6";
        String sigAlg = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        String queryString = "SAMLRequest=" + Util.urlEncoder((String)samlRequestEncoded);
        queryString = queryString + "&RelayState=" + Util.urlEncoder((String)relayState);
        queryString = queryString + "&SigAlg=" + Util.urlEncoder((String)sigAlg);
        String signature = "27tdJT0kmletQ/fSUhB6Y8L0S6Y7pcZlGFvOCCVcqZZDyxlZBaCfmLlDXhB3/oJrWRn8injiY44h1BnCsughYQjTGBWZi175J9HA/dYhMZ+IFw9V/oUrRTY8/o9kFQSIefhQcJoegY2BvJVDSKeqYg2mCcQnItyceLhS1eiEQy0=";
        HttpRequest httpRequest = new HttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls").addParameter("SAMLRequest", samlRequestEncoded).addParameter("RelayState", relayState).addParameter("SigAlg", sigAlg).addParameter("Signature", signature);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"Signature validation failed. Logout Request rejected", (Object)logoutRequest.getError());
    }

    @Test
    public void testIsInValidSign_naiveUrlEncoding() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.knownIdpPrivateKey.properties").build();
        settings.setStrict(true);
        settings.setWantMessagesSigned(true);
        String requestURL = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls";
        String samlRequestEncoded = "lVLBitswEP0Vo7tjWbJkSyReFkIhsN1tm6WHvQTZHmdFbUmVZLqfXzlpIS10oZdhGM17b96MtkHNk5MP9myX+AW+LxBi9jZPJsjLyw4t3kirgg7SqBmCjL083n98kGSDpfM22t5O6AbyPkKFAD5qa1B22O/QSWA+EFWPjCtaM6gBugrXHCo6Ut6UgvTV2DSkBoKyr+BDQu5QIkrwEBY4mBCViamEyyrHNCf4ueSScMnIC8r2yY02Kl5QrzG6IIvC6dgt07eNsbl2G+vPhYEf1sBkz9oUA8y2LLQZ4G3jXt1dmALKHm18Mk/+fozgk5YQNMciJ+UzKWV11Wq3q3l5mcq3/9YKenYTrL3FGkihB1fMENWgoloVt8Ut0ZX1Me3xsM+On9bk86ImPep1kv+xdKuBsg/Wzyq+f6u1ood8vLTK6JUJGkxE7WnsSDcQRirOKMc97TtWCgqU1ZyJBvM+RZbSrv/l5mrg6sbJI4T1kId1ye0JhoaQgYg+XT1dnilMSZO4uko1jPSYVF0luqQjrmR/4X8X//jC7U8=";
        String relayState = "_1037fbc88ec82ce8e770b2bed1119747bb812a07e6";
        String sigAlg = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        String queryString = "SAMLRequest=" + NaiveUrlEncoder.encode(samlRequestEncoded);
        queryString = queryString + "&RelayState=" + NaiveUrlEncoder.encode(relayState);
        queryString = queryString + "&SigAlg=" + NaiveUrlEncoder.encode(sigAlg);
        String signatureNaiveEncoding = "j/qDRTzgQw3cMDkkSkBOShqxi3t9qJxYnrADqwAECnJ3Y+iYgT33C0l/Vy3+ooQkFRyObYJqg9o7iIcMdgV6CXxpa6itVIUAI2VJewsMjzvJ4OdpePeSx7+/umVPKCfMvffsELlqo/UgxsyRZh8NMLej0ojCB7bUfIMKsiU7e0c=";
        HttpRequest httpRequest = new HttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls", queryString).addParameter("SAMLRequest", samlRequestEncoded).addParameter("RelayState", relayState).addParameter("SigAlg", sigAlg).addParameter("Signature", signatureNaiveEncoding);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"Signature validation failed. Logout Request rejected", (Object)logoutRequest.getError());
    }

    @Test
    public void testIsInValidSign() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setStrict(false);
        settings.setWantMessagesSigned(true);
        String requestURL = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls";
        String samlRequestEncoded = "lVLBitswEP0Vo7tjWbJkSyReFkIhsN1tm6WHvQTZHmdFbUmVZLqfXzlpIS10oZdhGM17b96MtkHNk5MP9myX+AW+LxBi9jZPJsjLyw4t3kirgg7SqBmCjL083n98kGSDpfM22t5O6AbyPkKFAD5qa1B22O/QSWA+EFWPjCtaM6gBugrXHCo6Ut6UgvTV2DSkBoKyr+BDQu5QIkrwEBY4mBCViamEyyrHNCf4ueSScMnIC8r2yY02Kl5QrzG6IIvC6dgt07eNsbl2G+vPhYEf1sBkz9oUA8y2LLQZ4G3jXt1dmALKHm18Mk/+fozgk5YQNMciJ+UzKWV11Wq3q3l5mcq3/9YKenYTrL3FGkihB1fMENWgoloVt8Ut0ZX1Me3xsM+On9bk86ImPep1kv+xdKuBsg/Wzyq+f6u1ood8vLTK6JUJGkxE7WnsSDcQRirOKMc97TtWCgqU1ZyJBvM+RZbSrv/l5mrg6sbJI4T1kId1ye0JhoaQgYg+XT1dnilMSZO4uko1jPSYVF0luqQjrmR/4X8X//jC7U8=";
        String relayState = "_1037fbc88ec82ce8e770b2bed1119747bb812a07e6";
        String sigAlg = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String signature = "j/qDRTzgQw3cMDkkSkBOShqxi3t9qJxYnrADqwAECnJ3Y+iYgT33C0l/Vy3+ooQkFRyObYJqg9o7iIcMdgV6CXxpa6itVIUAI2VJewsMjzvJ4OdpePeSx7+/umVPKCfMvffsELlqo/UgxsyRZh8NMLej0ojCB7bUfIMKsiU7e0c=";
        HttpRequest httpRequest = new HttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls", (String)null).addParameter("SAMLRequest", samlRequestEncoded).addParameter("RelayState", relayState).addParameter("SigAlg", sigAlg).addParameter("Signature", signature);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setStrict(true);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setStrict(false);
        String signature2 = "vfWbbc47PkP3ejx4bjKsRX7lo9Ml1WRoE5J5owF/0mnyKHfSY6XbhO1wwjBV5vWdrUVX+xp6slHyAf4YoAsXFS0qhan6txDiZY4Oec6yE+l10iZbzvie06I4GPak4QrQ4gAyXOSzwCrRmJu4gnpeUxZ6IqKtdrKfAYRAcVf3333=";
        httpRequest = httpRequest.removeParameter("Signature").addParameter("Signature", signature2);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"Signature validation failed. Logout Request rejected", (Object)logoutRequest.getError());
        httpRequest = httpRequest.removeParameter("Signature").addParameter("Signature", signature).removeParameter("SigAlg");
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        httpRequest = httpRequest.removeParameter("Signature");
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setStrict(true);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"The Message of the Logout Request is not signed and the SP requires it", (Object)logoutRequest.getError());
        httpRequest = httpRequest.addParameter("Signature", signature);
        settings = new SettingsBuilder().fromFile("config/config.mywithnocert.properties").build();
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"In order to validate the sign on the Logout Request, the x509cert of the IdP is required", (Object)logoutRequest.getError());
    }

    @Test
    public void testIsInValidSignWithDeprecatedAlg() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setStrict(false);
        settings.setWantMessagesSigned(true);
        String requestURL = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls";
        String samlRequestEncoded = "lVLBitswEP0Vo7tjeWzJtki8LIRCYLvbNksPewmyPc6K2pJqyXQ/v1LSQlroQi/DMJr33rwZbZ2cJysezNms/gt+X9H55G2etBOXlx1ZFy2MdMoJLWd0wvfieP/xQcCGCrsYb3ozkRvI+wjpHC5eGU2Sw35HTg3lA8hqZFwWFcMKsStpxbEsxoLXeQN9OdY1VAgk+YqLC8gdCUQB7tyKB+281D6UaF6mtEiBPudcABcMXkiyD26Ulv6CevXeOpFlVvlunb5ttEmV3ZjlnGn8YTRO5qx0NuBs8kzpAd829tXeucmR5NH4J/203I8el6gFRUqbFPJnyEV51Wq30by4TLW0/9ZyarYTxt4sBsjUYLMZvRykl1Fxm90SXVkfwx4P++T4KSafVzmpUcVJ/sfSrQZJPphllv79W8WKGtLx0ir8IrVTqD1pT2MH3QAMSs4KTvui71jeFFiwirOmprwPkYW063+5uRq4urHiiC4e8hCX3J5wqAEGaPpw9XB5JmkBdeDqSlkz6CmUXdl0Qae5kv2F/1384wu3PwE=";
        String relayState = "_1037fbc88ec82ce8e770b2bed1119747bb812a07e6";
        String sigAlg = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String signature = "XCwCyI5cs7WhiJlB5ktSlWxSBxv+6q2xT3c8L7dLV6NQG9LHWhN7gf8qNsahSXfCzA0Ey9dp5BQ0EdRvAk2DIzKmJY6e3hvAIEp1zglHNjzkgcQmZCcrkK9Czi2Y1WkjOwR/WgUTUWsGJAVqVvlRZuS3zk3nxMrLH6f7toyvuJc=";
        HttpRequest httpRequest = new HttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?sls", (String)null).addParameter("SAMLRequest", samlRequestEncoded).addParameter("RelayState", relayState).addParameter("SigAlg", sigAlg).addParameter("Signature", signature);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertTrue((boolean)logoutRequest.isValid());
        settings.setRejectDeprecatedAlg(true);
        LogoutRequest logoutRequest2 = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest2.isValid());
    }

    @Test
    public void testIsValidNoLogoutRequest() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlRequestEncoded = "";
        String requestURL = "/";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest("/", samlRequestEncoded);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"SAML Logout Request is not loaded", (Object)logoutRequest.getError());
    }

    @Test
    public void testIsValidNoCurrentURL() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/logout_request_deflated.xml.base64");
        LogoutRequest logoutRequest = new LogoutRequest(settings, (HttpRequest)null);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"The HttpRequest of the current host was not established", (Object)logoutRequest.getError());
        String requestURL = "";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest("", samlRequestEncoded);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertFalse((boolean)logoutRequest.isValid());
        Assert.assertEquals((Object)"The URL of the current host was not established", (Object)logoutRequest.getError());
    }

    @Test
    public void testGetError() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        settings.setStrict(true);
        String samlRequestEncoded = Util.getFileAsString((String)"data/logout_requests/logout_request_deflated.xml.base64");
        String requestURL = "/";
        HttpRequest httpRequest = LogoutRequestTest.newHttpRequest("/", samlRequestEncoded);
        LogoutRequest logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertNull((Object)logoutRequest.getError());
        Assert.assertNull((Object)logoutRequest.getValidationException());
        logoutRequest.isValid();
        Assert.assertThat((Object)logoutRequest.getError(), (Matcher)CoreMatchers.containsString((String)"The LogoutRequest was received at"));
        Assert.assertTrue((boolean)(logoutRequest.getValidationException() instanceof ValidationException));
        settings.setStrict(false);
        logoutRequest = new LogoutRequest(settings, httpRequest);
        Assert.assertNull((Object)logoutRequest.getError());
        Assert.assertNull((Object)logoutRequest.getValidationException());
        logoutRequest.isValid();
        Assert.assertNull((Object)logoutRequest.getError());
        Assert.assertNull((Object)logoutRequest.getValidationException());
    }

    private static HttpRequest newHttpRequest(String requestURL, String samlRequestEncoded) {
        return new HttpRequest(requestURL, (String)null).addParameter("SAMLRequest", samlRequestEncoded);
    }

    @Test
    public void testPostProcessXml() throws Exception {
        final Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        final LogoutRequestParams params = new LogoutRequestParams();
        LogoutRequest logoutRequest = new LogoutRequest(settings, params){

            protected String postProcessXml(String logoutRequestXml, LogoutRequestParams par, Saml2Settings sett) {
                Assert.assertEquals((Object)logoutRequestXml, (Object)super.postProcessXml(logoutRequestXml, par, sett));
                Assert.assertSame((Object)settings, (Object)sett);
                Assert.assertSame((Object)params, (Object)par);
                return "changed";
            }
        };
        Assert.assertEquals((Object)"changed", (Object)logoutRequest.getLogoutRequestXml());
    }
}

