/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.test.authn;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.codelibs.saml2.core.authn.SamlResponse;
import org.codelibs.saml2.core.exception.SAMLSevereException;
import org.codelibs.saml2.core.exception.SettingsException;
import org.codelibs.saml2.core.exception.ValidationException;
import org.codelibs.saml2.core.http.HttpRequest;
import org.codelibs.saml2.core.model.SamlResponseStatus;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.settings.SettingsBuilder;
import org.codelibs.saml2.core.util.DateTimeTestUtils;
import org.codelibs.saml2.core.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AuthnResponseTest {
    private static final String ACS_URL = "http://localhost:8080/java-saml-jspsample/acs.jsp";
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Before
    public void setDateTime() {
        DateTimeTestUtils.setFixedDateTime("2020-06-01T00:00:00Z");
    }

    @After
    public void goBackToNormal() {
        DateTimeTestUtils.setCurrentMillisSystem();
    }

    @Test
    public void testDeconstructedConstructor() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String requestURL = "/";
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("/", samlResponseEncoded));
        Assert.assertTrue((boolean)(samlResponse instanceof SamlResponse));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, "/", samlResponseEncoded);
        Assert.assertTrue((boolean)(samlResponse instanceof SamlResponse));
    }

    @Test
    public void testConstructor() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String requestURL = "/";
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("/", samlResponseEncoded));
        Assert.assertTrue((boolean)(samlResponse instanceof SamlResponse));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("/", samlResponseEncoded));
        Assert.assertTrue((boolean)(samlResponse instanceof SamlResponse));
    }

    @Test
    public void testOInvalidResponseWithNonExpectedElementsFail() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrapped_response_2.xml.base64");
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("SAML Response could not be processed");
        new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
    }

    @Test
    public void testEncryptedAssertionNokey() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        this.expectedEx.expect(SettingsException.class);
        this.expectedEx.expectMessage("No private key available for decrypt, check settings");
        new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
    }

    @Test
    public void testTextWithCommentAttack() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_node_test_attack.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Map attributes = samlResponse.getAttributes();
        String nameId = samlResponse.getNameId();
        Assert.assertEquals((Object)"smith", ((List)attributes.get("surname")).get(0));
        Assert.assertEquals((Object)"support@onelogin.com", (Object)nameId);
    }

    @Test
    public void testNamespaces() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/open_saml_response.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Map attributes = samlResponse.getAttributes();
        Assert.assertFalse((boolean)attributes.isEmpty());
        Assert.assertTrue((boolean)attributes.containsKey("FirstName"));
        Assert.assertTrue((boolean)attributes.containsKey("LastName"));
        ArrayList<String> expectedFirstName = new ArrayList<String>();
        expectedFirstName.add("Someone");
        ArrayList<String> expectedLastName = new ArrayList<String>();
        expectedLastName.add("Special");
        Assert.assertEquals(expectedFirstName, attributes.get("FirstName"));
        Assert.assertEquals(expectedLastName, attributes.get("LastName"));
    }

    @Test
    public void testGetSAMLResponseXml() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String requestURL = "/";
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("/", samlResponseEncoded));
        String samlResponseXML = samlResponse.getSAMLResponseXml();
        Assert.assertThat((Object)samlResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:Response"));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("/", samlResponseEncoded));
        samlResponseXML = samlResponse.getSAMLResponseXml();
        Assert.assertThat((Object)samlResponseXML, (Matcher)CoreMatchers.containsString((String)"<samlp:Response"));
        Assert.assertThat((Object)samlResponseXML, (Matcher)CoreMatchers.containsString((String)"<saml:Assertion"));
    }

    @Test
    public void testGetNameId() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"support@onelogin.com", (Object)samlResponse.getNameId());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_encrypted_nameid.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"2de11defd199f8d5bb63f9b7deb265ba5c675c10", (Object)samlResponse.getNameId());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"_68392312d490db6d355555cfbbd8ec95d746516f60", (Object)samlResponse.getNameId());
        settings.setWantNameId(false);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_nameid.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertNull((Object)samlResponse.getNameId());
    }

    @Test
    public void testGetNameIdFormat() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", (Object)samlResponse.getNameIdFormat());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_encrypted_nameid.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", (Object)samlResponse.getNameIdFormat());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient", (Object)samlResponse.getNameIdFormat());
        settings.setWantNameId(false);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_nameid.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertNull((Object)samlResponse.getNameIdFormat());
    }

    @Test
    public void testGetNameIdNameQualifier() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertNull((Object)samlResponse.getNameIdNameQualifier());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response_with_namequalifier.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"example.com", (Object)samlResponse.getNameIdNameQualifier());
    }

    @Test
    public void testGetNameIdSPNameQualifier() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertNull((Object)samlResponse.getNameIdSPNameQualifier());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response_with_namequalifier.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)settings.getSpEntityId(), (Object)samlResponse.getNameIdSPNameQualifier());
    }

    @Test
    public void testGetNameIdNoNameId() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantNameId(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_nameid.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("No name id found in Document.");
        samlResponse.getNameId();
    }

    @Test
    public void testGetNameIdWrongSPNameQualifier() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantNameId(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_spnamequalifier.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("The SPNameQualifier value mismatch the SP entityID value.");
        samlResponse.getNameId();
    }

    @Test
    public void testGetNameIdNoKey() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_encrypted_nameid.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(SettingsException.class);
        this.expectedEx.expectMessage("Key is required in order to decrypt the NameID");
        samlResponse.getNameId();
    }

    @Test
    public void testGetNameIdEmptyNameIDValue() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        settings.setStrict(false);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/empty_nameid.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        String nameId = samlResponse.getNameId();
        Assert.assertTrue((boolean)nameId.isEmpty());
        settings.setStrict(true);
        SamlResponse samlResponse2 = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("An empty NameID value found");
        samlResponse2.getNameId();
    }

    @Test
    public void testGetNameIdWrongEncryptedData() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/response_encrypted_subconfirm_as_nameid.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(Exception.class);
        this.expectedEx.expectMessage("Not able to decrypt the EncryptedID and get a NameID");
        samlResponse.getNameId();
    }

    @Test
    public void testGetNameIdTrimming() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        settings.setStrict(false);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response3_with_whitespace.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        String nameId = samlResponse.getNameId();
        Assert.assertEquals((Object)"\n      \tsomeone@example.com\n      ", (Object)nameId);
        settings.setTrimNameIds(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        nameId = samlResponse.getNameId();
        Assert.assertEquals((Object)"someone@example.com", (Object)nameId);
    }

    @Test
    public void testGetNameIdData() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"{Format=urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, Value=support@onelogin.com}", (Object)samlResponse.getNameIdData().toString());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_encrypted_nameid.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        String NameIdDataStr = samlResponse.getNameIdData().toString();
        Assert.assertThat((Object)NameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Format=urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
        Assert.assertThat((Object)NameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Value=2de11defd199f8d5bb63f9b7deb265ba5c675c10"));
        Assert.assertThat((Object)NameIdDataStr, (Matcher)CoreMatchers.containsString((String)"SPNameQualifier=http://localhost:8080/java-saml-jspsample/metadata.jsp"));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        NameIdDataStr = samlResponse.getNameIdData().toString();
        Assert.assertThat((Object)NameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Format=urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
        Assert.assertThat((Object)NameIdDataStr, (Matcher)CoreMatchers.containsString((String)"Value=_68392312d490db6d355555cfbbd8ec95d746516f60"));
        Assert.assertThat((Object)NameIdDataStr, (Matcher)CoreMatchers.containsString((String)"SPNameQualifier=http://localhost:8080/java-saml-jspsample/metadata.jsp"));
        settings.setWantNameId(false);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_nameid.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.getNameIdData().isEmpty());
    }

    @Test
    public void testGetIssueInstant() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"2010-11-18T21:57:37Z", (Object)Util.formatDateTime((long)samlResponse.getResponseIssueInstant().getTimeInMillis()));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_encrypted_nameid.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"2014-03-09T12:23:37Z", (Object)Util.formatDateTime((long)samlResponse.getResponseIssueInstant().getTimeInMillis()));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"2014-03-29T12:01:57Z", (Object)Util.formatDateTime((long)samlResponse.getResponseIssueInstant().getTimeInMillis()));
    }

    @Test
    public void testEncryptedResponse() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.decrypt.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_to_decrypt.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"archit.neema@intellicus.com", (Object)samlResponse.getNameId());
    }

    @Test
    public void testGetNameIdDataNoNameId() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantNameId(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_nameid.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("No name id found in Document");
        samlResponse.getNameIdData();
    }

    @Test
    public void testGetNameIdDataWrongSPNameQualifier() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantNameId(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_spnamequalifier.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("The SPNameQualifier value mismatch the SP entityID value.");
        samlResponse.getNameIdData();
    }

    @Test
    public void testGetNameIdDataEmptyNameIDValue() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        settings.setStrict(false);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/empty_nameid.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Map nameIdData = samlResponse.getNameIdData();
        Assert.assertTrue((boolean)((String)nameIdData.get("Value")).isEmpty());
        settings.setStrict(true);
        SamlResponse samlResponse2 = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("An empty NameID value found");
        samlResponse2.getNameIdData();
    }

    @Test
    public void testGetNameIdDataTrimming() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        settings.setStrict(false);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response3_with_whitespace.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Map nameIdData = samlResponse.getNameIdData();
        Assert.assertEquals((Object)"\n      \tsomeone@example.com\n      ", nameIdData.get("Value"));
        settings.setTrimNameIds(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        nameIdData = samlResponse.getNameIdData();
        Assert.assertEquals((Object)"someone@example.com", nameIdData.get("Value"));
    }

    @Test
    public void checkOneCondition() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_conditions.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.checkOneCondition());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.checkOneCondition());
    }

    @Test
    public void checkOneAuthNStatement() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_authnstatement.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.checkOneAuthnStatement());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.checkOneAuthnStatement());
    }

    @Test
    public void testCheckStatus() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        samlResponse.checkStatus();
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        samlResponse.checkStatus();
    }

    @Test
    public void testCheckStatusResponder() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/status_code_responder.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("The status code of the Response was not Success, was urn:oasis:names:tc:SAML:2.0:status:Responder");
        samlResponse.checkStatus();
    }

    @Test
    public void testCheckStatusResponderMsg() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/status_code_responder_and_msg.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("The status code of the Response was not Success, was urn:oasis:names:tc:SAML:2.0:status:Responder -> something_is_wrong");
        samlResponse.checkStatus();
    }

    @Test
    public void testCheckStatusNoStatus() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_status.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Missing Status on response");
        samlResponse.checkStatus();
    }

    @Test
    public void testCheckStatusNoStatusCode() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_status_code.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Missing Status Code on response");
        samlResponse.checkStatus();
    }

    @Test
    public void testGetStatus() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        Document samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        SamlResponseStatus status = SamlResponse.getStatus((Document)samlResponseDoc);
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:status:Success", (Object)status.getStatusCode());
        Assert.assertNull((Object)status.getStatusMessage());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        status = SamlResponse.getStatus((Document)samlResponseDoc);
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:status:Success", (Object)status.getStatusCode());
        Assert.assertNull((Object)status.getStatusMessage());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/status_code_responder.xml.base64");
        samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        status = SamlResponse.getStatus((Document)samlResponseDoc);
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:status:Responder", (Object)status.getStatusCode());
        Assert.assertNull((Object)status.getStatusMessage());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/status_code_responder_and_msg.xml.base64");
        samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        status = SamlResponse.getStatus((Document)samlResponseDoc);
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:status:Responder", (Object)status.getStatusCode());
        Assert.assertEquals((Object)"something_is_wrong", (Object)status.getStatusMessage());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/status_code_and_sub_status_code_responder_and_msg.xml.base64");
        samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        status = SamlResponse.getStatus((Document)samlResponseDoc);
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:status:Responder", (Object)status.getStatusCode());
        Assert.assertEquals((Object)"urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", (Object)status.getSubStatusCode());
        Assert.assertEquals((Object)"something_is_wrong", (Object)status.getStatusMessage());
    }

    @Test
    public void testGetAudiences() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        ArrayList<String> expectedAudiences = new ArrayList<String>();
        expectedAudiences.add("{audience}");
        Assert.assertEquals(expectedAudiences, (Object)samlResponse.getAudiences());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        expectedAudiences = new ArrayList();
        expectedAudiences.add("http://localhost:8080/java-saml-jspsample/metadata.jsp");
        Assert.assertEquals(expectedAudiences, (Object)samlResponse.getAudiences());
    }

    @Test
    public void testGetResponseIssuerTrimming() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response3_with_whitespace.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"\n  \thttp://example.com/services/trust\n  ", (Object)samlResponse.getResponseIssuer());
        settings.setTrimNameIds(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"http://example.com/services/trust", (Object)samlResponse.getResponseIssuer());
    }

    @Test
    public void testGetAssertionIssuerNoInAssertion() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_issuer_assertion.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Issuer of the Assertion not found or multiple.");
        samlResponse.getAssertionIssuer();
    }

    @Test
    public void testGetAssertionIssuerTrimming() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response3_with_whitespace.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"\n    \thttp://example.com/services/trust\n    ", (Object)samlResponse.getAssertionIssuer());
        settings.setTrimNameIds(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"http://example.com/services/trust", (Object)samlResponse.getAssertionIssuer());
    }

    @Test
    public void testGetIssuers() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        String expectedIssuer = "http://idp.example.com/";
        ArrayList<String> expectedIssuers = new ArrayList<String>();
        expectedIssuers.add(expectedIssuer);
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getResponseIssuer());
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getAssertionIssuer());
        Assert.assertEquals(expectedIssuers, (Object)samlResponse.getIssuers());
        expectedIssuers.remove(0);
        expectedIssuer = "https://pitbulk.no-ip.org/simplesaml/saml2/idp/metadata.php";
        expectedIssuers.add(expectedIssuer);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_message_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getResponseIssuer());
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getAssertionIssuer());
        Assert.assertEquals(expectedIssuers, (Object)samlResponse.getIssuers());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/double_signed_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getResponseIssuer());
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getAssertionIssuer());
        Assert.assertEquals(expectedIssuers, (Object)samlResponse.getIssuers());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getResponseIssuer());
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getAssertionIssuer());
        Assert.assertEquals(expectedIssuers, (Object)samlResponse.getIssuers());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/double_signed_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getResponseIssuer());
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getAssertionIssuer());
        Assert.assertEquals(expectedIssuers, (Object)samlResponse.getIssuers());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_assertion_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getResponseIssuer());
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getAssertionIssuer());
        Assert.assertEquals(expectedIssuers, (Object)samlResponse.getIssuers());
        expectedIssuer = "https://app.onelogin.com/saml/metadata/13590";
        expectedIssuers = new ArrayList();
        expectedIssuers.add(expectedIssuer);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_issuer_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertNull((String)expectedIssuer, (Object)samlResponse.getResponseIssuer());
        Assert.assertEquals((Object)expectedIssuer, (Object)samlResponse.getAssertionIssuer());
        Assert.assertEquals(expectedIssuers, (Object)samlResponse.getIssuers());
    }

    @Test
    public void testGetIssuersDifferentIssuers() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/different_issuers.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        ArrayList<String> expectedIssuers = new ArrayList<String>();
        String expectedResponseIssuer = "https://response-issuer.com";
        String expectedAssertionIssuer = "https://assertion-issuer.com";
        expectedIssuers.add(expectedResponseIssuer);
        expectedIssuers.add(expectedAssertionIssuer);
        Assert.assertEquals((Object)expectedResponseIssuer, (Object)samlResponse.getResponseIssuer());
        Assert.assertEquals((Object)expectedAssertionIssuer, (Object)samlResponse.getAssertionIssuer());
        Assert.assertEquals(expectedIssuers, (Object)samlResponse.getIssuers());
    }

    @Test
    public void testGetIssuersNoInAssertion() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_issuer_assertion.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        samlResponse.getResponseIssuer();
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Issuer of the Assertion not found or multiple.");
        samlResponse.getIssuers();
    }

    @Test
    public void testGetIssuersTrimming() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response3_with_whitespace.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals(Arrays.asList("\n  \thttp://example.com/services/trust\n  ", "\n    \thttp://example.com/services/trust\n    "), (Object)samlResponse.getIssuers());
        settings.setTrimNameIds(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals(Arrays.asList("http://example.com/services/trust"), (Object)samlResponse.getIssuers());
    }

    @Test
    public void testGetSessionIndex() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"_531c32d283bdff7e04e487bcdbc4dd8d", (Object)samlResponse.getSessionIndex());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"_7164a9a9f97828bfdb8d0ebc004a05d2e7d873f70c", (Object)samlResponse.getSessionIndex());
    }

    @Test
    public void testGetAssertionDetails() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        SamlResponse samlResponse = new SamlResponse(new SettingsBuilder().fromFile("config/config.my.properties").build(), AuthnResponseTest.newHttpRequest(Util.getFileAsString((String)"data/responses/response1.xml.base64")));
        List notOnOrAfters = samlResponse.getAssertionNotOnOrAfter();
        Assert.assertEquals((Object)"pfxa46574df-b3b0-a06a-23c8-636413198772", (Object)samlResponse.getAssertionId());
        Assert.assertThat((Object)notOnOrAfters, (Matcher)Matchers.contains((Object[])new Instant[]{Instant.parse("2010-11-18T22:02:37Z")}));
    }

    @Test
    public void testGetAssertionDetails_encrypted() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        SamlResponse samlResponse = new SamlResponse(new SettingsBuilder().fromFile("config/config.my.properties").build(), AuthnResponseTest.newHttpRequest(Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64")));
        List notOnOrAfters = samlResponse.getAssertionNotOnOrAfter();
        Assert.assertEquals((Object)"_519c2712648ee09a06d1f9a08e9e835715fea60267", (Object)samlResponse.getAssertionId());
        Assert.assertThat((Object)notOnOrAfters, (Matcher)Matchers.contains((Object[])new Instant[]{Instant.parse("2055-06-07T20:17:08Z")}));
    }

    @Test
    public void testGetAssertionDetails_multiple() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(true);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(this.loadSignMessageAndEncode("data/responses/invalids/invalid_subjectconfirmation_multiple_issues.xml")));
        List notOnOrAfters = samlResponse.getAssertionNotOnOrAfter();
        Assert.assertEquals((Object)"pfx7841991c-c73f-4035-e2ee-c170c0e1d3e4", (Object)samlResponse.getAssertionId());
        Assert.assertThat((Object)notOnOrAfters, (Matcher)Matchers.contains((Object[])new Instant[]{Instant.parse("2120-06-17T14:53:44Z"), Instant.parse("2010-06-17T14:53:44Z")}));
    }

    @Test
    public void testGetAttributes() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        HashMap expectedAttributes = new HashMap();
        ArrayList<String> attrValues = new ArrayList<String>();
        attrValues.add("demo");
        ArrayList<String> attrValues2 = new ArrayList<String>();
        attrValues2.add("value");
        expectedAttributes.put("uid", attrValues);
        expectedAttributes.put("another_value", attrValues2);
        Assert.assertEquals(expectedAttributes, (Object)samlResponse.getAttributes());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/response2.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.getAttributes().isEmpty());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/encrypted_attrs.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.getAttributes().isEmpty());
    }

    @Test
    public void testGetAttributesTrimming() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response3_with_whitespace.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        HashMap expectedAttributes = new HashMap();
        ArrayList<String> attrValuesTrimmed = new ArrayList<String>();
        attrValuesTrimmed.add("someone@example.com");
        ArrayList<String> attrValuesNonTrimmed = new ArrayList<String>();
        attrValuesNonTrimmed.add("\n        \tsomeone@example.com\n        ");
        expectedAttributes.put("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress", attrValuesNonTrimmed);
        Assert.assertEquals(expectedAttributes, (Object)samlResponse.getAttributes());
        settings.setTrimAttributeValues(true);
        expectedAttributes.put("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress", attrValuesTrimmed);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals(expectedAttributes, (Object)samlResponse.getAttributes());
    }

    @Test
    public void testGetAttributesDuplicatedNames() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/duplicated_attributes.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Found an Attribute element with duplicated Name");
        samlResponse.getAttributes();
    }

    @Test
    public void testGetAttributesAllowDuplicatedNames() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.allowduplicatednames.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/duplicated_attributes.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Map attributes = samlResponse.getAttributes();
        Assert.assertNotNull((Object)attributes);
        Assert.assertTrue((boolean)attributes.containsKey("uid"));
        Assert.assertEquals((long)2L, (long)((List)attributes.get("uid")).size());
    }

    @Test
    public void testOnlyRetrieveAssertionWithIDThatMatchesSignatureReference() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_assertion_response_with_2_assertions.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"492882615acf31c8096b627245d76ae53036c090", (Object)samlResponse.getNameId());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_assertion_response_with_2_assertions_differrent_order.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"492882615acf31c8096b627245d76ae53036c090", (Object)samlResponse.getNameId());
    }

    @Test
    public void testDoesNotAllowSignatureWrappingAttack() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response4.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)"test@onelogin.com", (Object)samlResponse.getNameId());
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"SAML Response must contain 1 Assertion.", (Object)samlResponse.getError());
    }

    @Test
    public void testDoesNotAllowSignatureWrappingAttack2() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.newattack.properties").build();
        String samlResponseEncoded = Util.base64encoder((String)Util.getFileAsString((String)"data/responses/invalids/attacks/encrypted_new_attack.xml"));
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Found an invalid Signed Element. SAML Response rejected", (Object)samlResponse.getError());
    }

    @Test
    public void testDoesNotAllowSignatureWrappingAttack3() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.newattack2.properties").build();
        settings.setStrict(false);
        String requestURL = "https://example.com/endpoint";
        String samlResponseEncoded = Util.base64encoder((String)Util.getFileAsString((String)"data/responses/invalids/attacks/response_with_doubled_signed_assertion.xml"));
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("https://example.com/endpoint", samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"SAML Response must contain 1 Assertion.", (Object)samlResponse.getError());
        Assert.assertEquals((Object)"someone@example.org", (Object)samlResponse.getNameId());
    }

    @Test
    public void testDoesNotAllowSignatureWrappingAttack4() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.newattack2.properties").build();
        settings.setStrict(false);
        String requestURL = "https://example.com/endpoint";
        String samlResponseEncoded = Util.base64encoder((String)Util.getFileAsString((String)"data/responses/invalids/attacks/response_with_concealed_signed_assertion.xml"));
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("https://example.com/endpoint", samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"SAML Response must contain 1 Assertion.", (Object)samlResponse.getError());
        Assert.assertEquals((Object)"someone@example.org", (Object)samlResponse.getNameId());
    }

    @Test
    public void testValidatesTheExpectedSignatures() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(true);
        settings.setWantMessagesSigned(true);
        String samlResponseEncoded = Util.base64encoder((String)Util.getFileAsString((String)"data/responses/invalids/attacks/response_with_spoofed_response_signature.xml"));
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Invalid Signature Element {urn:oasis:names:tc:SAML:2.0:assertion}Response SAML Response rejected", (Object)samlResponse.getError());
    }

    @Test
    public void testGetSessionNotOnOrAfter() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((long)1290203857000L, (long)samlResponse.getSessionNotOnOrAfter().toEpochMilli());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/response2.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertNull((Object)samlResponse.getSessionNotOnOrAfter());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((long)2696012228000L, (long)samlResponse.getSessionNotOnOrAfter().toEpochMilli());
    }

    @Test
    public void testValidateNumAssertions() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response1.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.validateNumAssertions());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/multiple_assertions.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.validateNumAssertions());
    }

    @Test
    public void testValidateTimestamps() throws ValidationException, IOException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.validateTimestamps());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_encrypted_assertion.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.validateTimestamps());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_time_condition.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.validateTimestamps());
    }

    @Test
    public void testValidateTimestampsExpired() throws ValidationException, XPathExpressionException, ParserConfigurationException, SAXException, IOException, SettingsException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/expired_response.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Could not validate timestamp: expired. Check system clock.");
        samlResponse.validateTimestamps();
    }

    @Test
    public void testValidateTimestampsNA() throws ValidationException, XPathExpressionException, ParserConfigurationException, SAXException, IOException, SettingsException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/not_after_failed.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Could not validate timestamp: expired. Check system clock.");
        samlResponse.validateTimestamps();
    }

    @Test
    public void testValidateTimestampsNB() throws ValidationException, XPathExpressionException, ParserConfigurationException, SAXException, IOException, SettingsException, SAMLSevereException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/not_before_failed.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Could not validate timestamp: not yet valid. Check system clock.");
        samlResponse.validateTimestamps();
    }

    @Test
    public void testNullRequest() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        this.expectedEx.expect(NullPointerException.class);
        SamlResponse samlResponse = new SamlResponse(settings, null);
    }

    @Test
    public void testNoCurrentURL() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String requestURL = "";
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("", samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The URL of the current host was not established", (Object)samlResponse.getError());
        samlResponse.setDestinationUrl(null);
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The URL of the current host was not established", (Object)samlResponse.getError());
    }

    @Test
    public void testValidateVersion() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_saml2.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertTrue((boolean)samlResponse.getError().startsWith("Unsupported SAML Version"));
    }

    @Test
    public void testValidateResponseVersion() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_response_version.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Unsupported SAML Version on Response.", (Object)samlResponse.getError());
    }

    @Test
    public void testValidateAssertionVersion() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_assertion_version.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Unsupported SAML Version on Assertion.", (Object)samlResponse.getError());
    }

    @Test
    public void testValidateID() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_id.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Missing ID attribute on SAML Response.", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidExpired() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/expired_response.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Could not validate timestamp: expired. Check system clock.", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidNoKey() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_key.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Signature validation failed. SAML Response rejected", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidMultipleAssertions() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/multiple_assertions.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"SAML Response must contain 1 Assertion.", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidEncAttrs() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/encrypted_attrs.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"There is an EncryptedAttribute in the Response and this SP does not support them", (Object)samlResponse.getError());
    }

    @Test
    public void testIsValidWrongEncryptedID() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/response_encrypted_subconfirm_as_nameid.xml.base64");
        settings.setStrict(false);
        settings.setWantAssertionsSigned(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        this.expectedEx.expect(Exception.class);
        this.expectedEx.expectMessage("Not able to decrypt the EncryptedID and get a NameID");
        samlResponse.getNameId();
    }

    @Test
    public void testIsValidWrongSPNameQualifier() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_spnamequalifier.xml.base64");
        settings.setStrict(true);
        settings.setWantAssertionsSigned(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("The SPNameQualifier value mismatch the SP entityID value.");
        samlResponse.getNameId();
    }

    @Test
    public void testIsInValidWrongXML() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String requestURL = "https://pitbulk.no-ip.org/newonelogin/demo1/index.php?acs";
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_xml.xml.base64");
        settings.setStrict(false);
        settings.setWantXMLValidation(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?acs", samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setWantXMLValidation(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?acs", samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        settings.setWantXMLValidation(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?acs", samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"http://localhost:8080/java-saml-jspsample/metadata.jsp is not a valid audience for this Response", (Object)samlResponse.getError());
        settings.setWantXMLValidation(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("https://pitbulk.no-ip.org/newonelogin/demo1/index.php?acs", samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Invalid SAML Response. Not match the saml-schema-protocol-2.0.xsd", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidDestination() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String requestURL = "/";
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/unsigned_response.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("/", samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("/", samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertThat((Object)samlResponse.getError(), (Matcher)CoreMatchers.containsString((String)"The response was received at"));
        samlResponse.setDestinationUrl(ACS_URL);
        samlResponse.isValid();
        Assert.assertThat((Object)samlResponse.getError(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"The response was received at")));
    }

    @Test
    public void testIsInValidNoDestination() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String requestURL = "/";
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/empty_destination.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("/", samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("/", samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The response has an empty Destination value", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidConditions() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_conditions.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The Assertion must include a Conditions element", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidAuthStatement() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_authnstatement.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The Assertion must include an AuthnStatement element", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidAudience() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_audience.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertThat((Object)samlResponse.getError(), (Matcher)CoreMatchers.containsString((String)"is not a valid audience for this Response"));
    }

    @Test
    public void testIsInValidIssuer() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_issuer_assertion.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Invalid issuer in the Assertion/Response. Was 'http://invalid.issuer.example.com/', but expected 'http://idp.example.com/'", (Object)samlResponse.getError());
        settings.setStrict(false);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_issuer_message.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Invalid issuer in the Assertion/Response. Was 'http://invalid.isser.example.com/', but expected 'http://idp.example.com/'", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidSessionIndex() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_sessionindex.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The attributes have expired, based on the SessionNotOnOrAfter of the AttributeStatement of this Response", (Object)samlResponse.getError());
    }

    @Test
    public void testIsValidSubjectConfirmation_noSubjectConfirmationMethod() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_subjectconfirmation_method.xml.base64");
        this.assertResponseValid(settings, samlResponseEncoded, false, false, "No Signature found. SAML Response rejected");
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response");
    }

    @Test
    public void testIsValidSubjectConfirmation_noSubjectConfirmationData() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_subjectconfirmation_data.xml.base64");
        this.assertResponseValid(settings, samlResponseEncoded, false, false, "No Signature found. SAML Response rejected");
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response");
    }

    @Test
    public void testIsValidSubjectConfirmation_invalidInResponseTo() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_subjectconfirmation_inresponse.xml.base64");
        this.assertResponseValid(settings, samlResponseEncoded, false, false, "No Signature found. SAML Response rejected");
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response: SubjectConfirmationData has an invalid InResponseTo value");
    }

    @Test
    public void testIsValidSubjectConfirmation_unmatchedInResponseTo() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(true);
        String samlResponseEncoded = this.loadSignMessageAndEncode("data/responses/invalids/invalid_unpaired_inresponsesto.xml");
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response: SubjectConfirmationData has an invalid InResponseTo value");
        this.assertResponseValid(settings, samlResponseEncoded, false, true, null);
    }

    @Test
    public void testIsValidSubjectConfirmation_invalidRecipient() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_subjectconfirmation_recipient.xml.base64");
        this.assertResponseValid(settings, samlResponseEncoded, false, false, "No Signature found. SAML Response rejected");
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response: SubjectConfirmationData doesn't match a valid Recipient");
    }

    @Test
    public void testIsValidSubjectConfirmation_noLongerValid() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/invalid_subjectconfirmation_noa.xml.base64");
        this.assertResponseValid(settings, samlResponseEncoded, false, false, "No Signature found. SAML Response rejected");
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response: SubjectConfirmationData is no longer valid");
    }

    @Test
    public void testIsValidSubjectConfirmation_notYetValid() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = this.loadAndEncode("data/responses/invalids/invalid_subjectconfirmation_nb.xml");
        this.assertResponseValid(settings, samlResponseEncoded, false, false, "No Signature found. SAML Response rejected");
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response: SubjectConfirmationData is not yet valid");
    }

    @Test
    public void testIsValidSubjectConfirmation_missingRecipient() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(true);
        String samlResponseEncoded = this.loadSignMessageAndEncode("data/responses/invalids/invalid_subjectconfirmation_no_recipient.xml");
        this.assertResponseValid(settings, samlResponseEncoded, false, true, null);
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response: SubjectConfirmationData doesn't contain a Recipient");
    }

    @Test
    public void testIsValidSubjectConfirmation_missingNotOnOrAfter() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(true);
        String samlResponseEncoded = this.loadSignMessageAndEncode("data/responses/invalids/invalid_subjectconfirmation_no_notonorafter.xml");
        this.assertResponseValid(settings, samlResponseEncoded, false, true, null);
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response: SubjectConfirmationData doesn't contain a NotOnOrAfter attribute");
    }

    @Test
    public void testIsValidSubjectConfirmation_multipleIssues() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(true);
        String samlResponseEncoded = this.loadSignMessageAndEncode("data/responses/invalids/invalid_subjectconfirmation_multiple_issues.xml");
        this.assertResponseValid(settings, samlResponseEncoded, false, true, null);
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "A valid SubjectConfirmation was not found on this Response: \n[0] SubjectConfirmationData doesn't contain a NotOnOrAfter attribute, \n[1] SubjectConfirmationData doesn't contain a Recipient, \n[2] SubjectConfirmationData is no longer valid");
    }

    @Test
    public void testIsValid_multipleThreads() throws Exception {
        int jobCount = 100;
        int threadCount = 5;
        ExecutorService executor = Executors.newFixedThreadPool(5);
        final CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        final AtomicInteger successCount = new AtomicInteger();
        for (int i = 0; i < 100; ++i) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
                        settings.setWantAssertionsSigned(false);
                        settings.setWantMessagesSigned(true);
                        String samlResponseEncoded = AuthnResponseTest.this.loadSignMessageAndEncode("data/responses/valid_idp_initiated_response.xml");
                        AuthnResponseTest.this.assertResponseValid(settings, samlResponseEncoded, true, true, null);
                        successCount.incrementAndGet();
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        Assert.assertThat(errors, (Matcher)Matchers.empty());
        Assert.assertThat((Object)successCount.get(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testDatetimeWithMiliseconds() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/unsigned_response_with_miliseconds.xm.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
    }

    @Test
    public void testParseAzureB2CTimestamp() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/redacted_azure_b2c.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        DateTimeTestUtils.setFixedDateTime("2020-07-16T07:57:00Z");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"A valid SubjectConfirmation was not found on this Response: SubjectConfirmationData doesn't match a valid Recipient", (Object)samlResponse.getError());
        DateTimeTestUtils.setFixedDateTime("2020-07-01T00:00:00Z");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Could not validate timestamp: not yet valid. Check system clock.", (Object)samlResponse.getError());
        DateTimeTestUtils.setFixedDateTime("2020-08-01T00:00:00Z");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Could not validate timestamp: expired. Check system clock.", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidRequestId() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        Assert.assertTrue((boolean)samlResponse.isValid("invalidRequestId"));
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        Assert.assertFalse((boolean)samlResponse.isValid("invalidRequestId"));
        Assert.assertThat((Object)samlResponse.getError(), (Matcher)CoreMatchers.containsString((String)"The InResponseTo of the Response"));
    }

    @Test
    public void testUnexpectedRequestId() throws Exception {
        Saml2Settings acceptingUnexpectedInResponseTo = new SettingsBuilder().fromFile("config/config.my.properties").build();
        Saml2Settings rejectingUnexpectedInResponseTo = new SettingsBuilder().fromFile("config/config.my.properties").build();
        rejectingUnexpectedInResponseTo.setRejectUnsolicitedResponsesWithInResponseTo(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        this.assertResponseValid(acceptingUnexpectedInResponseTo, samlResponseEncoded, true, true, null);
        this.assertResponseValid(rejectingUnexpectedInResponseTo, samlResponseEncoded, true, false, "The Response has an InResponseTo attribute: ONELOGIN_5fe9d6e499b2f0913206aab3f7191729049bb807 while no InResponseTo was expected");
    }

    @Test
    public void testMissingExpectedRequestId() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantMessagesSigned(true);
        settings.setWantAssertionsSigned(false);
        settings.setStrict(true);
        String samlResponseEncoded = this.loadSignMessageAndEncode("data/responses/valid_idp_initiated_response.xml");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid("expected-id"));
        Assert.assertEquals((Object)samlResponse.getError(), (Object)"The InResponseTo of the Response: null, does not match the ID of the AuthNRequest sent by the SP: expected-id");
    }

    @Test
    public void testIsInValidSignIssues() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/unsigned_response.xml.base64");
        settings.setStrict(false);
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setWantAssertionsSigned(true);
        settings.setWantMessagesSigned(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setWantAssertionsSigned(true);
        settings.setWantMessagesSigned(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setWantAssertionsSigned(true);
        settings.setWantMessagesSigned(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The Assertion of the Response is not signed and the SP requires it", (Object)samlResponse.getError());
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The Message of the Response is not signed and the SP requires it", (Object)samlResponse.getError());
        settings.setWantAssertionsSigned(true);
        settings.setWantMessagesSigned(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The Assertion of the Response is not signed and the SP requires it", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidEncIssues() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/unsigned_response.xml.base64");
        settings.setStrict(false);
        settings.setWantAssertionsEncrypted(false);
        settings.setWantNameIdEncrypted(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setWantAssertionsEncrypted(true);
        settings.setWantNameIdEncrypted(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setWantAssertionsEncrypted(false);
        settings.setWantNameIdEncrypted(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setWantAssertionsEncrypted(true);
        settings.setWantNameIdEncrypted(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setStrict(true);
        settings.setWantAssertionsEncrypted(false);
        settings.setWantNameIdEncrypted(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings.setWantAssertionsEncrypted(true);
        settings.setWantNameIdEncrypted(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The assertion of the Response is not encrypted and the SP requires it", (Object)samlResponse.getError());
        settings.setWantAssertionsEncrypted(false);
        settings.setWantNameIdEncrypted(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The NameID of the Response is not encrypted and the SP requires it", (Object)samlResponse.getError());
        settings.setWantAssertionsEncrypted(true);
        settings.setWantNameIdEncrypted(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"The assertion of the Response is not encrypted and the SP requires it", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidCert() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.invalididpcertstring.properties").build();
        settings.setStrict(false);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Signature validation failed. SAML Response rejected", (Object)samlResponse.getError());
    }

    @Test
    public void testNamespaceIsValid() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_namespaces.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
    }

    @Test
    public void testADFSValid() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.adfs.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_adfs1.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
    }

    @Test
    public void testIsValid() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
    }

    @Test
    public void testIsValid2() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.mywithnocert.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
    }

    @Test
    public void testIsValid_doubleSignedEncrypted() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(true);
        settings.setWantMessagesSigned(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/double_signed_encrypted_assertion.xml.base64");
        this.assertResponseValid(settings, samlResponseEncoded, false, true, null);
        this.assertResponseValid(settings, samlResponseEncoded, true, true, null);
    }

    @Test
    public void testIsValid_signedResponseEncryptedAssertion() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_message_encrypted_assertion.xml.base64");
        this.assertResponseValid(settings, samlResponseEncoded, false, true, null);
        this.assertResponseValid(settings, samlResponseEncoded, true, true, null);
        settings.setWantAssertionsSigned(true);
        this.assertResponseValid(settings, samlResponseEncoded, false, true, null);
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "The Assertion of the Response is not signed and the SP requires it");
    }

    @Test
    public void testIsValid_signedEncryptedAssertion() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(true);
        settings.setWantMessagesSigned(false);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_encrypted_assertion.xml.base64");
        this.assertResponseValid(settings, samlResponseEncoded, false, true, null);
        this.assertResponseValid(settings, samlResponseEncoded, true, true, null);
        settings.setWantMessagesSigned(true);
        this.assertResponseValid(settings, samlResponseEncoded, false, true, null);
        this.assertResponseValid(settings, samlResponseEncoded, true, false, "The Message of the Response is not signed and the SP requires it");
    }

    @Test
    public void testIsInValidSignWithDeprecatedAlg() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(false);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_message_response.xml.base64");
        settings.setStrict(true);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setRejectDeprecatedAlg(true);
        SamlResponse samlResponse2 = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse2.isValid());
        settings.setRejectDeprecatedAlg(false);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_assertion_response.xml.base64");
        SamlResponse samlResponse3 = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse3.isValid());
        settings.setRejectDeprecatedAlg(true);
        SamlResponse samlResponse4 = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse4.isValid());
        settings.setRejectDeprecatedAlg(false);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/double_signed_response.xml.base64");
        SamlResponse samlResponse5 = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse5.isValid());
        settings.setRejectDeprecatedAlg(true);
        SamlResponse samlResponse6 = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse6.isValid());
    }

    @Test
    public void testIsValidSign() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(false);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_message_response.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_assertion_response.xml.base64");
        settings.setStrict(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/double_signed_response.xml.base64");
        settings.setStrict(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
    }

    @Test
    public void testIsValidSignWithCertMulti() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.mywithmulticert.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(false);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_message_response.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_assertion_response.xml.base64");
        settings.setStrict(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/double_signed_response.xml.base64");
        settings.setStrict(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
    }

    @Test
    public void testProcessSignedElementsInvalidSignElement() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        String samlResponseEncoded;
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_message_response.xml.base64")));
        Assert.assertTrue((!samlResponse.processSignedElements().isEmpty() ? 1 : 0) != 0);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_assertion_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((!samlResponse.processSignedElements().isEmpty() ? 1 : 0) != 0);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/double_signed_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((!samlResponse.processSignedElements().isEmpty() ? 1 : 0) != 0);
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/unsigned_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.processSignedElements().isEmpty());
    }

    @Test
    public void testProcessSignedElementsInvalidSignElem() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_signed_element.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Invalid Signature Element {urn:oasis:names:tc:SAML:2.0:assertion}Subject SAML Response rejected");
        samlResponse.processSignedElements();
    }

    @Test
    public void testProcessSignedElementsInvalidSignElem2() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_signed_element2.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Invalid Signature Element {urn:oasis:names:tc:SAML:2.0:assertion}Subject SAML Response rejected");
        samlResponse.processSignedElements();
    }

    @Test
    public void testProcessSignedElementsNoId() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_assertion_id.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Signed Element must contain an ID. SAML Response rejected");
        samlResponse.processSignedElements();
    }

    @Test
    public void testProcessSignedElementsDuplicateRef() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/duplicate_reference_uri.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        this.expectedEx.expect(ValidationException.class);
        this.expectedEx.expectMessage("Found an invalid Signed Element. SAML Response rejected");
        samlResponse.processSignedElements();
    }

    @Test
    public void testIsInValidSign() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        settings.setStrict(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/unsigned_response.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/triple_signed_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Duplicated ID. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/signed_assertion_response_with_2signatures.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Duplicated ID. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/signed_message_response_with_2signatures.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Duplicated ID. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_signed_element.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Invalid Signature Element {urn:oasis:names:tc:SAML:2.0:assertion}Subject SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_signed_element2.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Invalid Signature Element {urn:oasis:names:tc:SAML:2.0:assertion}Subject SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/duplicate_reference_uri.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Found an invalid Signed Element. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_assertion_id.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Signed Element must contain an ID. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/bad_reference.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Found an invalid Signed Element. SAML Response rejected", (Object)samlResponse.getError());
    }

    @Test
    public void testIsInValidSignWithCertMulti() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        settings.setStrict(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/unsigned_response.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"No Signature found. SAML Response rejected", (Object)samlResponse.getError());
        settings = new SettingsBuilder().fromFile("config/config.mywithmulticert.properties").build();
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/triple_signed_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Duplicated ID. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/signed_assertion_response_with_2signatures.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Duplicated ID. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/signed_message_response_with_2signatures.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Duplicated ID. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_signed_element.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Invalid Signature Element {urn:oasis:names:tc:SAML:2.0:assertion}Subject SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_signed_element2.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Invalid Signature Element {urn:oasis:names:tc:SAML:2.0:assertion}Subject SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/duplicate_reference_uri.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Found an invalid Signed Element. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/no_assertion_id.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Signed Element must contain an ID. SAML Response rejected", (Object)samlResponse.getError());
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/bad_reference.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertFalse((boolean)samlResponse.isValid());
        Assert.assertEquals((Object)"Found an invalid Signed Element. SAML Response rejected", (Object)samlResponse.getError());
    }

    @Test
    public void testValidateSignedElements() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Node signNode;
        int i;
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        ArrayList<Object> signedElements = new ArrayList<Object>();
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/signed_message_response.xml.base64");
        Document samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        NodeList signNodes = Util.query((Document)samlResponseDoc, (String)"//ds:Signature");
        Assert.assertFalse((boolean)samlResponse.validateSignedElements(signedElements));
        signedElements = new ArrayList();
        for (i = 0; i < signNodes.getLength(); ++i) {
            signNode = signNodes.item(i);
            signedElements.add("{" + signNode.getParentNode().getNamespaceURI() + "}" + signNode.getParentNode().getLocalName());
        }
        Assert.assertTrue((boolean)samlResponse.validateSignedElements(signedElements));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/triple_signed_response.xml.base64");
        samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        signNodes = Util.query((Document)samlResponseDoc, (String)"//ds:Signature");
        signedElements = new ArrayList();
        for (i = 0; i < signNodes.getLength(); ++i) {
            signNode = signNodes.item(i);
            signedElements.add(signNode.getParentNode().getLocalName());
        }
        Assert.assertFalse((boolean)samlResponse.validateSignedElements(signedElements));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/signed_assertion_response_with_2signatures.xml.base64");
        samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        signNodes = Util.query((Document)samlResponseDoc, (String)"//ds:Signature");
        signedElements = new ArrayList();
        for (i = 0; i < signNodes.getLength(); ++i) {
            signNode = signNodes.item(i);
            signedElements.add("{" + signNode.getParentNode().getNamespaceURI() + "}" + signNode.getParentNode().getLocalName());
        }
        Assert.assertFalse((boolean)samlResponse.validateSignedElements(signedElements));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/signed_message_response_with_2signatures.xml.base64");
        samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        signNodes = Util.query((Document)samlResponseDoc, (String)"//ds:Signature");
        signedElements = new ArrayList();
        for (i = 0; i < signNodes.getLength(); ++i) {
            signNode = signNodes.item(i);
            signedElements.add("{" + signNode.getParentNode().getNamespaceURI() + "}" + signNode.getParentNode().getLocalName());
        }
        Assert.assertFalse((boolean)samlResponse.validateSignedElements(signedElements));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/invalids/wrong_signed_element.xml.base64");
        samlResponseDoc = Util.loadXML((String)new String(Util.base64decoder((String)samlResponseEncoded)));
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        signNodes = Util.query((Document)samlResponseDoc, (String)"//ds:Signature");
        signedElements = new ArrayList();
        for (i = 0; i < signNodes.getLength(); ++i) {
            signNode = signNodes.item(i);
            signedElements.add("{" + signNode.getParentNode().getNamespaceURI() + "}" + signNode.getParentNode().getLocalName());
        }
        Assert.assertFalse((boolean)samlResponse.validateSignedElements(signedElements));
    }

    @Test
    public void testIsValidSignWithEmptyReferenceURI() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.noreferenceuri.properties").build();
        settings.setWantAssertionsSigned(false);
        settings.setWantMessagesSigned(false);
        String requestURL = "http://localhost:9001/v1/users/authorize/saml";
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response_without_reference_uri.xml.base64");
        settings.setStrict(false);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("http://localhost:9001/v1/users/authorize/saml", samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest("http://localhost:9001/v1/users/authorize/saml", samlResponseEncoded));
        Assert.assertTrue((boolean)samlResponse.isValid());
        Map attributes = samlResponse.getAttributes();
        Assert.assertFalse((boolean)attributes.isEmpty());
        String attrName = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress";
        Assert.assertEquals((Object)"saml@user.com", ((List)attributes.get(attrName)).get(0));
    }

    @Test
    public void testGetError() throws IOException, SAMLSevereException, XPathExpressionException, ParserConfigurationException, SAXException, SettingsException, ValidationException {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.my.properties").build();
        settings.setStrict(true);
        String samlResponseEncoded = Util.getFileAsString((String)"data/responses/response4.xml.base64");
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertNull((Object)samlResponse.getError());
        Assert.assertNull((Object)samlResponse.getValidationException());
        samlResponse.isValid();
        Assert.assertThat((Object)samlResponse.getError(), (Matcher)CoreMatchers.containsString((String)"SAML Response must contain 1 Assertion."));
        Assert.assertTrue((boolean)(samlResponse.getValidationException() instanceof ValidationException));
        settings.setStrict(false);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        samlResponse.isValid();
        Assert.assertThat((Object)samlResponse.getError(), (Matcher)CoreMatchers.containsString((String)"SAML Response must contain 1 Assertion."));
        Assert.assertTrue((boolean)(samlResponse.getValidationException() instanceof ValidationException));
        samlResponseEncoded = Util.getFileAsString((String)"data/responses/valid_response.xml.base64");
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertNull((Object)samlResponse.getError());
        Assert.assertNull((Object)samlResponse.getValidationException());
        samlResponse.isValid();
        Assert.assertNull((Object)samlResponse.getError());
        Assert.assertNull((Object)samlResponse.getValidationException());
        settings.setStrict(true);
        samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertNull((Object)samlResponse.getError());
        Assert.assertNull((Object)samlResponse.getValidationException());
        samlResponse.isValid();
        Assert.assertNull((Object)samlResponse.getError());
        Assert.assertNull((Object)samlResponse.getValidationException());
    }

    private String loadAndEncode(String path) throws Exception {
        return Util.base64encoder((String)Util.getFileAsString((String)path));
    }

    private String loadSignMessageAndEncode(String path) throws Exception {
        String samlResponse = Util.getFileAsString((String)path);
        String signed = Util.addSign((Document)Util.convertStringToDocument((String)samlResponse), (PrivateKey)Util.loadPrivateKey((String)Util.getFileAsString((String)"data/customPath/certs/sp.pem")), (X509Certificate)Util.loadCert((String)Util.getFileAsString((String)"data/customPath/certs/sp.crt")), (String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        return Util.base64encoder((String)signed);
    }

    private void assertResponseValid(Saml2Settings settings, String samlResponseEncoded, boolean strict, boolean expectedValid, String expectedError) throws Exception {
        settings.setStrict(strict);
        SamlResponse samlResponse = new SamlResponse(settings, AuthnResponseTest.newHttpRequest(samlResponseEncoded));
        Assert.assertEquals((Object)expectedValid, (Object)samlResponse.isValid());
        Assert.assertEquals((Object)expectedError, (Object)samlResponse.getError());
    }

    private static HttpRequest newHttpRequest(String samlResponseEncoded) {
        return AuthnResponseTest.newHttpRequest(ACS_URL, samlResponseEncoded);
    }

    private static HttpRequest newHttpRequest(String requestURL, String samlResponseEncoded) {
        return new HttpRequest(requestURL, (String)null).addParameter("SAMLResponse", samlResponseEncoded);
    }
}

