/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.test.authn;

import java.util.ArrayList;
import java.util.Calendar;
import org.codelibs.saml2.core.authn.AuthnRequest;
import org.codelibs.saml2.core.authn.AuthnRequestParams;
import org.codelibs.saml2.core.settings.Saml2Settings;
import org.codelibs.saml2.core.settings.SettingsBuilder;
import org.codelibs.saml2.core.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class AuthnRequestTest {
    @Test
    public void testGetEncodedAuthnRequestSimulated() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        final String authnRequestString = Util.getFileAsString((String)"data/requests/authn_request.xml");
        AuthnRequest authnRequest = new AuthnRequest(settings){

            public String getAuthnRequestXml() {
                return authnRequestString;
            }
        };
        String expectedAuthnRequestStringBase64Deflated = Util.getFileAsString((String)"data/requests/authn_request.xml.deflated.base64");
        String expectedAuthnRequestStringBase64 = Util.getFileAsString((String)"data/requests/authn_request.xml.base64");
        String authnRequestStringBase64Deflated = authnRequest.getEncodedAuthnRequest();
        Assert.assertEquals((Object)authnRequestStringBase64Deflated, (Object)expectedAuthnRequestStringBase64Deflated);
        authnRequestStringBase64Deflated = authnRequest.getEncodedAuthnRequest(null);
        Assert.assertEquals((Object)authnRequestStringBase64Deflated, (Object)expectedAuthnRequestStringBase64Deflated);
        authnRequestStringBase64Deflated = authnRequest.getEncodedAuthnRequest(Boolean.valueOf(true));
        Assert.assertEquals((Object)authnRequestStringBase64Deflated, (Object)expectedAuthnRequestStringBase64Deflated);
        authnRequestStringBase64Deflated = authnRequest.getEncodedAuthnRequest(Boolean.valueOf(false));
        Assert.assertNotEquals((Object)authnRequestStringBase64Deflated, (Object)expectedAuthnRequestStringBase64Deflated);
        Assert.assertEquals((Object)authnRequestStringBase64Deflated, (Object)expectedAuthnRequestStringBase64);
        settings.setCompressRequest(true);
        authnRequest = new AuthnRequest(settings){

            public String getAuthnRequestXml() {
                return authnRequestString;
            }
        };
        authnRequestStringBase64Deflated = authnRequest.getEncodedAuthnRequest(null);
        Assert.assertEquals((Object)authnRequestStringBase64Deflated, (Object)expectedAuthnRequestStringBase64Deflated);
        settings.setCompressRequest(false);
        authnRequest = new AuthnRequest(settings){

            public String getAuthnRequestXml() {
                return authnRequestString;
            }
        };
        authnRequestStringBase64Deflated = authnRequest.getEncodedAuthnRequest(null);
        Assert.assertNotEquals((Object)authnRequestStringBase64Deflated, (Object)expectedAuthnRequestStringBase64Deflated);
        Assert.assertEquals((Object)authnRequestStringBase64Deflated, (Object)expectedAuthnRequestStringBase64);
    }

    @Test
    public void testGetEncodedAuthnRequestOnlySettings() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"ProviderName=\"SP Java Example\"")));
        settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        authnRequest = new AuthnRequest(settings);
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"ProviderName=\"SP Java Example\""));
    }

    @Test
    public void testGetEncodedAuthnRequestOnlySettingsSpecialChars() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_specialchars.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"ProviderName=\"S&amp;P Java Example\"")));
        settings = new SettingsBuilder().fromFile("config/config.all_specialchars.properties").build();
        authnRequest = new AuthnRequest(settings);
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"ProviderName=\"S&amp;P Java &quot;Example&quot;\""));
    }

    @Test
    public void testGetAuthnRequestXml() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestXML = authnRequest.getAuthnRequestXml();
        Assert.assertThat((Object)authnRequestXML, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
    }

    @Test
    public void testForceAuthN() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"ForceAuthn=\"true\"")));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, false));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"ForceAuthn=\"true\"")));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(true, false, false));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"ForceAuthn=\"true\""));
    }

    @Test
    public void testIsPassive() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"IsPassive=\"true\"")));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, false));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"IsPassive=\"true\"")));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, true, false));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"IsPassive=\"true\""));
    }

    @Test
    public void testNameIDPolicy() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified\""));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, false));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy")));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, true));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified\""));
    }

    @Test
    public void testAllowCreate() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"AllowCreate=\"true\""));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, true));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"AllowCreate=\"true\""));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, true, true));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"AllowCreate=\"true\""));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, true, false));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"AllowCreate=\"true\"")));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, false));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy")));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"AllowCreate=\"true\"")));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, false, true));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy")));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"AllowCreate=\"true\"")));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, false, false));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy")));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"AllowCreate=\"true\"")));
    }

    @Test
    public void testCreateEncPolicySAMLRequest() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.all.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:NameIDPolicy"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted\""));
    }

    @Test
    public void testAuthNContext() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        ArrayList<String> requestedAuthnContext = new ArrayList<String>();
        settings.setRequestedAuthnContext(requestedAuthnContext);
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:RequestedAuthnContext")));
        requestedAuthnContext.add("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        settings.setRequestedAuthnContext(requestedAuthnContext);
        authnRequest = new AuthnRequest(settings);
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:RequestedAuthnContext Comparison=\"exact\">"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:Password</saml:AuthnContextClassRef>"));
        requestedAuthnContext.add("urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
        settings.setRequestedAuthnContext(requestedAuthnContext);
        settings.setRequestedAuthnContext(requestedAuthnContext);
        authnRequest = new AuthnRequest(settings);
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:RequestedAuthnContext Comparison=\"exact\">"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:Password</saml:AuthnContextClassRef>"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:X509</saml:AuthnContextClassRef>"));
    }

    @Test
    public void testAuthNContextSpecialChars() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_specialchars.properties").build();
        ArrayList<String> requestedAuthnContext = new ArrayList<String>();
        settings.setRequestedAuthnContext(requestedAuthnContext);
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:RequestedAuthnContext")));
        requestedAuthnContext.add("urn:custom:a&b");
        settings.setRequestedAuthnContext(requestedAuthnContext);
        authnRequest = new AuthnRequest(settings);
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:RequestedAuthnContext Comparison=\"exact\">"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:AuthnContextClassRef>urn:custom:a&amp;b</saml:AuthnContextClassRef>"));
        requestedAuthnContext.add("urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
        settings.setRequestedAuthnContext(requestedAuthnContext);
        settings.setRequestedAuthnContext(requestedAuthnContext);
        authnRequest = new AuthnRequest(settings);
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:RequestedAuthnContext Comparison=\"exact\">"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:AuthnContextClassRef>urn:custom:a&amp;b</saml:AuthnContextClassRef>"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:X509</saml:AuthnContextClassRef>"));
    }

    @Test
    public void testSubject() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<saml:Subject")));
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, false, "testuser@example.com"));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:Subject"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified\">testuser@example.com</saml:NameID>"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:bearer\">"));
        settings = new SettingsBuilder().fromFile("config/config.emailaddressformat.properties").build();
        authnRequest = new AuthnRequest(settings, new AuthnRequestParams(false, false, false, "testuser@example.com"));
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:Subject"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress\">testuser@example.com</saml:NameID>"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:bearer\">"));
    }

    @Test
    public void testSubjectSpecialChars() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_specialchars.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<saml:Subject")));
        authnRequest = new AuthnRequest(settings, false, false, false, "t&stuser@example.com");
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:Subject"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified\">t&amp;stuser@example.com</saml:NameID>"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<saml:SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:bearer\">"));
    }

    @Test
    public void testGetId() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStr = Util.base64decodedInflated((String)authnRequest.getEncodedAuthnRequest());
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)("ID=\"" + authnRequest.getId() + "\"")));
    }

    @Test
    public void testGetIssueInstant() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        long start = System.currentTimeMillis();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        long end = System.currentTimeMillis();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequest.getEncodedAuthnRequest());
        Calendar issueInstant = authnRequest.getIssueInstant();
        Assert.assertNotNull((Object)issueInstant);
        long millis = issueInstant.getTimeInMillis();
        Assert.assertTrue((millis >= start && millis <= end ? 1 : 0) != 0);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)("IssueInstant=\"" + Util.formatDateTime((long)millis) + "\"")));
    }

    @Test
    public void testAuthNDestination() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SSOService.php\""));
        settings = new Saml2Settings();
        authnRequest = new AuthnRequest(settings);
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SSOService.php\"")));
    }

    @Test
    public void testAuthNDestinationSpecialChars() throws Exception {
        Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min_specialchars.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings);
        String authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        String authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SSOService.php?a=1&amp;b=2\""));
        settings = new Saml2Settings();
        authnRequest = new AuthnRequest(settings);
        authnRequestStringBase64 = authnRequest.getEncodedAuthnRequest();
        authnRequestStr = Util.base64decodedInflated((String)authnRequestStringBase64);
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.containsString((String)"<samlp:AuthnRequest"));
        Assert.assertThat((Object)authnRequestStr, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Destination=\"http://idp.example.com/simplesaml/saml2/idp/SSOService.php?a=1&amp;b=2\"")));
    }

    @Test
    public void testPostProcessXml() throws Exception {
        final Saml2Settings settings = new SettingsBuilder().fromFile("config/config.min.properties").build();
        AuthnRequest authnRequest = new AuthnRequest(settings){

            protected String postProcessXml(String authnRequestXml, AuthnRequestParams params, Saml2Settings sett) {
                Assert.assertEquals((Object)authnRequestXml, (Object)super.postProcessXml(authnRequestXml, params, sett));
                Assert.assertSame((Object)settings, (Object)sett);
                return "changed";
            }
        };
        Assert.assertEquals((Object)"changed", (Object)authnRequest.getAuthnRequestXml());
    }
}

