/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.saml2.core.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.saml2.core.http.HttpRequest;
import org.codelibs.saml2.core.test.NaiveUrlEncoder;
import org.codelibs.saml2.core.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HttpRequestTest {
    @Test
    public void testConstructorWithNoQueryParams() throws Exception {
        String url = "url";
        HttpRequest request = new HttpRequest("url", (String)null);
        Assert.assertThat((Object)request.getRequestURL(), (Matcher)CoreMatchers.equalTo((Object)"url"));
        Assert.assertThat((Object)request.getParameters(), (Matcher)CoreMatchers.equalTo(Collections.emptyMap()));
        Assert.assertThat((Object)request.getParameters("x"), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
        Assert.assertThat((Object)request.getParameter("x"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testConstructorWithQueryParams() throws Exception {
        String url = "url";
        String name = "name";
        String value1 = "val1";
        String value2 = "val2";
        List<String> values = Arrays.asList("val1", "val2");
        Map<String, List<String>> parametersMap = Collections.singletonMap("name", values);
        HttpRequest request = new HttpRequest("url", parametersMap, null);
        Assert.assertThat((Object)request.getRequestURL(), (Matcher)CoreMatchers.equalTo((Object)"url"));
        Assert.assertThat((Object)request.getParameters(), (Matcher)CoreMatchers.equalTo(parametersMap));
        Assert.assertThat((Object)request.getParameters("name"), (Matcher)CoreMatchers.equalTo(values));
        Assert.assertThat((Object)request.getParameter("name"), (Matcher)CoreMatchers.equalTo((Object)"val1"));
    }

    @Test
    public void testAddParameter() throws Exception {
        String url = "some_url";
        String name = "name";
        String value = "value";
        HttpRequest request = new HttpRequest("some_url", (String)null).addParameter("name", "value");
        Assert.assertThat((Object)request.getRequestURL(), (Matcher)CoreMatchers.equalTo((Object)"some_url"));
        Assert.assertThat((Object)request.getParameters(), (Matcher)CoreMatchers.equalTo(Collections.singletonMap("name", Collections.singletonList("value"))));
        Assert.assertThat((Object)request.getParameters("name"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("value")));
        Assert.assertThat((Object)request.getParameter("name"), (Matcher)CoreMatchers.equalTo((Object)"value"));
        HttpRequest request2 = request.addParameter("name", "value");
        Assert.assertThat((Object)request2.getParameters("name"), (Matcher)CoreMatchers.equalTo(Arrays.asList("value", "value")));
    }

    @Test
    public void testRemoveParameter() throws Exception {
        String url = "some_url";
        String name = "name";
        String value = "value";
        HttpRequest request = new HttpRequest("some_url", (String)null).addParameter("name", "value");
        Assert.assertThat((Object)request.getRequestURL(), (Matcher)CoreMatchers.equalTo((Object)"some_url"));
        Assert.assertThat((Object)request.getParameters(), (Matcher)CoreMatchers.equalTo(Collections.singletonMap("name", Collections.singletonList("value"))));
        Assert.assertThat((Object)request.getParameters("name"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("value")));
        Assert.assertThat((Object)request.getParameter("name"), (Matcher)CoreMatchers.equalTo((Object)"value"));
        request = request.removeParameter("name");
        Assert.assertThat((Object)request.getRequestURL(), (Matcher)CoreMatchers.equalTo((Object)"some_url"));
        Assert.assertTrue((boolean)request.getParameters().isEmpty());
        Assert.assertTrue((boolean)request.getParameters("name").isEmpty());
        Assert.assertNull((Object)request.getParameter("name"));
    }

    @Test
    public void testGetEncodedParameter_encodesParametersNotOnQueryString() throws Exception {
        String url = "url";
        String name = "name";
        String value1 = "val/1!";
        String addedName = "added";
        String addedValue = "added#value!";
        List<String> values = Arrays.asList("val/1!");
        Map<String, List<String>> parametersMap = Collections.singletonMap("name", values);
        HttpRequest request = new HttpRequest("url", parametersMap, null).addParameter("added", "added#value!");
        Assert.assertThat((Object)request.getEncodedParameter("name"), (Matcher)CoreMatchers.equalTo((Object)Util.urlEncoder((String)"val/1!")));
        Assert.assertThat((Object)request.getEncodedParameter("added"), (Matcher)CoreMatchers.equalTo((Object)Util.urlEncoder((String)"added#value!")));
    }

    @Test
    public void testGetEncodedParameter_prefersValueFromQueryString() throws Exception {
        String url = "url";
        String name = "name";
        String value1 = "value1";
        String urlValue1 = "onUrl1";
        String queryString = "name=onUrl1";
        List<String> values = Arrays.asList("value1");
        Map<String, List<String>> parametersMap = Collections.singletonMap("name", values);
        HttpRequest request = new HttpRequest("url", parametersMap, "name=onUrl1");
        Assert.assertThat((Object)request.getEncodedParameter("name"), (Matcher)CoreMatchers.equalTo((Object)"onUrl1"));
        Assert.assertThat((Object)request.getParameter("name"), (Matcher)CoreMatchers.equalTo((Object)"value1"));
    }

    @Test
    public void testGetEncodedParameter_returnsExactAsGivenInQueryString() throws Exception {
        String url = "url";
        String name = "name";
        String encodedValue1 = NaiveUrlEncoder.encode("do not alter!");
        String queryString = "name=" + encodedValue1;
        HttpRequest request = new HttpRequest("url", queryString);
        Assert.assertThat((Object)request.getEncodedParameter("name"), (Matcher)CoreMatchers.equalTo((Object)encodedValue1));
    }

    @Test
    public void testGetEncodedParameter_handlesMultipleValuesOnQueryString() throws Exception {
        String url = "url";
        String queryString = "k1=v1&k2=v2&k3=v3";
        HashMap parametersMap = new HashMap();
        HttpRequest request = new HttpRequest("url", parametersMap, "k1=v1&k2=v2&k3=v3");
        Assert.assertThat((Object)request.getEncodedParameter("k1"), (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)request.getEncodedParameter("k2"), (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)request.getEncodedParameter("k3"), (Matcher)CoreMatchers.equalTo((Object)"v3"));
    }

    @Test
    public void testGetEncodedParameter_stopsAtUrlFragment() throws Exception {
        String url = "url";
        String queryString = "first=&foo=bar#ignore";
        HttpRequest request = new HttpRequest("url", "first=&foo=bar#ignore");
        Assert.assertThat((Object)request.getEncodedParameter("foo"), (Matcher)CoreMatchers.equalTo((Object)"bar"));
    }

    @Test
    public void testGetEncodedParameter_withDefault_usesDefaultWhenParameterMissing() throws Exception {
        String url = "url";
        String foobar = "foo/bar!";
        HttpRequest request = new HttpRequest("url", (String)null);
        Assert.assertThat((Object)request.getEncodedParameter("missing", "foo/bar!"), (Matcher)CoreMatchers.equalTo((Object)Util.urlEncoder((String)"foo/bar!")));
    }

    @Test
    public void testAddParameter_preservesQueryString() throws Exception {
        String url = "url";
        String name = "name";
        String value1 = "val/1!";
        String encodedValue1 = NaiveUrlEncoder.encode("val/1!");
        String queryString = "name=" + encodedValue1;
        HashMap parametersMap = new HashMap();
        HttpRequest request = new HttpRequest("url", parametersMap, queryString).addParameter("name", "val/1!");
        Assert.assertThat((Object)request.getEncodedParameter("name"), (Matcher)CoreMatchers.equalTo((Object)encodedValue1));
    }

    @Test
    public void testRemoveParameter_preservesQueryString() throws Exception {
        String url = "url";
        String name = "name";
        String value1 = "val/1!";
        String encodedValue1 = NaiveUrlEncoder.encode("val/1!");
        String queryString = "name=" + encodedValue1;
        List<String> values = Arrays.asList("val/1!");
        Map<String, List<String>> parametersMap = Collections.singletonMap("name", values);
        HttpRequest request = new HttpRequest("url", parametersMap, queryString).removeParameter("name");
        Assert.assertThat((Object)request.getEncodedParameter("name"), (Matcher)CoreMatchers.equalTo((Object)encodedValue1));
    }
}

