/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.ds.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.app.service.FailureUrlService;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MultipleCrawlingAccessException;
import org.codelibs.fess.ds.AbstractDataStore;
import org.codelibs.fess.ds.callback.IndexUpdateCallback;
import org.codelibs.fess.es.config.exentity.CrawlingConfig;
import org.codelibs.fess.es.config.exentity.DataConfig;
import org.codelibs.fess.exception.DataStoreCrawlingException;
import org.codelibs.fess.exception.DataStoreException;
import org.codelibs.fess.exception.FessSystemException;
import org.codelibs.fess.util.ComponentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDataStore
extends AbstractDataStore {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseDataStore.class);
    private static final String SQL_PARAM = "sql";
    private static final String URL_PARAM = "url";
    private static final String PASSWORD_PARAM = "password";
    private static final String USERNAME_PARAM = "username";
    private static final String DRIVER_PARAM = "driver";

    protected String getName() {
        return "Database";
    }

    protected String getDriverClass(Map<String, String> paramMap) {
        String driverName = paramMap.get(DRIVER_PARAM);
        if (StringUtil.isBlank((String)driverName)) {
            throw new DataStoreException("JDBC driver is null");
        }
        return driverName;
    }

    protected String getUsername(Map<String, String> paramMap) {
        return paramMap.get(USERNAME_PARAM);
    }

    protected String getPassword(Map<String, String> paramMap) {
        return paramMap.get(PASSWORD_PARAM);
    }

    protected String getUrl(Map<String, String> paramMap) {
        return paramMap.get(URL_PARAM);
    }

    protected String getSql(Map<String, String> paramMap) {
        String sql = paramMap.get(SQL_PARAM);
        if (StringUtil.isBlank((String)sql)) {
            throw new DataStoreException("sql is null");
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void storeData(DataConfig config, IndexUpdateCallback callback, Map<String, String> paramMap, Map<String, String> scriptMap, Map<String, Object> defaultDataMap) {
        long readInterval = this.getReadInterval(paramMap);
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Class.forName(this.getDriverClass(paramMap));
            String jdbcUrl = this.getUrl(paramMap);
            String username = this.getUsername(paramMap);
            if (logger.isDebugEnabled()) {
                logger.debug("jdbc: " + jdbcUrl + " : " + username);
            }
            String password = this.getPassword(paramMap);
            con = StringUtil.isNotEmpty((String)username) ? DriverManager.getConnection(jdbcUrl, username, password) : DriverManager.getConnection(jdbcUrl);
            String sql = this.getSql(paramMap);
            if (logger.isDebugEnabled()) {
                logger.debug("sql: " + sql);
            }
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            boolean loop = true;
            while (rs.next() && loop && this.alive) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.putAll(defaultDataMap);
                HashMap<String, Object> crawlingContext = new HashMap<String, Object>();
                crawlingContext.put("doc", dataMap);
                ResultSetParamMap params = new ResultSetParamMap(config, crawlingContext, rs, paramMap);
                if (logger.isDebugEnabled()) {
                    logger.debug("params: " + params);
                }
                for (Map.Entry<String, String> entry : scriptMap.entrySet()) {
                    Object convertValue = this.convertValue(entry.getValue(), params);
                    if (convertValue == null) continue;
                    dataMap.put(entry.getKey(), convertValue);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("dataMap: " + dataMap);
                }
                try {
                    callback.store(paramMap, dataMap);
                }
                catch (CrawlingAccessException e) {
                    String url;
                    Throwable cause;
                    Throwable[] causes;
                    logger.warn("Crawling Access Exception at : " + dataMap, (Throwable)e);
                    Throwable target = e;
                    if (target instanceof MultipleCrawlingAccessException && (causes = ((MultipleCrawlingAccessException)target).getCauses()).length > 0) {
                        target = causes[causes.length - 1];
                    }
                    String errorName = (cause = target.getCause()) != null ? cause.getClass().getCanonicalName() : target.getClass().getCanonicalName();
                    if (target instanceof DataStoreCrawlingException) {
                        DataStoreCrawlingException dce = (DataStoreCrawlingException)target;
                        url = dce.getUrl();
                        if (dce.aborted()) {
                            loop = false;
                        }
                    } else {
                        url = sql + ":" + rs.getRow();
                    }
                    FailureUrlService failureUrlService = (FailureUrlService)ComponentUtil.getComponent(FailureUrlService.class);
                    failureUrlService.store((CrawlingConfig)config, errorName, url, target);
                }
                catch (Throwable t) {
                    logger.warn("Crawling Access Exception at : " + dataMap, t);
                    String url = sql + ":" + rs.getRow();
                    FailureUrlService failureUrlService = (FailureUrlService)ComponentUtil.getComponent(FailureUrlService.class);
                    failureUrlService.store((CrawlingConfig)config, t.getClass().getCanonicalName(), url, t);
                }
                if (readInterval <= 0L) continue;
                this.sleep(readInterval);
            }
            return;
        }
        catch (Exception e) {
            throw new DataStoreException("Failed to crawl data in DB.", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.warn("Failed to close a result set.", (Throwable)e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    logger.warn("Failed to close a statement.", (Throwable)e);
                }
                finally {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (SQLException e) {
                        logger.warn("Failed to close a db connection.", (Throwable)e);
                    }
                }
            }
        }
    }

    protected static class ResultSetParamMap
    implements Map<String, Object> {
        private final Map<String, Object> paramMap = new HashMap<String, Object>();

        public ResultSetParamMap(DataConfig config, Map<String, Object> crawlingContext, ResultSet resultSet, Map<String, String> paramMap) {
            this.paramMap.putAll(paramMap);
            this.paramMap.put("crawlingConfig", config);
            this.paramMap.put("crawlingContext", crawlingContext);
            try {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columnCount = metaData.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    try {
                        String label = metaData.getColumnLabel(i + 1);
                        String value = resultSet.getString(i + 1);
                        this.paramMap.put(label, value);
                        continue;
                    }
                    catch (SQLException e) {
                        logger.warn("Failed to parse data in a result set. The column is " + (i + 1) + ".", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                throw new FessSystemException("Failed to access meta data.", (Throwable)e);
            }
        }

        @Override
        public void clear() {
            this.paramMap.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.paramMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.paramMap.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.paramMap.entrySet();
        }

        @Override
        public Object get(Object key) {
            return this.paramMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.paramMap.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.paramMap.keySet();
        }

        @Override
        public Object put(String key, Object value) {
            return this.paramMap.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            this.paramMap.putAll(m);
        }

        @Override
        public Object remove(Object key) {
            return this.paramMap.remove(key);
        }

        @Override
        public int size() {
            return this.paramMap.size();
        }

        @Override
        public Collection<Object> values() {
            return this.paramMap.values();
        }
    }
}

