/*
 * Decompiled with CFR 0.152.
 */
package org.codejuicer.java2csharp.sharpen.customization;

import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.codejuicer.java2csharp.sharpen.customization.CompilationUnitExtended;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import sharpen.core.framework.ASTResolver;

public class CustomASTResolver
implements ASTResolver {
    private Log logger;
    private Map<String, CompilationUnitExtended> sourcePathEntry;

    public CustomASTResolver(Log logger, Map<String, CompilationUnitExtended> sourcePathEntry) {
        this.logger = logger;
        this.sourcePathEntry = sourcePathEntry;
    }

    @Override
    public ASTNode findDeclaringNode(IBinding binding) {
        if (binding != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((CharSequence)("Called resolver for binding " + binding.getName()));
            }
            for (String sourceFilePath : this.sourcePathEntry.keySet()) {
                CompilationUnit cu = this.sourcePathEntry.get(sourceFilePath).getCompilationUnit();
                ASTNode node = cu.findDeclaringNode(binding);
                if (null == node) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((CharSequence)("Found ASTNode " + node.toString()));
                }
                return node;
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)"Called resolver for null binding");
        }
        return null;
    }
}

