/*
 * Decompiled with CFR 0.152.
 */
package org.codejuicer.java2csharp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codejuicer.java2csharp.ConversionConfiguration;
import org.codejuicer.java2csharp.sharpen.customization.CSharpFileWriter;
import org.codejuicer.java2csharp.sharpen.customization.CompilationUnitExtended;
import org.codejuicer.java2csharp.sharpen.customization.CustomASTResolver;
import org.codejuicer.java2csharp.sharpen.customization.CustomFileASTRequestor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import sharpen.core.CSharpBuilder;
import sharpen.core.Configuration;
import sharpen.core.ConfigurationFactory;
import sharpen.core.csharp.ast.CSCompilationUnit;
import sharpen.core.framework.ASTUtility;
import sharpen.core.framework.Environment;
import sharpen.core.framework.Environments;

public class Java2CsharpMojo
extends AbstractMojo {
    private ConversionConfiguration[] conversionConfigurations;
    private List<String> inputPaths;
    private List<String> charsetEntry;
    private Map<String, CompilationUnitExtended> sourcePathEntry;

    private void listFilesForFolder(File folder) {
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                this.inputPaths.add(fileEntry.getAbsolutePath());
                this.listFilesForFolder(fileEntry);
                continue;
            }
            this.charsetEntry.add("UTF-8");
            this.sourcePathEntry.put(fileEntry.getAbsolutePath(), null);
        }
    }

    private void processFolderToFindJavaClass(File inputFolder) {
        this.inputPaths = new ArrayList<String>();
        this.inputPaths.add(inputFolder.getAbsolutePath());
        this.sourcePathEntry = new HashMap<String, CompilationUnitExtended>();
        this.charsetEntry = new ArrayList<String>();
        this.listFilesForFolder(inputFolder);
    }

    private void createCompilationUnitsForJavaFiles(File inputFolder) {
        this.processFolderToFindJavaClass(inputFolder);
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setEnvironment(null, new String[]{inputFolder.getAbsolutePath()}, new String[]{"UTF-8"}, true);
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        parser.setCompilerOptions((Map)options);
        CustomFileASTRequestor requestor = new CustomFileASTRequestor(this.getLog(), inputFolder.getAbsolutePath(), this.sourcePathEntry);
        parser.createASTs(this.sourcePathEntry.keySet().toArray(new String[0]), this.charsetEntry.toArray(new String[0]), new String[]{""}, (FileASTRequestor)requestor, null);
    }

    private Configuration createCustomConfiguration() {
        Configuration configuration = ConfigurationFactory.defaultConfiguration();
        configuration.enableNativeTypeSystem();
        configuration.enableOrganizeUsings();
        return configuration;
    }

    private void processCompilationUnitAndGenerateCSharpUnit(CompilationUnit cu, CSCompilationUnit compilationUnit) {
        ASTUtility.checkForProblems(cu, false);
        CustomASTResolver resolver = new CustomASTResolver(this.getLog(), this.sourcePathEntry);
        Environment environment = Environments.newConventionBasedEnvironment(cu, this.createCustomConfiguration(), resolver, compilationUnit);
        try {
            Environments.runWith(environment, new Runnable(){

                @Override
                public void run() {
                    CSharpBuilder builder = new CSharpBuilder();
                    builder.run();
                }
            });
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error during parsing java file", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"start Java2Csharp execution");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Java2Csharp analize " + this.conversionConfigurations.length + " configurations"));
        }
        for (ConversionConfiguration configuration : this.conversionConfigurations) {
            File inpuFolder = new File(configuration.getSourcePath());
            if (!inpuFolder.exists() || !inpuFolder.isDirectory()) throw new MojoExecutionException("Invalid source path " + configuration.getSourcePath());
            File outputFolder = new File(configuration.getOutputDirectory());
            if (!outputFolder.exists() || !outputFolder.isDirectory()) throw new MojoExecutionException("Invalid output directory " + configuration.getOutputDirectory());
            try {
                this.createCompilationUnitsForJavaFiles(inpuFolder);
                for (String filename : this.sourcePathEntry.keySet()) {
                    CompilationUnitExtended cue = this.sourcePathEntry.get(filename);
                    CompilationUnit cu = cue.getCompilationUnit();
                    CSCompilationUnit compilationUnit = new CSCompilationUnit();
                    this.processCompilationUnitAndGenerateCSharpUnit(cu, compilationUnit);
                    String outputFileName = cue.retrieveCSharpFileNameFromJavaFileName(filename);
                    String outputSubFolderName = configuration.getOutputDirectory() + "/" + cue.getRelativePath();
                    File outputSubFolder = new File(outputSubFolderName);
                    if (!outputSubFolder.exists() && !outputSubFolder.mkdir()) continue;
                    CSharpFileWriter writer = new CSharpFileWriter(outputSubFolderName + "/" + outputFileName, compilationUnit);
                    writer.writeFile();
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error during reading java file", (Throwable)e);
            }
            this.getLog().info((CharSequence)("Java2Csharp configuration " + configuration.getName() + " created"));
        }
    }

    public void setConversionConfigurations(ConversionConfiguration[] xsdConfigurations) {
        this.conversionConfigurations = xsdConfigurations;
    }
}

