/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;

public class BindingUtils {
    public static IMethodBinding findOverriddenMethodInType(ITypeBinding type, IMethodBinding method) {
        if (type.getName().equals("Object") && method.getName().equals("clone")) {
            return null;
        }
        for (IMethodBinding o : type.getDeclaredMethods()) {
            IMethodBinding existing = o;
            if (!existing.isSubsignature(method) && !method.isSubsignature(existing)) continue;
            return existing;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInTypeOrSuperclasses(ITypeBinding type, IMethodBinding method) {
        IMethodBinding found = BindingUtils.findOverriddenMethodInType(type, method);
        if (null != found) {
            return found;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (null != superClass) {
            return BindingUtils.findOverriddenMethodInTypeOrSuperclasses(superClass, method);
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInHierarchy(ITypeBinding type, IMethodBinding binding) {
        return BindingUtils.findOverriddenMethodInHierarchy(type, binding, true);
    }

    public static IMethodBinding findOverriddenMethodInHierarchy(ITypeBinding type, IMethodBinding binding, boolean considerInterfaces) {
        IMethodBinding superClassMethod;
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (superClassMethod = BindingUtils.findOverriddenMethodInHierarchy(superClass, binding)) != null) {
            return superClassMethod;
        }
        IMethodBinding method = BindingUtils.findOverriddenMethodInType(type, binding);
        if (method != null) {
            return method;
        }
        if (considerInterfaces) {
            ITypeBinding[] interfaces = type.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                IMethodBinding interfaceMethod = BindingUtils.findOverriddenMethodInHierarchy(interfaces[i], binding);
                if (interfaceMethod == null) continue;
                return interfaceMethod;
            }
        }
        return null;
    }

    public static IMethodBinding findMethodDefininition(IMethodBinding method, AST typeResolver) {
        IMethodBinding res;
        if (null == method) {
            return null;
        }
        IMethodBinding definition = null;
        ITypeBinding type = method.getDeclaringClass();
        ITypeBinding[] interfaces = type.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            IMethodBinding res2 = BindingUtils.findOverriddenMethodInHierarchy(interfaces[i], method);
            if (res2 == null) continue;
            definition = res2;
            break;
        }
        if (type.getSuperclass() != null) {
            IMethodBinding res3 = BindingUtils.findOverriddenMethodInHierarchy(type.getSuperclass(), method);
            if (res3 != null && !Modifier.isPrivate((int)res3.getModifiers())) {
                definition = res3;
            }
        } else if (type.isInterface() && null != typeResolver && (res = BindingUtils.findOverriddenMethodInHierarchy(typeResolver.resolveWellKnownType("java.lang.Object"), method)) != null) {
            definition = res;
        }
        IMethodBinding def = BindingUtils.findMethodDefininition(definition, typeResolver);
        if (def != null) {
            return def;
        }
        return definition;
    }

    public static boolean isVisibleInHierarchy(IMethodBinding member, IPackageBinding pack) {
        int otherflags = member.getModifiers();
        ITypeBinding declaringType = member.getDeclaringClass();
        if (Modifier.isPublic((int)otherflags) || Modifier.isProtected((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (Modifier.isPrivate((int)otherflags)) {
            return false;
        }
        return pack == declaringType.getPackage();
    }

    public static String qualifiedName(IMethodBinding binding) {
        return BindingUtils.qualifiedName(binding.getDeclaringClass()) + "." + binding.getName();
    }

    public static String qualifiedSignature(IMethodBinding binding) {
        StringBuffer buf = new StringBuffer();
        buf.append(BindingUtils.qualifiedName(binding.getDeclaringClass())).append(".").append(binding.getName()).append("(");
        ITypeBinding[] parameterTypes = binding.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(BindingUtils.qualifiedName(parameterTypes[i]));
        }
        buf.append(")");
        return buf.toString();
    }

    public static String typeMappingKey(ITypeBinding type) {
        ITypeBinding[] typeArguments = type.getTypeArguments();
        if (typeArguments.length == 0) {
            typeArguments = type.getTypeParameters();
        }
        if (typeArguments.length > 0) {
            return BindingUtils.qualifiedName(type) + "<" + BindingUtils.repeat(',', typeArguments.length - 1) + ">";
        }
        return BindingUtils.qualifiedName(type);
    }

    private static String repeat(char c, int count) {
        StringBuilder builder = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            builder.append(c);
        }
        return builder.toString();
    }

    public static String qualifiedName(ITypeBinding declaringClass) {
        String qn = declaringClass.getTypeDeclaration().getQualifiedName();
        if (qn.length() > 0) {
            return qn;
        }
        return declaringClass.getQualifiedName();
    }

    public static String qualifiedName(IVariableBinding binding) {
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (null == declaringClass) {
            return binding.getName();
        }
        return BindingUtils.qualifiedName(declaringClass) + "." + binding.getName();
    }

    public static boolean isStatic(IMethodBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    public static boolean isStatic(IVariableBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    public static boolean isStatic(MethodInvocation invocation) {
        return BindingUtils.isStatic(invocation.resolveMethodBinding());
    }
}

