/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.HashMap;
import java.util.Map;
import sharpen.core.csharp.ast.CSNode;
import sharpen.core.csharp.ast.CSVisitor;

public class CSMacro
extends CSNode {
    private final String _template;
    private Map<String, Object> _variables = new HashMap<String, Object>();

    public CSMacro(String template) {
        this._template = template;
    }

    @Override
    public void accept(CSVisitor visitor) {
        visitor.visit(this);
    }

    public String template() {
        return this._template;
    }

    public void addVariable(String name, Object value) {
        if (this._variables.containsKey(name)) {
            throw new IllegalArgumentException("Variable '" + name + "' already set!");
        }
        this._variables.put(name, value);
    }

    public Object resolveVariable(String name) {
        if (!this._variables.containsKey(name)) {
            throw new IllegalStateException("Variable '" + name + "' is not set!");
        }
        return this._variables.get(name);
    }
}

