/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sharpen.core.csharp.ast.CSArrayCreationExpression;
import sharpen.core.csharp.ast.CSArrayInitializerExpression;
import sharpen.core.csharp.ast.CSArrayTypeReference;
import sharpen.core.csharp.ast.CSAttribute;
import sharpen.core.csharp.ast.CSBaseExpression;
import sharpen.core.csharp.ast.CSBlock;
import sharpen.core.csharp.ast.CSBlockStatement;
import sharpen.core.csharp.ast.CSBoolLiteralExpression;
import sharpen.core.csharp.ast.CSBreakStatement;
import sharpen.core.csharp.ast.CSCaseClause;
import sharpen.core.csharp.ast.CSCastExpression;
import sharpen.core.csharp.ast.CSCatchClause;
import sharpen.core.csharp.ast.CSCharLiteralExpression;
import sharpen.core.csharp.ast.CSClass;
import sharpen.core.csharp.ast.CSClassModifier;
import sharpen.core.csharp.ast.CSCompilationUnit;
import sharpen.core.csharp.ast.CSConditionalExpression;
import sharpen.core.csharp.ast.CSConstructor;
import sharpen.core.csharp.ast.CSConstructorInvocationExpression;
import sharpen.core.csharp.ast.CSContinueStatement;
import sharpen.core.csharp.ast.CSDeclarationExpression;
import sharpen.core.csharp.ast.CSDeclarationStatement;
import sharpen.core.csharp.ast.CSDelegate;
import sharpen.core.csharp.ast.CSDestructor;
import sharpen.core.csharp.ast.CSDoStatement;
import sharpen.core.csharp.ast.CSDocAttributeNode;
import sharpen.core.csharp.ast.CSDocNode;
import sharpen.core.csharp.ast.CSDocTagNode;
import sharpen.core.csharp.ast.CSDocTextNode;
import sharpen.core.csharp.ast.CSDocTextOverlay;
import sharpen.core.csharp.ast.CSEnum;
import sharpen.core.csharp.ast.CSEnumValue;
import sharpen.core.csharp.ast.CSEvent;
import sharpen.core.csharp.ast.CSExpression;
import sharpen.core.csharp.ast.CSExpressionStatement;
import sharpen.core.csharp.ast.CSField;
import sharpen.core.csharp.ast.CSFieldModifier;
import sharpen.core.csharp.ast.CSForEachStatement;
import sharpen.core.csharp.ast.CSForStatement;
import sharpen.core.csharp.ast.CSGotoStatement;
import sharpen.core.csharp.ast.CSIfStatement;
import sharpen.core.csharp.ast.CSIndexedExpression;
import sharpen.core.csharp.ast.CSInfixExpression;
import sharpen.core.csharp.ast.CSInterface;
import sharpen.core.csharp.ast.CSLabelStatement;
import sharpen.core.csharp.ast.CSLineComment;
import sharpen.core.csharp.ast.CSLockStatement;
import sharpen.core.csharp.ast.CSMacro;
import sharpen.core.csharp.ast.CSMacroExpression;
import sharpen.core.csharp.ast.CSMacroTypeReference;
import sharpen.core.csharp.ast.CSMember;
import sharpen.core.csharp.ast.CSMemberReferenceExpression;
import sharpen.core.csharp.ast.CSMetaMember;
import sharpen.core.csharp.ast.CSMethod;
import sharpen.core.csharp.ast.CSMethodBase;
import sharpen.core.csharp.ast.CSMethodInvocationExpression;
import sharpen.core.csharp.ast.CSMethodModifier;
import sharpen.core.csharp.ast.CSNode;
import sharpen.core.csharp.ast.CSNullLiteralExpression;
import sharpen.core.csharp.ast.CSNumberLiteralExpression;
import sharpen.core.csharp.ast.CSParenthesizedExpression;
import sharpen.core.csharp.ast.CSPostfixExpression;
import sharpen.core.csharp.ast.CSPrefixExpression;
import sharpen.core.csharp.ast.CSProperty;
import sharpen.core.csharp.ast.CSReferenceExpression;
import sharpen.core.csharp.ast.CSRemovedExpression;
import sharpen.core.csharp.ast.CSReturnStatement;
import sharpen.core.csharp.ast.CSStringLiteralExpression;
import sharpen.core.csharp.ast.CSStruct;
import sharpen.core.csharp.ast.CSSwitchStatement;
import sharpen.core.csharp.ast.CSThisExpression;
import sharpen.core.csharp.ast.CSThrowStatement;
import sharpen.core.csharp.ast.CSTryStatement;
import sharpen.core.csharp.ast.CSTypeArgumentProvider;
import sharpen.core.csharp.ast.CSTypeDeclaration;
import sharpen.core.csharp.ast.CSTypeParameter;
import sharpen.core.csharp.ast.CSTypeParameterProvider;
import sharpen.core.csharp.ast.CSTypeReference;
import sharpen.core.csharp.ast.CSTypeReferenceExpression;
import sharpen.core.csharp.ast.CSTypeofExpression;
import sharpen.core.csharp.ast.CSUncheckedExpression;
import sharpen.core.csharp.ast.CSUsing;
import sharpen.core.csharp.ast.CSUsingStatement;
import sharpen.core.csharp.ast.CSVariableDeclaration;
import sharpen.core.csharp.ast.CSVisibility;
import sharpen.core.csharp.ast.CSVisitor;
import sharpen.core.csharp.ast.CSWhileStatement;
import sharpen.core.io.IndentedWriter;

public class CSharpPrinter
extends CSVisitor {
    protected IndentedWriter _writer;
    protected CSTypeDeclaration _currentType;
    private int _lastPrintedCommentIndex;
    private List<CSLineComment> _comments;
    static final Pattern META_VARIABLE_PATTERN = Pattern.compile("\\$(\\w+)");

    public void setWriter(Writer writer, String indentString, int maxColumns) {
        this._writer = new IndentedWriter(writer, maxColumns);
        if (indentString != null) {
            this._writer.setIndentString(indentString);
        }
    }

    public void print(CSCompilationUnit node) {
        this._lastPrintedCommentIndex = 0;
        this._comments = node.comments();
        try {
            node.accept(this);
        }
        finally {
            this._currentType = null;
            this._comments = null;
        }
    }

    private List<CSUsing> printableUsingList(Iterable<CSUsing> usings) {
        ArrayList<CSUsing> list = new ArrayList<CSUsing>();
        for (CSUsing using : usings) {
            list.add(using);
        }
        Collections.sort(list, new Comparator<CSUsing>(){

            @Override
            public int compare(CSUsing a, CSUsing b) {
                boolean ia = a.namespace().startsWith("System");
                boolean ib = b.namespace().startsWith("System");
                if (ia && ib) {
                    return a.namespace().compareTo(b.namespace());
                }
                if (ia) {
                    return -1;
                }
                if (ib) {
                    return 1;
                }
                return a.namespace().compareTo(b.namespace());
            }
        });
        return list;
    }

    @Override
    public void visit(CSMacroExpression node) {
        node.macro().accept(this);
    }

    @Override
    public void visit(CSMacroTypeReference node) {
        node.macro().accept(this);
    }

    @Override
    public void visit(CSMacro node) {
        String template = node.template();
        Matcher matcher = META_VARIABLE_PATTERN.matcher(template);
        int last = 0;
        while (matcher.find()) {
            this.write(template.substring(last, matcher.start()));
            Object value = node.resolveVariable(matcher.group(1));
            if (value instanceof CSNode) {
                ((CSNode)value).accept(this);
            } else {
                this.writeCommaSeparatedList((Iterable)value);
            }
            last = matcher.end();
        }
        this.write(template.substring(last));
    }

    @Override
    public void visit(CSCompilationUnit node) {
        this.beginEnclosingIfDefs(node);
        List<CSUsing> usings = this.printableUsingList(node.usings());
        for (CSUsing using : usings) {
            using.accept(this);
        }
        if (usings.size() > 0) {
            this._writer.writeLine();
        }
        if (null != node.namespace()) {
            this.writeLine("namespace " + node.namespace());
            this.enterBody();
        }
        this.writeLineSeparatedList(node.types());
        if (null != node.namespace()) {
            this.leaveBody();
        }
        this.endEnclosingIfDefs(node);
    }

    @Override
    public void visit(CSRemovedExpression node) {
        throw new IllegalStateException("Unexpected removal of expression: " + node.toString());
    }

    @Override
    public void visit(CSUsing node) {
        this.writeLine("using " + node.namespace() + ";");
    }

    @Override
    public void visit(CSUsingStatement node) {
        this.printPrecedingComments(node);
        this.writeIndented("using (");
        node.expression().accept(this);
        this.writeLine(")");
        node.body().accept(this);
    }

    @Override
    public void visit(CSClass node) {
        this.writeType(node);
    }

    @Override
    public void visit(CSEnum node) {
        this.writeMemberHeader(node);
        this.writeLine("enum " + node.name());
        this.enterBody();
        this.writeSeparatedList(node.values(), new Closure(){

            @Override
            public void execute() {
                CSharpPrinter.this.writeLine(",");
            }
        });
        this.writeLine();
        this.leaveBody();
    }

    @Override
    public void visit(CSEnumValue node) {
        this.writeIndented(node.name());
    }

    @Override
    public void visit(CSStruct node) {
        this.writeType(node);
    }

    @Override
    public void visit(CSInterface node) {
        this.writeType(node);
    }

    @Override
    public void visit(CSTypeParameter node) {
        this.write(node.name());
    }

    @Override
    public void visit(CSArrayTypeReference node) {
        node.elementType().accept(this);
        for (int i = 0; i < node.dimensions(); ++i) {
            this.write("[]");
        }
    }

    @Override
    public void visit(CSTypeReference node) {
        this.write(node.typeName());
        this.writeTypeArguments(node);
    }

    private void writeTypeArguments(CSTypeArgumentProvider node) {
        List<CSTypeReferenceExpression> typeArgs = node.typeArguments();
        if (!typeArgs.isEmpty()) {
            this.writeGenericParameters(typeArgs);
        }
    }

    @Override
    public void visit(CSDelegate node) {
        this.writeMemberHeader(node);
        this.write("delegate void ");
        this.write(node.name());
        this.writeParameterList(node.parameters());
        this.writeLine(";");
    }

    private void writeTypeHeader(CSTypeDeclaration node) {
        this.writeMemberHeader(node);
        if (node.isInterface()) {
            if (node.partial()) {
                this._writer.write("partial ");
            }
            this.write("interface " + node.name());
        } else if (node instanceof CSClass) {
            CSClass classNode = (CSClass)node;
            this.write(this.classModifier(classNode.modifier()));
            if (node.partial()) {
                this._writer.write("partial ");
            }
            this.write("class " + node.name());
        } else {
            this.write("struct " + node.name());
        }
        this.writeTypeParameters(node);
        this.writeBaseTypes(node);
        this.writeTypeParameterConstraints(node.typeParameters());
    }

    private void writeMemberHeader(CSTypeDeclaration node) {
        this.writeAttributes(node);
        this.writeVisibility(node);
    }

    private void writeTypeParameters(CSTypeParameterProvider node) {
        List<CSTypeParameter> parameters = node.typeParameters();
        if (parameters.isEmpty()) {
            return;
        }
        this.writeGenericParameters(parameters);
    }

    private void writeTypeParameterConstraints(List<CSTypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        for (CSTypeParameter tp : parameters) {
            if (tp.superClass() == null) continue;
            this.writeLine();
            this.indent();
            this.writeIndented("where ");
            this.write(tp.name() + " : ");
            tp.superClass().accept(this);
            this.outdent();
        }
    }

    private <T extends CSNode> void writeGenericParameters(Iterable<T> nodes) {
        this.write("<");
        this.writeCommaSeparatedList(nodes);
        this.write(">");
    }

    private void writeType(CSTypeDeclaration node) {
        this.writeDoc(node);
        this.beginEnclosingIfDefs(node);
        this.writeTypeHeader(node);
        this.writeTypeBody(node);
        this.endEnclosingIfDefs(node);
    }

    private void writeBaseTypes(CSTypeDeclaration node) {
        List<CSTypeReferenceExpression> baseTypes = node.baseTypes();
        if (baseTypes.isEmpty()) {
            return;
        }
        this.write(" : ");
        this.writeCommaSeparatedList(baseTypes);
    }

    private void writeTypeBody(CSTypeDeclaration node) {
        this.writeLine();
        this.enterBody();
        CSTypeDeclaration saved = this._currentType;
        this._currentType = node;
        this.writeLineSeparatedList(node.members());
        this._currentType = saved;
        this.printPrecedingComments(node.startPosition() + node.sourceLength());
        this.leaveBody();
    }

    private void writeVisibility(CSMember member) {
        this.writeIndentation();
        if (member.isNewModifier()) {
            this.write("new ");
        }
        if (this.isExplicitMember(member)) {
            return;
        }
        CSVisibility visibility = member.visibility();
        this.write(visibility.toString().toLowerCase());
        this.write(" ");
    }

    private boolean isExplicitMember(CSMember member) {
        return member.name().indexOf(46) != -1;
    }

    @Override
    public void visit(CSVariableDeclaration node) {
        node.type().accept(this);
        if (null != node.name()) {
            this.write(" ");
            this.write(node.name());
        }
        if (null != node.initializer()) {
            this.write(" = ");
            node.initializer().accept(this);
        }
    }

    @Override
    public void visit(CSConstructor node) {
        this.writeDoc(node);
        this.writeAttributes(node);
        if (node.isStatic()) {
            this.writeIndented("static ");
        } else {
            this.writeVisibility(node);
        }
        this.write(this._currentType.name());
        this.writeParameterList(node);
        if (null != node.chainedConstructorInvocation()) {
            this.writeLine();
            this.indent();
            this.writeIndented(": ");
            this.writeMethodInvocation(node.chainedConstructorInvocation());
            this.outdent();
        }
        this.writeLine();
        node.body().accept(this);
    }

    @Override
    public void visit(CSDestructor node) {
        this.writeIndented("~");
        this.write(this._currentType.name());
        this.writeLine("()");
        node.body().accept(this);
    }

    @Override
    public void visit(CSMethod node) {
        this.printPrecedingComments(node);
        this.beginEnclosingIfDefs(node);
        this.writeDoc(node);
        this.writeAttributes(node);
        this.writeMethodHeader(node, node.modifier());
        node.returnType().accept(this);
        this.write(" ");
        this.writeMethodName(node);
        this.writeTypeParameters(node);
        this.writeParameterList(node);
        if (node.modifier() != CSMethodModifier.Override) {
            this.writeTypeParameterConstraints(node.typeParameters());
        }
        if (node.isAbstract()) {
            this.writeLine(";");
        } else {
            this.writeMethodBody(node);
        }
        this.endEnclosingIfDefs(node);
    }

    private void endEnclosingIfDefs(CSNode node) {
        for (String expression : node.enclosingIfDefs()) {
            this.writeIndented("#endif // ");
            this.writeLine(expression);
        }
    }

    private void beginEnclosingIfDefs(CSNode node) {
        for (String expression : node.enclosingIfDefs()) {
            this.writeIndented("#if ");
            this.writeLine(expression);
        }
    }

    private void writeMethodHeader(CSMember member, CSMethodModifier modifiers) {
        if (!this._currentType.isInterface()) {
            this.writeVisibility(member);
            this.write(this.methodModifier(modifiers));
        } else {
            this.writeIndentation();
        }
    }

    protected void writeMethodBody(CSMethod node) {
        this.writeLine();
        node.body().accept(this);
    }

    protected void writeMethodName(CSMethod node) {
        this.write(node.name());
    }

    @Override
    public void visit(CSBlock node) {
        this.enterBody();
        this.visitList(node.statements());
        this.leaveBody();
    }

    @Override
    public void visit(CSDeclarationStatement node) {
        this.printPrecedingComments(node);
        this.writeIndentation();
        node.declaration().accept(this);
        this.writeLine(";");
    }

    @Override
    public void visit(CSDeclarationExpression node) {
        node.declaration().accept(this);
    }

    private void writeDeclaration(CSTypeReferenceExpression type, String name, CSExpression initializer) {
        type.accept(this);
        this.write(" ");
        this.write(name);
        if (null != initializer) {
            this.write(" = ");
            initializer.accept(this);
        }
        this.writeLine(";");
    }

    @Override
    public void visit(CSLineComment node) {
        this.writeIndentedLine(node.text());
    }

    @Override
    public void visit(CSReturnStatement node) {
        this.printPrecedingComments(node);
        if (null == node.expression()) {
            this.writeIndentedLine("return;");
        } else {
            this.writeIndented("return ");
            node.expression().accept(this);
            this.writeLine(";");
        }
    }

    private void printPrecedingComments(CSNode node) {
        this.printPrecedingComments(node.startPosition());
    }

    private void printPrecedingComments(int startPosition) {
        if (startPosition <= 0) {
            return;
        }
        if (this._lastPrintedCommentIndex >= this._comments.size()) {
            return;
        }
        this._lastPrintedCommentIndex = this.printCommentsBetween(this._lastPrintedCommentIndex, startPosition);
    }

    private int printCommentsBetween(int lastIndex, int endStartPosition) {
        int endIndex = this.commentIndexAfter(lastIndex, endStartPosition);
        if (endIndex == -1) {
            endIndex = this._comments.size();
        }
        this.visitList(this._comments.subList(lastIndex, endIndex));
        return endIndex;
    }

    private int commentIndexAfter(int startIndex, int endStartPosition) {
        for (int i = startIndex; i < this._comments.size(); ++i) {
            if (this._comments.get(i).startPosition() <= endStartPosition) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void visit(CSIfStatement node) {
        this.printPrecedingComments(node);
        this.writeIndented("if (");
        node.expression().accept(this);
        this.writeLine(")");
        node.trueBlock().accept(this);
        if (!node.falseBlock().isEmpty()) {
            this.writeIndentedLine("else");
            node.falseBlock().accept(this);
        }
    }

    @Override
    public void visit(CSLockStatement node) {
        this.writeBlockStatement("lock", node);
    }

    @Override
    public void visit(CSWhileStatement node) {
        this.writeBlockStatement("while", node);
    }

    @Override
    public void visit(CSSwitchStatement node) {
        this.writeIndented("switch (");
        node.expression().accept(this);
        this.writeLine(")");
        this.enterBody();
        this.writeLineSeparatedList(node.caseClauses());
        this.leaveBody();
    }

    @Override
    public void visit(CSCaseClause node) {
        int clauses = 0;
        for (CSExpression e : node.expressions()) {
            if (clauses++ > 0) {
                this.writeLine();
            }
            this.writeIndented("case ");
            e.accept(this);
            this.write(":");
        }
        if (node.isDefault()) {
            if (clauses > 0) {
                this.writeLine();
            }
            this.writeIndented("default:");
        }
        this.writeLine();
        node.body().accept(this);
    }

    @Override
    public void visit(CSForEachStatement node) {
        this.printPrecedingComments(node);
        this.writeIndented("foreach (");
        node.variable().accept(this);
        this.write(" in ");
        node.expression().accept(this);
        this.writeLine(")");
        node.body().accept(this);
    }

    @Override
    public void visit(CSForStatement node) {
        this.printPrecedingComments(node);
        this.writeIndented("for (");
        this.writeCommaSeparatedList(node.initializers());
        this.write("; ");
        if (null != node.expression()) {
            node.expression().accept(this);
        }
        this.write("; ");
        this.writeCommaSeparatedList(node.updaters());
        this.writeLine(")");
        node.body().accept(this);
    }

    @Override
    public void visit(CSBreakStatement node) {
        this.printPrecedingComments(node);
        this.writeIndentedLine("break;");
    }

    @Override
    public void visit(CSGotoStatement node) {
        this.printPrecedingComments(node);
        if (node.target() != null) {
            this.writeIndented("goto case ");
            node.target().accept(this);
            this.write(";");
            this.writeLine();
        } else {
            this.writeIndentedLine("goto " + node.label() + ";");
        }
    }

    @Override
    public void visit(CSContinueStatement node) {
        this.printPrecedingComments(node);
        this.writeIndentedLine("continue;");
    }

    private void writeBlockStatement(String keyword, CSBlockStatement node) {
        this.printPrecedingComments(node);
        this.writeIndented(keyword);
        this.write(" (");
        node.expression().accept(this);
        this.write(")");
        this.writeLine();
        node.body().accept(this);
    }

    @Override
    public void visit(CSDoStatement node) {
        this.writeIndentedLine("do");
        node.body().accept(this);
        this.writeIndented("while (");
        node.expression().accept(this);
        this.writeLine(");");
    }

    @Override
    public void visit(CSTryStatement node) {
        this.printPrecedingComments(node);
        this.writeIndentedLine("try");
        node.body().accept(this);
        this.visitList(node.catchClauses());
        if (null != node.finallyBlock()) {
            this.writeIndentedLine("finally");
            node.finallyBlock().accept(this);
        }
    }

    @Override
    public void visit(CSCatchClause node) {
        this.writeIndented("catch");
        CSVariableDeclaration ex = node.exception();
        if (ex != null) {
            this.write(" (");
            ex.accept(this);
            this.write(")");
        }
        this.writeLine();
        node.body().accept(this);
    }

    @Override
    public void visit(CSThrowStatement node) {
        this.printPrecedingComments(node);
        if (null == node.expression()) {
            this.writeIndentedLine("throw;");
        } else {
            this.writeIndented("throw ");
            node.expression().accept(this);
            this.writeLine(";");
        }
    }

    @Override
    public void visit(CSExpressionStatement node) {
        this.printPrecedingComments(node);
        this.writeIndentation();
        node.expression().accept(this);
        this.writeLine(";");
    }

    @Override
    public void visit(CSParenthesizedExpression node) {
        this.write("(");
        node.expression().accept(this);
        this.write(")");
    }

    @Override
    public void visit(CSConditionalExpression node) {
        node.expression().accept(this);
        this.write(" ? ");
        node.trueExpression().accept(this);
        this.write(" : ");
        node.falseExpression().accept(this);
    }

    @Override
    public void visit(CSInfixExpression node) {
        node.lhs().accept(this);
        this.write(" ");
        this.write(node.operator());
        this.write(" ");
        node.rhs().accept(this);
    }

    @Override
    public void visit(CSPrefixExpression node) {
        this.write(node.operator());
        node.operand().accept(this);
    }

    @Override
    public void visit(CSPostfixExpression node) {
        node.operand().accept(this);
        this.write(node.operator());
    }

    @Override
    public void visit(CSConstructorInvocationExpression node) {
        this.write("new ");
        this.writeMethodInvocation(node);
    }

    @Override
    public void visit(CSMethodInvocationExpression node) {
        this.writeMethodInvocation(node);
    }

    protected void writeMethodInvocation(CSMethodInvocationExpression node) {
        node.expression().accept(this);
        this.writeTypeArguments(node);
        this.writeParameterList(node.arguments());
    }

    @Override
    public void visit(CSNumberLiteralExpression node) {
        this.write(node.token());
    }

    @Override
    public void visit(CSUncheckedExpression node) {
        this.write("unchecked(");
        node.expression().accept(this);
        this.write(")");
    }

    @Override
    public void visit(CSTypeofExpression node) {
        this.write("typeof(");
        node.type().accept(this);
        this.write(")");
    }

    @Override
    public void visit(CSBoolLiteralExpression node) {
        this.write(Boolean.toString(node.booleanValue()));
    }

    @Override
    public void visit(CSStringLiteralExpression node) {
        this.write(node.escapedValue());
    }

    @Override
    public void visit(CSCharLiteralExpression node) {
        this.write(node.escapedValue());
    }

    @Override
    public void visit(CSNullLiteralExpression node) {
        this.write("null");
    }

    @Override
    public void visit(CSBaseExpression node) {
        this.write("base");
    }

    @Override
    public void visit(CSThisExpression node) {
        this.write("this");
    }

    @Override
    public void visit(CSArrayCreationExpression node) {
        this.write("new ");
        CSharpTypeReferenceVisitor arrayElementTypeVisitor = new CSharpTypeReferenceVisitor(this);
        node.elementType().accept(arrayElementTypeVisitor);
        this.write("[");
        if (null != node.length()) {
            node.length().accept(this);
        }
        this.write("]");
        this.write(arrayElementTypeVisitor.sufix());
        if (null != node.initializer()) {
            this.write(" ");
            node.initializer().accept(this);
        }
    }

    @Override
    public void visit(CSArrayInitializerExpression node) {
        this.write("{ ");
        this.writeCommaSeparatedList(this.filterRemovedExpressions(node.expressions()));
        this.write(" }");
    }

    private Iterable<CSNode> filterRemovedExpressions(List<CSExpression> expressions) {
        ArrayList<CSNode> result = new ArrayList<CSNode>(expressions.size());
        for (CSNode cSNode : expressions) {
            if (cSNode instanceof CSRemovedExpression) continue;
            result.add(cSNode);
        }
        return result;
    }

    @Override
    public void visit(CSIndexedExpression node) {
        node.expression().accept(this);
        this.write("[");
        this.writeCommaSeparatedList(node.indexes());
        this.write("]");
    }

    @Override
    public void visit(CSCastExpression node) {
        this.write("(");
        node.type().accept(this);
        this.write(")");
        if (null != node.expression()) {
            node.expression().accept(this);
        }
    }

    @Override
    public void visit(CSReferenceExpression node) {
        this.write(node.name());
    }

    @Override
    public void visit(CSMemberReferenceExpression node) {
        node.expression().accept(this);
        this.write(".");
        this.write(node.name());
    }

    protected void writeParameterList(CSMethodBase node) {
        List<CSVariableDeclaration> parameters = node.parameters();
        this.write("(");
        if (node.isVarArgs()) {
            if (parameters.size() > 1) {
                this.writeCommaSeparatedList(parameters.subList(0, parameters.size() - 1));
                this.write(", ");
            }
            this.write("params ");
            this.visit(parameters.get(parameters.size() - 1));
        } else {
            this.writeCommaSeparatedList(parameters);
        }
        this.write(")");
    }

    protected <T extends CSNode> void writeParameterList(Iterable<T> parameters) {
        this.write("(");
        this.writeCommaSeparatedList(parameters);
        this.write(")");
    }

    @Override
    public void visit(CSField node) {
        this.writeMemberHeader(node);
        this.writeFieldModifiers(node);
        this.writeDeclaration(node.type(), node.name(), node.initializer());
    }

    @Override
    public void visit(CSProperty node) {
        this.writeMetaMemberHeader(node);
        node.type().accept(this);
        this.write(" ");
        if (node.isIndexer()) {
            this.write("this[");
            this.writeCommaSeparatedList(node.parameters());
            this.writeLine("]");
        } else {
            this.writeLine(node.name());
        }
        this.enterBody();
        this.writeOptionalMemberBlock("get", node.getter(), node.isAbstract());
        this.writeOptionalMemberBlock("set", node.setter(), node.isAbstract());
        this.leaveBody();
    }

    private void writeOptionalMemberBlock(String name, CSBlock block, boolean isAbstract) {
        if (null != block) {
            this.writeMemberBlock(name, block, isAbstract);
        }
    }

    private void writeMemberHeader(CSMember node) {
        this.writeDoc(node);
        this.writeAttributes(node);
        this.writeVisibility(node);
    }

    @Override
    public void visit(CSEvent node) {
        this.writeMetaMemberHeader(node);
        this.write("event ");
        node.type().accept(this);
        this.write(" ");
        this.write(node.name());
        CSBlock firstBlock = node.getAddBlock();
        if (null == firstBlock) {
            this.writeLine(";");
            return;
        }
        this.writeLine();
        this.enterBody();
        this.writeMemberBlock("add", firstBlock, node.isAbstract());
        this.writeMemberBlock("remove", node.getRemoveBlock(), node.isAbstract());
        this.leaveBody();
    }

    private void writeMetaMemberHeader(CSMetaMember node) {
        this.writeDoc(node);
        this.writeAttributes(node);
        this.writeMethodHeader(node, node.modifier());
    }

    private void writeMemberBlock(String name, CSBlock block, boolean isAbstract) {
        this.writeIndented(name);
        if (isAbstract) {
            this.writeLine(";");
        } else {
            this.writeLine();
            block.accept(this);
        }
    }

    @Override
    public void visit(CSAttribute node) {
        this.writeIndented("[");
        this.write(node.name());
        if (!node.arguments().isEmpty()) {
            this.writeParameterList(node.arguments());
        }
        this.writeLine("]");
    }

    @Override
    public void visit(CSLabelStatement node) {
        this.writeLine(node.label() + ": ;");
    }

    @Override
    public void visit(CSDocTextOverlay node) {
        this.writeXmlDoc(node.text());
    }

    @Override
    public void visit(CSDocTextNode node) {
        this.writeXmlDoc(this.xmlEscape(node.text()));
    }

    private void writeXmlDoc(String xmldocText) {
        String[] lines = xmldocText.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                this.writeLine();
                this.writeIndentation();
            }
            this.writeBlock(lines[i].trim().replace("<br>", "<br />"));
        }
    }

    private String xmlEscape(String text) {
        return text.replaceAll("(<)(/?[^\\s][^>]*)(>)", ":lt:$2:gt:").replace("<", "&lt;").replace(">", "&gt;").replace(":lt:", "<").replace(":gt:", ">");
    }

    @Override
    public void visit(CSDocTagNode node) {
        String tagName = node.tagName();
        List<CSDocAttributeNode> attributes = node.attributes();
        List<CSDocNode> fragments = node.fragments();
        this.write("<");
        this.write(tagName);
        if (!attributes.isEmpty()) {
            for (CSDocAttributeNode attr : attributes) {
                this.write(" ");
                this.write(attr.name());
                this.write("=\"");
                this.write(attr.value());
                this.write("\"");
            }
        }
        if (fragments.isEmpty()) {
            this.write("/");
        }
        this.write(">");
        if (fragments.size() > 1) {
            this.writeLine();
            for (CSDocNode f : fragments) {
                this.writeIndentation();
                f.accept(this);
                this.writeLine();
            }
            this.writeIndented("</" + tagName + ">");
        } else if (!fragments.isEmpty()) {
            fragments.get(0).accept(this);
            this.write("</" + tagName + ">");
        }
    }

    private void writeAttributes(CSMember node) {
        this.visitList(node.attributes());
    }

    private void writeFieldModifiers(CSField node) {
        for (CSFieldModifier m : node.modifiers()) {
            this.write(m.toString().toLowerCase());
            this.write(" ");
        }
    }

    private void writeDoc(CSMember node) {
        List<CSDocNode> docs = node.docs();
        if (docs.isEmpty()) {
            return;
        }
        this.linePrefix("/// ");
        for (CSDocNode doc : docs) {
            this.writeIndentation();
            doc.accept(this);
            this.writeLine();
        }
        this.linePrefix(null);
    }

    private String methodModifier(CSMethodModifier modifier) {
        switch (modifier) {
            case Static: {
                return "static ";
            }
            case Virtual: {
                return "virtual ";
            }
            case Abstract: {
                return "abstract ";
            }
            case AbstractOverride: {
                return "abstract override ";
            }
            case Sealed: {
                return "sealed override ";
            }
            case Override: {
                return "override ";
            }
        }
        return "";
    }

    private <T extends CSNode> void writeLineSeparatedList(Iterable<T> nodes) {
        this.writeSeparatedList(nodes, new Closure(){

            @Override
            public void execute() {
                CSharpPrinter.this.writeLine();
            }
        });
    }

    private <T extends CSNode> void writeCommaSeparatedList(Iterable<T> nodes) {
        this.writeList(nodes, ", ");
    }

    private <T extends CSNode> void writeList(Iterable<T> nodes, final String separator) {
        this.writeSeparatedList(nodes, new Closure(){

            @Override
            public void execute() {
                CSharpPrinter.this.write(separator);
            }
        });
    }

    private <T extends CSNode> void writeSeparatedList(Iterable<T> nodes, Closure separator) {
        Iterator<T> iterator = nodes.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        ((CSNode)iterator.next()).accept(this);
        while (iterator.hasNext()) {
            separator.execute();
            ((CSNode)iterator.next()).accept(this);
        }
    }

    private String classModifier(CSClassModifier modifier) {
        switch (modifier) {
            case Abstract: {
                return "abstract ";
            }
            case Sealed: {
                return "sealed ";
            }
            case Static: {
                return "static ";
            }
        }
        return "";
    }

    protected void enterBody() {
        this.writeIndentedLine("{");
        this.indent();
    }

    private void indent() {
        this._writer.indent();
    }

    private void outdent() {
        this._writer.outdent();
    }

    private void writeIndentation() {
        this._writer.writeIndentation();
    }

    private void writeIndented(String s) {
        this._writer.writeIndented(s);
    }

    private void writeIndentedLine(String s) {
        this._writer.writeIndentedLine(s);
    }

    private void write(String s) {
        this._writer.write(s);
    }

    private void linePrefix(String s) {
        this._writer.linePrefix(s);
    }

    private void writeBlock(String s) {
        this._writer.writeBlock(s);
    }

    private void writeLine(String s) {
        this._writer.writeLine(s);
    }

    private void writeLine() {
        this._writer.writeLine();
    }

    protected void leaveBody() {
        this.outdent();
        this.writeIndentedLine("}");
    }

    class CSharpTypeReferenceVisitor
    extends CSVisitor {
        private CSVisitor _delegate;
        private StringBuffer _sb = new StringBuffer();

        CSharpTypeReferenceVisitor(CSVisitor delegate) {
            this._delegate = delegate;
        }

        @Override
        public void visit(CSArrayTypeReference node) {
            node.elementType().accept(this._delegate);
            for (int i = 0; i < node.dimensions(); ++i) {
                this._sb.append("[]");
            }
        }

        public void visit(CSTypeReferenceExpression node) {
            node.accept(this._delegate);
        }

        @Override
        public void visit(CSTypeReference node) {
            node.accept(this._delegate);
        }

        String sufix() {
            return this._sb.toString();
        }
    }

    static interface Closure {
        public void execute();
    }
}

