/*
 * Decompiled with CFR 0.152.
 */
package org.codegeny.jakartron.jms;

import com.arjuna.ats.jta.TransactionManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSDestinationDefinition;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionScoped;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.codegeny.jakartron.CoreExtension;
import org.codegeny.jakartron.jndi.JNDI;

public class JMSExtension
implements Extension {
    private static final AtomicInteger SERVER_ID = new AtomicInteger();
    private static final Logger LOGGER = Logger.getLogger(JMSExtension.class.getName());
    private final Set<String> queues = new HashSet<String>();
    private final Set<String> topics = new HashSet<String>();

    public void configure(@Observes BeforeBeanDiscovery event) {
        event.configureQualifier(JMSConnectionFactory.class);
    }

    public void processResources(@Observes @WithAnnotations(value={Resource.class}) ProcessAnnotatedType<?> event) {
        event.configureAnnotatedType().filterFields(f -> f.isAnnotationPresent(Resource.class) && !((Resource)f.getAnnotation(Resource.class)).lookup().isEmpty() && Queue.class.isAssignableFrom(f.getJavaMember().getType())).forEach(f -> this.queues.add(((Resource)f.getAnnotated().getAnnotation(Resource.class)).lookup()));
        event.configureAnnotatedType().filterFields(f -> f.isAnnotationPresent(Resource.class) && !((Resource)f.getAnnotation(Resource.class)).lookup().isEmpty() && Topic.class.isAssignableFrom(f.getJavaMember().getType())).forEach(f -> this.topics.add(((Resource)f.getAnnotated().getAnnotation(Resource.class)).lookup()));
    }

    public void addBeans(@Observes AfterBeanDiscovery event) {
        event.addBean().types(new Type[]{Object.class, ConnectionFactory.class, XAConnectionFactory.class, ActiveMQConnectionFactory.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE, JNDI.Literal.of((String)"connectionFactory")}).produceWith(instance -> ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName(), Collections.singletonMap("serverId", ((ActiveMQServer)instance.select(ActiveMQServer.class, new Annotation[0]).get()).getIdentity()))})).disposeWith((instance, context) -> instance.close());
        event.addBean().types(new Type[]{Object.class, JMSContext.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).produceWith(instance -> ((ConnectionFactory)instance.select(ConnectionFactory.class, new Annotation[0]).get()).createContext()).disposeWith((instance, context) -> instance.close());
        event.addBean().types(new Type[]{Object.class, JMSContext.class}).qualifiers(new Annotation[]{new JMSConnectionFactoryLiteral("java:/JmsXA"), Any.Literal.INSTANCE}).produceWith(instance -> (XAJMSContext)instance.select(XAJMSContext.class, new Annotation[0]).get());
        event.addBean().types(new Type[]{Object.class, XAJMSContext.class}).scope(TransactionScoped.class).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).produceWith(this::xaJMSContext).disposeWith((instance, context) -> instance.close());
        this.queues.forEach(name -> event.addBean().types(new Type[]{Object.class, Destination.class, Queue.class, ActiveMQDestination.class, ActiveMQQueue.class}).scope(ApplicationScoped.class).qualifiers(new Annotation[]{Any.Literal.INSTANCE, JNDI.Literal.of((String)name)}).createWith(context -> ActiveMQDestination.createQueue((String)name)));
        this.topics.forEach(name -> event.addBean().types(new Type[]{Object.class, Destination.class, Topic.class, ActiveMQDestination.class, ActiveMQTopic.class}).scope(ApplicationScoped.class).qualifiers(new Annotation[]{Any.Literal.INSTANCE, JNDI.Literal.of((String)name)}).createWith(context -> ActiveMQDestination.createTopic((String)name)));
    }

    private XAJMSContext xaJMSContext(Instance<Object> instance) {
        try {
            XAJMSContext context = ((XAConnectionFactory)instance.select(XAConnectionFactory.class, new Annotation[0]).get()).createXAContext();
            TransactionManager.transactionManager().getTransaction().enlistResource(context.getXAResource());
            return context;
        }
        catch (RollbackException | SystemException exception) {
            throw new CreationException(exception);
        }
    }

    public void start(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        event.addBean().types(new Type[]{ActiveMQServer.class}).scope(Singleton.class).createWith(context -> {
            String serverId = Integer.toString(SERVER_ID.incrementAndGet());
            Map<String, String> params = Collections.singletonMap("serverId", serverId);
            ConfigurationImpl configuration = new ConfigurationImpl().setSecurityEnabled(false).setPersistenceEnabled(false).setJMXManagementEnabled(false).addAddressesSetting("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(true)).setDeadLetterAddress(new SimpleString("dlq")).setExpiryAddress(new SimpleString("dlq")).setMaxDeliveryAttempts(3).setRedeliveryDelay(0L)).addQueueConfiguration(new QueueConfiguration("dlq")).addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName(), params));
            ActiveMQServer server = ActiveMQServers.newActiveMQServer((Configuration)configuration);
            server.setIdentity(serverId);
            try {
                server.start();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            ((CoreExtension)beanManager.getExtension(CoreExtension.class)).addShutdownHook(() -> ((ActiveMQServer)server).stop());
            LOGGER.fine(() -> String.format("Started broker #%s", serverId));
            return server;
        });
    }

    public void process(@Observes @WithAnnotations(value={JMSDestinationDefinition.class}) ProcessAnnotatedType<?> event) {
        for (JMSDestinationDefinition definition : event.getAnnotatedType().getAnnotations(JMSDestinationDefinition.class)) {
            if (definition.interfaceName().equals(Queue.class.getName())) {
                this.queues.add(definition.name());
                continue;
            }
            if (definition.interfaceName().equals(Topic.class.getName())) {
                this.topics.add(definition.name());
                continue;
            }
            throw new IllegalArgumentException("Unsupported destination " + definition.interfaceName());
        }
    }

    public static class JMSConnectionFactoryLiteral
    extends AnnotationLiteral<JMSConnectionFactory>
    implements JMSConnectionFactory {
        private final String value;

        public JMSConnectionFactoryLiteral(String value) {
            this.value = Objects.requireNonNull(value);
        }

        public String value() {
            return this.value;
        }
    }
}

