/*
 * Decompiled with CFR 0.152.
 */
package org.codegeny.jakartron.jaxws;

import com.sun.xml.ws.binding.WebServiceFeatureList;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceRef;
import org.codegeny.jakartron.servlet.Base;

public final class JAXWSIntegration
implements Extension {
    private final Set<Class<?>> implementorClasses = new HashSet();
    private final Map<Object, Consumer<AfterBeanDiscovery>> beans = new HashMap<Object, Consumer<AfterBeanDiscovery>>();

    public void collectImplementorClass(@Observes @WithAnnotations(value={WebService.class}) ProcessAnnotatedType<?> event) {
        this.implementorClasses.add(event.getAnnotatedType().getJavaClass());
    }

    public void collectInjectionPoint(@Observes ProcessInjectionPoint<?, ?> event) {
        InjectionPoint injectionPoint = event.getInjectionPoint();
        injectionPoint.getQualifiers().stream().filter(Base.class::isInstance).map(Base.class::cast).findFirst().ifPresent(base -> this.process(injectionPoint, (Base)base));
    }

    private void process(InjectionPoint injectionPoint, Base base) {
        Class portInterface;
        Type portType;
        WebServiceRef webServiceRef = (WebServiceRef)injectionPoint.getAnnotated().getAnnotation(WebServiceRef.class);
        if (webServiceRef != null && (portType = injectionPoint.getType()) instanceof Class && (portInterface = (Class)portType).isInterface() && portInterface.isAnnotationPresent(WebService.class)) {
            WebServiceFeatureList webServiceFeatures = new WebServiceFeatureList();
            webServiceFeatures.parseAnnotations((Iterable)injectionPoint.getAnnotated().getAnnotations());
            this.beans.put(new HashSet<Object>(Arrays.asList(portInterface, base, webServiceRef)), afterBeanDiscovery -> afterBeanDiscovery.addBean().types(new Type[]{portType}).qualifiers(new Annotation[]{base}).produceWith(instance -> this.createPort((String)instance.select(String.class, new Annotation[]{base}).get(), portInterface, webServiceRef, webServiceFeatures.toArray())));
        }
    }

    private Object createPort(String uri, Class<?> portInterface, WebServiceRef webServiceRef, WebServiceFeature ... features) {
        Object port = this.createPort(portInterface, webServiceRef, features);
        BindingProvider provider = (BindingProvider)port;
        provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", uri);
        return port;
    }

    private Object createPort(Class<?> portClass, WebServiceRef webServiceRef, WebServiceFeature ... features) {
        String wsdlLocation;
        WebService webService = portClass.getAnnotation(WebService.class);
        String string = wsdlLocation = webServiceRef.wsdlLocation().isEmpty() ? webService.wsdlLocation() : webServiceRef.wsdlLocation();
        if (webServiceRef.value().equals(Service.class)) {
            if (webService.targetNamespace().isEmpty() || webService.portName().isEmpty() || webService.serviceName().isEmpty()) {
                throw new CreationException("If no Service class is specified in @WebServiceRef.value(), then targetNamespace(), portName() and serviceName() must all 3 be filled in the @WebService annotation on the port interface");
            }
            QName serviceName = new QName(webService.targetNamespace(), webService.serviceName());
            QName portName = new QName(webService.targetNamespace(), webService.portName());
            if (wsdlLocation.isEmpty()) {
                throw new CreationException("If no Service class is specified in @WebServiceRef.value(), then wsdlLocation() must be filled either on @WebServiceRef or on the port interface @WebService");
            }
            Service service = Service.create((URL)Thread.currentThread().getContextClassLoader().getResource(wsdlLocation), (QName)serviceName, (WebServiceFeature[])features);
            return service.getPort(portName, portClass);
        }
        try {
            Service service = this.createService(webServiceRef.value(), wsdlLocation, features);
            Method method = Stream.of(webServiceRef.value().getDeclaredMethods()).filter(m -> m.getParameterCount() == 0 && m.getReturnType().equals(portClass)).findFirst().orElseThrow(() -> new CreationException("Cannot find a correct port factory method on the given service"));
            return method.invoke((Object)service, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new CreationException((Throwable)exception);
        }
    }

    private Service createService(Class<? extends Service> serviceClass, String wsdlLocation, WebServiceFeature ... features) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        if (wsdlLocation.isEmpty()) {
            return features.length == 0 ? serviceClass.newInstance() : serviceClass.getConstructor(WebServiceFeature[].class).newInstance(new Object[]{features});
        }
        URL wsdlLocationUrl = Thread.currentThread().getContextClassLoader().getResource(wsdlLocation);
        return features.length == 0 ? serviceClass.getConstructor(URL.class).newInstance(wsdlLocationUrl) : serviceClass.getConstructor(URL.class, WebServiceFeature[].class).newInstance(wsdlLocationUrl, features);
    }

    public void createBeans(@Observes AfterBeanDiscovery event) {
        this.beans.values().forEach(bean -> bean.accept(event));
    }

    public Set<Class<?>> getImplementorClasses() {
        return this.implementorClasses;
    }
}

