/*
 * Decompiled with CFR 0.152.
 */
package org.codegeny.jakartron.jaxws;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import com.sun.xml.ws.transport.http.servlet.WSServlet;
import com.sun.xml.ws.transport.http.servlet.WSServletDelegate;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRegistration;
import javax.xml.namespace.QName;
import org.codegeny.jakartron.jaxws.BeanInvoker;
import org.codegeny.jakartron.jaxws.JAXWSIntegration;
import org.codegeny.jakartron.jaxws.ServletContainer;
import org.codegeny.jakartron.jaxws.ServletContextModule;
import org.codegeny.jakartron.jaxws.ServletContextResourceLoader;
import org.codegeny.jakartron.servlet.Initialized;
import org.xml.sax.EntityResolver;

@Dependent
public final class JAXWSProducer {
    private void configureEndpoints(@Observes @Initialized ServletContextEvent event, BeanManager beanManager) {
        ServletContext context = event.getServletContext();
        ServletRegistration.Dynamic registration = context.addServlet(WSServlet.class.getName(), WSServlet.class);
        List adapters = ((JAXWSIntegration)beanManager.getExtension(JAXWSIntegration.class)).getImplementorClasses().stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).map(implementorClass -> this.toServletAdapter((Class<?>)implementorClass, context, beanManager)).peek(adapter -> registration.addMapping(new String[]{adapter.getValidPath()})).collect(Collectors.toList());
        context.setAttribute("com.sun.xml.ws.server.http.servletDelegate", (Object)new WSServletDelegate(adapters, context));
    }

    private ServletAdapter toServletAdapter(Class<?> implementorClass, ServletContext context, BeanManager beanManager) {
        WebService webService = implementorClass.getAnnotation(WebService.class);
        String urlPattern = "/" + webService.name();
        WSEndpoint endpoint = WSEndpoint.create(implementorClass, (boolean)true, (Invoker)new BeanInvoker(beanManager), (QName)new QName(webService.targetNamespace(), webService.serviceName()), (QName)new QName(webService.targetNamespace(), webService.portName()), (Container)JAXWSProducer.createContainer(context), (WSBinding)JAXWSProducer.createBinding(implementorClass), (SDDocumentSource)JAXWSProducer.createWsdl(webService.wsdlLocation()), Collections.emptyList(), (EntityResolver)XmlUtil.createDefaultCatalogResolver(), (boolean)false);
        return (ServletAdapter)new ServletAdapterList(context).createAdapter(webService.name(), urlPattern, endpoint);
    }

    private static SDDocumentSource createWsdl(String wsdlLocation) {
        return wsdlLocation.isEmpty() ? null : SDDocumentSource.create((URL)Thread.currentThread().getContextClassLoader().getResource(wsdlLocation));
    }

    private static Container createContainer(ServletContext context) {
        return new ServletContainer(new Object[]{context, new ServletContextModule(context), new ServletContextResourceLoader(context)});
    }

    private static WSBinding createBinding(Class<?> implementorClass) {
        WebServiceFeatureList features = new WebServiceFeatureList();
        features.parseAnnotations(implementorClass);
        BindingID bindingID = BindingID.parse(implementorClass);
        features.addAll((Iterable)bindingID.createBuiltinFeatureList());
        return bindingID.createBinding(features.toArray());
    }
}

