/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.yaml;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.WatchPodLogsAction;

public class WatchPodLogs
extends AbstractKubernetesAction.Builder<WatchPodLogsAction, WatchPodLogs> {
    private final WatchPodLogsAction.Builder delegate = new WatchPodLogsAction.Builder();

    public void setName(String name) {
        this.delegate.podName(name);
    }

    public void setLabels(List<Label> labels) {
        labels.forEach(label -> this.delegate.label(label.getName(), label.getValue()));
    }

    public void setLabel(String labelExpression) {
        String[] tokens = labelExpression.split("=", 2);
        this.delegate.label(tokens[0].trim(), tokens[1].trim());
    }

    public void setTimeout(String timeout) {
        this.delegate.milliseconds(timeout);
    }

    public WatchPodLogs description(String description) {
        this.delegate.description(description);
        return this;
    }

    public WatchPodLogs actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public WatchPodLogs client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public WatchPodLogs inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public WatchPodLogs autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public WatchPodLogsAction doBuild() {
        return (WatchPodLogsAction)this.delegate.build();
    }

    public static class Label {
        protected String name;
        protected String value;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

