/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.yaml;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActionContainerBuilder;
import org.citrusframework.TestActor;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesAction;
import org.citrusframework.kubernetes.yaml.Agent;
import org.citrusframework.kubernetes.yaml.Connect;
import org.citrusframework.kubernetes.yaml.CreateAnnotations;
import org.citrusframework.kubernetes.yaml.CreateConfigMap;
import org.citrusframework.kubernetes.yaml.CreateCustomResource;
import org.citrusframework.kubernetes.yaml.CreateLabels;
import org.citrusframework.kubernetes.yaml.CreateResource;
import org.citrusframework.kubernetes.yaml.CreateSecret;
import org.citrusframework.kubernetes.yaml.CreateService;
import org.citrusframework.kubernetes.yaml.DeleteConfigMap;
import org.citrusframework.kubernetes.yaml.DeleteCustomResource;
import org.citrusframework.kubernetes.yaml.DeleteResource;
import org.citrusframework.kubernetes.yaml.DeleteSecret;
import org.citrusframework.kubernetes.yaml.DeleteService;
import org.citrusframework.kubernetes.yaml.Disconnect;
import org.citrusframework.kubernetes.yaml.VerifyCustomResource;
import org.citrusframework.kubernetes.yaml.VerifyPod;
import org.citrusframework.kubernetes.yaml.WatchPodLogs;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

public class Kubernetes
implements TestActionBuilder<KubernetesAction>,
ReferenceResolverAware {
    private AbstractKubernetesAction.Builder<?, ?> builder;
    private String description;
    private String actor;
    private String kubernetesClient;
    private String namespace;
    private boolean autoRemoveResources = KubernetesSettings.isAutoRemoveResources();
    private ReferenceResolver referenceResolver;

    public void setDescription(String value) {
        this.description = this.description;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setAutoRemove(boolean autoRemoveResources) {
        this.autoRemoveResources = autoRemoveResources;
    }

    public void setClient(String client) {
        this.kubernetesClient = client;
    }

    public void setAgent(Agent builder) {
        this.builder = builder;
    }

    public void setConnect(Connect builder) {
        this.builder = builder;
    }

    public void setDisconnect(Disconnect builder) {
        this.builder = builder;
    }

    public void setCreateService(CreateService builder) {
        this.builder = builder;
    }

    public void setCreateSecret(CreateSecret builder) {
        this.builder = builder;
    }

    public void setCreateConfigMap(CreateConfigMap builder) {
        this.builder = builder;
    }

    public void setCreateResource(CreateResource builder) {
        this.builder = builder;
    }

    public void setCreateCustomResource(CreateCustomResource builder) {
        this.builder = builder;
    }

    public void setCreateLabels(CreateLabels builder) {
        this.builder = builder;
    }

    public void setCreateAnnotations(CreateAnnotations builder) {
        this.builder = builder;
    }

    public void setDeleteService(DeleteService builder) {
        this.builder = builder;
    }

    public void setDeleteSecret(DeleteSecret builder) {
        this.builder = builder;
    }

    public void setDeleteConfigMap(DeleteConfigMap builder) {
        this.builder = builder;
    }

    public void setDeleteResource(DeleteResource builder) {
        this.builder = builder;
    }

    public void setDeleteCustomResource(DeleteCustomResource builder) {
        this.builder = builder;
    }

    public void setVerifyPod(VerifyPod builder) {
        this.builder = builder;
    }

    public void setVerifyCustomResource(VerifyCustomResource builder) {
        this.builder = builder;
    }

    public void setWatchPodLogs(WatchPodLogs builder) {
        this.builder = builder;
    }

    public KubernetesAction build() {
        if (this.builder == null) {
            throw new CitrusRuntimeException("Missing Kubernetes action - please provide proper action details");
        }
        if (this.builder instanceof TestActionContainerBuilder) {
            ((TestActionContainerBuilder)this.builder).getActions().stream().filter(action -> action instanceof ReferenceResolverAware).forEach(action -> ((ReferenceResolverAware)action).setReferenceResolver(this.referenceResolver));
        }
        if (this.builder instanceof ReferenceResolverAware) {
            this.builder.setReferenceResolver(this.referenceResolver);
        }
        this.builder.description(this.description);
        this.builder.inNamespace(this.namespace);
        this.builder.autoRemoveResources(this.autoRemoveResources);
        if (this.referenceResolver != null) {
            if (this.kubernetesClient != null) {
                this.builder.client((KubernetesClient)this.referenceResolver.resolve(this.kubernetesClient, KubernetesClient.class));
            }
            if (this.actor != null) {
                this.builder.actor((TestActor)this.referenceResolver.resolve(this.actor, TestActor.class));
            }
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

