/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.yaml;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateServiceAction;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

public class CreateService
extends AbstractKubernetesAction.Builder<CreateServiceAction, CreateService>
implements ReferenceResolverAware {
    private final CreateServiceAction.Builder delegate = new CreateServiceAction.Builder();

    public void setName(String name) {
        this.delegate.service(name);
    }

    public void setServer(String serverName) {
        this.delegate.server(serverName);
    }

    public void setAutoCreateServerBinding(boolean enabled) {
        this.delegate.autoCreateServerBinding(enabled);
    }

    public void setPorts(List<PortMapping> portMappings) {
        portMappings.forEach(mapping -> this.delegate.portMapping(mapping.getPort(), mapping.getTargetPort()));
    }

    public void setProtocol(String protocol) {
        this.delegate.protocol(protocol);
    }

    public void setSelector(PodSelector selector) {
        selector.getLabels().forEach(label -> this.delegate.label(label.getName(), label.getValue()));
    }

    @Override
    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.delegate.setReferenceResolver(referenceResolver);
    }

    public CreateService description(String description) {
        this.delegate.description(description);
        return this;
    }

    public CreateService actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public CreateService client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public CreateService inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public CreateService autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public CreateServiceAction doBuild() {
        return (CreateServiceAction)this.delegate.build();
    }

    public static class PodSelector {
        protected List<Label> labels;

        public List<Label> getLabels() {
            if (this.labels == null) {
                this.labels = new ArrayList<Label>();
            }
            return this.labels;
        }

        public void setLabels(List<Label> labels) {
            this.labels = labels;
        }

        public static class Label {
            protected String name;
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    public static class PortMapping {
        protected String port;
        protected String targetPort;

        public void setPort(String port) {
            this.port = port;
        }

        public String getPort() {
            return this.port;
        }

        public void setTargetPort(String targetPort) {
            this.targetPort = targetPort;
        }

        public String getTargetPort() {
            return this.targetPort;
        }
    }
}

