/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.yaml;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.HashMap;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateSecretAction;

public class CreateSecret
extends AbstractKubernetesAction.Builder<CreateSecretAction, CreateSecret> {
    private final CreateSecretAction.Builder delegate = new CreateSecretAction.Builder();

    public void setName(String name) {
        this.delegate.secret(name);
    }

    public void setProperties(List<Property> properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        properties.forEach(property -> props.put(property.getName(), property.getValue()));
        this.delegate.properties(props);
    }

    public void setFile(String path) {
        this.delegate.fromFile(path);
    }

    public CreateSecret description(String description) {
        this.delegate.description(description);
        return this;
    }

    public CreateSecret actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public CreateSecret client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public CreateSecret inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public CreateSecret autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public CreateSecretAction doBuild() {
        return (CreateSecretAction)this.delegate.build();
    }

    public static class Property {
        protected String name;
        protected String value;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

