/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.yaml;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateLabelsAction;

public class CreateLabels
extends AbstractKubernetesAction.Builder<CreateLabelsAction, CreateLabels> {
    private final CreateLabelsAction.Builder delegate = new CreateLabelsAction.Builder();

    public void setResource(String name) {
        this.delegate.resource(name);
    }

    public void setType(String resourceType) {
        this.delegate.type(resourceType);
    }

    public void setLabels(List<Label> labels) {
        labels.forEach(label -> this.delegate.label(label.getName(), label.getValue()));
    }

    public CreateLabels description(String description) {
        this.delegate.description(description);
        return this;
    }

    public CreateLabels actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public CreateLabels client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public CreateLabels inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public CreateLabels autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public CreateLabelsAction doBuild() {
        return (CreateLabelsAction)this.delegate.build();
    }

    public static class Label {
        protected String name;
        protected String value;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

