/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.yaml;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateAnnotationsAction;

public class CreateAnnotations
extends AbstractKubernetesAction.Builder<CreateAnnotationsAction, CreateAnnotations> {
    private final CreateAnnotationsAction.Builder delegate = new CreateAnnotationsAction.Builder();

    public void setResource(String name) {
        this.delegate.resource(name);
    }

    public void setType(String resourceType) {
        this.delegate.type(resourceType);
    }

    public void setAnnotations(List<Annotation> annotations) {
        annotations.forEach(annotation -> this.delegate.annotation(annotation.getName(), annotation.getValue()));
    }

    public CreateAnnotations description(String description) {
        this.delegate.description(description);
        return this;
    }

    public CreateAnnotations actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public CreateAnnotations client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public CreateAnnotations inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public CreateAnnotations autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public CreateAnnotationsAction doBuild() {
        return (CreateAnnotationsAction)this.delegate.build();
    }

    public static class Annotation {
        protected String name;
        protected String value;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

