/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.yaml;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.TestActor;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.ServiceConnectAction;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

public class Connect
extends AbstractKubernetesAction.Builder<AbstractKubernetesAction, Connect>
implements ReferenceResolverAware {
    private AbstractKubernetesAction.Builder<? extends AbstractKubernetesAction, ?> delegate;

    public void setService(Service service) {
        ServiceConnectAction.Builder builder = new ServiceConnectAction.Builder();
        builder.service(service.getName());
        if (service.getClient() != null) {
            builder.client(service.getClient());
        }
        if (service.getPort() != null) {
            builder.port(service.getPort());
        }
        if (service.getLocalPort() != null) {
            builder.localPort(service.getLocalPort());
        }
        this.delegate = builder;
    }

    @Override
    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.delegate.setReferenceResolver(referenceResolver);
    }

    public Connect description(String description) {
        this.delegate.description(description);
        return this;
    }

    public Connect actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public Connect client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public Connect inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public Connect autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public AbstractKubernetesAction doBuild() {
        if (this.delegate == null) {
            throw new CitrusRuntimeException("Missing Kubernetes connect action - please provide proper action details");
        }
        return (AbstractKubernetesAction)this.delegate.build();
    }

    public static class Service {
        protected String name;
        protected String client;
        protected String port;
        protected String localPort;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public String getClient() {
            return this.client;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getPort() {
            return this.port;
        }

        public void setLocalPort(String localPort) {
            this.localPort = localPort;
        }

        public String getLocalPort() {
            return this.localPort;
        }
    }
}

