/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.xml;

import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.VerifyCustomResourceAction;

@XmlRootElement(name="verify-custom-resource")
public class VerifyCustomResource
extends AbstractKubernetesAction.Builder<VerifyCustomResourceAction, VerifyCustomResource> {
    private final VerifyCustomResourceAction.Builder delegate = new VerifyCustomResourceAction.Builder();

    @XmlAttribute
    public void setName(String name) {
        this.delegate.resourceName(name);
    }

    @XmlAttribute
    public void setType(String resourceType) {
        try {
            this.delegate.resourceType(Class.forName(resourceType));
        }
        catch (ClassCastException | ClassNotFoundException e) {
            this.delegate.type(resourceType);
        }
    }

    @XmlAttribute
    public void setKind(String kind) {
        this.delegate.kind(kind);
    }

    @XmlAttribute
    public void setGroup(String group) {
        this.delegate.group(group);
    }

    @XmlAttribute
    public void setVersion(String version) {
        this.delegate.version(version);
    }

    @XmlAttribute(name="api-version")
    public void setApiVersion(String apiVersion) {
        this.delegate.apiVersion(apiVersion);
    }

    @XmlAttribute(required=true)
    public void setCondition(String value) {
        this.delegate.condition(value);
    }

    @XmlAttribute
    public void setLabel(String labelExpression) {
        String[] tokens = labelExpression.split("=", 2);
        this.delegate.label(tokens[0].trim(), tokens[1].trim());
    }

    @XmlAttribute(name="max-attempts")
    public void setMaxAttempts(int maxAttempts) {
        this.delegate.maxAttempts(maxAttempts);
    }

    @XmlAttribute(name="delay-between-attempts")
    public void setDelayBetweenAttempts(long delayBetweenAttempts) {
        this.delegate.delayBetweenAttempts(delayBetweenAttempts);
    }

    public VerifyCustomResource description(String description) {
        this.delegate.description(description);
        return this;
    }

    public VerifyCustomResource actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public VerifyCustomResource client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public VerifyCustomResource inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public VerifyCustomResource autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public VerifyCustomResourceAction doBuild() {
        return (VerifyCustomResourceAction)this.delegate.build();
    }
}

