/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.xml;

import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.CreateLabelsAction;

@XmlRootElement(name="create-labels")
public class CreateLabels
extends AbstractKubernetesAction.Builder<CreateLabelsAction, CreateLabels> {
    private final CreateLabelsAction.Builder delegate = new CreateLabelsAction.Builder();

    @XmlAttribute(required=true)
    public void setResource(String name) {
        this.delegate.resource(name);
    }

    @XmlAttribute(required=true)
    public void setType(String resourceType) {
        this.delegate.type(resourceType);
    }

    @XmlElement
    public void setLabels(Labels labels) {
        labels.getLabels().forEach(label -> this.delegate.label(label.getName(), label.getValue()));
    }

    public CreateLabels description(String description) {
        this.delegate.description(description);
        return this;
    }

    public CreateLabels actor(TestActor actor) {
        this.delegate.actor(actor);
        return this;
    }

    @Override
    public CreateLabels client(KubernetesClient client) {
        this.delegate.client(client);
        return this;
    }

    @Override
    public CreateLabels inNamespace(String namespace) {
        this.delegate.inNamespace(namespace);
        return this;
    }

    @Override
    public CreateLabels autoRemoveResources(boolean enabled) {
        this.delegate.autoRemoveResources(enabled);
        return this;
    }

    @Override
    public CreateLabelsAction doBuild() {
        return (CreateLabelsAction)this.delegate.build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"labels"})
    public static class Labels {
        @XmlElement(name="label", required=true)
        protected List<Label> labels;

        public List<Label> getLabels() {
            if (this.labels == null) {
                this.labels = new ArrayList<Label>();
            }
            return this.labels;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Label {
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute(name="value")
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

