/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.functions;

import java.util.List;
import java.util.Locale;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.functions.Function;
import org.citrusframework.http.server.HttpServer;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.KubernetesSupport;

public class ResolveServiceUrlFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (parameterList.isEmpty()) {
            throw new CitrusRuntimeException("Missing service name for resolve function");
        }
        String serviceName = parameterList.get(0);
        boolean secure = false;
        int servicePort = 0;
        if (parameterList.size() > 1) {
            try {
                servicePort = Integer.parseInt(parameterList.get(1));
            }
            catch (IllegalArgumentException e) {
                secure = Boolean.parseBoolean(parameterList.get(1).toLowerCase(Locale.US));
            }
        }
        if (parameterList.size() > 2) {
            secure = Boolean.parseBoolean(parameterList.get(2).toLowerCase(Locale.US));
        }
        String scheme = "http://";
        if (secure) {
            scheme = "https://";
        }
        if (KubernetesSettings.isLocal()) {
            if (context.getReferenceResolver().isResolvable(serviceName)) {
                HttpServer server = (HttpServer)context.getReferenceResolver().resolve(serviceName, HttpServer.class);
                servicePort = server.getPort();
            }
            return String.format("%slocalhost%s", scheme, servicePort > 0 ? ":" + servicePort : "");
        }
        return String.format("%s%s.%s", scheme, serviceName, KubernetesSupport.getNamespace(context));
    }
}

