/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.functions;

import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.KubernetesSupport;
import org.citrusframework.kubernetes.functions.ResolveServiceUrlFunction;

public class ResolveExternalServiceUrlFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (KubernetesSettings.isLocal()) {
            return new ResolveServiceUrlFunction().execute(parameterList, context);
        }
        if (parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty - please provide a proper service name");
        }
        String serviceName = parameterList.get(0);
        String namespace = parameterList.size() > 1 ? parameterList.get(1) : KubernetesSupport.getNamespace(context);
        KubernetesClient k8sClient = KubernetesSupport.getKubernetesClient(context);
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)k8sClient.services().inNamespace(namespace)).withName(serviceName)).get();
        if (service == null) {
            throw new CitrusRuntimeException(String.format("Unable to resolve service instance %s/%s", namespace, serviceName));
        }
        String hostIp = null;
        Integer nodePort = null;
        if ("NodePort".equals(service.getSpec().getType())) {
            List nodeAddresses;
            List servicePorts = service.getSpec().getPorts();
            if (servicePorts != null && !servicePorts.isEmpty()) {
                nodePort = ((ServicePort)servicePorts.get(0)).getNodePort();
            }
            if (nodePort == null) {
                throw new CitrusRuntimeException(String.format("Unable to resolve service endpoint URL for service '%s' - failed to determine node port", service.getMetadata().getName()));
            }
            NodeList nodeList = (NodeList)k8sClient.nodes().list();
            if (nodeList != null && !nodeList.getItems().isEmpty() && ((Node)nodeList.getItems().get(0)).getStatus() != null && (nodeAddresses = ((Node)nodeList.getItems().get(0)).getStatus().getAddresses()) != null) {
                hostIp = nodeAddresses.stream().filter(nodeAddress -> "ExternalIP".equals(nodeAddress.getType())).map(NodeAddress::getAddress).findFirst().orElse(null);
            }
        } else if ("LoadBalancer".equals(service.getSpec().getType()) && service.getStatus() != null) {
            LoadBalancerStatus loadBalancerStatus = service.getStatus().getLoadBalancer();
            if (loadBalancerStatus != null && loadBalancerStatus.getIngress() != null && !loadBalancerStatus.getIngress().isEmpty()) {
                hostIp = ((LoadBalancerIngress)loadBalancerStatus.getIngress().get(0)).getIp();
            }
        } else {
            List servicePorts;
            List externalIps = service.getSpec().getExternalIPs();
            if (externalIps != null && !externalIps.isEmpty()) {
                hostIp = (String)externalIps.get(0);
            }
            if ((servicePorts = service.getSpec().getPorts()) != null && !servicePorts.isEmpty()) {
                nodePort = ((ServicePort)servicePorts.get(0)).getNodePort();
            }
        }
        if (hostIp == null) {
            throw new CitrusRuntimeException(String.format("Unable to resolve service endpoint URL for service '%s' - failed to determine load balancer ingress ip", service.getMetadata().getName()));
        }
        if (nodePort != null) {
            return "http://%s:%s".formatted(hostIp, nodePort);
        }
        return "http://%s".formatted(hostIp);
    }
}

