/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.endpoint.AbstractPollableEndpointConfiguration;
import org.citrusframework.kubernetes.message.KubernetesMessageConverter;
import org.citrusframework.message.DefaultMessageCorrelator;
import org.citrusframework.message.MessageCorrelator;

public class KubernetesEndpointConfiguration
extends AbstractPollableEndpointConfiguration {
    private Config kubernetesClientConfig;
    private KubernetesClient kubernetesClient;
    private MessageCorrelator correlator = new DefaultMessageCorrelator();
    private ObjectMapper objectMapper = new ObjectMapper();
    private KubernetesMessageConverter messageConverter = new KubernetesMessageConverter();

    private KubernetesClient createKubernetesClient() {
        return new DefaultKubernetesClient(this.getKubernetesClientConfig());
    }

    public KubernetesClient getKubernetesClient() {
        if (this.kubernetesClient == null) {
            this.kubernetesClient = this.createKubernetesClient();
        }
        return this.kubernetesClient;
    }

    public void setKubernetesClient(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public Config getKubernetesClientConfig() {
        if (this.kubernetesClientConfig == null) {
            this.kubernetesClientConfig = new ConfigBuilder().build();
        }
        return this.kubernetesClientConfig;
    }

    public void setKubernetesClientConfig(Config kubernetesClientConfig) {
        this.kubernetesClientConfig = kubernetesClientConfig;
    }

    public void setCorrelator(MessageCorrelator correlator) {
        this.correlator = correlator;
    }

    public MessageCorrelator getCorrelator() {
        return this.correlator;
    }

    public KubernetesMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(KubernetesMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

