/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.config.xml;

import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractEndpointParser;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.config.CredentialValidator;
import org.citrusframework.kubernetes.config.xml.K8sClientConfig;
import org.citrusframework.kubernetes.endpoint.KubernetesEndpointConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class KubernetesClientParser
extends AbstractEndpointParser {
    protected void parseEndpointConfiguration(BeanDefinitionBuilder endpointConfiguration, Element element, ParserContext parserContext) {
        super.parseEndpointConfiguration(endpointConfiguration, element, parserContext);
        String username = element.getAttribute("username");
        String password = element.getAttribute("password");
        String oauthToken = element.getAttribute("oauthToken");
        if (!CredentialValidator.isValid(username, password, oauthToken)) {
            throw new IllegalArgumentException("Parameters not set correctly - check if either an oauthToke or password and username is set");
        }
        BeanDefinitionBuilder configBuilder = BeanDefinitionBuilder.genericBeanDefinition(K8sClientConfig.class);
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)configBuilder, (String)element.getAttribute("url"), (String)"masterUrl");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)configBuilder, (String)element.getAttribute("version"), (String)"apiVersion");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)configBuilder, (String)username, (String)"username");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)configBuilder, (String)password, (String)"password");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)configBuilder, (String)oauthToken, (String)"oauthToken");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)configBuilder, (String)element.getAttribute("namespace"), (String)"namespace");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)configBuilder, (String)element.getAttribute("cert-file"), (String)"caCertFile");
        String clientConfigId = element.getAttribute("id") + "Config";
        BeanDefinitionParserUtils.registerBean((String)clientConfigId, (BeanDefinition)configBuilder.getBeanDefinition(), (ParserContext)parserContext, (boolean)this.shouldFireEvents());
        endpointConfiguration.addPropertyReference("kubernetesClientConfig", clientConfigId);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("message-converter"), (String)"messageConverter");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("object-mapper"), (String)"objectMapper");
    }

    protected Class<? extends Endpoint> getEndpointClass() {
        return KubernetesClient.class;
    }

    protected Class<? extends EndpointConfiguration> getEndpointConfigurationClass() {
        return KubernetesEndpointConfiguration.class;
    }
}

