/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.config.xml;

import org.citrusframework.kubernetes.command.CreateService;
import org.citrusframework.kubernetes.config.xml.KubernetesExecuteActionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateServiceActionParser
extends KubernetesExecuteActionParser<CreateService> {
    public CreateServiceActionParser() {
        super(CreateService.class);
    }

    @Override
    protected CreateService parseCommand(CreateService command, Element element, ParserContext parserContext) {
        Element specElement;
        Element templateElement = DomUtils.getChildElementByTagName((Element)element, (String)"template");
        if (templateElement != null) {
            command.setTemplate(templateElement.getAttribute("file"));
        }
        if ((specElement = DomUtils.getChildElementByTagName((Element)element, (String)"spec")) != null) {
            Element portsElement;
            Element selectorElement = DomUtils.getChildElementByTagName((Element)specElement, (String)"selector");
            if (selectorElement != null) {
                command.setSelector(selectorElement.getAttribute("label"));
            }
            if ((portsElement = DomUtils.getChildElementByTagName((Element)specElement, (String)"ports")) != null) {
                if (portsElement.hasAttribute("protocol")) {
                    command.setProtocol(portsElement.getAttribute("protocol"));
                }
                if (portsElement.hasAttribute("port")) {
                    command.setPort(portsElement.getAttribute("port"));
                }
                if (portsElement.hasAttribute("target-port")) {
                    command.setTargetPort(portsElement.getAttribute("target-port"));
                }
                if (portsElement.hasAttribute("node-port")) {
                    command.setNodePort(portsElement.getAttribute("node-port"));
                }
            }
        }
        return command;
    }
}

