/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.command;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.command.CommandResult;
import org.citrusframework.kubernetes.command.CommandResultCallback;
import org.citrusframework.kubernetes.command.KubernetesCommand;

public abstract class AbstractKubernetesCommand<T extends HasMetadata, O, C extends KubernetesCommand<T, O>>
implements KubernetesCommand<T, O> {
    private final C self;
    private final String name;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private CommandResult<O> commandResult;
    private CommandResultCallback<O> resultCallback;

    public AbstractKubernetesCommand(String name) {
        this.name = name;
        this.self = this;
    }

    protected boolean hasParameter(String parameterName) {
        return this.getParameters().containsKey(parameterName);
    }

    protected String getParameter(String parameterName, TestContext context) {
        if (this.getParameters().containsKey(parameterName)) {
            return context.replaceDynamicContentInString(this.getParameters().get(parameterName).toString());
        }
        throw new CitrusRuntimeException(String.format("Missing kubernetes command parameter '%s'", parameterName));
    }

    @Override
    public CommandResult<O> getCommandResult() {
        return this.commandResult;
    }

    protected void setCommandResult(CommandResult<O> commandResult) {
        this.commandResult = commandResult;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public C withParam(String name, String value) {
        this.parameters.put(name, value);
        return this.self;
    }

    public C validate(CommandResultCallback<O> callback) {
        this.resultCallback = callback;
        return this.self;
    }

    @Override
    public CommandResultCallback<O> getResultCallback() {
        return this.resultCallback;
    }

    public C label(String key, String value) {
        if (!this.hasParameter("citrus_kubernetes_label")) {
            this.withParam("citrus_kubernetes_label", key + "=" + value);
        } else {
            this.withParam("citrus_kubernetes_label", this.getParameters().get("citrus_kubernetes_label") + "," + key + "=" + value);
        }
        return this.self;
    }

    public C label(String key) {
        if (!this.hasParameter("citrus_kubernetes_label")) {
            this.withParam("citrus_kubernetes_label", key);
        } else {
            this.withParam("citrus_kubernetes_label", this.getParameters().get("citrus_kubernetes_label") + "," + key);
        }
        return this.self;
    }

    public C namespace(String key) {
        this.withParam("citrus_kubernetes_namespace", key);
        return this.self;
    }

    public C name(String key) {
        this.withParam("citrus_kubernetes_name", key);
        return this.self;
    }

    public C withoutLabel(String key, String value) {
        if (!this.hasParameter("citrus_kubernetes_label")) {
            this.withParam("citrus_kubernetes_label", key + "!=" + value);
        } else {
            this.withParam("citrus_kubernetes_label", this.getParameters().get("citrus_kubernetes_label") + "," + key + "!=" + value);
        }
        return this.self;
    }

    public C withoutLabel(String key) {
        if (!this.hasParameter("citrus_kubernetes_label")) {
            this.withParam("citrus_kubernetes_label", "!" + key);
        } else {
            this.withParam("citrus_kubernetes_label", this.getParameters().get("citrus_kubernetes_label") + ",!" + key);
        }
        return this.self;
    }

    protected Map<String, String> getLabels(String labelExpression, TestContext context) {
        HashMap<String, String> labels = new HashMap<String, String>();
        Set values = Arrays.stream(labelExpression.split(",")).collect(Collectors.toSet());
        for (String item : values) {
            if (item.contains("!=")) continue;
            if (item.contains("=")) {
                labels.put(context.replaceDynamicContentInString(item.substring(0, item.indexOf("="))), context.replaceDynamicContentInString(item.substring(item.indexOf("=") + 1)));
                continue;
            }
            if (item.startsWith("!")) continue;
            labels.put(context.replaceDynamicContentInString(item), null);
        }
        return labels;
    }

    protected Map<String, String> getWithoutLabels(String labelExpression, TestContext context) {
        HashMap<String, String> labels = new HashMap<String, String>();
        Set values = Arrays.stream(labelExpression.split(",")).collect(Collectors.toSet());
        for (String item : values) {
            if (item.contains("!=")) {
                labels.put(context.replaceDynamicContentInString(item.substring(0, item.indexOf("!="))), context.replaceDynamicContentInString(item.substring(item.indexOf("!=") + 2)));
                continue;
            }
            if (!item.startsWith("!")) continue;
            labels.put(context.replaceDynamicContentInString(item.substring(1)), null);
        }
        return labels;
    }
}

