/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.client.LocalPortForward;
import java.io.IOException;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;

public class ServiceDisconnectAction
extends AbstractKubernetesAction {
    private final String serviceName;

    protected ServiceDisconnectAction(String name, Builder builder) {
        super(name, builder);
        this.serviceName = builder.serviceName;
    }

    public ServiceDisconnectAction(Builder builder) {
        this("service-disconnect", builder);
    }

    public void doExecute(TestContext context) {
        this.logger.info("Disconnect from Kubernetes service '{}'", (Object)this.serviceName);
        if (KubernetesSettings.isLocal()) {
            return;
        }
        if (context.getReferenceResolver().isResolvable(this.serviceName + ":port-forward", LocalPortForward.class)) {
            LocalPortForward portForward = (LocalPortForward)context.getReferenceResolver().resolve(this.serviceName + ":port-forward", LocalPortForward.class);
            try {
                if (portForward.isAlive()) {
                    portForward.close();
                    this.logger.info("Successfully disconnected from Kubernetes service '{}'", (Object)this.serviceName);
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to close local port forward for Kubernetes service '{}'", (Object)this.serviceName);
            }
        } else {
            this.logger.warn("Failed to disconnect from Kubernetes service '{}' - no port forward available", (Object)this.serviceName);
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<ServiceDisconnectAction, Builder> {
        private String serviceName = KubernetesSettings.getServiceName();

        public Builder service(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public ServiceDisconnectAction doBuild() {
            return new ServiceDisconnectAction(this);
        }
    }
}

