/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.http.client.HttpClientBuilder;
import org.citrusframework.http.server.HttpServer;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesActionBuilder;
import org.citrusframework.util.StringUtils;

public class ServiceConnectAction
extends AbstractKubernetesAction {
    protected final String clientName;
    protected final String serviceName;
    protected final String port;
    protected final String localPort;

    protected ServiceConnectAction(String name, Builder builder) {
        super(name, builder);
        this.serviceName = builder.serviceName;
        this.port = builder.port;
        this.clientName = builder.clientName;
        this.localPort = builder.localPort;
    }

    public ServiceConnectAction(Builder builder) {
        this("service-connect", builder);
    }

    public void doExecute(TestContext context) {
        if (KubernetesSettings.isLocal()) {
            if (context.getReferenceResolver().isResolvable(this.serviceName, HttpServer.class)) {
                HttpServer server = (HttpServer)context.getReferenceResolver().resolve(this.serviceName, HttpServer.class);
                this.exposeServiceClient(context, server.getPort());
            }
            return;
        }
        LocalPortForward portForward = StringUtils.hasText((String)this.localPort) ? ((ServiceResource)((NonNamespaceOperation)this.getKubernetesClient().services().inNamespace(this.namespace(context))).withName(this.serviceName)).portForward(Integer.parseInt(context.replaceDynamicContentInString(this.port)), Integer.parseInt(context.replaceDynamicContentInString(this.localPort))) : ((ServiceResource)((NonNamespaceOperation)this.getKubernetesClient().services().inNamespace(this.namespace(context))).withName(this.serviceName)).portForward(Integer.parseInt(context.replaceDynamicContentInString(this.port)));
        if (context.getReferenceResolver().isResolvable(this.clientName)) {
            throw new CitrusRuntimeException("Failed to bind Kubernetes service client '%s' - client already exists".formatted(this.clientName));
        }
        this.exposeServiceClient(context, portForward.getLocalPort());
        if (context.getReferenceResolver().isResolvable(this.serviceName + ":port-forward")) {
            throw new CitrusRuntimeException("Failed to bind Kubernetes service port forward '%s' - already exists".formatted(this.serviceName + ":port-forward"));
        }
        context.getReferenceResolver().bind(this.serviceName + ":port-forward", (Object)portForward);
        if (this.isAutoRemoveResources()) {
            context.doFinally(KubernetesActionBuilder.kubernetes().client(this.getKubernetesClient()).services().disconnect(this.serviceName).inNamespace(this.namespace(context)));
        }
    }

    private void exposeServiceClient(TestContext context, int localPort) {
        if (context.getReferenceResolver().isResolvable(this.clientName, HttpClient.class)) {
            HttpClient serviceClient = (HttpClient)context.getReferenceResolver().resolve(this.clientName, HttpClient.class);
            serviceClient.getEndpointConfiguration().setRequestUrl("http://localhost:%d".formatted(localPort));
        } else {
            HttpClient serviceClient = (HttpClient)new HttpClientBuilder().requestUrl("http://localhost:%d".formatted(localPort)).build();
            context.getReferenceResolver().bind(this.clientName, (Object)serviceClient);
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<ServiceConnectAction, Builder> {
        private String clientName;
        protected String localPort;
        private String serviceName = KubernetesSettings.getServiceName();
        private String port = "8080";

        public Builder service(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder client(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Builder port(String port) {
            this.port = port;
            return this;
        }

        public Builder port(int port) {
            this.port = String.valueOf(port);
            return this;
        }

        public Builder portMapping(String port, String localPort) {
            if (port != null) {
                this.port(port);
            }
            if (localPort != null) {
                this.localPort(localPort);
            }
            return this;
        }

        public Builder portMapping(int port, int localPort) {
            this.port(port);
            this.localPort(localPort);
            return this;
        }

        public Builder localPort(String localPort) {
            this.localPort = localPort;
            return this;
        }

        public Builder localPort(int localPort) {
            this.localPort = String.valueOf(localPort);
            return this;
        }

        @Override
        public ServiceConnectAction doBuild() {
            if (this.clientName == null) {
                this.client(this.serviceName + ".client");
            }
            return new ServiceConnectAction(this);
        }
    }
}

