/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.events.v1.Event;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.kubernetes.client.KubernetesClient;
import org.citrusframework.kubernetes.command.CommandResult;
import org.citrusframework.kubernetes.command.CommandResultCallback;
import org.citrusframework.kubernetes.command.CreatePod;
import org.citrusframework.kubernetes.command.CreateService;
import org.citrusframework.kubernetes.command.DeletePod;
import org.citrusframework.kubernetes.command.DeleteResult;
import org.citrusframework.kubernetes.command.DeleteService;
import org.citrusframework.kubernetes.command.GetPod;
import org.citrusframework.kubernetes.command.GetService;
import org.citrusframework.kubernetes.command.Info;
import org.citrusframework.kubernetes.command.InfoResult;
import org.citrusframework.kubernetes.command.KubernetesCommand;
import org.citrusframework.kubernetes.command.ListEndpoints;
import org.citrusframework.kubernetes.command.ListEvents;
import org.citrusframework.kubernetes.command.ListNamespaces;
import org.citrusframework.kubernetes.command.ListNodes;
import org.citrusframework.kubernetes.command.ListPods;
import org.citrusframework.kubernetes.command.ListReplicationControllers;
import org.citrusframework.kubernetes.command.ListResult;
import org.citrusframework.kubernetes.command.ListServices;
import org.citrusframework.kubernetes.command.WatchNamespaces;
import org.citrusframework.kubernetes.command.WatchNodes;
import org.citrusframework.kubernetes.command.WatchPods;
import org.citrusframework.kubernetes.command.WatchReplicationControllers;
import org.citrusframework.kubernetes.command.WatchServices;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.json.JsonMessageValidationContext;
import org.citrusframework.validation.json.JsonPathMessageValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesExecuteAction
extends AbstractTestAction {
    private final KubernetesClient kubernetesClient;
    private final KubernetesCommand<?, ?> command;
    private final String commandResult;
    private final Map<String, Object> commandResultExpressions;
    private final MessageValidator<? extends ValidationContext> jsonMessageValidator;
    private final MessageValidator<? extends ValidationContext> jsonPathMessageValidator;
    public static final String DEFAULT_JSON_MESSAGE_VALIDATOR = "defaultJsonMessageValidator";
    public static final String DEFAULT_JSON_PATH_MESSAGE_VALIDATOR = "defaultJsonPathMessageValidator";
    private static final Logger logger = LoggerFactory.getLogger(KubernetesExecuteAction.class);

    public KubernetesExecuteAction(Builder builder) {
        super("kubernetes-execute", (AbstractTestActionBuilder)builder);
        this.kubernetesClient = builder.kubernetesClient;
        this.command = builder.command;
        this.commandResult = builder.commandResult;
        this.commandResultExpressions = builder.commandResultExpressions;
        this.jsonMessageValidator = builder.jsonMessageValidator;
        this.jsonPathMessageValidator = builder.jsonPathMessageValidator;
    }

    public void doExecute(TestContext context) {
        try {
            logger.debug("Executing Kubernetes command '{}'", (Object)this.command.getName());
            this.command.execute(this.kubernetesClient, context);
            this.validateCommandResult(this.command, context);
            logger.debug("Kubernetes command execution successful: '{}'", (Object)this.command.getName());
        }
        catch (CitrusRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Unable to perform kubernetes command", (Throwable)e);
        }
    }

    private void validateCommandResult(KubernetesCommand<?, ?> command, TestContext context) {
        logger.debug("Starting Kubernetes command result validation");
        CommandResult<?> result = command.getCommandResult();
        if (StringUtils.hasText((String)this.commandResult) || !this.commandResultExpressions.isEmpty()) {
            if (result == null) {
                throw new ValidationException("Missing Kubernetes command result");
            }
            try {
                String commandResultJson = this.kubernetesClient.getEndpointConfiguration().getObjectMapper().writeValueAsString(result);
                if (StringUtils.hasText((String)this.commandResult)) {
                    this.getMessageValidator(context).validateMessage((Message)new DefaultMessage((Object)commandResultJson), (Message)new DefaultMessage((Object)this.commandResult), context, Collections.singletonList(new JsonMessageValidationContext()));
                    logger.debug("Kubernetes command result validation successful - all values OK!");
                }
                if (!this.commandResultExpressions.isEmpty()) {
                    JsonPathMessageValidationContext validationContext = new JsonPathMessageValidationContext.Builder().expressions(this.commandResultExpressions).build();
                    this.getPathValidator(context).validateMessage((Message)new DefaultMessage((Object)commandResultJson), (Message)new DefaultMessage((Object)this.commandResult), context, Collections.singletonList(validationContext));
                    logger.debug("Kubernetes command result path validation successful - all values OK!");
                }
            }
            catch (JsonProcessingException e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
        if (command.getResultCallback() != null && result != null) {
            command.validateCommandResult(context);
        }
    }

    private MessageValidator<? extends ValidationContext> getMessageValidator(TestContext context) {
        if (this.jsonMessageValidator != null) {
            return this.jsonMessageValidator;
        }
        Optional<MessageValidator> defaultJsonMessageValidator = context.getMessageValidatorRegistry().findMessageValidator(DEFAULT_JSON_MESSAGE_VALIDATOR);
        if (defaultJsonMessageValidator.isEmpty() && context.getReferenceResolver().isResolvable(DEFAULT_JSON_MESSAGE_VALIDATOR)) {
            defaultJsonMessageValidator = Optional.of((MessageValidator)context.getReferenceResolver().resolve(DEFAULT_JSON_MESSAGE_VALIDATOR, MessageValidator.class));
        }
        if (defaultJsonMessageValidator.isEmpty()) {
            defaultJsonMessageValidator = MessageValidator.lookup((String)"json");
        }
        if (defaultJsonMessageValidator.isPresent()) {
            return (MessageValidator)defaultJsonMessageValidator.get();
        }
        throw new CitrusRuntimeException("Unable to locate proper JSON message validator - please add validator to project");
    }

    private MessageValidator<? extends ValidationContext> getPathValidator(TestContext context) {
        if (this.jsonPathMessageValidator != null) {
            return this.jsonPathMessageValidator;
        }
        Optional<MessageValidator> defaultJsonMessageValidator = context.getMessageValidatorRegistry().findMessageValidator(DEFAULT_JSON_PATH_MESSAGE_VALIDATOR);
        if (defaultJsonMessageValidator.isEmpty() && context.getReferenceResolver().isResolvable(DEFAULT_JSON_PATH_MESSAGE_VALIDATOR)) {
            defaultJsonMessageValidator = Optional.of((MessageValidator)context.getReferenceResolver().resolve(DEFAULT_JSON_PATH_MESSAGE_VALIDATOR, MessageValidator.class));
        }
        if (defaultJsonMessageValidator.isEmpty()) {
            defaultJsonMessageValidator = MessageValidator.lookup((String)"json-path");
        }
        if (defaultJsonMessageValidator.isPresent()) {
            return (MessageValidator)defaultJsonMessageValidator.get();
        }
        throw new CitrusRuntimeException("Unable to locate proper JSON path message validator - please add validator to project");
    }

    public KubernetesCommand getCommand() {
        return this.command;
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public String getCommandResult() {
        return this.commandResult;
    }

    public Map<String, Object> getCommandResultExpressions() {
        return this.commandResultExpressions;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<KubernetesExecuteAction, Builder>
    implements ReferenceResolverAware {
        private KubernetesClient kubernetesClient;
        private KubernetesCommand<?, ?> command;
        private String commandResult;
        private final Map<String, Object> commandResultExpressions = new HashMap<String, Object>();
        private MessageValidator<? extends ValidationContext> jsonMessageValidator;
        private MessageValidator<? extends ValidationContext> jsonPathMessageValidator;
        private ReferenceResolver referenceResolver;

        public static Builder kubernetes() {
            return new Builder();
        }

        public Builder client(KubernetesClient kubernetesClient) {
            this.kubernetesClient = kubernetesClient;
            return this;
        }

        public Builder command(KubernetesCommand<?, ?> command) {
            this.command = command;
            return this;
        }

        public Builder result(String result) {
            this.commandResult = result;
            return this;
        }

        public Builder validate(String path, Object value) {
            this.commandResultExpressions.put(path, value);
            return this;
        }

        public Builder validator(MessageValidator<? extends ValidationContext> validator) {
            this.jsonMessageValidator = validator;
            return this;
        }

        public Builder pathExpressionValidator(MessageValidator<? extends ValidationContext> validator) {
            this.jsonPathMessageValidator = validator;
            return this;
        }

        public Builder withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public BaseActionBuilder<InfoResult, InfoResult, ?> info() {
            return new BaseActionBuilder(new Info());
        }

        public PodsActionBuilder pods() {
            return new PodsActionBuilder();
        }

        public ServicesActionBuilder services() {
            return new ServicesActionBuilder();
        }

        public ReplicationControllersActionBuilder replicationControllers() {
            return new ReplicationControllersActionBuilder();
        }

        public EndpointsActionBuilder endpoints() {
            return new EndpointsActionBuilder();
        }

        public NodesActionBuilder nodes() {
            return new NodesActionBuilder();
        }

        public EventsActionBuilder events() {
            return new EventsActionBuilder();
        }

        public NamespacesActionBuilder namespaces() {
            return new NamespacesActionBuilder();
        }

        public KubernetesExecuteAction build() {
            if (this.kubernetesClient == null) {
                this.kubernetesClient = this.referenceResolver != null && this.referenceResolver.isResolvable(KubernetesClient.class) ? (KubernetesClient)((Object)this.referenceResolver.resolve(KubernetesClient.class)) : new KubernetesClient();
            }
            return new KubernetesExecuteAction(this);
        }

        public class BaseActionBuilder<T extends HasMetadata, O, B extends BaseActionBuilder<T, O, B>>
        extends AbstractTestActionBuilder<KubernetesExecuteAction, B> {
            protected final KubernetesCommand<T, O> command;

            BaseActionBuilder(KubernetesCommand<T, O> command) {
                this.command = command;
                this.command(command);
            }

            public B result(String result) {
                Builder.this.commandResult = result;
                return (B)((Object)((BaseActionBuilder)this.self));
            }

            public B validate(String path, Object value) {
                Builder.this.commandResultExpressions.put(path, value);
                return (B)((Object)((BaseActionBuilder)this.self));
            }

            public B validate(CommandResultCallback<O> callback) {
                this.command.validate(callback);
                return (B)((Object)((BaseActionBuilder)this.self));
            }

            public B label(String key, String value) {
                this.command.label(key, value);
                return (B)((Object)((BaseActionBuilder)this.self));
            }

            public B label(String key) {
                this.command.label(key);
                return (B)((Object)((BaseActionBuilder)this.self));
            }

            public B withoutLabel(String key, String value) {
                this.command.withoutLabel(key, value);
                return (B)((Object)((BaseActionBuilder)this.self));
            }

            public B withoutLabel(String key) {
                this.command.withoutLabel(key);
                return (B)((Object)((BaseActionBuilder)this.self));
            }

            protected B command(KubernetesCommand<T, O> command) {
                Builder.this.command(command);
                return (B)((Object)((BaseActionBuilder)this.self));
            }

            public KubernetesExecuteAction build() {
                return Builder.this.build();
            }
        }

        public class PodsActionBuilder {
            public NamespacedActionBuilder<Pod, ListResult<Pod>> list() {
                ListPods command = new ListPods();
                return new NamespacedActionBuilder<Pod, ListResult<Pod>>(command);
            }

            public NamedActionBuilder<Pod, Pod> create(Pod pod) {
                CreatePod command = new CreatePod();
                command.setPod(pod);
                return new NamedActionBuilder<Pod, Pod>(command);
            }

            public NamedActionBuilder<Pod, Pod> create(Resource template) {
                CreatePod command = new CreatePod();
                command.setTemplateResource(template);
                return new NamedActionBuilder<Pod, Pod>(command);
            }

            public NamedActionBuilder<Pod, Pod> create(String templatePath) {
                CreatePod command = new CreatePod();
                command.setTemplate(templatePath);
                return new NamedActionBuilder<Pod, Pod>(command);
            }

            public NamedActionBuilder<Pod, Pod> get(String name) {
                GetPod command = new GetPod();
                command.name(name);
                return new NamedActionBuilder<Pod, Pod>(command);
            }

            public NamedActionBuilder<Pod, DeleteResult> delete(String name) {
                DeletePod command = new DeletePod();
                command.name(name);
                return new NamedActionBuilder<Pod, DeleteResult>(command);
            }

            public NamedActionBuilder<Pod, DeleteResult> delete() {
                DeletePod command = new DeletePod();
                return new NamedActionBuilder<Pod, DeleteResult>(command);
            }

            public NamedActionBuilder<Pod, Pod> watch() {
                return new NamedActionBuilder<Pod, Pod>(new WatchPods());
            }
        }

        public class ServicesActionBuilder {
            public NamespacedActionBuilder<Service, ListResult<Service>> list() {
                return new NamespacedActionBuilder<Service, ListResult<Service>>(new ListServices());
            }

            public NamedActionBuilder<Service, Service> create(Service pod) {
                CreateService command = new CreateService();
                command.setService(pod);
                return new NamedActionBuilder<Service, Service>(command);
            }

            public NamedActionBuilder<Service, Service> create(Resource template) {
                CreateService command = new CreateService();
                command.setTemplateResource(template);
                return new NamedActionBuilder<Service, Service>(command);
            }

            public NamedActionBuilder<Service, Service> create(String templatePath) {
                CreateService command = new CreateService();
                command.setTemplate(templatePath);
                return new NamedActionBuilder<Service, Service>(command);
            }

            public NamedActionBuilder<Service, Service> get(String name) {
                GetService command = new GetService();
                command.name(name);
                return new NamedActionBuilder<Service, Service>(command);
            }

            public NamedActionBuilder<Service, DeleteResult> delete(String name) {
                DeleteService command = new DeleteService();
                command.name(name);
                return new NamedActionBuilder<Service, DeleteResult>(command);
            }

            public NamedActionBuilder<Service, DeleteResult> delete() {
                DeleteService command = new DeleteService();
                return new NamedActionBuilder<Service, DeleteResult>(command);
            }

            public NamedActionBuilder<Service, Service> watch() {
                return new NamedActionBuilder<Service, Service>(new WatchServices());
            }
        }

        public class ReplicationControllersActionBuilder {
            public NamespacedActionBuilder<ReplicationController, ListResult<ReplicationController>> list() {
                return new NamespacedActionBuilder<ReplicationController, ListResult<ReplicationController>>(new ListReplicationControllers());
            }

            public NamespacedActionBuilder<ReplicationController, ReplicationController> watch() {
                return new NamespacedActionBuilder<ReplicationController, ReplicationController>(new WatchReplicationControllers());
            }
        }

        public class EndpointsActionBuilder {
            public NamespacedActionBuilder<Endpoints, ListResult<Endpoints>> list() {
                return new NamespacedActionBuilder<Endpoints, ListResult<Endpoints>>(new ListEndpoints());
            }
        }

        public class NodesActionBuilder {
            public BaseActionBuilder<Node, ListResult<Node>, ?> list() {
                return new BaseActionBuilder(new ListNodes());
            }

            public BaseActionBuilder<Node, Node, ?> watch() {
                return new BaseActionBuilder(new WatchNodes());
            }
        }

        public class EventsActionBuilder {
            public NamespacedActionBuilder<Event, ListResult<Event>> list() {
                return new NamespacedActionBuilder<Event, ListResult<Event>>(new ListEvents());
            }
        }

        public class NamespacesActionBuilder {
            public BaseActionBuilder<Namespace, ListResult<Namespace>, ?> list() {
                return new BaseActionBuilder(new ListNamespaces());
            }

            public BaseActionBuilder<Namespace, Namespace, ?> watch() {
                return new BaseActionBuilder(new WatchNamespaces());
            }
        }

        public class NamedActionBuilder<T extends HasMetadata, O>
        extends BaseActionBuilder<T, O, NamedActionBuilder<T, O>> {
            NamedActionBuilder(KubernetesCommand<T, O> command) {
                super(command);
            }

            public NamedActionBuilder<T, O> name(String key) {
                this.command.name(key);
                return this;
            }

            public NamedActionBuilder<T, O> namespace(String key) {
                this.command.namespace(key);
                return this;
            }
        }

        public class NamespacedActionBuilder<T extends HasMetadata, O>
        extends BaseActionBuilder<T, O, NamespacedActionBuilder<T, O>> {
            NamespacedActionBuilder(KubernetesCommand<T, O> command) {
                super(command);
            }

            public NamespacedActionBuilder<T, O> namespace(String key) {
                this.command.namespace(key);
                return this;
            }
        }
    }
}

