/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;

public class DeleteResourceAction
extends AbstractKubernetesAction {
    private final String content;
    private final Resource resource;
    private final String resourcePath;

    public DeleteResourceAction(Builder builder) {
        super("create-resource", builder);
        this.content = builder.content;
        this.resource = builder.resource;
        this.resourcePath = builder.resourcePath;
    }

    public void doExecute(TestContext context) {
        InputStream is;
        if (this.content != null) {
            is = new ByteArrayInputStream(context.replaceDynamicContentInString(this.content).getBytes(StandardCharsets.UTF_8));
        } else if (this.resource != null) {
            is = this.resource.getInputStream();
        } else if (this.resourcePath != null) {
            is = Resources.create((String)context.replaceDynamicContentInString(this.resourcePath)).getInputStream();
        } else {
            throw new CitrusRuntimeException("Missing proper Kubernetes resource content");
        }
        ((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.getKubernetesClient().load(is).inNamespace(this.namespace(context))).delete();
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<DeleteResourceAction, Builder> {
        private String content;
        private Resource resource;
        private String resourcePath;

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder resource(String path) {
            this.resourcePath = path;
            return this;
        }

        @Override
        public DeleteResourceAction doBuild() {
            return new DeleteResourceAction(this);
        }
    }
}

